#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo ""
echo "<mkdelete.sh>"

CIRCLEDATAFILES="R0r.d R10.d R1r.d T0r.d T10.d T1r.d Z00.d Z0r.d Z1r.d "
WAV3CFILES="$udfile $ewfile $nsfile"
OUTPUTNUMDIRITEMS="
AmpRV_R.d
AmpRV_R.d.lint
coh2.d
nsr.d
nsr.d.lint
nsrlim_cca.d
nsrlim_cca.d.lint
nsrlim_cca.lwapx.d
nsrlim_cca.lwapx.d.lint
nsr_h.d
nsr_h.d.lint
pow_noise.d
pow_noise.d.lint
powratio_R2L.d
powratio_R2L.d.lint
pow_signal.d
pow_signal.d.lint
R0r_R0r.d
R0r_R10.d
R0r_R1r.d
R10_R0r.d
R10_R10.d
R10_R1r.d
R10_T0r.d
R10_T10.d
R1r_R0r.d
R1r_R1r.d
R1r_T0r.d
R1r_T1r.d
spr_cca.d
spr_h0.d
spr_h1.d
sprh_cca_minus_L.d
sprh_cca_minus_R.d
sprh_spac_minus_L.d
sprh_spac_minus_R.d
sprh_spac_plus_L.d
sprh_spac_plus_R.d
spr_spac.d
spr_spac.d.lint
spr_v.d
T0r_R0r.d
T0r_T0r.d
T0r_T10.d
T0r_T1r.d
T10_R0r.d
T10_T0r.d
T10_T1r.d
T1r_R0r.d
T1r_T0r.d
T1r_T1r.d
vel_cca.d
vel_cca.d.lint
vel_cca.lwapx.d
vel_cca.lwapx.d.lint
vel_h0.d
vel_h0.d.lint
vel_h1.d
vel_h1.d.lint
velh_cca_minus_L.d
velh_cca_minus_L.d.lint
velh_cca_minus_R.d
velh_cca_minus_R.d.lint
velh_spac_minus_L.d
velh_spac_minus_L.d.lint
velh_spac_minus_R.d
velh_spac_minus_R.d.lint
velh_spac_plus_L.d
velh_spac_plus_L.d.lint
velh_spac_plus_R.d
velh_spac_plus_R.d.lint
vel_spac.d
vel_spac.d.lint
vel_v.d
vel_v.d.lint
spr_hv.d
spr_hv.d.lint
spr_hv_ew.d
spr_hv_ew.d.lint
spr_hv_ns.d
spr_hv_ns.d.lint
wavud_wavud.d
wavns_wavns.d
wavew_wavew.d
Z00_Z00.d
Z00_Z0r.d
Z0r_Z00.d
Z0r_Z0r.d
Z00_Z1r.d
Z0r_Z1r.d 
Z1r_R1r.d
Z1r_T1r.d
Z1r_Z1r.d
nsr_cca.h0pc.lwapx.d
nsr_cca.h0pc.lwapx.d.lint
nsr_cca.h1pc.lwapx.d
nsr_cca.h1pc.lwapx.d.lint
r_nsr.d
spr_h0_pc.d
spr_h1_pc.d
vel_cca.h0pc.lwapx.d
vel_cca.h0pc.lwapx.d.lint
vel_cca.h1pc.lwapx.d
vel_cca.h1pc.lwapx.d.lint
vel_h0_pc.d
vel_h0_pc.d.lint
vel_h1_pc.d
vel_h1_pc.d.lint
cmax_by_nsr.d
cmax_by_nsr.d.lint"

OUTPUTNUMDIRITEMS_ADDED=""

AVEDIRITEMS="
spr_h0.d
spr_h1.d"
AVEDIRITEMS_ADDED="spr_esac.d"

if [ -f $outputdir/1/SD1u_SD1u.d -o -f $outputdir/1/SD1n_SD1n.d ]
then
cd $outputdir/1
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls SD*.d SD*.d.lint`"
cd -
fi

if [ -f $outputdir/1/MSQcoh1_2u.d -o -f $outputdir/1/MSQcoh1_2n.d ]
then
cd $outputdir/1
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls MSQcoh*.d MSQcoh*.d.lint`"
cd -
fi

if [ -f $outputdir/1/NSR1_2u.d -o -f $outputdir/1/NSR1_2n.d ]
then
cd $outputdir/1
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls NSR*.d NSR*.d.lint`"
cd -
fi
 
if [ -f $outputdir/1/PHASE1_2u.d -o -f $outputdir/1/PHASE1_2n.d ]
then
cd $outputdir/1
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls PHASE*.d PHASE*.d.lint`"
cd -
fi

if [ -f $outputdir/1/PSDRATIO1_2u.d -o -f $outputdir/1/PSDRATIO1_2n.d ]
then
cd $outputdir/1
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls PSDRATIO*.d PSDRATIO*.d.lint`"
cd -
fi

if [ -f $outputdir/1/PSD_NOISE1_2u.d -o -f $outputdir/1/PSD_NOISE1_2n.d ]
then
cd $outputdir/1
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls PSD_NOISE*.d PSD_NOISE*.d.lint`"
cd -
fi


if [ $idcohcca -eq 1 ]
then

if [ -f $outputdir/1/CMPLXcoh1_2u.d -o -f $outputdir/1/CMPLXcoh1_2n.d ]
then
cd $outputdir/1
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls CMPLXcoh*.d*`"
cd -
fi

if [ -f $outputdir/1/nsr_cca.lwapx.d ]
then
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED nsr_cca.lwapx.d nsr_cca.lwapx.d.lint pow_noise.d pow_noise.d.lint pow_signal.d pow_signal.d.lint"
fi

if [ $idhuddle -ne 1 ]
then
cd $outputdir/1

ls spr_*.d.img.lint >& /dev/null
if test "$?" == "0"
then
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls spr_*.d spr_*.d.lint spr_*.d.img.lint vel_*.d vel_*.d.lint nsr_ncspac.d nsr_ncspac.d.lint r_nsr.d`"
else
OUTPUTNUMDIRITEMS_ADDED="$OUTPUTNUMDIRITEMS_ADDED `ls spr_*.d spr_*.d.lint vel_*.d vel_*.d.lint nsr_ncspac.d nsr_ncspac.d.lint r_nsr.d`"
fi

cd -
fi
fi

#---------------------------
# execution
#---------------------------
if [ -d $cpwavdir ] # delete cpwave directory all time
then
#echo "Temprary dierectory $cpwavdir deleted."
rm -rf $cpwavdir
fi

if [ $delete_level -eq 0 ]
then
echo "All temporary files preserved."

elif [ $delete_level -eq 1 ]
then
echo "All temporary files deleted  (except for logfiles)..."

OUTPUTNUMDIRS=`ls -d $outputdir/[1-9]* | sort | sed '1,1d'`
for dir in $OUTPUTNUMDIRS;do
if [ -d $dir ];then
rm -rf $dir
fi
done
for dir in $outputdir/1 ;do
for item in $OUTPUTNUMDIRITEMS $OUTPUTNUMDIRITEMS_ADDED;do
if [ -f $dir/$item ];then
rm -f $dir/$item
fi
done
done

for file in $CIRCLEDATAFILES
do
if [ -f $outputdir/$file ];then
rm -f $outputdir/$file
fi
done

for file in $WAV3CFILES
do
if [ -f $file ];then
rm -f $file
fi
done

for item in $AVEDIRITEMS $AVEDIRITEMS_ADDED;do
if [ -f $avedir/$item ];then
rm -f $avedir/$item
fi
done
if [ -f $avedir/input.r_nsr.stat ];then
rm -f $avedir/input.r_nsr.stat
fi

#------
# delete imaginary part (comment out these lines if needed)
#ls $avedir/*.img >& /dev/null
#if test "$?" == "0"
#then
#rm -f $avedir/*.img
#fi
#------

echo done.

fi # if [ $delete_level -eq 0 ]
