#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

# Check parameters
if test "$smoothband" == ""
then
echo ERROR smoothband not defined. STOP
exit 1
fi

# Create Input file
echo "<ESTSPEC>"
echo 0 > $infile_estspec_hv
echo $logfile_estspec_hv >> $infile_estspec_hv
echo $outputdir2 >> $infile_estspec_hv
FILES="$udfile $ewfile $nsfile $segmentfile"
echo 3        >> $infile_estspec_hv
echo $udfile >> $infile_estspec_hv
echo $ewfile >> $infile_estspec_hv
echo $nsfile >> $infile_estspec_hv
echo 1 0 0   >> $infile_estspec_hv
echo 0 1 0   >> $infile_estspec_hv
echo 0 0 1   >> $infile_estspec_hv
echo $idzeropad  >> $infile_estspec_hv
echo $itype_dtwin>> $infile_estspec_hv
echo $tpend_estspec >> $infile_estspec_hv
echo $smoothband >> $infile_estspec_hv
cat  $segmentfile |grep -v '^#'| awk 'BEGIN{
print "'"$num"'", "'"$nseg_segave"'"}{
if($1!=""){print $0}}' | $bindir/extrctsgments >> $infile_estspec_hv  

for file in $FILES; do
. script/chkfile.sh $file
done

cat  $infile_estspec_hv | grep -v '^#' | $bindir/estspec 
cat $logfile_estspec_hv | grep 'ERROR' >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/estspec.
echo abnormal exit $0
echo See logfile: $logfile_estspec_hv
exit 1
fi
