#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

# Check parameters
if test "$smoothband" == ""
then
echo ERROR smoothband not defined. STOP
exit 1
fi

# Create Input file
echo "<ESTSPEC>"
echo 1 > $infile_estspec
echo $logfile_estspec >> $infile_estspec
echo $outputdir2 >> $infile_estspec
if [ $id_center -eq 1 ]
then
FILES="$Z00file $Z0rfile $segmentfile"
echo 2        >> $infile_estspec
echo $Z00file >> $infile_estspec
echo $Z0rfile >> $infile_estspec
echo 1 0      >> $infile_estspec
echo 1 1      >> $infile_estspec
else
echo ERROR senser at the center point not defined. STOP
exit 1
fi
echo $idzeropad  >> $infile_estspec
echo $itype_dtwin>> $infile_estspec
echo $tpend_estspec >> $infile_estspec
echo $smoothband >> $infile_estspec
cat  $segmentfile |grep -v '^#'| awk 'BEGIN{
print "'"$num"'", "'"$nseg_segave"'"}{
if($1!=""){print $0}}' | $bindir/extrctsgments >> $infile_estspec  

for file in $FILES; do
. script/chkfile.sh $file
done

cat  $infile_estspec | grep -v '^#' | $bindir/estspec 
cat $logfile_estspec | grep 'ERROR' >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/estspec.
echo abnormal exit $0
echo See logfile: $logfile_estspec
exit 1
fi
