#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

######################################################################
# Don't touch from here
######################################################################
#if test "$1" == "1"
#then
ID_PYEXE=0
#else
#ID_PYEXE=1
#fi

XTERM=`which xterm`
GNUPLOT=`which gnuplot`
PATH=.:$PATH
echo OS: `uname`

if test "$DISPLAY" == "" -a "$display" == ""
then
export DISPLAY=:0.0
echo Parameter DISPLAY not defined.
echo Now set to $DISPLAY
else
echo DISPLAY $DISPLAY
fi

if test "$ID_PYEXE" == "0" # In case where python3 is isntalled 
then
    
echo Note: python scripts used 
APPDIR=`pwd`/bin/
WORKDIR_ALL=$APPDIR/WORK
PYTHON_PVREADER="python3 $WORKDIR_ALL/ANALYSIS_POINT/script/pvreader.py"
PYTHON_READPV="python3 $WORKDIR_ALL/ANALYSIS_POINT/script/readpv.py"
PYTHON_READSPRSPAC="python3 $WORKDIR_ALL/ANALYSIS_POINT/script/readsprspac.py"

elif test "$ID_PYEXE" == "1" 
then  

echo Note: python exectables used 
APPDIR=`pwd`/bin/
WORKDIR_ALL=$APPDIR/WORK
PYTHON_PVREADER=$APPDIR/pvreader
PYTHON_READPV=$APPDIR/readpv
PYTHON_READSPRSPAC=$APPDIR/readsprspac

fi 

idok=1
if [ ! -f Install3.2.log ]
then
idok=0
cat <<EOF

Error: Compile the source files before running any program by typing

./Install3.2.sh [Hit Return Key]

See the manual "doc/bido_en_manual3.2.pdf" for the details of the installation.

EOF
fi

if test "$XTERM" == ""
then
idok=0
cat <<EOF
Error: XTERM not found.
EOF
fi

if test "$GNUPLOT" == ""
then
idok=0
cat <<EOF
Error: GNUPLOT not found.
EOF
fi

if test "$PYTHON_PVREADER" == ""
then
idok=0
cat <<EOF
Error: pvreader not found.
EOF
fi

if test "$PYTHON_READPV" == ""
then
idok=0
cat <<EOF
Error: readpv not found.
EOF
fi

if test "$PYTHON_READSPRSPAC" == ""
then
idok=0
cat <<EOF
Error: readsprspac not found.
EOF
fi

if [ $idok -eq 1 ]
then
	 
INPUT_DATADIR=`pwd`/demo
OUTPUT_DATADIR=`pwd`/demo
#echo INPUT_DATADIR: $INPUT_DATADIR
#echo OUTPUT_DATADIR: $OUTPUT_DATADIR

export XTERM
export GNUPLOT
export INPUT_DATADIR
export OUTPUT_DATADIR
export WORKDIR_ALL
export PYTHON_PVREADER
export PYTHON_READPV
export PYTHON_READSPRSPAC

if [ -f $WORKDIR_ALL/.pvreader ]
then
.   $WORKDIR_ALL/.pvreader
fi

if [ -f $WORKDIR_ALL/Analysis_Point.log ]
then
rm -f $WORKDIR_ALL/Analysis_Point.log
fi
touch -f $WORKDIR_ALL/Analysis_Point.log

date                  >> $WORKDIR_ALL/Analysis_Point.log
echo $PYTHON_PVREADER >> $WORKDIR_ALL/Analysis_Point.log

$PYTHON_PVREADER

iderror=0   
if [ ! -f $WORKDIR_ALL/Analysis_Point.log ]
then
iderror=1   
else
grep -i error $WORKDIR_ALL/Analysis_Point.log >&/dev/null
if test "$?" == "0"
then
iderror=1   
fi # if test "$?" == "0"
fi # if [ ! -f $WORKDIR_ALL/Analysis_Point.log ]

if [ $iderror -eq 1  ]
then
cat <<EOF

******************************************************
 Error(s) detected. Check the following executing log
******************************************************
EOF
cat $WORKDIR_ALL/Analysis_Point.log
cat <<EOF
******************************************************
EOF
fi # if [ $iderror -eq 1  ]

fi
