#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

arraydirpath=$1
output_workdir=$2
ARRAYNAMES=dummysite
XTERM4PYTHON=$XTERM
GNUPLOT=$GNUPLOT

#############################################################################
# Don't touch from here
#############################################################################
if test "$2" == ""
then
cat <<EOF
Usage: Analysis_Point.sh "DataDir(s)" SaveDir [Hit Return Key]
EOF
exit 1
fi

cat <<EOF >> Analysis_Point.log
XTERM $XTERM
GNUPLOT $GNUPLOT
WORKDIR_ALL $WORKDIR_ALL
PYTHON_READPV $PYTHON_READPV
PYTHON_READSPRSPAC $PYTHON_READSPRSPAC

arraydirpath $arraydirpath
output_workdir $output_workdir

Program was executed by the following command: ./Analysis_Point.sh "$arraydirpath" $output_workdir

EOF

#----------------------------
# check redundency in $1
#----------------------------
tmpfile1=$WORKDIR_ALL/tmp1.d
tmpfile2=$WORKDIR_ALL/tmp2.d
if [ -f $tmpfile1 ]
then
rm -f $tmpfile1
fi
if [ -f $tmpfile2 ]
then
rm -f $tmpfile2
fi
touch -f $tmpfile1
for a in $arraydirpath
do
echo $a | awk '{printf "%s\n",$1}'>> $tmpfile1
done
sort $tmpfile1 | uniq > $tmpfile2
arraydirpath="`cat $tmpfile2`"
rm -f $tmpfile1 $tmpfile2
#echo $arraydirpath
#----------------------------
# check redundency if exists end
#----------------------------

arrayresultdir=RESULT
pointresultdirpath=result_point
othersdir=OTHERS
ANALYSIS_POINTDIR=ANALYSIS_POINT
pointresultdir=RESULT
radiusfile=radius.d
locationfile=location.d
scriptdir=`pwd`/$ANALYSIS_POINTDIR/script
readpvdir=rpv
pickpvfile=picked.d
pickpvfile_auto=picked_auto.d
pickpvfile_refine=picked_refine.d
PYTHON=python3
id_pngout_readpv=0
visualreadflag_rpv_rate=visual_read_rpv_rate.log
visualreadflag_rpv=visual_read_rpv.log

# for readpv.sh 
FREQMIN_RPVAUTO=1.
FREQMAX_RPVAUTO=30.
ND_RPVAUTO=20
LINES_HACHOU_RPVAUTO="0.013,0.025,0.04,0.1"  # wavlengths [km]  
LINES_RADIUS_RPVAUTO="4,10,50,100"             # radius factors  
DIFLIM4CALERR_RPVAUTO=0.1 # Sepalation Ratio for statistics of pv
FREQMIN=0  # [Hz]
FREQMAX=30 # [Hz]
VRMIN=0.01 # [km]
VRMAX=2.  # [km]

bindir=`pwd`/$ANALYSIS_POINTDIR/bin
echo bindir $bindir               >> Analysis_Point.log

echo copy_each_data.sh >> Analysis_Point.log
. $scriptdir/copy_each_data.sh

if test "$?" == "0"
then
echo mkread_python.sh >> Analysis_Point.log
    . $scriptdir/mkread_python.sh
echo copy_results.sh  >> Analysis_Point.log
echo . $scriptdir/copy_results.sh >> Analysis_Point.log
     . $scriptdir/copy_results.sh
fi # if test "$?" == "0"
