c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NMAX_INC 5000000
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)
      dimension fvr(nmax),vr(nmax),vrerr(nmax)
      dimension w(nmax)
      real*8 izero(nmax),izero_in
      dimension fvrnod(nmax) ,vrnod(nmax) ,vrerrnod(nmax)
      data eps/1.d-18/
      data idlincale/0/ ! logscale
      data nnode,nbunkatsu/20,5/

c---------------------
c input
c---------------------
      i=1
 10   read(5,*,err=99,end=99)fvrin,vrin,izero_in
      fvr(i)=fvrin
      vr(i)=vrin
      izero(i)=izero_in
c      vrerr(i)=vrerrin
      vrerr(i)=1.d0
      w(i)=1.d0/dble(izero(i)) ! weight inverse proportional to the zero order
c----------------------      
      i=i+1
      goto 10
 99   continue
      fvr_min=fvr(1)
      vr_min=vr(1)
      
      nvr=i-1

c----------------------
c excludeing outliers
c (delete datum with abrupt changes)
c----------------------
      do i=1,nvr-1
         if(vr(i+1).ge.1.5d0*vr(i))then
            vr(i+1)=vr(i)
            w(i+1)=0.d0
         else if(vr(i+1).le.0.3d0*vr(i))then
            vr(i+1)=vr(i)
            w(i+1)=0.d0
         endif
      enddo
      
c----------------------
c linear or log scale       
c----------------------      
      if(idlincale.eq.0)then
         do i=1,nvr
            fvr(i)=log10(fvr(i))
            vr(i)=log10(vr(i))
         enddo
      endif
      
c---------------------
c normal interpolation, which is only used to define freqnecy intervals
c---------------------
      call hokan(fvr,vr,vrerr,nvr,nnode,nbunkatsu,
     +     fvrnod,vrnod,vrerrnod,innod)
     
c---------------------
c output output data  
c---------------------

c----------------------
c always output fmin data       
c----------------------      
      if(fvr_min.ne.0.and.vr_min.ne.0.)then
         write(6,'(3f12.5)')fvr_min,vr_min
      endif
      
      fvrnod(innod+1)=fvrnod(innod)
      vrnod(innod+1)=vrnod(innod)
c      do i=1,innod-1
      do i=1,innod
         sumfvr=0.d0
         sumvr=0.d0
         wnvrok=-eps
         do j=1,nvr
            if(fvr(j).ge.fvrnod(i).and.fvr(j).lt.fvrnod(i+1))then
               sumfvr=sumfvr+fvr(j)*w(j)
               sumvr=sumvr+vr(j)*w(j)
               wnvrok=wnvrok+w(j)
c     vrerrout=vrerrnod(i)
            endif
         enddo

         if(wnvrok.gt.0.d0)then
c----------------------
c linear or log scale       
c----------------------      
            if(idlincale.eq.1)then
               fvrout=sumfvr/dble(wnvrok)
               vrout=sumvr/dble(wnvrok)
            else
               fvrout=10**(sumfvr/dble(wnvrok))
               vrout=10**(sumvr/dble(wnvrok))
            endif
            if(fvrout.ne.0.and.vrout.ne.0.)then
               write(6,'(3f12.5)')fvrout,vrout
            endif
         endif ! if(wnvrok.gt.0.d0)then
c----------------------
      enddo ! do i=1,innod
       
      stop
      end

      subroutine hokan(fvr,vr,vrerr,nvr,nnode,nbunkatsu,
     +     fvrnod,vrnod,vrerrnod,innod)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)
      dimension fvr0(nmax)    ,vr0(nmax)    ,vrerr0(nmax)
      dimension fvr(nmax)    ,vr(nmax)    ,vrerr(nmax)
      dimension fvr_n(nmax)  ,vr_n(nmax)  ,vrerr_n(nmax)
      dimension fvrfine(nmax),vrfine(nmax),vrerrfine(nmax)
      dimension fvrnod(nmax) ,vrnod(nmax) ,vrerrnod(nmax)
      dimension w(nmax)
      
      fvrmin=1.d9
      fvrmax=-1.d9
      vrmin=1.d9
      vrmax=-1.d9
      do i=1,nvr
         if(fvr(i).ge.fvrmax)fvrmax=fvr(i)
         if(fvr(i).le.fvrmin)fvrmin=fvr(i)
         if(vr(i).ge.vrmax)vrmax=vr(i)
         if(vr(i).le.vrmin)vrmin=vr(i)
      enddo
      fvrw=fvrmax-fvrmin
      vrw=vrmax-vrmin

c normalize [0,1]-[0,1]      
      do i=1,nvr
         fvr_n(i)=(fvr(i)-fvrmin)/fvrw
         vr_n(i)=(vr(i)-vrmin)/vrw
         vrerr_n(i)=(vrerr(i)-vrmin)/vrw
c         write(16,*)fvr_n(i),vr_n(i)
c         write(16,*)fvr(i),vr(i)
      enddo

c refinement
      nfine=0
      do i=1,nvr-1
         do k=0,nbunkatsu-1
            nfine=nfine+1
            fvrfine(nfine)
     +           =(fvr_n(i+1)-fvr_n(i))/dble(nbunkatsu)*dble(k)+fvr_n(i)
            vrfine(nfine)
     +           =(vr_n(i+1)-vr_n(i))/dble(nbunkatsu)*dble(k)+vr_n(i)
            vrerrfine(nfine)
     +           =(vrerr_n(i+1)-vrerr_n(i))/dble(nbunkatsu)*dble(k)
     +            +vrerr_n(i)
         enddo
      enddo
      nfine=nfine+1
      fvrfine(nfine)=fvr_n(nvr)
      vrfine(nfine)=vr_n(nvr)
      vrerrfine(nfine)=vrerr_n(nvr)

c      do i=1,nfine
c         write(6,*)'DEBUG ',fvrfine(i),vrfine(i)
c      enddo
      
c      do i=1,nfine
c         write(17,*)fvrfine(i),vrfine(i)
c      enddo

c calculation of total length    
      sumlen=0.d0
      do i=1,nfine-1
         sumlen=sumlen
     +        +dsqrt((fvrfine(i+1)-fvrfine(i))**2
     +                +(vrfine(i+1)-vrfine(i))**2)
      enddo

      seglen=sumlen/dble(nnode-1)
      innod=1
      fvrnod(innod)  =  fvrfine(1)*fvrw+fvrmin
      vrnod(innod)   =   vrfine(1)* vrw+ vrmin
      vrerrnod(innod)=vrerrfine(1)* vrw+ vrmin
      alen=0.d0
      do i=1,nfine-1
         alen=alen
     +        +dsqrt((fvrfine(i+1)-fvrfine(i))**2
     +        +(vrfine(i+1)-vrfine(i))**2)
         if(alen.ge.seglen)then
            alen=0.d0
            innod=innod+1
            fvrnod(innod)  =   fvrfine(i)*fvrw+fvrmin
            vrnod(innod)   =    vrfine(i)*vrw + vrmin
            vrerrnod(innod)= vrerrfine(i)*vrw + vrmin
         endif
      enddo
      innod=innod+1
      fvrnod(innod)  =   fvrfine(nfine)*fvrw+fvrmin
      vrnod(innod)   =    vrfine(nfine)*vrw + vrmin
      vrerrnod(innod)= vrerrfine(nfine)*vrw + vrmin

c      do i=1,innod
c         write(6,*)'DEBUG2 ',fvrnod(i),vrnod(i)
c      enddo
      
      return
      end
      
