c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NMAX_INC 500000
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)
      dimension fvr(nmax),vr(nmax),vrerr(nmax)
      dimension izero(nmax),w(nmax)
      dimension fvrnod(nmax) ,vrnod(nmax) ,vrerrnod(nmax)
      data nbunkatsu/100/

c---------------------
c input
c---------------------
      read(5,*)idlincale
      read(5,*)nnode
      i=1
 10   read(5,*,err=99,end=99)fvrin,vrin
c     +     fvr(i),vr(i),vrerr(i)
      
c----------------------
c linear or log scale       
c----------------------      
      if(idlincale.eq.1)then
         fvr(i)=fvrin
         vr(i)=vrin
      else
         fvr(i)=log10(fvrin)
         vr(i)=log10(vrin)
      endif
c      vrerr(i)=vrerrin
      vrerr(i)=1.d0
c----------------------      
      i=i+1
      goto 10
 99   continue
      nvr=i-1

c---------------------
c normal interpolation
c---------------------
      call hokan(fvr,vr,vrerr,nvr,nnode,
     +     fvrnod,vrnod,vrerrnod,innod)

c---------------------
c output
c---------------------
      do i=1,innod
c----------------------
c linear or log scale       
c----------------------      
         if(idlincale.eq.1)then
            fvrout=fvrnod(i)
            vrout=vrnod(i)
         else
            fvrout=10**fvrnod(i)
            vrout=10**vrnod(i)
         endif
         vrerrout=vrerrnod(i)
c----------------------
         write(6,'(3f12.5)')fvrout,vrout
c         write(6,'(3f12.5)')fvrout
      enddo ! do i=1,innod
       
      stop
      end


      subroutine hokan(
     +     fvr,vr,vrerr,nvr,nnode,
     +     fvrnod,vrnod,vrerrnod,innod)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)
      dimension fvr0(nmax)    ,vr0(nmax)    ,vrerr0(nmax)
      dimension fvr(nmax)    ,vr(nmax)    ,vrerr(nmax)
      dimension fvr_n(nmax)  ,vr_n(nmax)  ,vrerr_n(nmax)
      dimension fvrfine(nmax),vrfine(nmax),vrerrfine(nmax)
      dimension fvrnod(nmax) ,vrnod(nmax) ,vrerrnod(nmax)
      dimension izero(nmax) ,w(nmax)
      data nbunkatsu/100/
      
      fvrmin=1.d9
      fvrmax=-1.d9
      vrmin=1.d9
      vrmax=-1.d9
      do i=1,nvr
         if(fvr(i).ge.fvrmax)fvrmax=fvr(i)
         if(fvr(i).le.fvrmin)fvrmin=fvr(i)
         if(vr(i).ge.vrmax)vrmax=vr(i)
         if(vr(i).le.vrmin)vrmin=vr(i)
      enddo
      fvrw=fvrmax-fvrmin
      vrw=vrmax-vrmin

c normalize [0,1]-[0,1]      
      do i=1,nvr
         fvr_n(i)=(fvr(i)-fvrmin)/fvrw
         vr_n(i)=(vr(i)-vrmin)/vrw
         vrerr_n(i)=(vrerr(i)-vrmin)/vrw
c         write(16,*)fvr_n(i),vr_n(i)
c         write(16,*)fvr(i),vr(i)
      enddo

c refinement
      nfine=0
      do i=1,nvr-1
         do k=0,nbunkatsu-1
            nfine=nfine+1
            fvrfine(nfine)
     +           =(fvr_n(i+1)-fvr_n(i))/dble(nbunkatsu)*dble(k)+fvr_n(i)
            vrfine(nfine)
     +           =(vr_n(i+1)-vr_n(i))/dble(nbunkatsu)*dble(k)+vr_n(i)
            vrerrfine(nfine)
     +           =(vrerr_n(i+1)-vrerr_n(i))/dble(nbunkatsu)*dble(k)
     +            +vrerr_n(i)
         enddo
      enddo
      nfine=nfine+1
      fvrfine(nfine)=fvr_n(nvr)
      vrfine(nfine)=vr_n(nvr)
      vrerrfine(nfine)=vrerr_n(nvr)

c      do i=1,nfine
c         write(6,*)'DEBUG ',fvrfine(i),vrfine(i)
c      enddo
      
c      do i=1,nfine
c         write(17,*)fvrfine(i),vrfine(i)
c      enddo

c calculation of total length    
      sumlen=0.d0
      do i=1,nfine-1
         sumlen=sumlen
     +        +dsqrt((fvrfine(i+1)-fvrfine(i))**2
     +                +(vrfine(i+1)-vrfine(i))**2)
      enddo

      seglen=sumlen/dble(nnode-1)
      innod=1
      fvrnod(innod)  =  fvrfine(1)*fvrw+fvrmin
      vrnod(innod)   =   vrfine(1)* vrw+ vrmin
      vrerrnod(innod)=vrerrfine(1)* vrw+ vrmin
      alen=0.d0
      do i=1,nfine-1
         alen=alen
     +        +dsqrt((fvrfine(i+1)-fvrfine(i))**2
     +        +(vrfine(i+1)-vrfine(i))**2)
         if(alen.ge.seglen)then
            alen=0.d0
            innod=innod+1
            fvrnod(innod)  =   fvrfine(i)*fvrw+fvrmin
            vrnod(innod)   =    vrfine(i)*vrw + vrmin
            vrerrnod(innod)= vrerrfine(i)*vrw + vrmin
         endif
      enddo
      innod=innod+1
      fvrnod(innod)  =   fvrfine(nfine)*fvrw+fvrmin
      vrnod(innod)   =    vrfine(nfine)*vrw + vrmin
      vrerrnod(innod)= vrerrfine(nfine)*vrw + vrmin

c      do i=1,innod
c         write(6,*)'DEBUG2 ',fvrnod(i),vrnod(i)
c      enddo
      
      return
      end
      
