c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
c #define NMAX_INC 5000000
#define NMAX_INC 1000000
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC)
      dimension dat(0:nmax,4),f(nmax),work(nmax),pvobs(nmax)
      character*200 ofile
      dat(0,1)=-1.d0
      i=1
      read(5,*)fmin,fmax
      read(5,*)smoothing_det_ulwl
 10   read(5,*,end=99,err=99)(dat(i,j),j=1,2)
      if(dat(i-1,1).gt.dat(i,1))goto 99 ! decrease of frequnecy is error
      i=i+1
      goto 10
 99   continue
      ndata=i-1
      if(ndata.gt.nmax)then
         write(6,*)'Program smth'
         write(6,*)'ERROR(ndata>nmax) in rmkd: ',ndata,nmax
         stop
      endif

c-----------------------------------      
c screaning abnormal values for coherence 
c-----------------------------------      
      do i=2,ndata
         if(dat(i,2).gt.900.d0)dat(i,2)=dat(i-1,2)
      enddo      
      
c-----------------------------------      
c determine df (dealing with zero padding)
c-----------------------------------      
      nsum=0
      sum=0.d0
      do i=2,ndata
         if(dat(i,1)-dat(i-1,1).gt.0.d0)then
            sum=sum+(dat(i,1)-dat(i-1,1))
            nsum=nsum+1
         endif
      enddo      
      df=sum/dble(nsum)
c      write(6,*)'DEBUG: df ',df
c-----------------------------------      

c-----------------------------------      
c     determine fmin,fmax
c     fmin --> 0
c     fmax --> 80% of maximum frequeny      
c-----------------------------------      
      if(fmin.lt.0.d0)then
         fmin=0.d0
      endif
      if(fmax.lt.0.d0)then
         amax=-1.d18
         do i=1,ndata
            if(dat(i,1).ge.amax)amax=dat(i,1)
         enddo
         fmax=0.8d0*amax
      endif
c-----------------------------------      

      
      do i=1,ndata
         pvobs(i)=dat(i,2)
      enddo

c      do i=1,ndata
c         write(6,'(100e16.5)')dat(i,1),pvobs(i)
c      enddo
c      stop
      
c smoothing observed phase velocity      
      if(smoothing_det_ulwl.gt.0.d0)then
         do i=1,ndata
            f(i)=dat(i,1)
            work(i)=dat(i,2)
         enddo
c         call smooth_parzen(f,work,pvobs,ndata,df)
         call smooth_fparzen(f,work,pvobs,smoothing_det_ulwl,ndata,df) ! Parzen window with bandwidth of a*(center frequency)
      endif
      
      do i=1,ndata
         frq=dat(i,1)
         if(frq.ge.fmin.and.frq.le.fmax)
     +        write(6,'(100e16.5)')frq,pvobs(i)
      enddo
      stop
      end

      subroutine smooth_parzen(f,dat0,dat1,ndata,df)
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC)
      dimension f(nmax),dat0(nmax),dat1(nmax)
      data PRfac,PTfac/1.d0,1.d0/
      
c                    An effective bandwidth given as [-smb/2,smb/2]
c      read(5,*)smb              ! band width (not half width) for smoothing 
      smb=5.0 ! Hz

c The Parzen window is defined as W(f)=3/4*u*(sin(pi*u*f/2)/(pi*u*f/2))**4
c                               where u=280/151/smb
      u=1.854305d0/smb
c     Numerical calculation will be done in the frequency range of [-2/u,2/u]
c     (i.e.,[-lw,lw]; 2lw+1 data points are used for the spectral window)

c----
      lw=int(2.d0/(u*df))
c     lw=0
c----
      
      facu=0.75d0*u*df
c      gain=facu/(PRfac*PTfac)
      gain=facu
      
      do i=1,ndata
         dat1(i)=0.d0
         do j=-lw,lw

c----
           udf=1.570796d0*u*df*dble(j)
c            udf=0.d0
c----
            
            if(i+j.ge.1.and.i+j.le.ndata)then
               dat1(i)=dat1(i)
     +              +spw(udf)*dat0(i+j)
            else if(i+j.gt.ndata)then
               dat1(i)=dat1(i)
     +              +spw(udf)*dat0(2*ndata-i-j)
            else
               dat1(i)=dat1(i)
     +              +spw(udf)*dat0(2-i-j)
            endif
         enddo
         dat1(i)=gain*dat1(i)
      enddo
      return
      end
     
      subroutine smooth_fparzen(f,dat0,dat1,a,ndata,df)
c---------------------------------------------
c     Parzen window with bandwidth of a*(center frequency)
c---------------------------------------------
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC)
      dimension f(nmax),dat0(nmax),dat1(nmax)
      data PRfac,PTfac/1.d0,1.d0/
      data b/20.d0/

      do i=1,ndata

c                    An effective bandwidth given as [-smb/2,smb/2]
c      read(5,*)smb              ! band width (not half width) for smoothing 
c         smb=0.1                ! Hz
         smb=a*f(i)         ! Hz  

         if(smb.lt.2.d0*df)smb=2.d0*df
         
c For a normal setting (smb is effective; lw will be updated adjusted to smb)
c  地震動の...p.102 表6-1「スペクトルウインドウのバンド幅」よりuを計算。
c The Parzen window is defined as W(f)=3/4*u*(sin(pi*u*f/2)/(pi*u*f/2))**4
c                               where u=280/151/smb
         u=1.854305d0/smb
c     Numerical calculation will be done in the frequency range of [-2/u,2/u]
c     (i.e.,[-lw,lw]; 2lw+1 data points are used for the spectral window)
         lw=int(2.d0/(u*df))
         facu=0.75d0*u*df
      
         dat1(i)=0.d0
         do j=-lw,lw
            udf=1.570796d0*u*df*dble(j)
            
            if(i+j.ge.1.and.i+j.le.ndata)then
               dat1(i)=dat1(i)
     +              +spw(udf)*dat0(i+j)
            else if(i+j.gt.ndata)then
               dat1(i)=dat1(i)
     +              +spw(udf)*dat0(2*ndata-i-j)
            else
               dat1(i)=dat1(i)
     +              +spw(udf)*dat0(2-i-j)
            endif
            
         enddo
         dat1(i)=facu*dat1(i)
      enddo
      return
      end
      
      real*8 function spw(udf)
c      real*8 function spw_pzw(udf)
c   Parzen window 
      implicit real*8 (a-h,o-z)                                         
      if(udf.eq.0d0)then
         spw=1.d0
      else
         spw=sin(udf)/udf  
         spw=spw**4
      endif         
      return
      end
      
