C    
C    
C              *********************************************************
C              *                                                       *
C              *    Guide to the SLATEC Common Mathematical Library    *
C              *                                                       *
C              *********************************************************
C    
C    
C                                    Kirby W. Fong
C                    National Magnetic Fusion Energy Computer Center
C                        Lawrence Livermore National Laboratory
C    
C    
C                                 Thomas H. Jefferson
C                              Operating Systems Division
C                        Sandia National Laboratories Livermore
C    
C    
C                                  Tokihiko Suyehiro
C                      Computing and Mathematics Research Division
C                        Lawrence Livermore National Laboratory
C    
C    
C                                      Lee Walton
C                              Network Analysis Division
C                       Sandia National Laboratories Albuquerque
C    
C                                      July 1993
C    
C    
C    
C    
C   *******************************************************************************
C    
C                                  Table of Contents
C    
C    
C   SECTION 1.  ABSTRACT
C   SECTION 2.  BACKGROUND
C   SECTION 3.  MEMBERS OF THE SLATEC COMMON MATHEMATICAL LIBRARY SUBCOMMITTEE
C   SECTION 4.  OBTAINING THE LIBRARY
C   SECTION 5.  CODE SUBMISSION PROCEDURES
C   SECTION 6.  CODING GUIDELINES--GENERAL REQUIREMENTS FOR SLATEC
C   SECTION 7.  SOURCE CODE FORMAT
C   SECTION 8.  PROLOGUE FORMAT FOR SUBPROGRAMS
C   SECTION 9.  EXAMPLES OF PROLOGUES
C   SECTION 10. SLATEC QUICK CHECK PHILOSOPHY
C   SECTION 11. SPECIFIC PROGRAMMING STANDARDS FOR SLATEC QUICK CHECKS
C   SECTION 12. QUICK CHECK DRIVERS (MAIN PROGRAMS)
C   SECTION 13. QUICK CHECK SUBROUTINE EXAMPLE
C   SECTION 14. QUICK CHECK MAIN PROGRAM EXAMPLE
C    
C   APPENDIX A.  GAMS (AND SLATEC) CLASSIFICATION SCHEME
C   APPENDIX B.  MACHINE CONSTANTS
C   APPENDIX C.  ERROR HANDLING
C   APPENDIX D.  DISTRIBUTION FILE STRUCTURE
C   APPENDIX E.  SUGGESTED FORMAT FOR A SLATEC SUBPROGRAM
C    
C   ACKNOWLEDGEMENT
C   REFERENCES
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 1.  ABSTRACT
C    
C   This document is a guide to the SLATEC Common Mathematical Library (CML) [1].
C   The SLATEC CML is written in FORTRAN 77 (ANSI standard FORTRAN as defined by
C   ANSI X3.9-1978, reference [6]) and contains general purpose mathematical and
C   statistical routines.  Included in this document are a Library description,
C   code submission procedures, and a detailed description of the source file
C   format.  This report serves as a guide for programmers who are preparing codes
C   for inclusion in the library.  It also provides the information needed to
C   process the source file automatically for purposes such as extracting
C   documentation or inserting usage monitoring calls.  This guide will be updated
C   periodically, so be sure to contact a SLATEC CML subcommittee member to ensure
C   you have the latest version.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 2.  BACKGROUND
C    
C   SLATEC is the acronym for the Sandia, Los Alamos, Air Force Weapons Laboratory
C   Technical Exchange Committee.  This organization was formed in 1974 by the
C   computer centers of Sandia National Laboratories Albuquerque, Los Alamos
C   National Laboratory, and Air Force Weapons Laboratory to foster the exchange of
C   technical information.  The parent committee established several subcommittees
C   to deal with various computing specialties.  The SLATEC Common Mathematical
C   Library (CML) Subcommittee decided in 1977 to construct a mathematical FORTRAN
C   subprogram library that could be used on a variety of computers at the three
C   sites. A primary impetus for the library development was to provide portable,
C   non-proprietary, mathematical software for member sites' supercomputers.
C    
C   In l980 the computer centers of Sandia National Laboratories Livermore and the
C   Lawrence Livermore National Laboratory were admitted as members of the parent
C   committee and subcommittees. Lawrence Livermore National Laboratory, unlike the
C   others, has two separate computer centers: the National Magnetic Fusion Energy
C   Computer Center (NMFECC) and the Livermore Computer Center (LCC).  In 1981 the
C   National Bureau of Standards (now the National Institute of Standards and
C   Technology) and the Oak Ridge National Laboratory were invited to participate
C   in the math library subcommittee because of their great interest in the
C   project.
C    
C   Version 1.0 of the CML was released in April 1982 with 114,328 records and 491
C   user-callable routines.  In May 1984 Version 2.0, with 151,864 records and 646
C   user-callable routines was released.  This was followed in April 1986 by
C   Version 3.0 with 196,013 records and 704 user-callable routines.  Version 3.1
C   followed in August 1987 with 197,931 records and 707 user-callable routines
C   and Version 3.2 in August 1989 with 203,587 records and 709 user-callable
C   routines.  The committee released Version 4.0 in December 1992 with 298,954
C   records and 901 user-callable routines.  Finally, on July 1, 1993, Version 4.1
C   was released with 290,907 records and 902 user-callable routines.
C    
C   The sole documentation provided by SLATEC for the routines of the SLATEC
C   Library is via comment lines in the source code.  Although the library comes
C   with portable documentation programs to help users access the documentation in
C   the source code, various installations may wish to use their own documentation
C   programs.  To facilitate automatic extraction of documentation or further
C   processing by other computer programs, the source file for each routine must
C   be arranged in a precise format.  This document describes that format for the
C   benefit of potential library contributors and for those interested in
C   extracting library documentation from the source code.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 3.  MEMBERS OF THE SLATEC COMMON MATHEMATICAL LIBRARY SUBCOMMITTEE
C    
C   Current member sites and voting members of the subcommittee are the
C   following.
C    
C    
C   Air Force Phillips Laboratory, Kirtland (PLK)          Reginald Clemens
C    
C   Lawrence Livermore National Laboratory (LCC)           Fred N. Fritsch
C    
C   Lawrence Livermore National Laboratory (NERSC)         Steve Buonincontri
C    
C   Los Alamos National Laboratory (LANL)                  W. Robert Boland
C                                                          (Chairman)
C    
C   National Institute of Standards and Technology (NIST)  Daniel W. Lozier
C    
C   Oak Ridge National Laboratory (ORNL)                   Thomas H. Rowan
C    
C   Sandia National Laboratories/California (SNL/CA)       Thomas H. Jefferson
C    
C   Sandia National Laboratories/New Mexico (SNL/NM)       Sue Goudy
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 4.  OBTAINING THE LIBRARY
C    
C   The Library is in the public domain and distributed by the Energy Science
C   and Technology Software Center.
C    
C                  Energy Science and Technology Software Center
C                  P.O. Box 1020
C                  Oak Ridge, TN  37831
C    
C                  Telephone  615-576-2606
C                  E-mail  estsc%a1.adonis.mrouter@zeus.osti.gov
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 5.  CODE SUBMISSION PROCEDURES
C    
C   The SLATEC Library is continuously searching for portable high-quality routines
C   written in FORTRAN 77 that would be of interest to the member sites.  The
C   subcommittee meets several times annually with the member sites rotating as
C   meeting hosts.  At these meetings new routines are introduced, discussed, and
C   eventually voted on for inclusion in the library.  Some of the factors that are
C   considered in deciding whether to accept a routine into the Library are the
C   following:
C    
C    
C   1.  Usefulness.  Does the routine fill a void in the Library?  Will the routine
C       have widespread appeal?  Will it add a new capability?
C    
C   2.  Robustness.  Does the routine give accurate results over a wide range of
C       problems?  Does it diagnose errors?  Is the routine well tested?
C    
C   3.  Maintainability.  Is the author willing to respond to bugs in the routine?
C       Does the source code follow good programming practices?
C    
C   4.  Adherence to SLATEC standards and coding guidelines.  These standards
C       are described further in this guide and include such things as the order
C       of subprogram arguments, the presence of a correctly formatted prologue at
C       the start of each routine, and the naming of routines.
C    
C   5.  Good documentation.  Is clear, concise computer readable documentation
C       built into the source code?
C    
C   6.  Freely distributable.  Is the program in the public domain?
C    
C    
C   A typical submission procedure begins with contact between an author and a
C   Library committee member.  Preliminary discussions with the member are
C   encouraged for initial screening of any code and to gain insight into the
C   workings of SLATEC.  This member champions the routine to be considered.  The
C   code is introduced at a meeting where the author or committee member describes
C   the code and explains why it would be suitable for SLATEC.  Copies of the code
C   are distributed to all committee members.  Hopefully, the code already adheres
C   to SLATEC standards.  However, most codes do not.  At this first formal
C   discussion, the committee members are able to provide some useful suggestions
C   for improving the code and revising it for SLATEC.
C    
C   Between meetings, changes are made to the code and the modified code is
C   distributed in machine readable format for testing.  The code is then
C   considered at a subsequent meeting, to be voted on and accepted. However,
C   because committee members and authors do not always see eye to eye, and because
C   time constraints affect all, the code is usually discussed at several meetings.
C    
C   If codes adhered to the programming practices and formatting described in this
C   guide, the time for acceptance could be greatly reduced.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 6.  CODING GUIDELINES--GENERAL REQUIREMENTS FOR SLATEC
C    
C   A software collection of the size of the SLATEC Library that is designed to run
C   on a variety of computers demands uniformity in handling machine dependencies,
C   in handling error conditions, and in installation procedures.  Thus, while the
C   decision to add a new subroutine to the library depends mostly on its quality
C   and whether it fills a gap in the library, these are not the only
C   considerations.  Programming style must also be considered, so that the library
C   as a whole behaves in a consistent manner.  We now list the stylistic and
C   documentational recommendations and requirements for routines to be
C   incorporated into the library.
C    
C    
C   1.  The SLATEC Library is intended to have no restriction on its distribution;
C       therefore, new routines must be in the public domain.  This is generally
C       not a problem since most authors are proud of their work and would like
C       their routines to be used widely.
C    
C   2.  Routines must be written in FORTRAN 77 (ANSI standard FORTRAN as
C       defined by ANSI X3.9-1978, reference [6]).  Care must be taken so that
C       machine dependent features are not used.
C    
C   3.  To enhance maintainability codes are to be modular in structure.  Codes
C       must be composed of reasonably small subprograms which in turn are made
C       up of easily understandable blocks.
C    
C   4.  Equivalent routines of different precision are to look the same where
C       possible.  That is, the logical structure, statement numbers, variable
C       names, etc. are to be as close to identical as possible.  This implies
C       that generic intrinsics must be used instead of specific intrinsics.
C       Extraneous use of INT, REAL and DBLE are strongly discouraged;  use
C       mixed-mode expressions in accordance with the Fortran 77 standard.
C    
C   5.  New routines must build on existing routines in the Library, unless
C       there are compelling reasons to do otherwise.  For example, the SLATEC
C       Library contains the LINPACK and EISPACK routines, so new routines
C       should use the existing linear system and eigensystem routines rather
C       than introduce new ones.
C    
C   6.  System or machine dependent values must be obtained by calling routines
C       D1MACH, I1MACH, and R1MACH.  The SLATEC Library has adopted these routines
C       from the Bell Laboratories' PORT Library [2] [3].  See Appendix B
C       for a description of these machine dependent routines.
C    
C   7.  The SLATEC Library has a set of routines for handling error messages.
C       Each user-callable routine, if it can detect errors, must have as one
C       of its arguments an error flag, whose value upon exiting the routine
C       indicates the success or failure of the routine. It is acceptable for a
C       routine to set the error flag and RETURN; however, if the routine wishes
C       to write an error message, it must call XERMSG (see Appendix C) rather
C       than use WRITE or PRINT statements.  In general, all errors (even serious
C       ones) should be designated as "recoverable" rather than "fatal," and the
C       routine should RETURN to the user.  This permits the user to try an
C       alternate strategy if a routine decides a particular calculation is
C       inappropriate.  A description of the entire original error handling
C       package appears in reference [4].
C    
C   8.  Each user-callable routine (and subsidiary routine if appropriate) must
C       have a small demonstration routine that can be used as a quick check. This
C       demonstration routine can be more exhaustive, but in general, it should be
C       structured to provide a "pass" or "fail" answer on whether the library
C       routine appears to be functioning properly.  A more detailed description
C       of the required format of the quick checks appears later in this document.
C    
C   9.  Common blocks and SAVEd variables must be avoided.  Use subprogram
C       arguments for interprogram communication.  The use of these constructs
C       often obstructs multiprocessing.
C    
C       Variables that are statically allocated in memory and are used as
C       working storage cannot be used simultaneously by several processors.
C       SAVEd variables and common block variables are most likely to fall into
C       this category.  Such variables are acceptable if they are DATA loaded or
C       set at run time to values that are to be read (but not written) since it
C       does not matter in what order multiple processors read the values.
C       However, such variables should not be used as working storage since no
C       processor can use the work space while some other processor is using it.
C       Library routines should ask the user to provide any needed work space
C       by passing it in as an argument.  The user is then responsible for
C       giving each processor a different work space even though each processor
C       may be executing the same library routine.
C    
C   10. Complete self-contained documentation must be supplied as comments in
C       user-callable routines.  This documentation must be self-contained because
C       SLATEC provides no other documentation for using the routines.  This
C       documentation is called the "prologue" for the routine.  The rigid prologue
C       format for user-callable routines is described below.  The prologue must
C       tell the user how to call the routine but need not go into algorithmic
C       details since such explanations often require diagrams or non-ASCII
C       symbols.  Subsidiary routines are those called by other library routines
C       but which are not intended to be called directly by the user.  Subsidiary
C       routines also have prologues, but these prologues are considerably less
C       elaborate than those of user-callable routines.
C    
C   11. No output should be printed.  Instead, information should be returned
C       to the user via the subprogram arguments or function values.  If there is
C       some overriding reason that printed output is necessary, the user must be
C       able to suppress all output by means of a subprogram input variable.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 7.  SOURCE CODE FORMAT
C    
C   In this section and the two sections on prologues, we use the caret (^)
C   character to indicate a position in which a single blank character must
C   appear. Upper case letters are used for information that appears literally.
C   Lower case is used for material specific to the routine.
C    
C   1.  The first line of a subprogram must start with one of:
C    
C       SUBROUTINE^name^(arg1,^arg2,^...argn)
C       FUNCTION^name^(arg1,^arg2,^...argn)
C       COMPLEX^FUNCTION^name^(arg1,^arg2,^...argn)
C       DOUBLE^PRECISION^FUNCTION^name^(arg1,^arg2,^...argn)
C       INTEGER^FUNCTION^name^(arg1,^arg2,^...argn)
C       REAL^FUNCTION^name^(arg1,^arg2,^...argn)
C       LOGICAL^FUNCTION^name^(arg1,^arg2,^...argn)
C       CHARACTER[*len]^FUNCTION^name^(arg1,^arg2,^...argn)
C    
C       Each of the above lines starts in column 7.  If there is an argument
C       list, then there is exactly one blank after the subprogram name and
C       after each comma (except if the comma appears in column 72).  There is
C       no embedded blank in any formal parameter, after the leading left
C       parenthesis, before the trailing right parenthesis,  or before any
C       comma. Formal parameters are never split across lines. Any line to be
C       continued must end with a comma.
C    
C       For continuation lines, any legal continuation character may be used in
C       column 6, columns 7-9 must be blank and arguments or formal parameters
C       start in column 10 of a continuation line and continue up to the right
C       parenthesis (or comma if another continuation line is needed).  The
C       brackets in the CHARACTER declaration do not appear literally but
C       indicate the optional length specification described in the FORTRAN 77
C       standard.
C    
C   2.  The author must supply a prologue for each subprogram.  The prologue
C       must be in the format that will subsequently be described.  The
C       prologue begins with the first line after the subprogram declaration
C       (including continuation lines for long argument lists).
C    
C   3.  Except for the "C***" lines (to be described) in the prologue and
C       the "C***" line marking the first executable statement, no other line
C       may begin with "C***".
C    
C   4.  The first line of the prologue is the comment line
C    
C       C***BEGIN^PROLOGUE^^name
C    
C       where "name", starting in column 21, is the name of the subprogram.
C    
C   5.  The last line of a subprogram is the word "END" starting in column 7.
C    
C   6.  All alphabetic characters, except for those on comment lines or in
C       character constants, must be upper case, as specified by the FORTRAN 77
C       standard (see [6]).
C    
C   7.  In the prologue, the comment character in column 1 must be the upper
C       case "C".
C    
C   8.  All subprogram, common block, and any formal parameter names mentioned in
C       the prologue must be in upper case.
C    
C   9.  Neither FORTRAN statements nor comment lines can extend beyond column 72.
C       Columns 73 through 80 are reserved for identification or sequence numbers.
C    
C   10. Before the first executable statement of every subprogram, user-callable
C       or not, is the line
C    
C       C***FIRST^EXECUTABLE^STATEMENT^^name
C    
C       where "name" (starting in column 33) is the name of the subprogram.
C       Only comment lines may appear between the C***FIRST EXECUTABLE
C       STATEMENT line and the first executable statement.
C    
C   11. The subprogram name consists of a maximum of six characters.  Authors
C       should choose unusual and distinctive subprogram names to minimize
C       possible name conflicts.  Double precision routines should begin with
C       "D".  Subprograms of type complex should begin with "C".  The letter "Z"
C       is reserved for future use by possible double precision complex
C       subprograms.  No other subprograms should begin with either "D", "C", or
C       "Z".
C    
C   12. The recommended order for the formal parameters is:
C    
C       1.  Names of external subprograms.
C    
C       2.  Input variables.
C    
C       3.  Variables that are both input and output (except error flags).
C    
C       4.  Output variables.
C    
C       5.  Work arrays.
C    
C       6.  Error flags.
C    
C       However, array dimensioning parameters should immediately follow the
C       associated array name.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 8.  PROLOGUE FORMAT FOR SUBPROGRAMS
C    
C   Each subprogram has a section called a prologue that gives standardized
C   information about the routine.  The prologue consists of comment lines only.  A
C   subsidiary subprogram is one that is usually called by another SLATEC Library
C   subprogram only and is not meant to be called by a user's routine.  The
C   prologue for a user-callable subprogram is more extensive than the prologue for
C   a subsidiary subprogram.  The prologue for a user-callable subprogram has up to
C   14 sections, of which 12 are required and one is required if and only if a
C   common block is present.  Several of these sections are optional in subsidiary
C   programs and in the quick check routines.  The sections are always in the
C   order described in the table below.
C    
C    
C             Section           User-callable      Subsidiary     Quick Checks
C    
C      1.   BEGIN PROLOGUE        Required         Required       Required
C      2.   SUBSIDIARY            Not present      Required         Optional
C      3.   PURPOSE               Required         Required       Required
C      4.   LIBRARY   SLATEC      Required         Required       Required
C      5.   CATEGORY              Required           Optional       Optional
C      6.   TYPE                  Required         Required       Required
C      7.   KEYWORDS              Required           Optional       Optional
C      8.   AUTHOR                Required         Required       Required
C      9.   DESCRIPTION           Required           Optional       Optional
C     10.   SEE ALSO                Optional         Optional       Optional
C     11.   REFERENCES            Required           Optional       Optional
C     12.   ROUTINES CALLED       Required         Required       Required
C     13.   COMMON BLOCKS         Required***      Required***    Required***
C     14.   REVISION HISTORY      Required         Required       Required
C     15.   END PROLOGUE          Required         Required       Required
C    
C       ***Note:  The COMMON BLOCKS section appears in a subprogram prologue
C                 if and only if the subprogram contains a common block.
C    
C   In the prologue section descriptions that follow, the caret (^)
C   character is used for emphasis to indicate a required blank character.
C    
C    
C   1.  BEGIN PROLOGUE
C       This section is a single line that immediately follows the subprogram
C       declaration and its continuation lines.  It is
C    
C       C***BEGIN^PROLOGUE^^name
C    
C       where "name" (beginning in column 21) is the name of the subprogram.
C    
C   2.  SUBSIDIARY
C       This section is the single line
C    
C       C***SUBSIDIARY
C    
C       and indicates the routine in which this appears is not intended to be
C       user-callable.
C    
C   3.  PURPOSE
C       This  section gives one to six lines of information on the purpose of the
C       subprogram.  The letters may be in upper or lower case.  There are no blank
C       lines in the purpose section; i.e., there are no lines consisting solely of
C       a "C" in column 1.  The format for the first line and any continuation
C       lines is
C    
C       C***PURPOSE^^information
C       C^^^^^^^^^^^^more information
C    
C       Information begins in column 14 of the first line and no earlier than
C       column 14 of continuation lines.
C    
C   4.  LIBRARY   SLATEC
C       The section is a single line used to show that the routine is a part
C       of the SLATEC library and, optionally, to indicate other libraries,
C       collections, or packages (sublibraries) of which the routine is a part
C       or from which the routine has been derived.    The format is
C    
C       C***LIBRARY^^^SLATEC
C               or
C       C***LIBRARY^^^SLATEC^(sublib1,^sublib2,^...sublibn)
C    
C       The leading left parenthesis is immediately followed by the first member
C       of the list.  Each member, except for the last, is immediately followed by
C       a comma and a single blank.  The last member is immediately followed by
C       the trailing right parenthesis.
C    
C   5.  CATEGORY
C       This section is a list of classification system categories to which
C       this subprogram might reasonably be assigned.  There must be at least
C       one list item.  The first category listed is termed the primary
C       category, and others, if given, should be listed in monotonically
C       decreasing order of importance.  Categories must be chosen from the
C       classification scheme listed in Appendix A.  The required format for the
C       initial line and any continuation lines is
C    
C       C***CATEGORY^^cat1,^cat2,^cat3,^...catn,
C       C^^^^^^^^^^^^^continued list
C    
C       All alphabetic characters are in upper case.
C    
C       Items in the list are separated by the two characters, comma and space.
C       If the list will not fit on one line, the line may be ended at a comma
C       (with zero or more trailing spaces), and be continued on the next line.
C       The list and any continuations of the list begin with a nonblank character
C       in column 15.
C    
C   6.  TYPE
C       This section gives the datatype of the routine and indicates which
C       routines, including itself,  are equivalent (except possibly for type) to
C       the routine. The format for this section is
C    
C       C***TYPE^^^^^^routine_type^(equivalence list
C       C^^^^^^^^^^^^^continued equivalence list
C       C^^^^^^^^^^^^^continued equivalence list)
C    
C       Routine_type, starting in column 15, is the data type of the routine,
C       and is either SINGLE PRECISION, DOUBLE PRECISION, COMPLEX, INTEGER,
C       CHARACTER, LOGICAL, or ALL.  ALL is a pseudo-type given to routines that
C       could not reasonably be converted to some other type.  Their purpose is
C       typeless.  An example would be the SLATEC routine that prints error
C       messages.
C    
C       Equivalence list is a list of the routines (including this one) that are
C       equivalent to this one, but perhaps of a different type.  Each item in the
C       list consists of a routine name followed by the "-" character and then
C       followed by the first letter of the type (except use "H" for type
C       CHARACTER) of the equivalent routine.  The order of the items is S, D, C,
C       I, H, L and A.
C    
C       The initial item in the list is immediately preceded by a blank and a
C       left parenthesis and the final item is immediately followed by a right
C       parenthesis.  Items in the list are separated by the two characters,
C       comma and space.  If the list will not fit on one line, the line may be
C       ended at a comma (with zero or more trailing spaces), and be continued
C       on the next line.  The list and any continuations of the list begin with
C       a nonblank character in column 15.
C    
C       All alphabetic characters in this section are in upper case.
C    
C       Example
C    
C       C***TYPE      SINGLE PRECISION (ACOSH-S, DACOSH-D, CACOSH-C)
C    
C   7.  KEYWORDS
C       This section gives keywords or keyphrases that can be used by
C       information retrieval systems to identify subprograms that pertain to
C       the topic suggested by the keywords.  There must be at least one
C       keyword.  Keywords can have embedded blanks but may not have leading or
C       trailing blanks.  A keyword cannot be continued on the next line;  it
C       must be short enough to fit on one line. No keyword can have an embedded
C       comma. Characters are limited to the FORTRAN 77 character set (in
C       particular, no lower case letters).  There is no comma after the last
C       keyword in the list.  It is suggested that keywords be in either
C       alphabetical order or decreasing order of importance.  The format for
C       the initial line and any continuation lines is
C    
C       C***KEYWORDS^^list
C       C^^^^^^^^^^^^^continued list
C    
C       Items in the list are separated by the two characters, comma and space.
C       If the list will not fit on one line, the line may be ended at a comma
C       (with zero or more trailing spaces), and be continued on the next line.
C       The list and any continuations of the list begin with a nonblank character
C       in column 15.
C    
C   8.  AUTHOR
C       This required section gives the author's name.  There must be at least one
C       author, and there may be coauthors.  At least the last name of the author
C       must be given.  The first name (or initials) is optional.  The company,
C       organization, or affiliation of the author is also optional.  The brackets
C       below indicate optional information.  Note that if an organization is to be
C       listed, the remainder of the author's name must also be given.  If the
C       remainder of the author's name is given, the last name is immediately
C       followed by a comma.  If the organization is given, the first name (or
C       initials) is immediately followed by a comma.  The remainder of the name
C       and the organization name may have embedded blanks.  The remainder of the
C       name may not have embedded commas.  This makes it possible for an
C       information retrieval system to count commas to identify the remainder of
C       the name and the name of an organization. Additional information about the
C       author (e.g., address or telephone number) may be given on subsequent
C       lines.  The templates used are
C    
C       C***AUTHOR^^last-name[,^first-name[,^(org)]]
C       C^^^^^^^^^^^^^more information
C       C^^^^^^^^^^^^^more information
C           .
C           .
C           .
C       C^^^^^^^^^^^last-name[,^first-name[,^(org)]]
C       C^^^^^^^^^^^^^more information
C           .
C           .
C           .
C    
C       Each author's name starts in column 13.  Continued information starts in
C       column 15.
C    
C   9.  DESCRIPTION
C       This section is a description giving the program abstract, method used,
C       argument descriptions, dimension information, consultants, etc.  The
C       description of the arguments is in exactly the same order in which the
C       arguments appear in the calling sequence.  The description section may use
C       standard, 7-bit ASCII graphic characters, i.e., the 94 printing characters
C       plus the blank.  Names of subprograms, common blocks, externals, and formal
C       parameters are all in upper case.  Names of variables are also in upper
C       case.  The first line of this section is "C***DESCRIPTION" starting in
C       column 1.  All subsequent lines in this section start with a "C" in column
C       1 and no character other than a blank in column 2.  Lines with only a "C"
C       in column 1 may be used to improve the appearance of the description.
C    
C       A suggested format for the DESCRIPTION section is given in Appendix E.
C    
C   10. SEE ALSO
C       This section is used for listing other SLATEC routines whose prologues
C       contain documentation on the routine in which this section appears.
C       The form is
C    
C       C***SEE ALSO^^name,^name,^name
C    
C       where each "name" is the name of a user-callable SLATEC CML subprogram
C       whose prologue provides a description of this routine. The names are
C       given as a list (starting in column 15), with successive names separated
C       by a comma and a single blank.
C    
C   11. REFERENCES
C       This section is for references.  Any of the 94 ASCII printing characters
C       plus the blank may be used. There may be more than one reference.  If there
C       are no references, the section will consist of the single line
C    
C       C***REFERENCES^^(NONE)
C    
C       If there are references, they will be in the following format:
C    
C       C***REFERENCES^^reference 1
C       C^^^^^^^^^^^^^^^^^continuation of reference 1
C           .
C           .
C           .
C       C^^^^^^^^^^^^^^^reference 2
C       C^^^^^^^^^^^^^^^^^continuation of reference 2
C           .
C           .
C           .
C    
C       Information starts in column 17 of the first line of a reference and no
C       earlier than column 19 of continuation lines.
C    
C       References should be listed in either alphabetical order by last name or
C       order of citation.  They should be in upper and lower case, have initials
C       or first names ahead of last names, and (for multiple authors) have
C       "and" ahead of the last author's name instead of just a comma.  The first
C       word of the title of journal articles should be capitalized as should all
C       important words in titles of books, pamphlets, research reports, and
C       proceedings.  Titles should be given without quotation marks.  The names
C       of journals should be spelled out completely, or nearly so, because
C       software users may not be familiar with them.
C    
C       A complete example of a journal reference is:
C    
C       C               F. N. Fritsch and R. E. Carlson, Monotone piecewise
C       C                 cubic interpolation, SIAM Journal on Numerical Ana-
C       C                 lysis, 17 (1980), pp. 238-246.
C    
C       A complete example of a book reference is:
C    
C       C               Carl de Boor, A Practical Guide to Splines, Applied
C       C                 Mathematics Series 27, Springer-Verlag, New York,
C       C                 1978.
C    
C   12. ROUTINES CALLED
C       This section gives the names of routines in the SLATEC Common Mathematical
C       Library that are either directly referenced or declared in an EXTERNAL
C       statement and passed as an argument to a subprogram.  Note that the FORTRAN
C       intrinsics and other formal parameters that represent externals are not
C       listed.  A list is always given for routines called; however, if no routine
C       is called, the list will be the single item "(NONE)" where the parentheses
C       are included.  If there are genuine items in the list, the items are in
C       alphabetical order.  The collating sequence has "0" through "9" first, then
C       "A" through "Z".  The format is
C    
C       C***ROUTINES^CALLED^^name,^name,^name,^name,
C       C^^^^^^^^^^^^^^^^^^^^name,^name,^name
C    
C       Items in the list are separated by the two characters, comma and space.
C       If the list will not fit on one line, the line may be ended at a comma
C       (with zero or more trailing spaces), and be continued on the next line.
C       The list and any continuations of the list begin with a nonblank character
C       in column 22.
C    
C   13. COMMON BLOCKS
C       This section, that may or may not be required, tells what common blocks are
C       used by this subprogram.  If this subprogram uses no common blocks, this
C       section does not appear.  If this subprogram does use common blocks, this
C       section must appear.  The list of common blocks is in exactly the same
C       format as the list of routines called and uses the same collating sequence.
C       In addition, the name of blank common is "(BLANK)" where the parentheses
C       are included.  Blank common should be last in the list if it appears. The
C       format for this section is
C    
C       C***COMMON^BLOCKS^^^^name,^name,^name,^name,
C       C^^^^^^^^^^^^^^^^^^^^name,^name,^name^
C    
C       The list starts in column 22.
C    
C   14. REVISION HISTORY
C       This section provides a summary of the revisions made to this code.
C       Revision dates and brief reasons for revisions are given.  The format is
C    
C       C***REVISION^HISTORY^^(YYMMDD)
C       C^^^yymmdd^^DATE^WRITTEN
C       C^^^yymmdd^^revision description
C       C^^^^^^^^^^^more revision description
C       C^^^^^^^^^^^...
C       C^^^yymmdd^^revision description
C       C^^^^^^^^^^^more revision description
C       C^^^^^^^^^^^...
C       C^^^^^^^^^^^...
C    
C       where, for each revision,  "yy" (starting in column 5) is the last two
C       digits of the year, "mm" is the month (01, 02, ..., 12), and "dd" is the
C       day of the month (01, 02, ..., 31).  Because this ANSI standard form for
C       the date may not be familiar to some people, the character string
C       "(YYMMDD)" (starting in column 23) is included in the first line of the
C       section to assist in interpreting the sequence of digits.  Each line of the
C       revision descriptions starts in column 13.  The second line of this section
C       contains the date the routine was written, with the characters "DATE
C       WRITTEN" beginning in column 13.  These items must be in chronological
C       order.
C    
C   15. END PROLOGUE
C       The last section is the single line
C    
C       C***END^PROLOGUE^^name
C    
C       where "name" is the name of the subprogram.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 9.  EXAMPLES OF PROLOGUES
C    
C   This section contains examples of prologues for both user-callable
C   and subsidiary routines.  The routines are not from the SLATEC CML and
C   should be used only as guidelines for preparing routines for SLATEC.
C   Note that the C***DESCRIPTION sections follow the suggested LDOC format that
C   is described in Appendix E.  Following the suggested LDOC format with its
C   "C *"subsections helps to ensure that all necessary descriptive information is
C   provided.
C    
C         SUBROUTINE ADDXY (X, Y, Z, IERR)
C   C***BEGIN PROLOGUE  ADDXY
C   C***PURPOSE  This routine adds two single precision numbers together
C   C            after forcing both operands to be stored in memory.
C   C***LIBRARY   SLATEC
C   C***CATEGORY  A3A
C   C***TYPE      SINGLE PRECISION (ADDXY-S, DADDXY-D)
C   C***KEYWORDS  ADD, ADDITION, ARITHMETIC, REAL, SUM,
C   C             SUMMATION
C   C***AUTHOR  Fong, K. W., (NMFECC)
C   C             Mail Code L-560
C   C             Lawrence Livermore National Laboratory
C   C             Post Office Box 5509
C   C             Livermore, CA  94550
C   C           Jefferson, T. H., (SNLL)
C   C             Org. 8235
C   C             Sandia National Laboratories Livermore
C   C             Livermore, CA  94550
C   C           Suyehiro, T., (LLNL)
C   C             Mail Code L-316
C   C             Lawrence Livermore National Laboratory
C   C             Post Office Box 808
C   C             Livermore, CA  94550
C   C***DESCRIPTION
C   C
C   C *Usage:
C   C
C   C     INTEGER IERR
C   C     REAL X, Y, Z
C   C
C   C     CALL ADDXY (X, Y, Z, IERR)
C   C
C   C *Arguments:
C   C
C   C  X :IN   This is one of the operands to be added.  It will not
C   C          be modified by ADDXY.
C   C
C   C  Y :IN   This is the other operand to be added.  It will not be
C   C          modified by ADDXY.
C   C
C   C  Z :OUT  This is the sum of X and Y.  In case of an error,
C   C          this argument will not be modified.
C   C
C   C  IERR:OUT  This argument will be set to 0 if ADDXY added the two
C   C          operands.  It will be set to 1 if it appears the addition
C   C          would generate a result that might overflow.
C   C
C   C *Description:
C   C
C   C  ADDXY first divides X and Y by the largest single precision number
C   C  and then adds the quotients.  If the absolute value of the sum is
C   C  greater than 1.0, ADDXY returns with IERR set to 1.  Otherwise
C   C  ADDXY stores X and Y into an internal array and calls ADDZZ to add
C   C  them.  This increases the probability (but does not guarantee) that
C   C  operands and result are stored into memory to avoid retention of
C   C  extra bits in overlength registers or cache.
C   C
C   C***REFERENCES  W. M. Gentleman and S. B. Marovich, More on algorithms
C   C                 that reveal properties of floating point arithmetic
C   C                 units, Communications of the ACM, 17 (1974), pp.
C   C                 276-277.
C   C***ROUTINES CALLED  ADDZZ, R1MACH, XERMSG
C   C***REVISION HISTORY  (YYMMDD)
C   C   831109  DATE WRITTEN
C   C   880325  Modified to meet new SLATEC prologue standards.  Only
C   C           comment lines were modified.
C   C   881103  Brought DESCRIPTION section up to Appendix E standards.
C   C   921215  REFERENCE section modified to reflect recommended style.
C   C***END PROLOGUE  ADDXY
C         DIMENSION R(3)
C   C***FIRST EXECUTABLE STATEMENT  ADDXY
C         BIG = R1MACH( 2 )
C   C
C   C  This is an example program, not meant to be taken seriously.  The
C   C  following illustrates the use of XERMSG to send an error message.
C   C
C         IF ( (ABS((X/BIG)+(Y/BIG))-1.0) .GT. 0.0 ) THEN
C            IERR = 1
C            CALL XERMSG ( 'SLATEC', 'ADDXY', 'Addition of the operands '//
C        *      'is likely to cause overflow', IERR, 1 )
C         ELSE
C            IERR = 0
C            R(1) = X
C            R(2) = Y
C            CALL ADDZZ( R )
C            Z    = R(3)
C         ENDIF
C         RETURN
C         END
C         SUBROUTINE ADDZZ (R)
C   C***BEGIN PROLOGUE  ADDZZ
C   C***SUBSIDIARY
C   C***PURPOSE  This routine adds two single precision numbers.
C   C***LIBRARY   SLATEC
C   C***AUTHOR  Fong, K. W., (NMFECC)
C   C             Mail Code L-560
C   C             Lawrence Livermore National Laboratory
C   C             Post Office Box 5509
C   C             Livermore, CA  94550
C   C           Jefferson, T. H., (SNLL)
C   C             Org. 8235
C   C             Sandia National Laboratories Livermore
C   C             Livermore, CA  94550
C   C           Suyehiro, T., (LLNL)
C   C             Mail Code L-316
C   C             Lawrence Livermore National Laboratory
C   C             Post Office Box 808
C   C             Livermore, CA  94550
C   C***SEE ALSO  ADDXY
C   C***ROUTINES CALLED  (NONE)
C   C***REVISION HISTORY  (YYMMDD)
C   C   831109  DATE WRITTEN
C   C   880325  Modified to meet new SLATEC prologue standards.  Only
C   C           comment lines were modified.
C   C***END PROLOGUE  ADDZZ
C         DIMENSION R(3)
C   C***FIRST EXECUTABLE STATEMENT  ADDZZ
C         R(3) = R(1) + R(2)
C         RETURN
C         END
C    
C    
C    
C    
C   *******************************************************************************
C    
C    
C   SECTION 10. SLATEC QUICK CHECK PHILOSOPHY
C    
C   The SLATEC Library is distributed with a set of test programs that may be used
C   as an aid to insure that the Library is installed correctly.  This set of test
C   programs is known as the SLATEC quick checks.  The quick checks are not meant
C   to provide an exhaustive test of the Library.  Instead they are designed to
C   protect against gross errors, such as an unsatisfied external.  Because the
C   SLATEC Library runs on a great variety of computers, the quick checks often
C   detect arithmetic difficulties with either particular Library routines or with
C   a particular computational environment.
C    
C   A list of the quick check guidelines follows.
C    
C   1.  A quick check should test a few problems successfully solved by a
C       particular library subprogram.  It is not intended to be an extensive
C       test of a subprogram.
C    
C   2.  A quick check should provide consistent and minimal output in most
C       cases, including a "PASS" or "FAIL" indicator.  However, more detailed
C       output should be available on request to help track down problems in the
C       case of failures.
C    
C   3.  Some reasonable error conditions should be tested by the quick check by
C       purposefully referencing the routine incorrectly.
C    
C   4.  A quick check subprogram is expected to execute correctly on any machine
C       with an ANSI Fortran 77 compiler and library.  No test should have to be
C       skipped to avoid an abort on a particular machine.
C    
C   5.  As distributed on the SLATEC tape, the quick check package consists of a
C       number of quick check main programs and a moderate number of subprograms.
C       Each quick check main program, more frequently called a quick check driver,
C       calls one or more quick check subprograms.  Usually, a given driver
C       initiates the tests for a broadly related set of subprograms, e.g. for the
C       single precision Basic Linear Algebra Subprograms (BLAS).  Each quick
C       check subprogram will test one or more closely related library routines of
C       the same precision.  For example, single precision routines and their
C       double precision equivalents are not to be tested in the same quick check
C       subprogram.
C    
C   6.  The format of the quick check package does not rigidly dictate how it
C       must be executed on a particular machine.  For example, memory size of the
C       machine might preclude loading all quick check modules at once.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 11. SPECIFIC PROGRAMMING STANDARDS FOR SLATEC QUICK CHECKS
C    
C   Just as the routines in the SLATEC Common Mathematical Library must meet
C   certain standards, so must the quick checks.  These standards are meant to
C   ensure that the quick checks adhere to the SLATEC quick check philosophy and
C   to enhance maintainability.  The list of these quick check standards follow.
C    
C    
C   1.  Each module must test only a few related library subprograms.
C    
C   2.  Each module must be in the form of a subroutine with three arguments.
C       For example:
C    
C                   SUBROUTINE ADTST (LUN, KPRINT, IPASS)
C    
C       The first is an input argument giving the unit number to which any output
C       should be written.  The second is an input argument specifying the amount
C       of printing to be done by the quick check subroutine.  The third is an
C       output flag indicating passage or failure of the subroutine.
C    
C       LUN         Unit number to which any output should be written.
C    
C       KPRINT = 0  No printing is done (pass/fail is presumably monitored at a
C                   higher level, i.e. in the driver).  Error messages will not be
C                   printed since the quick check driver sets the error handling
C                   control flag to 0, using CALL XSETF(0) when KPRINT = 0 or 1.
C    
C              = 1  No printing is done for tests which pass; a short message
C                   (e.g., one line) is printed for tests which fail.  Error
C                   messages will not be printed since the quick check driver sets
C                   the error handling control flag to 0, using CALL XSETF(0)
C                   when KPRINT = 0 or 1.
C    
C              = 2  A short message is printed for tests which pass; more detailed
C                   information is printed for tests which fail.  Error messages
C                   describing the reason for failure should be printed.
C    
C              = 3  (Possibly) quite detailed information is printed for all tests.
C                   Error messages describing the reason for failure should be
C                   printed.
C    
C       IPASS  = 0  Indicates failure of the quick check subroutine (i.e., at least
C                   one test failed).
C    
C              = 1  Indicates that all tests passed in the quick check subroutine.
C    
C       In the case of a subroutine whose purpose is to produce output (e.g., a
C       printer-plotter), output of a more detailed nature might be produced for
C       KPRINT >= 1.
C    
C       The quick check must execute correctly and completely using each value
C       of KPRINT.  KPRINT is used only to control the printing and does not
C       affect the tests made of the SLATEC routine.
C    
C   3.  The quick check subprograms must be written in ANSI Fortran 77 and
C       must make use of I1MACH, R1MACH, and D1MACH for pass/fail tolerances.
C    
C   4.  Where possible, compute constants in a machine independent fashion.  For
C       example, PI = 4. * ATAN(1.0)
C    
C   5.  Using one library routine to test another is permitted, though this should
C       be done with care.
C    
C   6.  Known solutions can be stored using DATA or PARAMETER statements.  Some
C       subprograms return a "solution" which is more than one number - for
C       example, the eigenvalues of a matrix.  In these cases, take special care
C       that the quick check test passes for ALL orderings of the output which are
C       mathematically correct.
C    
C   7.  Where subprograms are required by a routine being tested, they
C       should accompany the quick check.  However, care should be taken so that
C       no two such subprograms have the same name. Choosing esoteric or odd
C       names is a good idea.  It is extremely desirable that each such
C       subprogram contain comments indicating which quick check needed it
C       (a C***SEE ALSO line should be used).
C    
C   8.  Detailed output should be self-contained yet concise.  No external
C       reference material or additional computations should be required to
C       determine what, for example, the correct solution to the problem really is.
C    
C   9.  For purposes of tracking down the cause of a failure, external reference
C       material or the name of a (willing) qualified expert should be listed in
C       the comment section of the quick check.
C    
C   10. Quick checks must have SLATEC prologues and be adequately commented
C       and cleanly written so that the average software librarian has some hope
C       of tracking down problems.  For example, if a test problem is known to
C       be tricky or if difficulties are expected for short word length
C       machines, an appropriate comment would be helpful.
C    
C   11. After deliberately calling a library routine with incorrect arguments,
C       invoke the function IERR=NUMXER(NERR) to verify that the correct error
C       number was set.  (NUMXER is a function in the SLATEC error handling
C       package that returns the number of the most recent error via both the
C       function value and the argument.)  Then CALL XERCLR to clear it before
C       this (or the next) quick check makes another error.
C    
C   12. A quick check should be written in such a way that it will execute
C       identically if called several times in the same program.  In particular,
C       there should be no modification of DATA loaded variables which cause the
C       quick check to start with the wrong values on subsequent calls.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 12. QUICK CHECK DRIVERS (MAIN PROGRAMS)
C    
C   Many people writing quick checks are not aware of the environment in which the
C   individual quick check is called.  The following aspects of the quick check
C   drivers are illustrated by the example driver in Section 14.
C    
C   1.  Each quick check driver will call one or more quick check subprograms.
C    
C   2.  The input and output units for the tests are set in the driver.
C    
C               LIN = I1MACH(1)        the input unit
C               LUN = I1MACH(2)        the output unit
C    
C       The output unit is communicated to the quick check subprograms
C       through the argument list.  All output should be directed to the unit LUN
C       that is in the argument list.
C    
C   3.  Each quick check has three arguments LUN, KPRINT, and IPASS.  The
C       meaning of these arguments within the quick checks is detailed
C       thoroughly in the previous section.
C    
C       a.  The quick check driver reads in KPRINT without a prompt, and
C           passes KPRINT as an argument to each quick check it calls.  KPRINT must
C           not be changed by any driver or quick check.  The driver uses KPRINT to
C           help determine what output to write.
C    
C       b.  The variable IPASS must be set to 0 (for fail) or to 1 (for pass) by
C           each quick check before returning to the driver.  Within the driver,
C           the variable NFAIL is set to 0.  If IPASS = 0 upon return to the
C           driver, then NFAIL is incremented.  After calling all the quick checks,
C           NFAIL will then have the number of quick checks which failed.
C    
C       c.  Quick check driver output should follow this chart:
C    
C                   NFAIL        OUTPUT
C                   -----        ------
C    
C                   not 0        driver writes fail message
C                     0          driver writes pass message
C    
C   4.  There are calls to three SLATEC error handler routines in each quick check
C       driver:
C    
C    
C               CALL XSETUN(LUN)       Selects unit LUN as the unit to which
C                                         error messages will be sent.
C               CALL XSETF(1)          Only fatal (not recoverable) error messages
C                 or XSETF(0)             will cause an abort.  XSETF sets the
C                                         KONTROL variable for the error handler
C                                         routines to the value of the XSETF
C                                         argument.  A value of either 0 or 1 will
C                                         make only fatal errors cause a program
C                                         abort.  A value of 1 will allow printing
C                                         of error messages, while a value of zero
C                                         will print only fatal error messages.
C               CALL XERMAX(1000)      Increase the number of times any
C                                         single message may be printed.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 13. QUICK CHECK SUBROUTINE EXAMPLE
C    
C   The following program provides a very minimal check of the sample routine
C   from Section 9.
C    
C    
C         SUBROUTINE ADTST (LUN, KPRINT, IPASS)
C   C***BEGIN PROLOGUE  ADTST
C   C***SUBSIDIARY
C   C***PURPOSE  Quick check for SLATEC routine ADDXY
C   C***LIBRARY   SLATEC
C   C***CATEGORY  A3A
C   C***TYPE      SINGLE PRECISION (ADTST-S, DADTST-D)
C   C***KEYWORDS  QUICK CHECK, ADDXY,
C   C***AUTHOR  Suyehiro, Tok, (LLNL)
C   C           Walton, Lee, (SNL)
C   C***ROUTINES CALLED  ADDXY, R1MACH
C   C***REVISION HISTORY  (YYMMDD)
C   C   880511  DATE WRITTEN
C   C   880608  Revised to meet new prologue standards.
C   C***END PROLOGUE  ADTST
C   C
C   C***FIRST EXECUTABLE STATEMENT  ADTST
C         IF ( KPRINT .GE. 2 ) WRITE (LUN,99999)
C   99999 FORMAT ('OUTPUT FROM ADTST')
C         IPASS = 1
C   C
C   C EXAMPLE PROBLEM
C         X = 1.
C         Y = 2.
C         CALL ADDXY(X, Y, Z, IERR)
C         EPS = R1MACH(4)
C         IF( (ABS(Z-3.) .GT. EPS)  .OR.  (IERR .EQ. 1) ) IPASS = 0
C         IF ( KPRINT .GE. 2 ) THEN
C         WRITE (LUN,99995)X, Y, Z
C   99995 FORMAT (/' EXAMPLE PROBLEM ',/' X = ',E20.13,' Y = ',E20.13,' Z = ',
C        *   E20.13)
C         ENDIF
C         IF ( (IPASS .EQ. 1 ) .AND. (KPRINT .GT. 1) ) WRITE (LUN,99994)
C         IF ( (IPASS .EQ. 0 ) .AND. (KPRINT .NE. 0) ) WRITE (LUN,99993)
C   99994 FORMAT(/' ***************ADDXY  PASSED ALL TESTS***************')
C   99993 FORMAT(/' ***************ADDXY  FAILED SOME TESTS***************')
C         RETURN
C         END
C    
C    
C    
C    
C   *******************************************************************************
C    
C   SECTION 14. QUICK CHECK MAIN PROGRAM EXAMPLE
C    
C   The following is an example main program which should be used to drive a quick
C   check.  The names of the quick check subroutines it calls, ADTST and DADTST,
C   should be replaced with the name or names of real quick checks.  The dummy
C   names of the SLATEC routines being tested, ADDXY and DADDXY, should be
C   replaced with the names of the routines which are actually being tested.
C    
C    
C         PROGRAM TEST00
C   C***BEGIN PROLOGUE  TEST00
C   C***SUBSIDIARY
C   C***PURPOSE  Driver for testing SLATEC subprograms
C   C            ADDXY    DADDXY
C   C***LIBRARY   SLATEC
C   C***CATEGORY  A3
C   C***TYPE      ALL (TEST00-A)
C   C***KEYWORDS  QUICK CHECK DRIVER, ADDXY, DADDXY
C   C***AUTHOR  Suyehiro, Tok, (LLNL)
C   C           Walton, Lee, (SNL)
C   C***DESCRIPTION
C   C
C   C *Usage:
C   C     One input data record is required
C   C         READ (LIN,990) KPRINT
C   C     990 FORMAT (I1)
C   C
C   C *Arguments:
C   C     KPRINT = 0  Quick checks - No printing.
C   C                 Driver       - Short pass or fail message printed.
C   C              1  Quick checks - No message printed for passed tests,
C   C                                short message printed for failed tests.
C   C                 Driver       - Short pass or fail message printed.
C   C              2  Quick checks - Print short message for passed tests,
C   C                                fuller information for failed tests.
C   C                 Driver       - Pass or fail message printed.
C   C              3  Quick checks - Print complete quick check results.
C   C                 Driver       - Pass or fail message printed.
C   C
C   C *Description:
C   C     Driver for testing SLATEC subprograms
C   C        ADDXY    DADDXY
C   C
C   C***REFERENCES  (NONE)
C   C***ROUTINES CALLED  ADTST, DADTST, I1MACH, XERMAX, XSETF, XSETUN
C   C***REVISION HISTORY  (YYMMDD)
C   C   880511  DATE WRITTEN
C   C   880608  Revised to meet the new SLATEC prologue standards.
C   C   881103  Brought DESCRIPTION section up to Appendix E standards.
C   C***END PROLOGUE  TEST00
C   C
C   C***FIRST EXECUTABLE STATEMENT  TEST00
C         LUN   = I1MACH(2)
C         LIN   = I1MACH(1)
C         NFAIL = 0
C   C
C   C   Read KPRINT parameter
C   C
C         READ (LIN,990) KPRINT
C     990 FORMAT (I1)
C         CALL XSETUN(LUN)
C         IF ( KPRINT .LE. 1 ) THEN
C            CALL XSETF(0)
C         ELSE
C            CALL XSETF(1)
C         ENDIF
C         CALL XERMAX(1000)
C   C
C   C   Test ADDXY
C   C
C         CALL ADTST(LUN, KPRINT, IPASS)
C         IF ( IPASS .EQ. 0 ) NFAIL = NFAIL + 1
C   C
C   C   Test DADDXY
C   C
C         CALL DADTST(LUN, KPRINT, IPASS)
C         IF ( IPASS .EQ. 0 ) NFAIL = NFAIL + 1
C   C
C         IF ( NFAIL .GT. 0 ) WRITE (LUN,980) NFAIL
C     980 FORMAT (/' ************* WARNING -- ', I5,
C        * ' TEST(S) FAILED IN PROGRAM TEST00 *************' )
C         IF ( NFAIL .EQ. 0 ) WRITE (LUN,970)
C     970 FORMAT
C        * (/' --------------TEST00  PASSED ALL TESTS----------------')
C         END
C    
C    
C    
C    
C   *******************************************************************************
C    
C   APPENDIX A.  GAMS (AND SLATEC) CLASSIFICATION SCHEME
C    
C   SLATEC has adopted the GAMS (Guide to Available Mathematical Software)
C   Classification Scheme for Mathematical and Statistical Software,
C   reference [5].
C    
C    
C                        GAMS (and SLATEC) Classification Scheme
C                                        for
C                        Mathematical and Statistical Software
C    
C    
C                              Version 1.2 October 1983
C    
C    
C    
C    
C   A.  Arithmetic, error analysis
C   A1.  Integer
C   A2.  Rational
C   A3.  Real
C   A3A.  Single precision
C   A3B.  Double precision
C   A3C.  Extended precision
C   A3D.  Extended range
C   A4.  Complex
C   A4A.  Single precision
C   A4B.  Double precision
C   A4C.  Extended precision
C   A4D.  Extended range
C   A5.  Interval
C   A5A.  Real
C   A5B.  Complex
C   A6.  Change of representation
C   A6A.  Type conversion
C   A6B.  Base conversion
C   A6C.  Decomposition, construction
C   A7.  Sequences (e.g., convergence acceleration)
C   B.  Number theory
C   C.  Elementary and special functions (search also class L5)
C   C1.  Integer-valued functions (e.g., floor, ceiling, factorial, binomial
C        coefficient)
C   C2.  Powers, roots, reciprocals
C   C3.  Polynomials
C   C3A.  Orthogonal
C   C3A1.  Trigonometric
C   C3A2.  Chebyshev, Legendre
C   C3A3.  Laguerre
C   C3A4.  Hermite
C   C3B.  Non-orthogonal
C   C4.  Elementary transcendental functions
C   C4A.  Trigonometric, inverse trigonometric
C   C4B.  Exponential, logarithmic
C   C4C.  Hyperbolic, inverse hyperbolic
C   C4D.  Integrals of elementary transcendental functions
C   C5.  Exponential and logarithmic integrals
C   C6.  Cosine and sine integrals
C   C7.  Gamma
C   C7A.  Gamma, log gamma, reciprocal gamma
C   C7B.  Beta, log beta
C   C7C.  Psi function
C   C7D.  Polygamma function
C   C7E.  Incomplete gamma
C   C7F.  Incomplete beta
C   C7G.  Riemann zeta
C   C8.  Error functions
C   C8A.  Error functions, their inverses, integrals, including the normal
C         distribution function
C   C8B.  Fresnel integrals
C   C8C.  Dawson's integral
C   C9.  Legendre functions
C   C10.  Bessel functions
C   C10A.  J, Y, H-(1), H-(2)
C   C10A1.  Real argument, integer order
C   C10A2.  Complex argument, integer order
C   C10A3.  Real argument, real order
C   C10A4.  Complex argument, real order
C   C10A5.  Complex argument, complex order
C   C10B.  I, K
C   C10B1.  Real argument, integer order
C   C10B2.  Complex argument, integer order
C   C10B3.  Real argument, real order
C   C10B4.  Complex argument, real order
C   C10B5.  Complex argument, complex order
C   C10C.  Kelvin functions
C   C10D.  Airy and Scorer functions
C   C10E.  Struve, Anger, and Weber functions
C   C10F.  Integrals of Bessel functions
C   C11.  Confluent hypergeometric functions
C   C12.  Coulomb wave functions
C   C13.  Jacobian elliptic functions, theta functions
C   C14.  Elliptic integrals
C   C15.  Weierstrass elliptic functions
C   C16.  Parabolic cylinder functions
C   C17.  Mathieu functions
C   C18.  Spheroidal wave functions
C   C19.  Other special functions
C   D.  Linear Algebra
C   D1.  Elementary vector and matrix operations
C   D1A.  Elementary vector operations
C   D1A1.  Set to constant
C   D1A2.  Minimum and maximum components
C   D1A3.  Norm
C   D1A3A.  L-1 (sum of magnitudes)
C   D1A3B.  L-2 (Euclidean norm)
C   D1A3C.  L-infinity (maximum magnitude)
C   D1A4.  Dot product (inner product)
C   D1A5.  Copy or exchange (swap)
C   D1A6.  Multiplication by scalar
C   D1A7.  Triad (a*x+y for vectors x,y and scalar a)
C   D1A8.  Elementary rotation (Givens transformation)
C   D1A9.  Elementary reflection (Householder transformation)
C   D1A10.  Convolutions
C   D1B.  Elementary matrix operations
C   D1B1.  Set to zero, to identity
C   D1B2.  Norm
C   D1B3.  Transpose
C   D1B4.  Multiplication by vector
C   D1B5.  Addition, subtraction
C   D1B6.  Multiplication
C   D1B7.  Matrix polynomial
C   D1B8.  Copy
C   D1B9.  Storage mode conversion
C   D1B10.  Elementary rotation (Givens transformation)
C   D1B11.  Elementary reflection (Householder transformation)
C   D2.  Solution of systems of linear equations (including inversion, LU and
C        related decompositions)
C   D2A.  Real nonsymmetric matrices
C   D2A1.  General
C   D2A2.  Banded
C   D2A2A.  Tridiagonal
C   D2A3.  Triangular
C   D2A4.  Sparse
C   D2B.  Real symmetric matrices
C   D2B1.  General
C   D2B1A.  Indefinite
C   D2B1B.  Positive definite
C   D2B2.  Positive definite banded
C   D2B2A.  Tridiagonal
C   D2B4.  Sparse
C   D2C.  Complex non-Hermitian matrices
C   D2C1.  General
C   D2C2.  Banded
C   D2C2A.  Tridiagonal
C   D2C3.  Triangular
C   D2C4.  Sparse
C   D2D.  Complex Hermitian matrices
C   D2D1.  General
C   D2D1A.  Indefinite
C   D2D1B.  Positive definite
C   D2D2.  Positive definite banded
C   D2D2A.  Tridiagonal
C   D2D4.  Sparse
C   D2E.  Associated operations (e.g., matrix reorderings)
C   D3.  Determinants
C   D3A.  Real nonsymmetric matrices
C   D3A1.  General
C   D3A2.  Banded
C   D3A2A.  Tridiagonal
C   D3A3.  Triangular
C   D3A4.  Sparse
C   D3B.  Real symmetric matrices
C   D3B1.  General
C   D3B1A.  Indefinite
C   D3B1B.  Positive definite
C   D3B2.  Positive definite banded
C   D3B2A.  Tridiagonal
C   D3B4.  Sparse
C   D3C.  Complex non-Hermitian matrices
C   D3C1.  General
C   D3C2.  Banded
C   D3C2A.  Tridiagonal
C   D3C3.  Triangular
C   D3C4.  Sparse
C   D3D.  Complex Hermitian matrices
C   D3D1.  General
C   D3D1A.  Indefinite
C   D3D1B.  Positive definite
C   D3D2.  Positive definite banded
C   D3D2A.  Tridiagonal
C   D3D4.  Sparse
C   D4.  Eigenvalues, eigenvectors
C   D4A.  Ordinary eigenvalue problems (Ax = (lambda) * x)
C   D4A1.  Real symmetric
C   D4A2.  Real nonsymmetric
C   D4A3.  Complex Hermitian
C   D4A4.  Complex non-Hermitian
C   D4A5.  Tridiagonal
C   D4A6.  Banded
C   D4A7.  Sparse
C   D4B.  Generalized eigenvalue problems (e.g., Ax = (lambda)*Bx)
C   D4B1.  Real symmetric
C   D4B2.  Real general
C   D4B3.  Complex Hermitian
C   D4B4.  Complex general
C   D4B5.  Banded
C   D4C.  Associated operations
C   D4C1.  Transform problem
C   D4C1A.  Balance matrix
C   D4C1B.  Reduce to compact form
C   D4C1B1.  Tridiagonal
C   D4C1B2.  Hessenberg
C   D4C1B3.  Other
C   D4C1C.  Standardize problem
C   D4C2.  Compute eigenvalues of matrix in compact form
C   D4C2A.  Tridiagonal
C   D4C2B.  Hessenberg
C   D4C2C.  Other
C   D4C3.  Form eigenvectors from eigenvalues
C   D4C4.  Back transform eigenvectors
C   D4C5.  Determine Jordan normal form
C   D5.  QR decomposition, Gram-Schmidt orthogonalization
C   D6.  Singular value decomposition
C   D7.  Update matrix decompositions
C   D7A.  LU
C   D7B.  Cholesky
C   D7C.  QR
C   D7D.  Singular value
C   D8.  Other matrix equations (e.g., AX+XB=C)
C   D9.  Overdetermined or underdetermined systems of equations, singular systems,
C        pseudo-inverses (search also classes D5, D6, K1a, L8a)
C   E.  Interpolation
C   E1.  Univariate data (curve fitting)
C   E1A.  Polynomial splines (piecewise polynomials)
C   E1B.  Polynomials
C   E1C.  Other functions (e.g., rational, trigonometric)
C   E2.  Multivariate data (surface fitting)
C   E2A.  Gridded
C   E2B.  Scattered
C   E3.  Service routines (e.g., grid generation, evaluation of fitted functions)
C        (search also class N5)
C   F.  Solution of nonlinear equations
C   F1.  Single equation
C   F1A.  Smooth
C   F1A1.  Polynomial
C   F1A1A.  Real coefficients
C   F1A1B.  Complex coefficients
C   F1A2.  Nonpolynomial
C   F1B.  General (no smoothness assumed)
C   F2.  System of equations
C   F2A.  Smooth
C   F2B.  General (no smoothness assumed)
C   F3.  Service routines (e.g., check user-supplied derivatives)
C   G.  Optimization (search also classes K, L8)
C   G1.  Unconstrained
C   G1A.  Univariate
C   G1A1.  Smooth function
C   G1A1A.  User provides no derivatives
C   G1A1B.  User provides first derivatives
C   G1A1C.  User provides first and second derivatives
C   G1A2.  General function (no smoothness assumed)
C   G1B.  Multivariate
C   G1B1.  Smooth function
C   G1B1A.  User provides no derivatives
C   G1B1B.  User provides first derivatives
C   G1B1C.  User provides first and second derivatives
C   G1B2.  General function (no smoothness assumed)
C   G2.  Constrained
C   G2A.  Linear programming
C   G2A1.  Dense matrix of constraints
C   G2A2.  Sparse matrix of constraints
C   G2B.  Transportation and assignments problem
C   G2C.  Integer programming
C   G2C1.  Zero/one
C   G2C2.  Covering and packing problems
C   G2C3.  Knapsack problems
C   G2C4.  Matching problems
C   G2C5.  Routing, scheduling, location problems
C   G2C6.  Pure integer programming
C   G2C7.  Mixed integer programming
C   G2D.  Network (for network reliability search class M)
C   G2D1.  Shortest path
C   G2D2.  Minimum spanning tree
C   G2D3.  Maximum flow
C   G2D3A.  Generalized networks
C   G2D3B.  Networks with side constraints
C   G2D4.  Test problem generation
C   G2E.  Quadratic programming
C   G2E1.  Positive definite Hessian (i.e. convex problem)
C   G2E2.  Indefinite Hessian
C   G2F.  Geometric programming
C   G2G.  Dynamic programming
C   G2H.  General nonlinear programming
C   G2H1.  Simple bounds
C   G2H1A.  Smooth function
C   G2H1A1.  User provides no derivatives
C   G2H1A2.  User provides first derivatives
C   G2H1A3.  User provides first and second derivatives
C   G2H1B.  General function (no smoothness assumed)
C   G2H2.  Linear equality or inequality constraints
C   G2H2A.  Smooth function
C   G2H2A1.  User provides no derivatives
C   G2H2A2.  User provides first derivatives
C   G2H2A3.  User provides first and second derivatives
C   G2H2B.  General function (no smoothness assumed)
C   G2H3.  Nonlinear constraints
C   G2H3A.  Equality constraints only
C   G2H3A1.  Smooth function and constraints
C   G2H3A1A.  User provides no derivatives
C   G2H3A1B.  User provides first derivatives of function and constraints
C   G2H3A1C.  User provides first and second derivatives of function and
C             constraints
C   G2H3A2.  General function and constraints (no smoothness assumed)
C   G2H3B.  Equality and inequality constraints
C   G2H3B1.  Smooth function and constraints
C   G2H3B1A.  User provides no derivatives
C   G2H3B1B.  User provides first derivatives of function and constraints
C   G2H3B1C.  User provides first and second derivatives of function and
C             constraints
C   G2H3B2.  General function and constraints (no smoothness assumed)
C   G2I.  Global solution to nonconvex problems
C   G3.  Optimal control
C   G4.  Service routines
C   G4A.  Problem input (e.g., matrix generation)
C   G4B.  Problem scaling
C   G4C.  Check user-supplied derivatives
C   G4D.  Find feasible point
C   G4E.  Check for redundancy
C   G4F.  Other
C   H.  Differentiation, integration
C   H1.  Numerical differentiation
C   H2.  Quadrature (numerical evaluation of definite integrals)
C   H2A.  One-dimensional integrals
C   H2A1.  Finite interval (general integrand)
C   H2A1A.  Integrand available via user-defined procedure
C   H2A1A1.  Automatic (user need only specify required accuracy)
C   H2A1A2.  Nonautomatic
C   H2A1B.  Integrand available only on grid
C   H2A1B1.  Automatic (user need only specify required accuracy)
C   H2A1B2.  Nonautomatic
C   H2A2.  Finite interval (specific or special type integrand including weight
C          functions, oscillating and singular integrands, principal value
C          integrals, splines, etc.)
C   H2A2A.  Integrand available via user-defined procedure
C   H2A2A1.  Automatic (user need only specify required accuracy)
C   H2A2A2.  Nonautomatic
C   H2A2B.  Integrand available only on grid
C   H2A2B1.  Automatic (user need only specify required accuracy)
C   H2A2B2.  Nonautomatic
C   H2A3.  Semi-infinite interval (including e**(-x) weight function)
C   H2A3A.  Integrand available via user-defined procedure
C   H2A3A1.  Automatic (user need only specify required accuracy)
C   H2A3A2.  Nonautomatic
C   H2A4.  Infinite interval (including e**(-x**2)) weight function)
C   H2A4A.  Integrand available via user-defined procedure
C   H2A4A1.  Automatic (user need only specify required accuracy)
C   H2A4A2.  Nonautomatic
C   H2B.  Multidimensional integrals
C   H2B1.  One or more hyper-rectangular regions
C   H2B1A.  Integrand available via user-defined procedure
C   H2B1A1.  Automatic (user need only specify required accuracy)
C   H2B1A2.  Nonautomatic
C   H2B1B.  Integrand available only on grid
C   H2B1B1.  Automatic (user need only specify required accuracy)
C   H2B1B2.  Nonautomatic
C   H2B2.  Nonrectangular region, general region
C   H2B2A.  Integrand available via user-defined procedure
C   H2B2A1.  Automatic (user need only specify required accuracy)
C   H2B2A2.  Nonautomatic
C   H2B2B.  Integrand available only on grid
C   H2B2B1.  Automatic (user need only specify required accuracy)
C   H2B2B2.  Nonautomatic
C   H2C.  Service routines (compute weight and nodes for quadrature formulas)
C   I.  Differential and integral equations
C   I1.  Ordinary differential equations
C   I1A.  Initial value problems
C   I1A1.  General, nonstiff or mildly stiff
C   I1A1A.  One-step methods (e.g., Runge-Kutta)
C   I1A1B.  Multistep methods (e.g., Adams' predictor-corrector)
C   I1A1C.  Extrapolation methods (e.g., Bulirsch-Stoer)
C   I1A2.  Stiff and mixed algebraic-differential equations
C   I1B.  Multipoint boundary value problems
C   I1B1.  Linear
C   I1B2.  Nonlinear
C   I1B3.  Eigenvalue (e.g., Sturm-Liouville)
C   I1C.  Service routines (e.g., interpolation of solutions, error handling)
C   I2.  Partial differential equations
C   I2A.  Initial boundary value problems
C   I2A1.  Parabolic
C   I2A1A.  One spatial dimension
C   I2A1B.  Two or more spatial dimensions
C   I2A2.  Hyperbolic
C   I2B.  Elliptic boundary value problems
C   I2B1.  Linear
C   I2B1A.  Second order
C   I2B1A1.  Poisson (Laplace) or Helmholz equation
C   I2B1A1A.  Rectangular domain (or topologically rectangular in the coordinate
C             system)
C   I2B1A1B.  Nonrectangular domain
C   I2B1A2.  Other separable problems
C   I2B1A3.  Nonseparable problems
C   I2B1C.  Higher order equations (e.g., biharmonic)
C   I2B2.  Nonlinear
C   I2B3.  Eigenvalue
C   I2B4.  Service routines
C   I2B4A.  Domain triangulation (search also class P2a2c1)
C   I2B4B.  Solution of discretized elliptic equations
C   I3.  Integral equations
C   J.  Integral transforms
C   J1.  Fast Fourier transforms (search class L10 for time series analysis)
C   J1A.  One-dimensional
C   J1A1.  Real
C   J1A2.  Complex
C   J1A3.  Trigonometric (sine, cosine)
C   J1B.  Multidimensional
C   J2.  Convolutions
C   J3.  Laplace transforms
C   J4.  Hilbert transforms
C   K.  Approximation (search also class L8)
C   K1.  Least squares (L-2) approximation
C   K1A.  Linear least squares (search also classes D5, D6, D9)
C   K1A1.  Unconstrained
C   K1A1A.  Univariate data (curve fitting)
C   K1A1A1.  Polynomial splines (piecewise polynomials)
C   K1A1A2.  Polynomials
C   K1A1A3.  Other functions (e.g., rational, trigonometric, user-specified)
C   K1A1B.  Multivariate data (surface fitting)
C   K1A2.  Constrained
C   K1A2A.  Linear constraints
C   K1A2B.  Nonlinear constraints
C   K1B.  Nonlinear least squares
C   K1B1.  Unconstrained
C   K1B1A.  Smooth functions
C   K1B1A1.  User provides no derivatives
C   K1B1A2.  User provides first derivatives
C   K1B1A3.  User provides first and second derivatives
C   K1B1B.  General functions
C   K1B2.  Constrained
C   K1B2A.  Linear constraints
C   K1B2B.  Nonlinear constraints
C   K2.  Minimax (L-infinity) approximation
C   K3.  Least absolute value (L-1) approximation
C   K4.  Other analytic approximations (e.g., Taylor polynomial, Pade)
C   K5.  Smoothing
C   K6.  Service routines (e.g., mesh generation, evaluation of fitted functions)
C        (search also class N5)
C   L.  Statistics, probability
C   L1.  Data summarization
C   L1A.  One univariate quantitative sample
C   L1A1.  Ungrouped data
C   L1A1A.  Location
C   L1A1B.  Dispersion
C   L1A1C.  Shape
C   L1A1D.  Distribution, density
C   L1A2.  Ungrouped data with missing values
C   L1A3.  Grouped data
C   L1A3A.  Location
C   L1A3B.  Dispersion
C   L1A3C.  Shape
C   L1C.  One univariate qualitative (proportional) sample
C   L1E.  Two or more univariate samples or one multivariate sample
C   L1E1.  Ungrouped data
C   L1E1A.  Location
C   L1E1B.  Correlation
C   L1E2.  Ungrouped data with missing values
C   L1E3.  Grouped data
C   L1F.  Two or more multivariate samples
C   L2.  Data manipulation (search also class N)
C   L2A.  Transform (search also class N6 for sorting, ranking)
C   L2B.  Group
C   L2C.  Sample
C   L2D.  Subset
C   L3.  Graphics (search also class Q)
C   L3A.  Histograms
C   L3B.  Distribution functions
C   L3C.  Scatter diagrams
C   L3C1.  Y vs. X
C   L3C2.  Symbol plots
C   L3C3.  Multiple plots
C   L3C4.  Probability plots
C   L3C4B.  Beta, binomial
C   L3C4C.  Cauchy, chi-squared
C   L3C4D.  Double exponential
C   L3C4E.  Exponential, extreme value
C   L3C4F.  F distribution
C   L3C4G.  Gamma, geometric
C   L3C4H.  Halfnormal
C   L3C4L.  Lambda, logistic, lognormal
C   L3C4N.  Negative binomial, normal
C   L3C4P.  Pareto, Poisson
C   L3C4T.  t distribution
C   L3C4U.  Uniform
C   L3C4W.  Weibull
C   L3C5.  Time series plots (X(i) vs. i, vertical, lag)
C   L3D.  EDA graphics
C   L4.  Elementary statistical inference, hypothesis testing
C   L4A.  One univariate quantitative sample
C   L4A1.  Ungrouped data
C   L4A1A.  Parameter estimation
C   L4A1A2.  Binomial
C   L4A1A5.  Extreme value
C   L4A1A14.  Normal
C   L4A1A16.  Poisson
C   L4A1A21.  Uniform
C   L4A1A23.  Weibull
C   L4A1B.  Distribution-free (nonparametric) analysis
C   L4A1C.  Goodness-of-fit tests
C   L4A1D.  Tests on sequences of numbers
C   L4A1E.  Density and distribution function estimation
C   L4A1F.  Tolerance limits
C   L4A2.  Ungrouped data with missing values
C   L4A3.  Grouped data
C   L4A3A.  Parameter estimation
C   L4A3A14.  Normal
C   L4B.  Two or more univariate quantitative samples
C   L4B1.  Ungrouped data
C   L4B1A.  Parameter estimation
C   L4B1A14.  Normal
C   L4B1B.  Distribution-free (nonparametric) analysis
C   L4B2.  Ungrouped data with missing values
C   L4B3.  Grouped data
C   L4C.  One univariate qualitative (proportional) sample
C   L4D.  Two or more univariate samples
C   L4E.  One multivariate sample
C   L4E1.  Ungrouped data
C   L4E1A.  Parameter estimation
C   L4E1A14.  Normal
C   L4E1B.  Distribution-free (nonparametric) analysis
C   L4E2.  Ungrouped data with missing values
C   L4E2A.  Parameter estimation
C   L4E2B.  Distribution-free (nonparametric) analysis
C   L4E3.  Grouped data
C   L4E3A.  Parameter estimation
C   L4E3A14.  Normal
C   L4E3B.  Distribution-free (nonparametric) analysis
C   L4E4.  Two or more multivariate samples
C   L4E4A.  Parameter estimation
C   L4E4A14.  Normal
C   L5.  Function evaluation (search also class C)
C   L5A.  Univariate
C   L5A1.  Cumulative distribution functions, probability density functions
C   L5A1B.  Beta, binomial
C   L5A1C.  Cauchy, chi-squared
C   L5A1D.  Double exponential
C   L5A1E.  Error function, exponential, extreme value
C   L5A1F.  F distribution
C   L5A1G.  Gamma, general, geometric
C   L5A1H.  Halfnormal, hypergeometric
C   L5A1K.  Kolmogorov-Smirnov
C   L5A1L.  Lambda, logistic, lognormal
C   L5A1N.  Negative binomial, normal
C   L5A1P.  Pareto, Poisson
C   L5A1T.  t distribution
C   L5A1U.  Uniform
C   L5A1W.  Weibull
C   L5A2.  Inverse cumulative distribution functions, sparsity functions
C   L5A2B.  Beta, binomial
C   L5A2C.  Cauchy, chi-squared
C   L5A2D.  Double exponential
C   L5A2E.  Exponential, extreme value
C   L5A2F.  F distribution
C   L5A2G.  Gamma, general, geometric
C   L5A2H.  Halfnormal
C   L5A2L.  Lambda, logistic, lognormal
C   L5A2N.  Negative binomial, normal, normal scores
C   L5A2P.  Pareto, Poisson
C   L5A2T.  t distribution
C   L5A2U.  Uniform
C   L5A2W.  Weibull
C   L5B.  Multivariate
C   L5B1.  Cumulative distribution functions, probability density functions
C   L5B1N.  Normal
C   L6.  Pseudo-random number generation
C   L6A.  Univariate
C   L6A2.  Beta, binomial, Boolean
C   L6A3.  Cauchy, chi-squared
C   L6A4.  Double exponential
C   L6A5.  Exponential, extreme value
C   L6A6.  F distribution
C   L6A7.  Gamma, general (continuous, discrete) distributions, geometric
C   L6A8.  Halfnormal, hypergeometric
C   L6A9.  Integers
C   L6A12.  Lambda, logical, logistic, lognormal
C   L6A14.  Negative binomial, normal
C   L6A15.  Order statistics
C   L6A16.  Pareto, permutations, Poisson
C   L6A19.  Samples, stable distribution
C   L6A20.  t distribution, time series, triangular
C   L6A21.  Uniform
C   L6A22.  Von Mises
C   L6A23.  Weibull
C   L6B.  Multivariate
C   L6B3.  Contingency table, correlation matrix
C   L6B13.  Multinomial
C   L6B14.  Normal
C   L6B15.  Orthogonal matrix
C   L6B21.  Uniform
C   L6C.  Service routines (e.g., seed)
C   L7.  Experimental design, including analysis of variance
C   L7A.  Univariate
C   L7A1.  One-way analysis of variance
C   L7A1A.  Parametric analysis
C   L7A1A1.  Contrasts, multiple comparisons
C   L7A1A2.  Analysis of variance components
C   L7A1B.  Distribution-free (nonparametric) analysis
C   L7A2.  Balanced multiway design
C   L7A2A.  Complete
C   L7A2A1.  Parametric analysis
C   L7A2A1A.  Two-way
C   L7A2A1B.  Factorial
C   L7A2A1C.  Nested
C   L7A2A2.  Distribution-free (nonparametric) analysis
C   L7A2B.  Incomplete
C   L7A2B1.  Parametric analysis
C   L7A2B1A.  Latin square
C   L7A2B1B.  Lattice designs
C   L7A2B2.  Distribution-free (nonparametric) analysis
C   L7A3.  Analysis of covariance
C   L7A4.  General linear model (unbalanced design)
C   L7A4A.  Parametric analysis
C   L7A4B.  Distribution-free (nonparametric) analysis
C   L7B.  Multivariate
C   L8.  Regression (search also classes G, K)
C   L8A.  Linear least squares (L-2) (search also classes D5, D6, D9)
C   L8A1.  Simple
C   L8A1A.  Ordinary
C   L8A1A1.  Unweighted
C   L8A1A1A.  No missing values
C   L8A1A1B.  Missing values
C   L8A1A2.  Weighted
C   L8A1B.  Through the origin
C   L8A1C.  Errors in variables
C   L8A1D.  Calibration (inverse regression)
C   L8A2.  Polynomial
C   L8A2A.  Not using orthogonal polynomials
C   L8A2A1.  Unweighted
C   L8A2A2.  Weighted
C   L8A2B.  Using orthogonal polynomials
C   L8A2B1.  Unweighted
C   L8A2B2.  Weighted
C   L8A3.  Piecewise polynomial (i.e. multiphase or spline)
C   L8A4.  Multiple
C   L8A4A.  Ordinary
C   L8A4A1.  Unweighted
C   L8A4A1A.  No missing values
C   L8A4A1B.  Missing values
C   L8A4A1C.  From correlation data
C   L8A4A1D.  Using principal components
C   L8A4A1E.  Using preference pairs
C   L8A4A2.  Weighted
C   L8A4B.  Errors in variables
C   L8A4D.  Logistic
C   L8A5.  Variable selection
C   L8A6.  Regression design
C   L8A7.  Several multiple regressions
C   L8A8.  Multivariate
C   L8A9.  Diagnostics
C   L8A10.  Hypothesis testing, inference
C   L8A10A.  Lack-of-fit tests
C   L8A10B.  Analysis of residuals
C   L8A10C.  Inference
C   L8B.  Biased (ridge)
C   L8C.  Linear least absolute value (L-1)
C   L8D.  Linear minimax (L-infinity)
C   L8E.  Robust
C   L8F.  EDA
C   L8G.  Nonlinear
C   L8G1.  Unweighted
C   L8G1A.  Derivatives not supplied
C   L8G1B.  Derivatives supplied
C   L8G2.  Weighted
C   L8G2A.  Derivatives not supplied
C   L8G2B.  Derivatives supplied
C   L8H.  Service routines
C   L9.  Categorical data analysis
C   L9A.  2-by-2 tables
C   L9B.  Two-way tables
C   L9C.  Log-linear model
C   L9D.  EDA (e.g., median polish)
C   L10.  Time series analysis (search also class L3c5 for time series graphics)
C   L10A.  Transformations, transforms (search also class J1)
C   L10B.  Smoothing, filtering
C   L10C.  Autocorrelation analysis
C   L10D.  Complex demodulation
C   L10E.  ARMA and ARIMA modeling and forecasting
C   L10E1.  Model and parameter estimation
C   L10E2.  Forecasting
C   L10F.  Spectral analysis
C   L10G.  Cross-correlation analysis
C   L10G1.  Parameter estimation
C   L10G2.  Forecasting
C   L11.  Correlation analysis
C   L12.  Discriminant analysis
C   L13.  Factor analysis
C   L13A.  Principal components analysis
C   L14.  Cluster analysis
C   L14A.  Unconstrained
C   L14A1.  Nested
C   L14A1A.  Joining (e.g., single link)
C   L14A1B.  Divisive
C   L14A2.  Non-nested
C   L14B.  Constrained
C   L14B1.  One-dimensional
C   L14B2.  Two-dimensional
C   L14C.  Display
C   L15.  Life testing, survival analysis
C   M.  Simulation, stochastic modeling (search also classes L6, L10)
C   M1.  Simulation
C   M1A.  Discrete
C   M1B.  Continuous (Markov models)
C   M2.  Queueing
C   M3.  Reliability
C   M3A.  Quality control
C   M3B.  Electrical network
C   M4.  Project optimization (e.g., PERT)
C   N.  Data handling (search also class L2)
C   N1.  Input, output
C   N2.  Bit manipulation
C   N3.  Character manipulation
C   N4.  Storage management (e.g., stacks, heaps, trees)
C   N5.  Searching
C   N5A.  Extreme value
C   N5B.  Insertion position
C   N5C.  On a key
C   N6.  Sorting
C   N6A.  Internal
C   N6A1.  Passive (i.e. construct pointer array, rank)
C   N6A1A.  Integer
C   N6A1B.  Real
C   N6A1B1.  Single precision
C   N6A1B2.  Double precision
C   N6A1C.  Character
C   N6A2.  Active
C   N6A2A.  Integer
C   N6A2B.  Real
C   N6A2B1.  Single precision
C   N6A2B2.  Double precision
C   N6A2C.  Character
C   N6B.  External
C   N7.  Merging
C   N8.  Permuting
C   O.  Symbolic computation
C   P.  Computational geometry (search also classes G, Q)
C   P1.  One dimension
C   P2.  Two dimensions
C   P2A.  Points, lines
C   P2A1.  Relationships
C   P2A1A.  Closest and farthest points
C   P2A1B.  Intersection
C   P2A2.  Graph construction
C   P2A2A.  Convex hull
C   P2A2B.  Minimum spanning tree
C   P2A2C.  Region partitioning
C   P2A2C1.  Triangulation
C   P2A2C2.  Voronoi diagram
C   P2B.  Polygons (e.g., intersection, hidden line problems)
C   P2C.  Circles
C   P3.  Three dimensions
C   P3A.  Points, lines, planes
C   P3B.  Polytopes
C   P3C.  Spheres
C   P4.  More than three dimensions
C   Q.  Graphics (search also classes L3, P)
C   Q1.  Line printer plotting
C   R.  Service routines
C   R1.  Machine-dependent constants
C   R2.  Error checking (e.g., check monotonicity)
C   R3.  Error handling
C   R3A.  Set criteria for fatal errors
C   R3B.  Set unit number for error messages
C   R3C.  Other utility programs
C   R4.  Documentation retrieval
C   S.  Software development tools
C   S1.  Program transformation
C   S2.  Static analysis
C   S3.  Dynamic analysis
C   Z.  Other
C    
C    
C    
C    
C   *******************************************************************************
C    
C   APPENDIX B.  MACHINE CONSTANTS
C    
C   The SLATEC Common Math Library uses three functions for keeping machine
C   constants.  In order to keep the source code for the Library as portable as
C   possible, no other Library routines should attempt to DATA load machine
C   dependent constants.  Due to the subtlety of trying to calculate machine
C   constants at run time in a manner that yields correct constants for all
C   possible computers, no Library routines should attempt to calculate them.
C   Routines I1MACH, R1MACH, and D1MACH in the SLATEC Common Math Library are
C   derived from the routines of these names in the Bell Laboratories' PORT Library
C   and should be called whenever machines constants are needed.  These functions
C   are DATA loaded with carefully determined constants of type integer, single
C   precision, and double precision, respectively, for a wide range of computers.
C   Each is called with one input argument to indicate which constant is desired.
C   The appropriate Fortran statements are:
C    
C   For integer constants:
C    
C         INTEGER I1MACH, I
C         I = I1MACH(N)                 where 1 .LE. N .LE. 16
C    
C   For single precision constants:
C    
C         REAL R1MACH, R
C         R = R1MACH(N)                 where 1 .LE. N .LE. 5
C    
C   For double precision constants:
C    
C         DOUBLE PRECISION D1MACH, D
C         D = D1MACH(N)                 where 1 .LE. N .LE. 5
C    
C   The different constants that can be retrieved will be explained below after we
C   give a summary of the floating point arithmetic model which they characterize.
C    
C   The PORT and SLATEC machine constant routines acknowledge that a computer
C   can have some minor flaws in how it performs arithmetic and that the purpose of
C   machine constant routines is to keep other library routines out of trouble.
C   For example, a computer may have a 48-bit coefficient, but due to round-off or
C   other deficiencies may be able to perform only 47-bit (or even 46-bit)
C   arithmetic reliably.  A machine can also misbehave at the extreme ends of its
C   exponent range.  The machine constants are chosen to describe a subset of the
C   floating point numbers of a computer on which operations such as addition,
C   subtraction, multiplication, reciprocation, and comparison work as your
C   intuition would expect.  If the actual performance of the machine is such that
C   results fall into the "expected" intervals of the subset floating point system,
C   then the usual forms of error analysis will apply.  For details, see [7].
C    
C   The machine constants normally cannot be determined by reading a computer's
C   hardware reference manual.  Such manuals tell the range and representation of
C   floating point numbers but usually do not describe the errors in the floating
C   point addition, subtraction, multiplication, reciprocation, or division units.
C   The constants for I1MACH, R1MACH, and D1MACH are found by doing extensive
C   testing using operands on which the hardware is most likely to fail.  Failure
C   is most likely to occur at the extreme ends of the exponent range and near
C   powers of the number base.  If such failures are relatively minor, we can
C   choose machine constants for I1MACH, R1MACH, and D1MACH to restrict the domain
C   of floating point numbers to a subset on which arithmetic operations work.
C    
C   The subset model of floating point arithmetic is characterized by four
C   parameters:
C    
C        B     the number base or radix.  This is usually 2 or 16.
C    
C        T     the number of digits in base B of the coefficient of the floating
C              point number.
C    
C        EMIN  the smallest (most negative) exponent (power of B)
C    
C        EMAX  the largest exponent (power of B)
C    
C   A floating point number is modeled as FRACTION*(B**EXP) where EXP falls between
C   EMIN and EMAX and the FRACTION is of the form
C    
C        + or - ( f(1)*B**(-1) + ... + f(T)*B**(-T) )
C    
C        with f(1) in the range 1 to B-1 inclusive and
C             f(2) through f(T) in the range 0 to B-1 inclusive.
C    
C   In this model the fraction has the radix point at the left end.  Some computers
C   have their radix point at the right end so that when their representation is
C   mapped onto this model, they appear to have an unbalanced exponent range (i.e.,
C   EMIN is not close to the negative of EMAX).  If the computer cannot correctly
C   calculate results near underflow, EMIN is increased to a more conservative
C   value.  Likewise, if the computer cannot correctly calculate results near
C   overflow, EMAX is decreased.  If a base 2 machine with a 48-bit fraction is
C   unable to calculate 48-bit results due to hardware round-off, T may be set to
C   47 (or even 46) to account for the loss of accuracy.
C    
C   The complete set of machine constants (including those not related to floating
C   point arithmetic) are:
C    
C   I/O Unit Numbers
C   ----------------
C    
C   I1MACH( 1) = the FORTRAN unit number for the standard input device.
C    
C   I1MACH( 2) = the FORTRAN unit number for the standard output device.
C    
C   I1MACH( 3) = the FORTRAN unit number for the standard punch device.
C    
C   I1MACH( 4) = the FORTRAN unit number for the standard error message device.
C    
C   Word Properties
C   ---------------
C    
C   I1MACH( 5) = the number of bits per integer storage unit.
C    
C   I1MACH( 6) = the number of characters per integer storage unit.
C    
C   Integer Arithmetic
C   ------------------
C    
C   I1MACH( 7) = the base or radix for integer arithmetic.
C    
C   I1MACH( 8) = the number of digits in radix I1MACH(7) used in integer
C                arithmetic.
C    
C   I1MACH( 9) = the largest magnitude integer for which the machine and compiler
C                perform the complete set of arithmetic operations.
C    
C   Floating Point Arithmetic
C   -------------------------
C    
C   I1MACH(10) = the base or radix for floating point arithmetic.  This is the B
C                of the floating point model.
C    
C   Single Precision Arithmetic
C   ---------------------------
C    
C   I1MACH(11) = the number of digits in radix I1MACH(10) used in single precision
C                arithmetic.  This is the T in the floating point model.
C    
C   I1MACH(12) = the most negative usable exponent short of underflow of radix
C                I1MACH(10) for a single precision number.  This is the EMIN in the
C                floating point model.
C    
C   I1MACH(13) = the largest usable exponent short of overflow of radix I1MACH(10)
C                for a single precision number.  This is the EMAX in the floating
C                point model.
C    
C   Double Precision Arithmetic
C   ---------------------------
C    
C   I1MACH(14) = the number of digits in radix I1MACH(10) used in double precision
C                arithmetic.  This is the T of the floating point model.
C    
C   I1MACH(15) = the most negative usable exponent short of underflow of radix
C                I1MACH(10) for a double precision number.  This is the EMIN of
C                the floating point model.
C    
C   I1MACH(16) = the largest usable exponent short of overflow of radix I1MACH(10)
C                for a double precision number.  This is the EMAX of the floating
C                point model.
C    
C   Special Single Precision Values
C   -------------------------------
C    
C   R1MACH( 1) = B**(EMIN-1).  This is the smallest, positive, single precision
C                number in the range for safe, accurate arithmetic.
C    
C   R1MACH( 2) = B**EMAX*(1-B**(-T)).  This is the largest, positive, single
C                precision number in the range for safe, accurate arithmetic.
C    
C   R1MACH( 3) = B**(-T).  This is the smallest relative spacing between two
C                adjacent single precision numbers in the floating point model.
C                This constant is not machine epsilon; see below for machine
C                epsilon.
C    
C   R1MACH( 4) = B**(1-T).  This is the largest relative spacing between two
C                adjacent single precision numbers in the floating point model.
C                Any two single precision numbers that have a greater relative
C                spacing than R1MACH(4) can be compared correctly (with operators
C                like .EQ. or .LT.). This constant is an upper bound on theoretical
C                machine epsilon.
C    
C   R1MACH( 5) = logarithm to base ten of the machine's floating point number base.
C    
C   Special Double Precision Values
C   -------------------------------
C    
C   D1MACH( 1) = B**(EMIN-1).  This is the smallest, positive, double precision
C                numbers in the range for safe, accurate arithmetic.
C    
C   D1MACH( 2) = B**EMAX*(1-B**(-T)).  This is the largest, positive, double
C                precision number in the range for safe, accurate arithmetic.
C    
C   D1MACH( 3) = B**(-T).  This is the smallest relative spacing between two
C                adjacent double precision numbers in the floating point model.
C                This constant is not machine epsilon; see below for machine
C                epsilon.
C    
C   D1MACH( 4) = B**(1-T).  This is the largest relative spacing between two
C                adjacent double precision numbers in the floating point model.
C                Any two double precision numbers that have a greater relative
C                spacing than D1MACH(4) can be compared correctly (with operators
C                like .EQ. or .LT.). This constant is an upper bound on theoretical
C                machine epsilon.
C    
C   D1MACH( 5) = logarithm to base ten of the machine's floating point number base.
C    
C   In theory, all of the R1MACH and D1MACH values can be calculated from I1MACH
C   values; however, they are provided (1) to save having to calculate them and (2)
C   to avoid rousing any bugs in the exponentiation (** operator ) or logarithm
C   routines.
C    
C   Machine epsilon (the smallest number that can be added to 1.0 or 1.0D0
C   that yields a result different from 1.0 or 1.0D0) is not one of the special
C   values that comes from this model.  If the purpose of machine epsilon is to
C   decide when iterations have converged, the proper constants to use are
C   R1MACH(4) or D1MACH(4).  These may be slightly larger than machine epsilon;
C   however, trying to iterate to smaller relative differences may not be possible
C   due to hardware round-off error.
C    
C   The Fortran standard requires that the amount of storage assigned to an INTEGER
C   and a REAL be the same.  Thus, the number of bits that can be used to represent
C   an INTEGER will almost always be larger than the number of bits in the mantissa
C   of a REAL.  In converting from an INTEGER to a REAL, some machines will
C   correctly round or truncate, but some will not.  Authors are therefore advised
C   to check the magnitude of INTEGERs and not attempt to convert INTEGERs to REALs
C   that can not be represented exactly as REALs.  Similar problems can occur when
C   converting INTEGERs to DOUBLEs.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   APPENDIX C.  ERROR HANDLING
C    
C   Authors of Library routines must use at least the first and preferably both of
C   the following techniques to handle errors that their routines detect.
C    
C   1.  One argument, preferably the last, in the calling sequence must be an
C       error flag if the routine can detect errors.  This is an integer variable
C       to which a value is assigned before returning to the caller.  A value of
C       zero means the routine completed successfully. A positive value (preferably
C       in the range 1 to 999) should be used to indicate potential, partial, or
C       total failure.  Separate values should be used for distinct conditions so
C       that the caller can determine the nature of the failure.  Of course, the
C       possible values of this error flag and their meanings must be documented in
C       the description section of the prologue of the routine.
C    
C   2.  In addition to returning an error flag, the routine can supply more
C       information by writing an error message via a call to XERMSG.  XERMSG
C       has an error number as one of its arguments, and the same value that will
C       be returned in the error flag argument must be used in calling XERMSG.
C    
C   XERMSG is part of the SLATEC Common Math Library error handling package
C   which consists of a number of routines.  It is not necessary for authors to
C   learn about the entire package.  Instead we summarize here a few aspects of the
C   package that an author must know in order to use XERMSG correctly.
C    
C   1.  Although XERMSG supports three levels of severity (warning, recoverable
C       error, and fatal error), be sparing in the use of fatal errors.  XERMSG
C       will terminate the program for fatal errors but may return for recoverable
C       errors, and will definitely return after warning messages.  An error should
C       be designated fatal only if returning to the caller is likely to be
C       disastrous (e.g. result in an infinite loop).
C    
C   2.  The error handling package remembers the value of the error number and has
C       an entry point whereby the user can retrieve the most recent error number.
C       Successive calls to XERMSG replace this retained value.  In the case of
C       warning messages, it is permissible to issue multiple warnings.  In the
C       case of a recoverable error, no additional calls to XERMSG must be made by
C       the Library routine before returning to the caller since the caller must be
C       given a chance to retrieve and clear the error number (and error condition)
C       from the error handling package.  In particular, if the user calls Library
C       routine X and X calls a lower level Library Y, it is permissible for Y
C       to call XERMSG, but after it returns to X, X must be careful to note any
C       recoverable errors detected in Y and not make any additional calls to
C       XERMSG in that case.  In practice, it would be simpler if subsidiary
C       routines did not call XERMSG but only returned error flags indicating a
C       serious problem.  Then the highest level Library routine could call XERMSG
C       just before returning to its caller.  This also allows the highest level
C       routine the most flexibility in assigning error numbers and assures that
C       all possible error conditions are documented in one prologue rather than
C       being distributed through prologues of subsidiary routines.
C    
C   Below we describe only subroutine XERMSG.  Other routines in the error
C   handling package are described in their prologues and in Reference [4].
C   The call to XERMSG looks like
C    
C   Template:  CALL XERMSG (library, routine, message, errornumber, level)
C    
C   Example:   CALL XERMSG ('SLATEC', 'MMPY',
C             1   'The order of the matrix exceeds the row dimension', 3, 1)
C    
C   where the meaning of the arguments is
C    
C   library       A character constant (or character variable) with the name of
C                 the library.  This will be 'SLATEC' for the SLATEC Common Math
C                 Library.  The error handling package is general enough to be used
C                 by many libraries simultaneously, so it is desirable for the
C                 routine that detects and reports an error to identify the library
C                 name as well as the routine name.
C    
C   routine       A character constant (or character variable) with the name of the
C                 routine that detected the error.  Usually it is the name of the
C                 routine that is calling XERMSG.  There are some instances where a
C                 user callable library routine calls lower level subsidiary
C                 routines where the error is detected.  In such cases it may be
C                 more informative to supply the name of the routine the user
C                 called rather than the name of the subsidiary routine that
C                 detected the error.
C    
C   message       A character constant (or character variable) with the text of the
C                 error or warning message.  In the example below, the message is a
C                 character constant that contains a generic message.
C    
C                       CALL XERMSG ('SLATEC', 'MMPY',
C                      *   'The order of the matrix exceeds the row dimension',
C                      *   3, 1)
C    
C                 It is possible (and is sometimes desirable) to generate a
C                 specific message--e.g., one that contains actual numeric values.
C                 Specific numeric values can be converted into character strings
C                 using formatted WRITE statements into character variables.  This
C                 is called standard Fortran internal file I/O and is exemplified
C                 in the first three lines of the following example.  You can also
C                 catenate substrings of characters to construct the error message.
C                 Here is an example showing the use of both writing to an internal
C                 file and catenating character strings.
C    
C                       CHARACTER*5 CHARN, CHARL
C                       WRITE (CHARN,10) N
C                       WRITE (CHARL,10) LDA
C                    10 FORMAT(I5)
C                       CALL XERMSG ('SLATEC', 'MMPY', 'The order'//CHARN//
C                      *   ' of the matrix exceeds its row dimension of'//
C                      *   CHARL, 3, 1)
C    
C                 There are two subtleties worth mentioning.  One is that the //
C                 for character catenation is used to construct the error message
C                 so that no single character constant is continued to the next
C                 line.  This avoids confusion as to whether there are trailing
C                 blanks at the end of the line.  The second is that by catenating
C                 the parts of the message as an actual argument rather than
C                 encoding the entire message into one large character variable,
C                 we avoid having to know how long the message will be in order to
C                 declare an adequate length for that large character variable.
C                 XERMSG calls XERPRN to print the message using multiple lines if
C                 necessary.  If the message is very long, XERPRN will break it
C                 into pieces of 72 characters (as requested by XERMSG) for
C                 printing on multiple lines.  Also, XERMSG asks XERPRN to prefix
C                 each line with ' *  ' so that the total line length could be 76
C                 characters.  Note also that XERPRN scans the error message
C                 backwards to ignore trailing blanks.  Another feature is that the
C                 substring '$$' is treated as a new line sentinel by XERPRN.  If
C                 you want to construct a multiline message without having to count
C                 out multiples of 72 characters, just use '$$' as a separator.
C                 '$$' obviously must occur within 72 characters of the start of
C                 each line to have its intended effect since XERPRN is asked to
C                 wrap around at 72 characters in addition to looking for '$$'.
C    
C   errornumber   An integer value that is chosen by the library routine's author.
C                 It must be in the range 1 to 999.  Each distinct error should
C                 have its own error number.  These error numbers should be
C                 described in the machine readable documentation for the routine.
C                 The error numbers need be unique only within each routine, so it
C                 is reasonable for each routine to start enumerating errors from 1
C                 and proceeding to the next integer.
C    
C   level         An integer value in the range 0 to 2 that indicates the level
C                 (severity) of the error.  Their meanings are
C    
C                 0  A warning message.  This is used if it is not clear that there
C                    really is an error, but the user's attention may be needed.
C    
C                 1  A recoverable error.  This is used even if the error is so
C                    serious that the routine cannot return any useful answer.  If
C                    the user has told the error package to return after
C                    recoverable errors, then XERMSG will return to the Library
C                    routine which can then return to the user's routine.  The user
C                    may also permit the error package to terminate the program
C                    upon encountering a recoverable error.
C    
C                 2  A fatal error.  XERMSG will not return to its caller after it
C                    receives a fatal error.  This level should hardly ever be
C                    used; it is much better to allow the user a chance to recover.
C                    An example of one of the few cases in which it is permissible
C                    to declare a level 2 error is a reverse communication Library
C                    routine that is likely to be called repeatedly until it
C                    integrates across some interval.  If there is a serious error
C                    in the input such that another step cannot be taken and the
C                    Library routine is called again without the input error having
C                    been corrected by the caller, the Library routine will
C                    probably be called forever with improper input.  In this case,
C                    it is reasonable to declare the error to be fatal.
C    
C   Each of the arguments to XERMSG is input; none will be modified by XERMSG.  A
C   routine may make multiple calls to XERMSG with warning level messages; however,
C   after a call to XERMSG with a recoverable error, the routine should return to
C   the user.  Do not try to call XERMSG with a second recoverable error after the
C   first recoverable error because the error package saves the error number.  The
C   user can retrieve this error number by calling another entry point in the error
C   handling package and then clear the error number when recovering from the
C   error.  Calling XERMSG in succession causes the old error number to be
C   overwritten by the latest error number.  This is considered harmless for error
C   numbers associated with warning messages but must not be done for error numbers
C   of serious errors.  After a call to XERMSG with a recoverable error, the user
C   must be given a chance to call NUMXER or XERCLR to retrieve or clear the error
C   number.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   APPENDIX D.  DISTRIBUTION FILE STRUCTURE
C    
C   The source files of the SLATEC library distribution tape are ASCII text files.
C   Each line image consists of exactly 80 characters.  The first file of the tape
C   is text file describing the contents of the tape.
C    
C   The SLATEC source code file has the following characteristics.
C    
C   1.  All subprograms in the file are in alphabetic order.  The collating
C       sequence is 0 through 9 and then A through Z.
C    
C   2.  Before each subprogram, of name for example XYZ, there is a line starting
C       in column 1 with
C    
C       *DECK XYZ
C    
C       This allows the source file to be used as input for a source code
C       maintenance program.
C    
C   3.  No comments other than the *DECK lines appear between subprograms.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   APPENDIX E.  SUGGESTED FORMAT FOR A SLATEC SUBPROGRAM
C    
C   A template embodying the suggested format for a SLATEC subprogram is given
C   below.  As elsewhere in this Guide, the caret (^) denotes a required blank
C   character.  These should be replaced with blanks AFTER filling out the
C   template.  The template itself begins with the *DECK line, below.  All
C   occurrences of "NAME" are to be replaced with the actual name of the
C   subprogram, of course.  Items in brackets [] are either explanations or
C   optional information.  Lines that do not have C or * in column 1 are
C   explanatory remarks that are intended to be deleted by the programmer.  In all
C   cases where "or" is used, exactly one of the indicated forms must occur.
C    
C   Lines that begin with C*** are standard SLATEC lines.  These must be in the
C   indicated order.  See Section 8 of this Guide for information on required vs
C   optional lines.  In all but the C***DESCRIPTION section, the exact spacing and
C   punctuation are as mandated by this Guide.  Spacing within this section is only
C   suggestive, except as noted below.  The SLATEC standard mandates that no other
C   comments may begin "C***".  All other lines between the C***BEGIN^PROLOGUE
C   and the C***END^PROLOGUE must be comment lines with "C^" in columns 1-2.
C    
C   Within the C***DESCRIPTION section, lines that begin with "C^*" are for the
C   LLNL LDOC standard [9].  If present, these lines must be exactly as given here.
C   They should be in the indicated order.  All other lines in this section must
C   have "C^^" in columns 1-3.
C    
C   In the Arguments subsection, each argument must be followed by exactly one
C   argument qualifier.  The qualifier must be preceded by a colon and followed
C   by at least one blank.  The allowable qualifiers and their meanings follow.
C    
C     Qualifier     Meaning
C     ---------    ---------
C      :IN      input variable.  Must be set by the user prior to the call
C               (unless otherwise indicated).  Must NOT be changed by the
C               routine under any circumstances.
C      :OUT     output variable.  Values will be set by the routine.
C               Must be initialized before first usage in the routine.
C      :INOUT   input/output variable.  Must be set by the user prior to
C               the call (as indicated in argument description); value(s)
C               may be set or changed by the routine.
C      :WORK    workspace.  Simply working storage required by the routine.
C               Need not be set prior to the call and will not contain
C               information meaningful to the user on return.  (Some
C               routines require the contents of a work array to remain
C               unchanged between successive calls.  Such usage should be
C               carefully explained in the argument description.)
C      :EXT     external procedure.  The actual argument must be the name of
C               a SUBROUTINE, FUNCTION, or BLOCK DATA subprogram.  It must
C               appear in an EXTERNAL statement in the calling program.  The
C               argument description following should precisely specify the
C               expected calling sequence.
C      :DUMMY   dummy argument.  Need not be set by user; will not be
C               referenced by the routine.  [Use discouraged!]
C    
C   To avoid potential problems with automatic formatting of argument descriptions,
C   none of these key words should appear anywhere else in the text immediately
C   preceded by a colon.
C    
C   NOTES:
C      1. Make a template by copying the following "*DECK^NAME" through
C         "^^^^^^END" lines, inclusive, from this Guide.
C      2. You will probably want to customize this template by filling
C         in the C***AUTHOR section and adding other things you customarily
C         include in your prologues.  If all of your routines are in the same
C         category(ies), you may wish to fill in the C***CATEGORY and
C         C***KEYWORDS sections, too.  Be sure to eliminate the brackets [].
C      3. Be sure to delete the "C***SUBSIDIARY" line if this is a user-
C         callable routine.
C    
C    
C   *DECK^NAME
C   ^^^^^^SUBROUTINE^NAME[^(ARG1[,^ARG2[,^...]])]               or
C   ^^^^^^FUNCTION^NAME^(ARG1[,^ARG2[,^...]])                   or
C   ^^^^^^COMPLEX^FUNCTION^NAME^(ARG1[,^ARG2[,^...]])           or
C   ^^^^^^DOUBLE^PRECISION^FUNCTION^NAME^(ARG1[,^ARG2[,^...]])  or
C   ^^^^^^INTEGER^FUNCTION^NAME^(ARG1[,^ARG2[,^...]])           or
C   ^^^^^^REAL^FUNCTION^NAME^(ARG1[,^ARG2[,^...]])              or
C   ^^^^^^LOGICAL^FUNCTION^NAME^(ARG1[,^ARG2[,^...]])           or
C   ^^^^^^CHARACTER[*len]^FUNCTION^NAME^(ARG1[,^ARG2[,^...]])
C   C***BEGIN^PROLOGUE^^NAME
C   C***SUBSIDIARY
C   C***PURPOSE^^Brief (1-6 lines) summary of the purpose of this routine.
C   C^^^^^^^^^^^^(To best fit LDOC standards, first line should be suitable
C   C^^^^^^^^^^^^for a table of contents entry for this routine.)
C   C***LIBRARY^^^SLATEC[^(Package)]
C   C***CATEGORY^^CAT1[,^CAT2]
C   C***TYPE^^^^^^SINGLE PRECISION^(NAME-S,^DNAME-D)
C   C***KEYWORDS^^KEY1[,^KEY2[,
C   C^^^^^^^^^^^^^MORE]]
C   C***AUTHOR^^Last-name[,^First-name[,^(Organization)]][
C   C^^^^^^^^^^^^^More information][
C   C^^^^^^^^^^^Second-last-name[,^First-name[,^(Organization)]][
C   C^^^^^^^^^^^^^More information]]
C   C***DESCRIPTION
C   C^^
C   C^*Usage:
C   C^^ This subsection should have declarations for all arguments to the
C   C^^   routine and a model call of the routine.  Use the actual names of
C   C^^   the arguments here. Ideally, arguments should be named in a way
C   C^^   that suggests their meaning.
C   C^^ The following example illustrates the use of dummy identifiers (in
C   C^^   lower case) to indicate that the required size of an array is
C   C^^   some function of the values of the other arguments.  This may not
C   C^^   be legal Fortran, but should be easier for a knowledgeable user
C   C^^   to understand than giving the required size somewhere else.
C   C^^
C   C^^      INTEGER  M, N, MDIMA, IERR
C   C^^      PARAMETER  (nfcns = 6, nwks = 3*nfcns+M+7)
C   C^^      REAL  X(nmax), A(MDIMA,nmax), FCNS(nfcns), WKS(nwks)
C   C^^
C   C^^      CALL NAME (M, N, X, A, MDIMA, FCNS, WKS, IERR)
C   C^^
C   C^*Arguments:
C   C^^ Arguments should be described in exactly the same order as in the
C   C^^   CALL list.  Include any restrictions, etc.
C   C^^ The following illustrates the recommended form of argument descrip-
C   C^^   tions for the example given above.  Note the use of qualifiers.
C   C^^
C   C^^   M :IN^    is the number of data points.
C   C^^
C   C^^   N :IN^    is the number of unknowns.  (Must have  0.lt.N.le.M .)
C   C^^
C   C^^   X :IN^    is a real array containing ...
C   C^^             (The dimensioned length of X must be at least N.)
C   C^^
C   C^^   A :INOUT^ should contain ... on input; will be destroyed on
C   C^^             return.  (The second dimension of A must be at least N.)
C   C^^
C   C^^   MDIMA:IN^ is the first dimension of array A.
C   C^^             (Must have  M.le.MDIMA .)
C   C^^
C   C^^   FCNS:OUT^ will contain the six summary functions based on ...
C   C^^
C   C^^   WKS:WORK^ is a real array of working storage.  Its length is a
C   C^^             function of the length of FCNS and the number of data
C   C^^             points, as indicated above.
C   C^^
C   C^^   IERR:OUT^ is an error flag with the following possible values:
C   C^^             Normal return:
C   C^^                IERR = 0  (no errors)
C   C^^             Warning error:
C   C^^                IERR > 0  means what?
C   C^^             "Recoverable" errors:
C   C^^                IERR =-1  if M < 1 or N < 1 .
C   C^^                IERR =-2  if M > MDIMA .
C   C^^                IERR =-3  means what?
C   C^^
C   C^*Function^Return^Values:
C   C^^ This subsection is present only in a FUNCTION subprogram.
C   C^^ In case of an integer- or character-valued function with a discrete
C   C^^   set of values, list all possible return values, with their
C   C^^   meanings, in the following form.  [The colon is significant.]
C   C^^      value : meaning
C   C^^   Otherwise, something of the following sort is acceptable.
C   C^^      SQRT : the square root of X.
C   C^^
C   C^*Description:
C   C^^ One or more paragraphs describing the intended routine use,
C   C^^   dependencies on other routines, etc.  Specific algorithm
C   C^^   descriptions could go here, if appropriate.
C   C^^ The emphasis should be on information useful to a user (as opposed
C   C^^   to developer or maintainer) of the routine.
C   C^^
C   C^*Examples:
C   C^^ Detailed examples of usage would go here, if desired.
C   C^^
C   C^*Accuracy:
C   C^^ This optional subsection contains notes on the accuracy or
C   C^^   precision of the results computed by the routine.
C   C^^
C   C^*Cautions:
C   C^^ List any known problems or potentially hazardous side effects
C   C^^   that are not otherwise described, such as not being safe for
C   C^^   multiprocessing or exceptional cases for arguments.
C   C^^   (Ideally, there should be none in a SLATEC routine!)
C   C^^
C   C^*See^Also:
C   C^^ This subsection would contain notes that refer to other library
C   C^^   routines that interrelate to this routine in important ways.
C   C^^   Examples include a solver for a LU factorization routine or an
C   C^^   evaluator for an interpolation or approximation routine.
C   C^^ This subsection may amplify information in the C***SEE ALSO
C   C^^   section, below, which should appear only if the prologue of the
C   C^^   listed routine(s) contains documentation for this routine.
C   C^^
C   C^*Long^Description:
C   C^^ An optional subsection containing much more detailed information.
C   C^^
C   C***SEE^ALSO^^RTN1[,^RTN2[,
C   C^^^^^^^^^^^^^RTNn]]
C   C***REFERENCES^^(NONE)              or
C   C***REFERENCES^^1. Reference 1 ...
C   C^^^^^^^^^^^^^^^^^Continuation of reference 1.
C   C^^^^^^^^^^^^^^^2. Reference 2 ...
C   C^^^^^^^^^^^^^^^^^Continuation of reference 2.
C   C***ROUTINES^CALLED^^(NONE)         or
C   C***ROUTINES^CALLED^^RTN1[,^RTN2[,
C   C^^^^^^^^^^^^^^^^^^^^RTNn]]
C      [Do not include standard Fortran intrinsics or externals.]
C   C***COMMON^BLOCKS^^^^BLOCK1[,^BLOCK2]
C   C***REVISION^HISTORY^^(YYMMDD)
C      [ This section should contain a record of the origin and ]
C      [ modification history of this routine.                  ]
C   C^^^871105^^DATE^WRITTEN
C   C^^^880121^^Various editorial changes.       (Version 6)
C   C^^^881102^^Converted to new SLATEC format.  (Version 7)
C   C^^^881128^^Various editorial changes.       (Version 8)
C   C^
C   C***END^PROLOGUE^^NAME
C   C
C   C*Internal Notes:
C   C   Implementation notes that explain details of the routine's design
C   C     or coding, tricky dependencies that might trip up a maintainer
C   C     later, environmental assumptions made, alternate designs that
C   C     were considered but not used, etc.
C   C   Details on contents of common blocks referenced, locks used, etc.,
C   C     would go here.
C   C   Emphasis is on INTERNALLY useful information.
C   C
C   C**End
C   C
C   C  Additional comments that are not appropriate even for an internal
C   C  document, but which the programmer feels should precede declarations.
C   C
C   C  Declare arguments.
C   C
C      < Declarations >
C   C
C   C  Declare local variables.
C   C
C      < Declarations >
C   C
C   C***FIRST^EXECUTABLE^STATEMENT^^NAME
C      < Body of NAME >
C   ^^^^^^END
C    
C    
C    
C    
C   *******************************************************************************
C    
C   ACKNOWLEDGEMENT
C    
C   The authors wish to acknowledge the assistance provided by  Dr. Frederick N.
C   Fritsch of the Computing and Mathematics Research Division, Lawrence Livermore
C   National Laboratory, who wrote Appendix E and made corrections and comments on
C   the manuscript.
C    
C    
C    
C    
C   *******************************************************************************
C    
C   REFERENCES
C    
C   [1]  W. H. Vandevender and K. H. Haskell, The SLATEC mathematical subroutine
C        library, SIGNUM Newsletter, 17, 3 (September 1982), pp. 16-21.
C    
C   [2]  P. A. Fox, A. D. Hall and N. L. Schryer, The PORT mathematical subroutine
C        library, ACM Transactions on Mathematical Software, 4, 2 (June 1978), pp.
C        104-126.
C    
C   [3]  P. A. Fox, A. D. Hall and N. L. Schryer, Algorithm 528: framework for a
C        portable library, ACM Transactions on Mathematical Software, 4, 2 (June
C        1978), pp. 177-188.
C    
C   [4]  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC error-handling package,
C        Software - Practice and Experience, 13, 3 (March 1983), pp. 251-257.
C    
C   [5]  R. F. Boisvert, S. E. Howe and D. K. Kahaner, GAMS: a framework for the
C        management of scientific software, ACM Transactions on Mathematical
C        Software, 11, 4 (December 1985), pp. 313-355.
C    
C   [6]  American National Standard Programming Language FORTRAN, ANSI X3.9-1978,
C        American National Standards Institute, 1430 Broadway, New York, New York
C        10018, April 1978.
C    
C   [7]  W. S. Brown, A simple but realistic model of floating point computation,
C        ACM Transactions on Mathematical Software, 7, 4 (December 1981), pp.
C        445-480.
C    
C   [8]  F. N. Fritsch, SLATEC/LDOC prologue: template and conversion program,
C        Report UCID-21357, Rev.1, Lawrence Livermore National Laboratory,
C        Livermore, California, November 1988.
C    




      
*DECK CSVDC
      SUBROUTINE CSVDC (X, LDX, N, P, S, E, U, LDU, V, LDV, WORK, JOB,
     +   INFO)
C***BEGIN PROLOGUE  CSVDC
C***PURPOSE  Perform the singular value decomposition of a rectangular
C            matrix.
C***LIBRARY   SLATEC (LINPACK)
C***CATEGORY  D6
C***TYPE      COMPLEX (SSVDC-S, DSVDC-D, CSVDC-C)
C***KEYWORDS  LINEAR ALGEBRA, LINPACK, MATRIX,
C             SINGULAR VALUE DECOMPOSITION
C***AUTHOR  Stewart, G. W., (U. of Maryland)
C***DESCRIPTION
C
C     CSVDC is a subroutine to reduce a complex NxP matrix X by
C     unitary transformations U and V to diagonal form.  The
C     diagonal elements S(I) are the singular values of X.  The
C     columns of U are the corresponding left singular vectors,
C     and the columns of V the right singular vectors.
C
C     On Entry
C
C         X         COMPLEX(LDX,P), where LDX .GE. N.
C                   X contains the matrix whose singular value
C                   decomposition is to be computed.  X is
C                   destroyed by CSVDC.
C
C         LDX       INTEGER.
C                   LDX is the leading dimension of the array X.
C
C         N         INTEGER.
C                   N is the number of rows of the matrix X.
C
C         P         INTEGER.
C                   P is the number of columns of the matrix X.
C
C         LDU       INTEGER.
C                   LDU is the leading dimension of the array U
C                   (see below).
C
C         LDV       INTEGER.
C                   LDV is the leading dimension of the array V
C                   (see below).
C
C         WORK      COMPLEX(N).
C                   WORK is a scratch array.
C
C         JOB       INTEGER.
C                   JOB controls the computation of the singular
C                   vectors.  It has the decimal expansion AB
C                   with the following meaning
C
C                        A .EQ. 0    Do not compute the left singular
C                                    vectors.
C                        A .EQ. 1    Return the N left singular vectors
C                                    in U.
C                        A .GE. 2    Return the first MIN(N,P)
C                                    left singular vectors in U.
C                        B .EQ. 0    Do not compute the right singular
C                                    vectors.
C                        B .EQ. 1    Return the right singular vectors
C                                    in V.
C
C     On Return
C
C         S         COMPLEX(MM), where MM = MIN(N+1,P).
C                   The first MIN(N,P) entries of S contain the
C                   singular values of X arranged in descending
C                   order of magnitude.
C
C         E         COMPLEX(P).
C                   E ordinarily contains zeros.  However see the
C                   discussion of INFO for exceptions.
C
C         U         COMPLEX(LDU,K), where LDU .GE. N.  If JOBA .EQ. 1
C                                   then K .EQ. N.  If JOBA .GE. 2 then
C                                   K .EQ. MIN(N,P).
C                   U contains the matrix of right singular vectors.
C                   U is not referenced if JOBA .EQ. 0.  If N .LE. P
C                   or if JOBA .GT. 2, then U may be identified with X
C                   in the subroutine call.
C
C         V         COMPLEX(LDV,P), where LDV .GE. P.
C                   V contains the matrix of right singular vectors.
C                   V is not referenced if JOB .EQ. 0.  If P .LE. N,
C                   then V may be identified with X in the
C                   subroutine call.
C
C         INFO      INTEGER.
C                   The singular values (and their corresponding
C                   singular vectors) S(INFO+1),S(INFO+2),...,S(M)
C                   are correct (here M=MIN(N,P)).  Thus if
C                   INFO.EQ. 0, all the singular values and their
C                   vectors are correct.  In any event, the matrix
C                   B = CTRANS(U)*X*V is the bidiagonal matrix
C                   with the elements of S on its diagonal and the
C                   elements of E on its super-diagonal (CTRANS(U)
C                   is the conjugate-transpose of U).  Thus the
C                   singular values of X and B are the same.
C
C***REFERENCES  J. J. Dongarra, J. R. Bunch, C. B. Moler, and G. W.
C                 Stewart, LINPACK Users' Guide, SIAM, 1979.
C***ROUTINES CALLED  CAXPY, CDOTC, CSCAL, CSROT, CSWAP, SCNRM2, SROTG
C***REVISION HISTORY  (YYMMDD)
C   790319  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900326  Removed duplicate information from DESCRIPTION section.
C           (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  CSVDC
      INTEGER LDX,N,P,LDU,LDV,JOB,INFO
      COMPLEX X(LDX,*),S(*),E(*),U(LDU,*),V(LDV,*),WORK(*)
C
C
      INTEGER I,ITER,J,JOBU,K,KASE,KK,L,LL,LLS,LM1,LP1,LS,LU,M,MAXIT,
     1        MM,MM1,MP1,NCT,NCTP1,NCU,NRT,NRTP1
      COMPLEX CDOTC,T,R
      REAL B,C,CS,EL,EMM1,F,G,SCNRM2,SCALE,SHIFT,SL,SM,SN,SMM1,T1,TEST,
     1     ZTEST
      LOGICAL WANTU,WANTV
      COMPLEX CSIGN,ZDUM,ZDUM1,ZDUM2
      REAL CABS1
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))
      CSIGN(ZDUM1,ZDUM2) = ABS(ZDUM1)*(ZDUM2/ABS(ZDUM2))
C***FIRST EXECUTABLE STATEMENT  CSVDC
C
C     SET THE MAXIMUM NUMBER OF ITERATIONS.
C
      MAXIT = 30
C
C     DETERMINE WHAT IS TO BE COMPUTED.
C
      WANTU = .FALSE.
      WANTV = .FALSE.
      JOBU = MOD(JOB,100)/10
      NCU = N
      IF (JOBU .GT. 1) NCU = MIN(N,P)
      IF (JOBU .NE. 0) WANTU = .TRUE.
      IF (MOD(JOB,10) .NE. 0) WANTV = .TRUE.
C
C     REDUCE X TO BIDIAGONAL FORM, STORING THE DIAGONAL ELEMENTS
C     IN S AND THE SUPER-DIAGONAL ELEMENTS IN E.
C
      INFO = 0
      NCT = MIN(N-1,P)
      NRT = MAX(0,MIN(P-2,N))
      LU = MAX(NCT,NRT)
      IF (LU .LT. 1) GO TO 170
      DO 160 L = 1, LU
         LP1 = L + 1
         IF (L .GT. NCT) GO TO 20
C
C           COMPUTE THE TRANSFORMATION FOR THE L-TH COLUMN AND
C           PLACE THE L-TH DIAGONAL IN S(L).
C
            S(L) = CMPLX(SCNRM2(N-L+1,X(L,L),1),0.0E0)
            IF (CABS1(S(L)) .EQ. 0.0E0) GO TO 10
               IF (CABS1(X(L,L)) .NE. 0.0E0) S(L) = CSIGN(S(L),X(L,L))
               CALL CSCAL(N-L+1,1.0E0/S(L),X(L,L),1)
               X(L,L) = (1.0E0,0.0E0) + X(L,L)
   10       CONTINUE
            S(L) = -S(L)
   20    CONTINUE
         IF (P .LT. LP1) GO TO 50
         DO 40 J = LP1, P
            IF (L .GT. NCT) GO TO 30
            IF (CABS1(S(L)) .EQ. 0.0E0) GO TO 30
C
C              APPLY THE TRANSFORMATION.
C
               T = -CDOTC(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)
               CALL CAXPY(N-L+1,T,X(L,L),1,X(L,J),1)
   30       CONTINUE
C
C           PLACE THE L-TH ROW OF X INTO  E FOR THE
C           SUBSEQUENT CALCULATION OF THE ROW TRANSFORMATION.
C
            E(J) = CONJG(X(L,J))
   40    CONTINUE
   50    CONTINUE
         IF (.NOT.WANTU .OR. L .GT. NCT) GO TO 70
C
C           PLACE THE TRANSFORMATION IN U FOR SUBSEQUENT BACK
C           MULTIPLICATION.
C
            DO 60 I = L, N
               U(I,L) = X(I,L)
   60       CONTINUE
   70    CONTINUE
         IF (L .GT. NRT) GO TO 150
C
C           COMPUTE THE L-TH ROW TRANSFORMATION AND PLACE THE
C           L-TH SUPER-DIAGONAL IN E(L).
C
            E(L) = CMPLX(SCNRM2(P-L,E(LP1),1),0.0E0)
            IF (CABS1(E(L)) .EQ. 0.0E0) GO TO 80
               IF (CABS1(E(LP1)) .NE. 0.0E0) E(L) = CSIGN(E(L),E(LP1))
               CALL CSCAL(P-L,1.0E0/E(L),E(LP1),1)
               E(LP1) = (1.0E0,0.0E0) + E(LP1)
   80       CONTINUE
            E(L) = -CONJG(E(L))
            IF (LP1 .GT. N .OR. CABS1(E(L)) .EQ. 0.0E0) GO TO 120
C
C              APPLY THE TRANSFORMATION.
C
               DO 90 I = LP1, N
                  WORK(I) = (0.0E0,0.0E0)
   90          CONTINUE
               DO 100 J = LP1, P
                  CALL CAXPY(N-L,E(J),X(LP1,J),1,WORK(LP1),1)
  100          CONTINUE
               DO 110 J = LP1, P
                  CALL CAXPY(N-L,CONJG(-E(J)/E(LP1)),WORK(LP1),1,
     1                       X(LP1,J),1)
  110          CONTINUE
  120       CONTINUE
            IF (.NOT.WANTV) GO TO 140
C
C              PLACE THE TRANSFORMATION IN V FOR SUBSEQUENT
C              BACK MULTIPLICATION.
C
               DO 130 I = LP1, P
                  V(I,L) = E(I)
  130          CONTINUE
  140       CONTINUE
  150    CONTINUE
  160 CONTINUE
  170 CONTINUE
C
C     SET UP THE FINAL BIDIAGONAL MATRIX OR ORDER M.
C
      M = MIN(P,N+1)
      NCTP1 = NCT + 1
      NRTP1 = NRT + 1
      IF (NCT .LT. P) S(NCTP1) = X(NCTP1,NCTP1)
      IF (N .LT. M) S(M) = (0.0E0,0.0E0)
      IF (NRTP1 .LT. M) E(NRTP1) = X(NRTP1,M)
      E(M) = (0.0E0,0.0E0)
C
C     IF REQUIRED, GENERATE U.
C
      IF (.NOT.WANTU) GO TO 300
         IF (NCU .LT. NCTP1) GO TO 200
         DO 190 J = NCTP1, NCU
            DO 180 I = 1, N
               U(I,J) = (0.0E0,0.0E0)
  180       CONTINUE
            U(J,J) = (1.0E0,0.0E0)
  190    CONTINUE
  200    CONTINUE
         IF (NCT .LT. 1) GO TO 290
         DO 280 LL = 1, NCT
            L = NCT - LL + 1
            IF (CABS1(S(L)) .EQ. 0.0E0) GO TO 250
               LP1 = L + 1
               IF (NCU .LT. LP1) GO TO 220
               DO 210 J = LP1, NCU
                  T = -CDOTC(N-L+1,U(L,L),1,U(L,J),1)/U(L,L)
                  CALL CAXPY(N-L+1,T,U(L,L),1,U(L,J),1)
  210          CONTINUE
  220          CONTINUE
               CALL CSCAL(N-L+1,(-1.0E0,0.0E0),U(L,L),1)
               U(L,L) = (1.0E0,0.0E0) + U(L,L)
               LM1 = L - 1
               IF (LM1 .LT. 1) GO TO 240
               DO 230 I = 1, LM1
                  U(I,L) = (0.0E0,0.0E0)
  230          CONTINUE
  240          CONTINUE
            GO TO 270
  250       CONTINUE
               DO 260 I = 1, N
                  U(I,L) = (0.0E0,0.0E0)
  260          CONTINUE
               U(L,L) = (1.0E0,0.0E0)
  270       CONTINUE
  280    CONTINUE
  290    CONTINUE
  300 CONTINUE
C
C     IF IT IS REQUIRED, GENERATE V.
C
      IF (.NOT.WANTV) GO TO 350
         DO 340 LL = 1, P
            L = P - LL + 1
            LP1 = L + 1
            IF (L .GT. NRT) GO TO 320
            IF (CABS1(E(L)) .EQ. 0.0E0) GO TO 320
               DO 310 J = LP1, P
                  T = -CDOTC(P-L,V(LP1,L),1,V(LP1,J),1)/V(LP1,L)
                  CALL CAXPY(P-L,T,V(LP1,L),1,V(LP1,J),1)
  310          CONTINUE
  320       CONTINUE
            DO 330 I = 1, P
               V(I,L) = (0.0E0,0.0E0)
  330       CONTINUE
            V(L,L) = (1.0E0,0.0E0)
  340    CONTINUE
  350 CONTINUE
C
C     TRANSFORM S AND E SO THAT THEY ARE REAL.
C
      DO 380 I = 1, M
         IF (CABS1(S(I)) .EQ. 0.0E0) GO TO 360
            T = CMPLX(ABS(S(I)),0.0E0)
            R = S(I)/T
            S(I) = T
            IF (I .LT. M) E(I) = E(I)/R
            IF (WANTU) CALL CSCAL(N,R,U(1,I),1)
  360    CONTINUE
         IF (I .EQ. M) GO TO 390
         IF (CABS1(E(I)) .EQ. 0.0E0) GO TO 370
            T = CMPLX(ABS(E(I)),0.0E0)
            R = T/E(I)
            E(I) = T
            S(I+1) = S(I+1)*R
            IF (WANTV) CALL CSCAL(P,R,V(1,I+1),1)
  370    CONTINUE
  380 CONTINUE
  390 CONTINUE
C
C     MAIN ITERATION LOOP FOR THE SINGULAR VALUES.
C
      MM = M
      ITER = 0
  400 CONTINUE
C
C        QUIT IF ALL THE SINGULAR VALUES HAVE BEEN FOUND.
C
         IF (M .EQ. 0) GO TO 660
C
C        IF TOO MANY ITERATIONS HAVE BEEN PERFORMED, SET
C        FLAG AND RETURN.
C
         IF (ITER .LT. MAXIT) GO TO 410
            INFO = M
            GO TO 660
  410    CONTINUE
C
C        THIS SECTION OF THE PROGRAM INSPECTS FOR
C        NEGLIGIBLE ELEMENTS IN THE S AND E ARRAYS.  ON
C        COMPLETION THE VARIABLES KASE AND L ARE SET AS FOLLOWS.
C
C           KASE = 1     IF S(M) AND E(L-1) ARE NEGLIGIBLE AND L.LT.M
C           KASE = 2     IF S(L) IS NEGLIGIBLE AND L.LT.M
C           KASE = 3     IF E(L-1) IS NEGLIGIBLE, L.LT.M, AND
C                        S(L), ..., S(M) ARE NOT NEGLIGIBLE (QR STEP).
C           KASE = 4     IF E(M-1) IS NEGLIGIBLE (CONVERGENCE).
C
         DO 430 LL = 1, M
            L = M - LL
            IF (L .EQ. 0) GO TO 440
            TEST = ABS(S(L)) + ABS(S(L+1))
            ZTEST = TEST + ABS(E(L))
            IF (ZTEST .NE. TEST) GO TO 420
               E(L) = (0.0E0,0.0E0)
               GO TO 440
  420       CONTINUE
  430    CONTINUE
  440    CONTINUE
         IF (L .NE. M - 1) GO TO 450
            KASE = 4
         GO TO 520
  450    CONTINUE
            LP1 = L + 1
            MP1 = M + 1
            DO 470 LLS = LP1, MP1
               LS = M - LLS + LP1
               IF (LS .EQ. L) GO TO 480
               TEST = 0.0E0
               IF (LS .NE. M) TEST = TEST + ABS(E(LS))
               IF (LS .NE. L + 1) TEST = TEST + ABS(E(LS-1))
               ZTEST = TEST + ABS(S(LS))
               IF (ZTEST .NE. TEST) GO TO 460
                  S(LS) = (0.0E0,0.0E0)
                  GO TO 480
  460          CONTINUE
  470       CONTINUE
  480       CONTINUE
            IF (LS .NE. L) GO TO 490
               KASE = 3
            GO TO 510
  490       CONTINUE
            IF (LS .NE. M) GO TO 500
               KASE = 1
            GO TO 510
  500       CONTINUE
               KASE = 2
               L = LS
  510       CONTINUE
  520    CONTINUE
         L = L + 1
C
C        PERFORM THE TASK INDICATED BY KASE.
C
         GO TO (530, 560, 580, 610), KASE
C
C        DEFLATE NEGLIGIBLE S(M).
C
  530    CONTINUE
            MM1 = M - 1
            F = REAL(E(M-1))
            E(M-1) = (0.0E0,0.0E0)
            DO 550 KK = L, MM1
               K = MM1 - KK + L
               T1 = REAL(S(K))
               CALL SROTG(T1,F,CS,SN)
               S(K) = CMPLX(T1,0.0E0)
               IF (K .EQ. L) GO TO 540
                  F = -SN*REAL(E(K-1))
                  E(K-1) = CS*E(K-1)
  540          CONTINUE
               IF (WANTV) CALL CSROT(P,V(1,K),1,V(1,M),1,CS,SN)
  550       CONTINUE
         GO TO 650
C
C        SPLIT AT NEGLIGIBLE S(L).
C
  560    CONTINUE
            F = REAL(E(L-1))
            E(L-1) = (0.0E0,0.0E0)
            DO 570 K = L, M
               T1 = REAL(S(K))
               CALL SROTG(T1,F,CS,SN)
               S(K) = CMPLX(T1,0.0E0)
               F = -SN*REAL(E(K))
               E(K) = CS*E(K)
               IF (WANTU) CALL CSROT(N,U(1,K),1,U(1,L-1),1,CS,SN)
  570       CONTINUE
         GO TO 650
C
C        PERFORM ONE QR STEP.
C
  580    CONTINUE
C
C           CALCULATE THE SHIFT.
C
            SCALE = MAX(ABS(S(M)),ABS(S(M-1)),ABS(E(M-1)),
     1                    ABS(S(L)),ABS(E(L)))
            SM = REAL(S(M))/SCALE
            SMM1 = REAL(S(M-1))/SCALE
            EMM1 = REAL(E(M-1))/SCALE
            SL = REAL(S(L))/SCALE
            EL = REAL(E(L))/SCALE
            B = ((SMM1 + SM)*(SMM1 - SM) + EMM1**2)/2.0E0
            C = (SM*EMM1)**2
            SHIFT = 0.0E0
            IF (B .EQ. 0.0E0 .AND. C .EQ. 0.0E0) GO TO 590
               SHIFT = SQRT(B**2+C)
               IF (B .LT. 0.0E0) SHIFT = -SHIFT
               SHIFT = C/(B + SHIFT)
  590       CONTINUE
            F = (SL + SM)*(SL - SM) - SHIFT
            G = SL*EL
C
C           CHASE ZEROS.
C
            MM1 = M - 1
            DO 600 K = L, MM1
               CALL SROTG(F,G,CS,SN)
               IF (K .NE. L) E(K-1) = CMPLX(F,0.0E0)
               F = CS*REAL(S(K)) + SN*REAL(E(K))
               E(K) = CS*E(K) - SN*S(K)
               G = SN*REAL(S(K+1))
               S(K+1) = CS*S(K+1)
               IF (WANTV) CALL CSROT(P,V(1,K),1,V(1,K+1),1,CS,SN)
               CALL SROTG(F,G,CS,SN)
               S(K) = CMPLX(F,0.0E0)
               F = CS*REAL(E(K)) + SN*REAL(S(K+1))
               S(K+1) = -SN*E(K) + CS*S(K+1)
               G = SN*REAL(E(K+1))
               E(K+1) = CS*E(K+1)
               IF (WANTU .AND. K .LT. N)
     1            CALL CSROT(N,U(1,K),1,U(1,K+1),1,CS,SN)
  600       CONTINUE
            E(M-1) = CMPLX(F,0.0E0)
            ITER = ITER + 1
         GO TO 650
C
C        CONVERGENCE.
C
  610    CONTINUE
C
C           MAKE THE SINGULAR VALUE  POSITIVE
C
            IF (REAL(S(L)) .GE. 0.0E0) GO TO 620
               S(L) = -S(L)
               IF (WANTV) CALL CSCAL(P,(-1.0E0,0.0E0),V(1,L),1)
  620       CONTINUE
C
C           ORDER THE SINGULAR VALUE.
C
  630       IF (L .EQ. MM) GO TO 640
               IF (REAL(S(L)) .GE. REAL(S(L+1))) GO TO 640
               T = S(L)
               S(L) = S(L+1)
               S(L+1) = T
               IF (WANTV .AND. L .LT. P)
     1            CALL CSWAP(P,V(1,L),1,V(1,L+1),1)
               IF (WANTU .AND. L .LT. N)
     1            CALL CSWAP(N,U(1,L),1,U(1,L+1),1)
               L = L + 1
            GO TO 630
  640       CONTINUE
            ITER = 0
            M = M - 1
  650    CONTINUE
      GO TO 400
  660 CONTINUE
      RETURN
      END
*DECK SROTG
      SUBROUTINE SROTG (SA, SB, SC, SS)
C***BEGIN PROLOGUE  SROTG
C***PURPOSE  Construct a plane Givens rotation.
C***LIBRARY   SLATEC (BLAS)
C***CATEGORY  D1B10
C***TYPE      SINGLE PRECISION (SROTG-S, DROTG-D, CROTG-C)
C***KEYWORDS  BLAS, GIVENS ROTATION, GIVENS TRANSFORMATION,
C             LINEAR ALGEBRA, VECTOR
C***AUTHOR  Lawson, C. L., (JPL)
C           Hanson, R. J., (SNLA)
C           Kincaid, D. R., (U. of Texas)
C           Krogh, F. T., (JPL)
C***DESCRIPTION
C
C                B L A S  Subprogram
C    Description of Parameters
C
C     --Input--
C       SA  single precision scalar
C       SB  single precision scalar
C
C     --Output--
C       SA  single precision result R
C       SB  single precision result Z
C       SC  single precision result
C       SS  single precision result
C
C     Construct the Givens transformation
C
C         ( SC  SS )
C     G = (        ) ,    SC**2 + SS**2 = 1 ,
C         (-SS  SC )
C
C     which zeros the second entry of the 2-vector  (SA,SB)**T.
C
C     The quantity R = (+/-)SQRT(SA**2 + SB**2) overwrites SA in
C     storage.  The value of SB is overwritten by a value Z which
C     allows SC and SS to be recovered by the following algorithm:
C
C           If Z=1  set  SC=0.0  and  SS=1.0
C           If ABS(Z) .LT. 1  set  SC=SQRT(1-Z**2)  and  SS=Z
C           If ABS(Z) .GT. 1  set  SC=1/Z  and  SS=SQRT(1-SC**2)
C
C     Normally, the subprogram SROT(N,SX,INCX,SY,INCY,SC,SS) will
C     next be called to apply the transformation to a 2 by N matrix.
C
C***REFERENCES  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
C                 Krogh, Basic linear algebra subprograms for Fortran
C                 usage, Algorithm No. 539, Transactions on Mathematical
C                 Software 5, 3 (September 1979), pp. 308-323.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   791001  DATE WRITTEN
C   861211  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  SROTG
C***FIRST EXECUTABLE STATEMENT  SROTG
      IF (ABS(SA) .LE. ABS(SB)) GO TO 10
C
C *** HERE ABS(SA) .GT. ABS(SB) ***
C
      U = SA + SA
      V = SB / U
C
C     NOTE THAT U AND R HAVE THE SIGN OF SA
C
      R = SQRT(0.25E0 + V**2) * U
C
C     NOTE THAT SC IS POSITIVE
C
      SC = SA / R
      SS = V * (SC + SC)
      SB = SS
      SA = R
      RETURN
C
C *** HERE ABS(SA) .LE. ABS(SB) ***
C
   10 IF (SB .EQ. 0.0E0) GO TO 20
      U = SB + SB
      V = SA / U
C
C     NOTE THAT U AND R HAVE THE SIGN OF SB
C     (R IS IMMEDIATELY STORED IN SA)
C
      SA = SQRT(0.25E0 + V**2) * U
C
C     NOTE THAT SS IS POSITIVE
C
      SS = SB / SA
      SC = V * (SS + SS)
      IF (SC .EQ. 0.0E0) GO TO 15
      SB = 1.0E0 / SC
      RETURN
   15 SB = 1.0E0
      RETURN
C
C *** HERE SA = SB = 0.0 ***
C
   20 SC = 1.0E0
      SS = 0.0E0
      RETURN
C
      END
*DECK SCNRM2
      REAL FUNCTION SCNRM2 (N, CX, INCX)
C***BEGIN PROLOGUE  SCNRM2
C***PURPOSE  Compute the unitary norm of a complex vector.
C***LIBRARY   SLATEC (BLAS)
C***CATEGORY  D1A3B
C***TYPE      COMPLEX (SNRM2-S, DNRM2-D, SCNRM2-C)
C***KEYWORDS  BLAS, EUCLIDEAN LENGTH, EUCLIDEAN NORM, L2,
C             LINEAR ALGEBRA, UNITARY, VECTOR
C***AUTHOR  Lawson, C. L., (JPL)
C           Hanson, R. J., (SNLA)
C           Kincaid, D. R., (U. of Texas)
C           Krogh, F. T., (JPL)
C***DESCRIPTION
C
C                B L A S  Subprogram
C    Description of Parameters
C
C     --Input--
C        N  number of elements in input vector(s)
C       CX  complex vector with N elements
C     INCX  storage spacing between elements of CX
C
C     --Output--
C   SCNRM2  single precision result (zero if N .LE. 0)
C
C     Unitary norm of the complex N-vector stored in CX with storage
C     increment INCX.
C     If N .LE. 0, return with result = 0.
C     If N .GE. 1, then INCX must be .GE. 1
C
C     Four phase method using two built-in constants that are
C     hopefully applicable to all machines.
C         CUTLO = maximum of  SQRT(U/EPS)  over all known machines.
C         CUTHI = minimum of  SQRT(V)      over all known machines.
C     where
C         EPS = smallest no. such that EPS + 1. .GT. 1.
C         U   = smallest positive no.   (underflow limit)
C         V   = largest  no.            (overflow  limit)
C
C     Brief outline of algorithm.
C
C     Phase 1 scans zero components.
C     Move to phase 2 when a component is nonzero and .LE. CUTLO
C     Move to phase 3 when a component is .GT. CUTLO
C     Move to phase 4 when a component is .GE. CUTHI/M
C     where M = N for X() real and M = 2*N for complex.
C
C     Values for CUTLO and CUTHI.
C     From the environmental parameters listed in the IMSL converter
C     document the limiting values are as follows:
C     CUTLO, S.P.   U/EPS = 2**(-102) for  Honeywell.  Close seconds are
C                   Univac and DEC at 2**(-103)
C                   Thus CUTLO = 2**(-51) = 4.44089E-16
C     CUTHI, S.P.   V = 2**127 for Univac, Honeywell, and DEC.
C                   Thus CUTHI = 2**(63.5) = 1.30438E19
C     CUTLO, D.P.   U/EPS = 2**(-67) for Honeywell and DEC.
C                   Thus CUTLO = 2**(-33.5) = 8.23181D-11
C     CUTHI, D.P.   same as S.P.  CUTHI = 1.30438D19
C     DATA CUTLO, CUTHI /8.232D-11,  1.304D19/
C     DATA CUTLO, CUTHI /4.441E-16,  1.304E19/
C
C***REFERENCES  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
C                 Krogh, Basic linear algebra subprograms for Fortran
C                 usage, Algorithm No. 539, Transactions on Mathematical
C                 Software 5, 3 (September 1979), pp. 308-323.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   791001  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890831  Modified array declarations.  (WRB)
C   890831  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  SCNRM2
      LOGICAL IMAG, SCALE
      INTEGER NEXT
      REAL CUTLO, CUTHI, HITEST, SUM, XMAX, ABSX, ZERO, ONE
      COMPLEX CX(*)
      SAVE CUTLO, CUTHI, ZERO, ONE
      DATA ZERO, ONE /0.0E0, 1.0E0/
C
      DATA CUTLO, CUTHI /4.441E-16,  1.304E19/
C***FIRST EXECUTABLE STATEMENT  SCNRM2
      IF (N .GT. 0) GO TO 10
         SCNRM2  = ZERO
         GO TO 300
C
   10 ASSIGN 30 TO NEXT
      SUM = ZERO
      NN = N * INCX
C
C                                                 BEGIN MAIN LOOP
C
      DO 210 I = 1,NN,INCX
         ABSX = ABS(REAL(CX(I)))
         IMAG = .FALSE.
         GO TO NEXT,(30, 50, 70, 90, 110)
   30 IF (ABSX .GT. CUTLO) GO TO 85
      ASSIGN 50 TO NEXT
      SCALE = .FALSE.
C
C                        PHASE 1.  SUM IS ZERO
C
   50 IF (ABSX .EQ. ZERO) GO TO 200
      IF (ABSX .GT. CUTLO) GO TO 85
C
C                                PREPARE FOR PHASE 2.
C
      ASSIGN 70 TO NEXT
      GO TO 105
C
C                                PREPARE FOR PHASE 4.
C
  100 ASSIGN 110 TO NEXT
      SUM = (SUM / ABSX) / ABSX
  105 SCALE = .TRUE.
      XMAX = ABSX
      GO TO 115
C
C                   PHASE 2.  SUM IS SMALL.
C                             SCALE TO AVOID DESTRUCTIVE UNDERFLOW.
C
   70 IF (ABSX .GT. CUTLO) GO TO 75
C
C                     COMMON CODE FOR PHASES 2 AND 4.
C                     IN PHASE 4 SUM IS LARGE.  SCALE TO AVOID OVERFLOW.
C
  110 IF (ABSX .LE. XMAX) GO TO 115
         SUM = ONE + SUM * (XMAX / ABSX)**2
         XMAX = ABSX
         GO TO 200
C
  115 SUM = SUM + (ABSX/XMAX)**2
      GO TO 200
C
C                  PREPARE FOR PHASE 3.
C
   75 SUM = (SUM * XMAX) * XMAX
C
   85 ASSIGN 90 TO NEXT
      SCALE = .FALSE.
C
C     FOR REAL OR D.P. SET HITEST = CUTHI/N
C     FOR COMPLEX      SET HITEST = CUTHI/(2*N)
C
      HITEST = CUTHI / N
C
C                   PHASE 3.  SUM IS MID-RANGE.  NO SCALING.
C
   90 IF (ABSX .GE. HITEST) GO TO 100
         SUM = SUM + ABSX**2
  200 CONTINUE
C
C                  CONTROL SELECTION OF REAL AND IMAGINARY PARTS.
C
      IF (IMAG) GO TO 210
         ABSX = ABS(AIMAG(CX(I)))
         IMAG = .TRUE.
      GO TO NEXT,(  50, 70, 90, 110 )
C
  210 CONTINUE
C
C              END OF MAIN LOOP.
C              COMPUTE SQUARE ROOT AND ADJUST FOR SCALING.
C
      SCNRM2 = SQRT(SUM)
      IF (SCALE) SCNRM2 = SCNRM2 * XMAX
  300 CONTINUE
      RETURN
      END
*DECK CSCAL
      SUBROUTINE CSCAL (N, CA, CX, INCX)
C***BEGIN PROLOGUE  CSCAL
C***PURPOSE  Multiply a vector by a constant.
C***LIBRARY   SLATEC (BLAS)
C***CATEGORY  D1A6
C***TYPE      COMPLEX (SSCAL-S, DSCAL-D, CSCAL-C)
C***KEYWORDS  BLAS, LINEAR ALGEBRA, SCALE, VECTOR
C***AUTHOR  Lawson, C. L., (JPL)
C           Hanson, R. J., (SNLA)
C           Kincaid, D. R., (U. of Texas)
C           Krogh, F. T., (JPL)
C***DESCRIPTION
C
C                B L A S  Subprogram
C    Description of Parameters
C
C     --Input--
C        N  number of elements in input vector(s)
C       CA  complex scale factor
C       CX  complex vector with N elements
C     INCX  storage spacing between elements of CX
C
C     --Output--
C       CX  complex result (unchanged if N .LE. 0)
C
C     Replace complex CX by complex CA*CX.
C     For I = 0 to N-1, replace CX(IX+I*INCX) with CA*CX(IX+I*INCX),
C     where IX = 1 if INCX .GE. 0, else IX = 1+(1-N)*INCX.
C
C***REFERENCES  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
C                 Krogh, Basic linear algebra subprograms for Fortran
C                 usage, Algorithm No. 539, Transactions on Mathematical
C                 Software 5, 3 (September 1979), pp. 308-323.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   791001  DATE WRITTEN
C   890831  Modified array declarations.  (WRB)
C   890831  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900821  Modified to correct problem with a negative increment.
C           (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  CSCAL
      COMPLEX CA, CX(*)
      INTEGER I, INCX, IX, N
C***FIRST EXECUTABLE STATEMENT  CSCAL
      IF (N .LE. 0) RETURN
C
      IF (INCX .EQ. 1) GOTO 20
C
C     Code for increment not equal to 1.
C
      IX = 1
      IF (INCX .LT. 0) IX = (-N+1)*INCX + 1
      DO 10 I = 1,N
        CX(IX) = CA*CX(IX)
        IX = IX + INCX
   10 CONTINUE
      RETURN
C
C     Code for increment equal to 1.
C
   20 DO 30 I = 1,N
        CX(I) = CA*CX(I)
   30 CONTINUE
      RETURN
      END
*DECK CDOTC
      COMPLEX FUNCTION CDOTC (N, CX, INCX, CY, INCY)
C***BEGIN PROLOGUE  CDOTC
C***PURPOSE  Dot product of two complex vectors using the complex
C            conjugate of the first vector.
C***LIBRARY   SLATEC (BLAS)
C***CATEGORY  D1A4
C***TYPE      COMPLEX (CDOTC-C)
C***KEYWORDS  BLAS, INNER PRODUCT, LINEAR ALGEBRA, VECTOR
C***AUTHOR  Lawson, C. L., (JPL)
C           Hanson, R. J., (SNLA)
C           Kincaid, D. R., (U. of Texas)
C           Krogh, F. T., (JPL)
C***DESCRIPTION
C
C                B L A S  Subprogram
C    Description of Parameters
C
C     --Input--
C        N  number of elements in input vector(s)
C       CX  complex vector with N elements
C     INCX  storage spacing between elements of CX
C       CY  complex vector with N elements
C     INCY  storage spacing between elements of CY
C
C     --Output--
C    CDOTC  complex result (zero if N .LE. 0)
C
C     Returns the dot product of complex CX and CY, using CONJUGATE(CX)
C     CDOTC = SUM for I = 0 to N-1 of CONJ(CX(LX+I*INCX))*CY(LY+I*INCY),
C     where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is
C     defined in a similar way using INCY.
C
C***REFERENCES  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
C                 Krogh, Basic linear algebra subprograms for Fortran
C                 usage, Algorithm No. 539, Transactions on Mathematical
C                 Software 5, 3 (September 1979), pp. 308-323.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   791001  DATE WRITTEN
C   890831  Modified array declarations.  (WRB)
C   890831  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920310  Corrected definition of LX in DESCRIPTION.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  CDOTC
      COMPLEX CX(*),CY(*)
C***FIRST EXECUTABLE STATEMENT  CDOTC
      CDOTC = (0.0,0.0)
      IF (N .LE. 0) RETURN
      IF (INCX.EQ.INCY .AND. INCX.GT.0) GO TO 20
C
C     Code for unequal or nonpositive increments.
C
      KX = 1
      KY = 1
      IF (INCX .LT. 0) KX = 1+(1-N)*INCX
      IF (INCY .LT. 0) KY = 1+(1-N)*INCY
      DO 10 I = 1,N
        CDOTC = CDOTC + CONJG(CX(KX))*CY(KY)
        KX = KX + INCX
        KY = KY + INCY
   10 CONTINUE
      RETURN
C
C     Code for equal, positive increments.
C
   20 NS = N*INCX
      DO 30 I = 1,NS,INCX
      CDOTC = CDOTC + CONJG(CX(I))*CY(I)
   30 CONTINUE
      RETURN
      END
*DECK CSROT
      SUBROUTINE CSROT (N, CX, INCX, CY, INCY, C, S)
C***BEGIN PROLOGUE  CSROT
C***PURPOSE  Apply a plane Givens rotation.
C***LIBRARY   SLATEC (BLAS)
C***CATEGORY  D1B10
C***TYPE      COMPLEX (SROT-S, DROT-D, CSROT-C)
C***KEYWORDS  BLAS, GIVENS ROTATION, GIVENS TRANSFORMATION,
C             LINEAR ALGEBRA, PLANE ROTATION, VECTOR
C***AUTHOR  Dongarra, J., (ANL)
C***DESCRIPTION
C
C     CSROT applies the complex Givens rotation
C
C          (X)   ( C S)(X)
C          (Y) = (-S C)(Y)
C
C     N times where for I = 0,...,N-1
C
C          X = CX(LX+I*INCX)
C          Y = CY(LY+I*INCY),
C
C     where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is
C     defined in a similar way using INCY.
C
C     Argument Description
C
C        N      (integer)  number of elements in each vector
C
C        CX     (complex array)  beginning of one vector
C
C        INCX   (integer)  memory spacing of successive elements
C               of vector CX
C
C        CY     (complex array)  beginning of the other vector
C
C        INCY   (integer)  memory spacing of successive elements
C               of vector CY
C
C        C      (real)  cosine term of the rotation
C
C        S      (real)  sine term of the rotation.
C
C***REFERENCES  J. J. Dongarra, J. R. Bunch, C. B. Moler, and G. W.
C                 Stewart, LINPACK Users' Guide, SIAM, 1979.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   810223  DATE WRITTEN
C   890831  Modified array declarations.  (WRB)
C   890831  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920310  Corrected definition of LX in DESCRIPTION.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  CSROT
      COMPLEX CX(*), CY(*), CTEMP
      REAL C, S
      INTEGER I, INCX, INCY, IX, IY, N
C***FIRST EXECUTABLE STATEMENT  CSROT
      IF (N .LE. 0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1)GO TO 20
C
C     Code for unequal increments or equal increments not equal to 1.
C
      IX = 1
      IY = 1
      IF (INCX .LT. 0) IX = (-N+1)*INCX + 1
      IF (INCY .LT. 0) IY = (-N+1)*INCY + 1
      DO 10 I = 1,N
        CTEMP = C*CX(IX) + S*CY(IY)
        CY(IY) = C*CY(IY) - S*CX(IX)
        CX(IX) = CTEMP
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      RETURN
C
C     Code for both increments equal to 1.
C
   20 DO 30 I = 1,N
        CTEMP = C*CX(I) + S*CY(I)
        CY(I) = C*CY(I) - S*CX(I)
        CX(I) = CTEMP
   30 CONTINUE
      RETURN
      END
*DECK CAXPY
      SUBROUTINE CAXPY (N, CA, CX, INCX, CY, INCY)
C***BEGIN PROLOGUE  CAXPY
C***PURPOSE  Compute a constant times a vector plus a vector.
C***LIBRARY   SLATEC (BLAS)
C***CATEGORY  D1A7
C***TYPE      COMPLEX (SAXPY-S, DAXPY-D, CAXPY-C)
C***KEYWORDS  BLAS, LINEAR ALGEBRA, TRIAD, VECTOR
C***AUTHOR  Lawson, C. L., (JPL)
C           Hanson, R. J., (SNLA)
C           Kincaid, D. R., (U. of Texas)
C           Krogh, F. T., (JPL)
C***DESCRIPTION
C
C                B L A S  Subprogram
C    Description of Parameters
C
C     --Input--
C        N  number of elements in input vector(s)
C       CA  complex scalar multiplier
C       CX  complex vector with N elements
C     INCX  storage spacing between elements of CX
C       CY  complex vector with N elements
C     INCY  storage spacing between elements of CY
C
C     --Output--
C       CY  complex result (unchanged if N .LE. 0)
C
C     Overwrite complex CY with complex  CA*CX + CY.
C     For I = 0 to N-1, replace  CY(LY+I*INCY) with CA*CX(LX+I*INCX) +
C       CY(LY+I*INCY),
C     where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is
C     defined in a similar way using INCY.
C
C***REFERENCES  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
C                 Krogh, Basic linear algebra subprograms for Fortran
C                 usage, Algorithm No. 539, Transactions on Mathematical
C                 Software 5, 3 (September 1979), pp. 308-323.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   791001  DATE WRITTEN
C   861211  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920310  Corrected definition of LX in DESCRIPTION.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C   920801  Removed variable CANORM.  (RWC, WRB)
C***END PROLOGUE  CAXPY
      COMPLEX CX(*), CY(*), CA
C***FIRST EXECUTABLE STATEMENT  CAXPY
      IF (N.LE.0 .OR. CA.EQ.(0.0E0,0.0E0)) RETURN
      IF (INCX.EQ.INCY .AND. INCX.GT.0) GO TO 20
C
C     Code for unequal or nonpositive increments.
C
      KX = 1
      KY = 1
      IF (INCX .LT. 0) KX = 1+(1-N)*INCX
      IF (INCY .LT. 0) KY = 1+(1-N)*INCY
      DO 10 I = 1,N
        CY(KY) = CY(KY) + CA*CX(KX)
        KX = KX + INCX
        KY = KY + INCY
   10 CONTINUE
      RETURN
C
C     Code for equal, positive, non-unit increments.
C
   20 NS = N*INCX
      DO 30 I = 1,NS,INCX
        CY(I) = CA*CX(I) + CY(I)
   30 CONTINUE
      RETURN
      END
*DECK CSWAP
      SUBROUTINE CSWAP (N, CX, INCX, CY, INCY)
C***BEGIN PROLOGUE  CSWAP
C***PURPOSE  Interchange two vectors.
C***LIBRARY   SLATEC (BLAS)
C***CATEGORY  D1A5
C***TYPE      COMPLEX (SSWAP-S, DSWAP-D, CSWAP-C, ISWAP-I)
C***KEYWORDS  BLAS, INTERCHANGE, LINEAR ALGEBRA, VECTOR
C***AUTHOR  Lawson, C. L., (JPL)
C           Hanson, R. J., (SNLA)
C           Kincaid, D. R., (U. of Texas)
C           Krogh, F. T., (JPL)
C***DESCRIPTION
C
C                B L A S  Subprogram
C    Description of Parameters
C
C     --Input--
C        N  number of elements in input vector(s)
C       CX  complex vector with N elements
C     INCX  storage spacing between elements of CX
C       CY  complex vector with N elements
C     INCY  storage spacing between elements of CY
C
C     --Output--
C       CX  input vector CY (unchanged if N .LE. 0)
C       CY  input vector CX (unchanged if N .LE. 0)
C
C     Interchange complex CX and complex CY
C     For I = 0 to N-1, interchange  CX(LX+I*INCX) and CY(LY+I*INCY),
C     where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is
C     defined in a similar way using INCY.
C
C***REFERENCES  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
C                 Krogh, Basic linear algebra subprograms for Fortran
C                 usage, Algorithm No. 539, Transactions on Mathematical
C                 Software 5, 3 (September 1979), pp. 308-323.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   791001  DATE WRITTEN
C   890831  Modified array declarations.  (WRB)
C   890831  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920310  Corrected definition of LX in DESCRIPTION.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  CSWAP
      COMPLEX CX(*),CY(*),CTEMP
C***FIRST EXECUTABLE STATEMENT  CSWAP
      IF (N .LE. 0) RETURN
      IF (INCX.EQ.INCY .AND. INCX.GT.0) GO TO 20
C
C     Code for unequal or nonpositive increments.
C
      KX = 1
      KY = 1
      IF (INCX .LT. 0) KX = 1+(1-N)*INCX
      IF (INCY .LT. 0) KY = 1+(1-N)*INCY
      DO 10 I = 1,N
        CTEMP = CX(KX)
        CX(KX) = CY(KY)
        CY(KY) = CTEMP
        KX = KX + INCX
        KY = KY + INCY
   10 CONTINUE
      RETURN
C
C     Code for equal, positive, non-unit increments.
C
   20 NS = N*INCX
      DO 30 I = 1,NS,INCX
        CTEMP = CX(I)
        CX(I) = CY(I)
        CY(I) = CTEMP
   30 CONTINUE
      RETURN
      END
*DECK FZERO
      SUBROUTINE FZERO (F, B, C, R, RE, AE, IFLAG)
C***BEGIN PROLOGUE  FZERO
C***PURPOSE  Search for a zero of a function F(X) in a given interval
C            (B,C).  It is designed primarily for problems where F(B)
C            and F(C) have opposite signs.
C***LIBRARY   SLATEC
C***CATEGORY  F1B
C***TYPE      SINGLE PRECISION (FZERO-S, DFZERO-D)
C***KEYWORDS  BISECTION, NONLINEAR EQUATIONS, ROOTS, ZEROS
C***AUTHOR  Shampine, L. F., (SNLA)
C           Watts, H. A., (SNLA)
C***DESCRIPTION
C
C     FZERO searches for a zero of a REAL function F(X) between the
C     given REAL values B and C until the width of the interval (B,C)
C     has collapsed to within a tolerance specified by the stopping
C     criterion,
C        ABS(B-C) .LE. 2.*(RW*ABS(B)+AE).
C     The method used is an efficient combination of bisection and the
C     secant rule and is due to T. J. Dekker.
C
C     Description Of Arguments
C
C   F     :EXT   - Name of the REAL external function.  This name must
C                  be in an EXTERNAL statement in the calling program.
C                  F must be a function of one REAL argument.
C
C   B     :INOUT - One end of the REAL interval (B,C).  The value
C                  returned for B usually is the better approximation
C                  to a zero of F.
C
C   C     :INOUT - The other end of the REAL interval (B,C)
C
C   R     :OUT   - A (better) REAL guess of a zero of F which could help
C                  in speeding up convergence.  If F(B) and F(R) have
C                  opposite signs, a root will be found in the interval
C                  (B,R); if not, but F(R) and F(C) have opposite signs,
C                  a root will be found in the interval (R,C);
C                  otherwise, the interval (B,C) will be searched for a
C                  possible root.  When no better guess is known, it is
C                  recommended that r be set to B or C, since if R is
C                  not interior to the interval (B,C), it will be
C                  ignored.
C
C   RE    :IN    - Relative error used for RW in the stopping criterion.
C                  If the requested RE is less than machine precision,
C                  then RW is set to approximately machine precision.
C
C   AE    :IN    - Absolute error used in the stopping criterion.  If
C                  the given interval (B,C) contains the origin, then a
C                  nonzero value should be chosen for AE.
C
C   IFLAG :OUT   - A status code.  User must check IFLAG after each
C                  call.  Control returns to the user from FZERO in all
C                  cases.
C
C                1  B is within the requested tolerance of a zero.
C                   The interval (B,C) collapsed to the requested
C                   tolerance, the function changes sign in (B,C), and
C                   F(X) decreased in magnitude as (B,C) collapsed.
C
C                2  F(B) = 0.  However, the interval (B,C) may not have
C                   collapsed to the requested tolerance.
C
C                3  B may be near a singular point of F(X).
C                   The interval (B,C) collapsed to the requested tol-
C                   erance and the function changes sign in (B,C), but
C                   F(X) increased in magnitude as (B,C) collapsed, i.e.
C                     ABS(F(B out)) .GT. MAX(ABS(F(B in)),ABS(F(C in)))
C
C                4  No change in sign of F(X) was found although the
C                   interval (B,C) collapsed to the requested tolerance.
C                   The user must examine this case and decide whether
C                   B is near a local minimum of F(X), or B is near a
C                   zero of even multiplicity, or neither of these.
C
C                5  Too many (.GT. 500) function evaluations used.
C
C***REFERENCES  L. F. Shampine and H. A. Watts, FZERO, a root-solving
C                 code, Report SC-TM-70-631, Sandia Laboratories,
C                 September 1970.
C               T. J. Dekker, Finding a zero by means of successive
C                 linear interpolation, Constructive Aspects of the
C                 Fundamental Theorem of Algebra, edited by B. Dejon
C                 and P. Henrici, Wiley-Interscience, 1969.
C***ROUTINES CALLED  R1MACH
C***REVISION HISTORY  (YYMMDD)
C   700901  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  FZERO
      REAL A,ACBS,ACMB,AE,AW,B,C,CMB,ER,FA,FB,FC,FX,FZ,P,Q,R,
     +     RE,RW,T,TOL,Z
      INTEGER IC,IFLAG,KOUNT
C***FIRST EXECUTABLE STATEMENT  FZERO
C
C   ER is two times the computer unit roundoff value which is defined
C   here by the function R1MACH.
C
c      ER = 2.0E0 * R1MACH(4)
C
C   Initialize.
C
      Z = R
      IF (R .LE. MIN(B,C)  .OR.  R .GE. MAX(B,C)) Z = C

c      RW = MAX(RE,ER)
      rw = re

      AW = MAX(AE,0.E0)
      IC = 0
      T = Z
      FZ = F(T)
      FC = FZ
      T = B
      FB = F(T)
      KOUNT = 2
      IF (SIGN(1.0E0,FZ) .EQ. SIGN(1.0E0,FB)) GO TO 1
      C = Z
      GO TO 2
    1 IF (Z .EQ. C) GO TO 2
      T = C
      FC = F(T)
      KOUNT = 3
      IF (SIGN(1.0E0,FZ) .EQ. SIGN(1.0E0,FC)) GO TO 2
      B = Z
      FB = FZ
    2 A = C
      FA = FC
      ACBS = ABS(B-C)
      FX = MAX(ABS(FB),ABS(FC))
C
    3 IF (ABS(FC) .GE. ABS(FB)) GO TO 4
C
C   Perform interchange.
C
      A = B
      FA = FB
      B = C
      FB = FC
      C = A
      FC = FA
C
    4 CMB = 0.5E0*(C-B)
      ACMB = ABS(CMB)
      TOL = RW*ABS(B) + AW
C
C   Test stopping criterion and function count.
C
      IF (ACMB .LE. TOL) GO TO 10
      IF (FB .EQ. 0.E0) GO TO 11
      IF (KOUNT .GE. 1000) GO TO 14
C
C   Calculate new iterate implicitly as B+P/Q, where we arrange
C   P .GE. 0.  The implicit form is used to prevent overflow.
C
      P = (B-A)*FB
      Q = FA - FB
      IF (P .GE. 0.E0) GO TO 5
      P = -P
      Q = -Q
C
C   Update A and check for satisfactory reduction in the size of the
C   bracketing interval.  If not, perform bisection.
C
    5 A = B
      FA = FB
      IC = IC + 1
      IF (IC .LT. 4) GO TO 6
      IF (8.0E0*ACMB .GE. ACBS) GO TO 8
      IC = 0
      ACBS = ACMB
C
C   Test for too small a change.
C
    6 IF (P .GT. ABS(Q)*TOL) GO TO 7
C
C   Increment by TOLerance.
C
      B = B + SIGN(TOL,CMB)
      GO TO 9
C
C   Root ought to be between B and (C+B)/2.
C
    7 IF (P .GE. CMB*Q) GO TO 8
C
C   Use secant rule.
C
      B = B + P/Q
      GO TO 9
C
C   Use bisection (C+B)/2.
C
    8 B = B + CMB
C
C   Have completed computation for new iterate B.
C
    9 T = B
      FB = F(T)
      KOUNT = KOUNT + 1
C
C   Decide whether next step is interpolation or extrapolation.
C
      IF (SIGN(1.0E0,FB) .NE. SIGN(1.0E0,FC)) GO TO 3
      C = A
      FC = FA
      GO TO 3
C
C   Finished.  Process results for proper setting of IFLAG.
C
   10 IF (SIGN(1.0E0,FB) .EQ. SIGN(1.0E0,FC)) GO TO 13
      IF (ABS(FB) .GT. FX) GO TO 12
      IFLAG = 1
      RETURN
   11 IFLAG = 2
      RETURN
   12 IFLAG = 3
      RETURN
   13 IFLAG = 4
      RETURN
   14 IFLAG = 5
      RETURN
      END

      SUBROUTINE DFZERO(F,B,C,R,RE,AE,IFLAG)
C***BEGIN PROLOGUE  DFZERO
C***DATE WRITTEN   700901   (YYMMDD)
C***REVISION DATE  861211   (YYMMDD)
C***CATEGORY NO.  F1B
C***KEYWORDS  LIBRARY=SLATEC,TYPE=DOUBLE PRECISION(FZERO-S DFZERO-D),
C             BISECTION,NONLINEAR,NONLINEAR EQUATIONS,ROOTS,ZEROES,
C             ZEROS
C***AUTHOR  SHAMPINE,L.F.,SNLA
C           WATTS,H.A.,SNLA
C***PURPOSE  Search for a zero of a function F(X) in a given
C            interval (B,C).  It is designed primarily for problems
C            where F(B) and F(C) have opposite signs.
C***DESCRIPTION
C
C       **** Double Precision version of FZERO ****
C
C     Based on a method by T J Dekker
C     written by L F Shampine and H A Watts
C
C            DFZERO searches for a zero of a function F(X) between
C            the given values B and C until the width of the interval
C            (B,C) has collapsed to within a tolerance specified by
C            the stopping criterion, DABS(B-C) .LE. 2.*(RW*DABS(B)+AE).
C            The method used is an efficient combination of bisection
C            and the secant rule.
C
C     Description Of Arguments
C
C     F,B,C,R,RE and AE are DOUBLE PRECISION input parameters.
C     B and C are DOUBLE PRECISION output parameters and IFLAG (flagged
C        by an * below).
C
C        F     - Name of the DOUBLE PRECISION valued external function.
C                This name must be in an EXTERNAL statement in the
C                calling program.  F must be a function of one double
C                precision argument.
C
C       *B     - One end of the interval (B,C).  The value returned for
C                B usually is the better approximation to a zero of F.
C
C       *C     - The other end of the interval (B,C)
C
C        R     - A (better) guess of a zero of F which could help in
C                speeding up convergence.  If F(B) and F(R) have
C                opposite signs, a root will be found in the interval
C                (B,R); if not, but F(R) and F(C) have opposite
C                signs, a root will be found in the interval (R,C);
C                otherwise, the interval (B,C) will be searched for a
C                possible root.  When no better guess is known, it is
C                recommended that r be set to B or C; because if R is
C                not interior to the interval (B,C), it will be ignored.
C
C        RE    - Relative error used for RW in the stopping criterion.
C                If the requested RE is less than machine precision,
C                then RW is set to approximately machine precision.
C
C        AE    - Absolute error used in the stopping criterion.  If the
C                given interval (B,C) contains the origin, then a
C                nonzero value should be chosen for AE.
C
C       *IFLAG - A status code.  User must check IFLAG after each call.
C                Control returns to the user from FZERO in all cases.
C                XERROR does not process diagnostics in these cases.
C
C                1  B is within the requested tolerance of a zero.
C                   The interval (B,C) collapsed to the requested
C                   tolerance, the function changes sign in (B,C), and
C                   F(X) decreased in magnitude as (B,C) collapsed.
C
C                2  F(B) = 0.  However, the interval (B,C) may not have
C                   collapsed to the requested tolerance.
C
C                3  B may be near a singular point of F(X).
C                   The interval (B,C) collapsed to the requested tol-
C                   erance and the function changes sign in (B,C), but
C                   F(X) increased in magnitude as (B,C) collapsed,i.e.
C                     abs(F(B out)) .GT. max(abs(F(B in)),abs(F(C in)))
C
C                4  No change in sign of F(X) was found although the
C                   interval (B,C) collapsed to the requested tolerance.
C                   The user must examine this case and decide whether
C                   B is near a local minimum of F(X), or B is near a
C                   zero of even multiplicity, or neither of these.
C
C                5  Too many (.GT. 500) function evaluations used.
C***REFERENCES  L. F. SHAMPINE AND H. A. WATTS, *FZERO, A ROOT-SOLVING
C                 CODE*, SC-TM-70-631, SEPTEMBER 1970.
C               T. J. DEKKER, *FINDING A ZERO BY MEANS OF SUCCESSIVE
C                 LINEAR INTERPOLATION*, 'CONSTRUCTIVE ASPECTS OF THE
C                 FUNDAMENTAL THEOREM OF ALGEBRA', EDITED BY B. DEJON
C                 P. HENRICI, 1969.
C***ROUTINES CALLED  D1MACH
C***END PROLOGUE  DFZERO
      INTEGER I, IC, ICNT, IERR, IFLAG, IPASS, IPSS, ITEST(36),
     *     ITMP(15), J, KLUS, KOUNT, KPRINT, LUN, NDEG
      DOUBLE PRECISION A, ACBS, ACMB, AE, AW, B, C,
     *     CMB, D1MACH, DABS,
     *     DMAX1, DMIN1, DSIGN1, DSQRT, ER, F, FA, FB, FC,
     *     FX, FZ, P, Q, R, RE, REL, RW, T, TOL, WI, WORK, WR, Z
C     BEGIN BLOCK PERMITTING ...EXITS TO 200
C          ER IS TWO TIMES THE COMPUTER UNIT ROUNDOFF VALUE WHICH IS
C          DEFINED HERE BY THE FUNCTION D1MACH.
C***FIRST EXECUTABLE STATEMENT  DFZERO
ccc         ER = 2.0D0*D1MACH(4)

ccc   For IEEE 754 double precision arithmetic
ccc   d1mach(4) should be 2^{-53} x 2 = 2.22e-16.
ccc   Added by Steve Verrill on 5/25/02.

         er = 2.0d0*2.22d-16

C
C        INITIALIZE
C
         Z = R
         IF (R .LE. DMIN1(B,C) .OR. R .GE. DMAX1(B,C)) Z = C
         RW = DMAX1(RE,ER)
         AW = DMAX1(AE,0.0D0)
         IC = 0
         T = Z
         FZ = F(T)
         FC = FZ
         T = B
         FB = F(T)
         KOUNT = 2
         IF (DSIGN(1.0D0,FZ) .EQ. DSIGN(1.0D0,FB)) GO TO 10
            C = Z
         GO TO 30
   10    CONTINUE
C           BEGIN BLOCK PERMITTING ...EXITS TO 20
C           ...EXIT
               IF (Z .EQ. C) GO TO 20
               T = C
               FC = F(T)
               KOUNT = 3
C           ...EXIT
               IF (DSIGN(1.0D0,FZ) .EQ. DSIGN(1.0D0,FC)) GO TO 20
               B = Z
               FB = FZ
   20       CONTINUE
   30    CONTINUE
         A = C
         FA = FC
         ACBS = DABS(B-C)
         FX = DMAX1(DABS(FB),DABS(FC))
C
   40    CONTINUE
C           BEGIN BLOCK PERMITTING ...EXITS TO 180
               IF (DABS(FC) .GE. DABS(FB)) GO TO 50
C                 PERFORM INTERCHANGE
                  A = B
                  FA = FB
                  B = C
                  FB = FC
                  C = A
                  FC = FA
   50          CONTINUE
C
               CMB = 0.5D0*(C - B)
               ACMB = DABS(CMB)
               TOL = RW*DABS(B) + AW
C
C              TEST STOPPING CRITERION AND FUNCTION COUNT
C
               IF (ACMB .GT. TOL) GO TO 90
C
C
C                 FINISHED. PROCESS RESULTS FOR PROPER SETTING OF IFLAG
C
                  IF (DSIGN(1.0D0,FB) .NE. DSIGN(1.0D0,FC)) GO TO 60
                     IFLAG = 4
                  GO TO 80
   60             CONTINUE
                  IF (DABS(FB) .LE. FX) GO TO 70
                     IFLAG = 3
                  GO TO 80
   70             CONTINUE
                     IFLAG = 1
   80             CONTINUE
C     ............EXIT
                  GO TO 200
   90          CONTINUE
               IF (FB .NE. 0.0D0) GO TO 100
                  IFLAG = 2
C     ............EXIT
                  GO TO 200
  100          CONTINUE
               IF (KOUNT .LT. 500) GO TO 110
                  IFLAG = 5
C     ............EXIT
                  GO TO 200
  110          CONTINUE
C
C              CALCULATE NEW ITERATE IMPLICITLY AS B+P/Q
C              WHERE WE ARRANGE P .GE. 0.
C              THE IMPLICIT FORM IS USED TO PREVENT OVERFLOW.
C
               P = (B - A)*FB
               Q = FA - FB
               IF (P .GE. 0.0D0) GO TO 120
                  P = -P
                  Q = -Q
  120          CONTINUE
C
C              UPDATE A AND CHECK FOR SATISFACTORY REDUCTION
C              IN THE SIZE OF THE BRACKETING INTERVAL.
C              IF NOT, PERFORM BISECTION.
C
               A = B
               FA = FB
               IC = IC + 1
               IF (IC .LT. 4) GO TO 140
                  IF (8.0D0*ACMB .LT. ACBS) GO TO 130
C
C                    USE BISECTION
C
                     B = 0.5D0*(C + B)
C           .........EXIT
                     GO TO 180
  130             CONTINUE
                  IC = 0
                  ACBS = ACMB
  140          CONTINUE
C
C              TEST FOR TOO SMALL A CHANGE
C
               IF (P .GT. DABS(Q)*TOL) GO TO 150
C
C                 INCREMENT BY TOLERANCE
C
                  B = B + DSIGN(TOL,CMB)
               GO TO 170
  150          CONTINUE
C
C              ROOT OUGHT TO BE BETWEEN B AND (C+B)/2.
C
               IF (P .LT. CMB*Q) GO TO 160
C
C                 USE BISECTION
C
                  B = 0.5D0*(C + B)
               GO TO 170
  160          CONTINUE
C
C                 USE SECANT RULE
C
                  B = B + P/Q
  170          CONTINUE
  180       CONTINUE
C
C           HAVE COMPLETED COMPUTATION FOR NEW ITERATE B
C
            T = B
            FB = F(T)
            KOUNT = KOUNT + 1
C
C           DECIDE WHETHER NEXT STEP IS INTERPOLATION OR EXTRAPOLATION
C
            IF (DSIGN(1.0D0,FB) .NE. DSIGN(1.0D0,FC)) GO TO 190
               C = A
               FC = FA
  190       CONTINUE
         GO TO 40
  200 CONTINUE
      RETURN
      END
*DECK CACAI
      SUBROUTINE CACAI (Z, FNU, KODE, MR, N, Y, NZ, RL, TOL, ELIM, ALIM)
C***BEGIN PROLOGUE  CACAI
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CAIRY
C***LIBRARY   SLATEC
C***TYPE      ALL (CACAI-A, ZACAI-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CACAI APPLIES THE ANALYTIC CONTINUATION FORMULA
C
C         K(FNU,ZN*EXP(MP))=K(FNU,ZN)*EXP(-MP*FNU) - MP*I(FNU,ZN)
C                 MP=PI*MR*CMPLX(0.0,1.0)
C
C     TO CONTINUE THE K FUNCTION FROM THE RIGHT HALF TO THE LEFT
C     HALF Z PLANE FOR USE WITH CAIRY WHERE FNU=1/3 OR 2/3 AND N=1.
C     CACAI IS THE SAME AS CACON WITH THE PARTS FOR LARGER ORDERS AND
C     RECURRENCE REMOVED. A RECURSIVE CALL TO CACON CAN RESULT IF CACON
C     IS CALLED FROM CAIRY.
C
C***SEE ALSO  CAIRY
C***ROUTINES CALLED  CASYI, CBKNU, CMLRI, CS1S2, CSERI, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CACAI
      COMPLEX CSGN, CSPN, C1, C2, Y, Z, ZN, CY
      REAL ALIM, ARG, ASCLE, AZ, CPN, DFNU, ELIM, FMR, FNU, PI, RL,
     * SGN, SPN, TOL, YY, R1MACH
      INTEGER INU, IUF, KODE, MR, N, NN, NW, NZ
      DIMENSION Y(N), CY(2)
      DATA PI / 3.14159265358979324E0 /
C***FIRST EXECUTABLE STATEMENT  CACAI
      NZ = 0
      ZN = -Z
      AZ = ABS(Z)
      NN = N
      DFNU = FNU + (N-1)
      IF (AZ.LE.2.0E0) GO TO 10
      IF (AZ*AZ*0.25E0.GT.DFNU+1.0E0) GO TO 20
   10 CONTINUE
C-----------------------------------------------------------------------
C     POWER SERIES FOR THE I FUNCTION
C-----------------------------------------------------------------------
      CALL CSERI(ZN, FNU, KODE, NN, Y, NW, TOL, ELIM, ALIM)
      GO TO 40
   20 CONTINUE
      IF (AZ.LT.RL) GO TO 30
C-----------------------------------------------------------------------
C     ASYMPTOTIC EXPANSION FOR LARGE Z FOR THE I FUNCTION
C-----------------------------------------------------------------------
      CALL CASYI(ZN, FNU, KODE, NN, Y, NW, RL, TOL, ELIM, ALIM)
      IF (NW.LT.0) GO TO 70
      GO TO 40
   30 CONTINUE
C-----------------------------------------------------------------------
C     MILLER ALGORITHM NORMALIZED BY THE SERIES FOR THE I FUNCTION
C-----------------------------------------------------------------------
      CALL CMLRI(ZN, FNU, KODE, NN, Y, NW, TOL)
      IF(NW.LT.0) GO TO 70
   40 CONTINUE
C-----------------------------------------------------------------------
C     ANALYTIC CONTINUATION TO THE LEFT HALF PLANE FOR THE K FUNCTION
C-----------------------------------------------------------------------
      CALL CBKNU(ZN, FNU, KODE, 1, CY, NW, TOL, ELIM, ALIM)
      IF (NW.NE.0) GO TO 70
      FMR = MR
      SGN = -SIGN(PI,FMR)
      CSGN = CMPLX(0.0E0,SGN)
      IF (KODE.EQ.1) GO TO 50
      YY = -AIMAG(ZN)
      CPN = COS(YY)
      SPN = SIN(YY)
      CSGN = CSGN*CMPLX(CPN,SPN)
   50 CONTINUE
C-----------------------------------------------------------------------
C     CALCULATE CSPN=EXP(FNU*PI*I) TO MINIMIZE LOSSES OF SIGNIFICANCE
C     WHEN FNU IS LARGE
C-----------------------------------------------------------------------
      INU = FNU
      ARG = (FNU-INU)*SGN
      CPN = COS(ARG)
      SPN = SIN(ARG)
      CSPN = CMPLX(CPN,SPN)
      IF (MOD(INU,2).EQ.1) CSPN = -CSPN
      C1 = CY(1)
      C2 = Y(1)
      IF (KODE.EQ.1) GO TO 60
      IUF = 0
      ASCLE = 1.0E+3*R1MACH(1)/TOL
      CALL CS1S2(ZN, C1, C2, NW, ASCLE, ALIM, IUF)
      NZ = NZ + NW
   60 CONTINUE
      Y(1) = CSPN*C1 + CSGN*C2
      RETURN
   70 CONTINUE
      NZ = -1
      IF(NW.EQ.(-2)) NZ=-2
      RETURN
      END
*DECK CAIRY
      SUBROUTINE CAIRY (Z, ID, KODE, AI, NZ, IERR)
C***BEGIN PROLOGUE  CAIRY
C***PURPOSE  Compute the Airy function Ai(z) or its derivative dAi/dz
C            for complex argument z.  A scaling option is available
C            to help avoid underflow and overflow.
C***LIBRARY   SLATEC
C***CATEGORY  C10D
C***TYPE      COMPLEX (CAIRY-C, ZAIRY-C)
C***KEYWORDS  AIRY FUNCTION, BESSEL FUNCTION OF ORDER ONE THIRD,
C             BESSEL FUNCTION OF ORDER TWO THIRDS
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C         On KODE=1, CAIRY computes the complex Airy function Ai(z)
C         or its derivative dAi/dz on ID=0 or ID=1 respectively. On
C         KODE=2, a scaling option exp(zeta)*Ai(z) or exp(zeta)*dAi/dz
C         is provided to remove the exponential decay in -pi/3<arg(z)
C         <pi/3 and the exponential growth in pi/3<abs(arg(z))<pi where
C         zeta=(2/3)*z**(3/2).
C
C         While the Airy functions Ai(z) and dAi/dz are analytic in
C         the whole z-plane, the corresponding scaled functions defined
C         for KODE=2 have a cut along the negative real axis.
C
C         Input
C           Z      - Argument of type COMPLEX
C           ID     - Order of derivative, ID=0 or ID=1
C           KODE   - A parameter to indicate the scaling option
C                    KODE=1  returns
C                            AI=Ai(z)  on ID=0
C                            AI=dAi/dz on ID=1
C                            at z=Z
C                        =2  returns
C                            AI=exp(zeta)*Ai(z)  on ID=0
C                            AI=exp(zeta)*dAi/dz on ID=1
C                            at z=Z where zeta=(2/3)*z**(3/2)
C
C         Output
C           AI     - Result of type COMPLEX
C           NZ     - Underflow indicator
C                    NZ=0    Normal return
C                    NZ=1    AI=0 due to underflow in
C                            -pi/3<arg(Z)<pi/3 on KODE=1
C           IERR   - Error flag
C                    IERR=0  Normal return     - COMPUTATION COMPLETED
C                    IERR=1  Input error       - NO COMPUTATION
C                    IERR=2  Overflow          - NO COMPUTATION
C                            (Re(Z) too large with KODE=1)
C                    IERR=3  Precision warning - COMPUTATION COMPLETED
C                            (Result has less than half precision)
C                    IERR=4  Precision error   - NO COMPUTATION
C                            (Result has no precision)
C                    IERR=5  Algorithmic error - NO COMPUTATION
C                            (Termination condition not met)
C
C *Long Description:
C
C         Ai(z) and dAi/dz are computed from K Bessel functions by
C
C                Ai(z) =  c*sqrt(z)*K(1/3,zeta)
C               dAi/dz = -c*   z   *K(2/3,zeta)
C                    c =  1/(pi*sqrt(3))
C                 zeta =  (2/3)*z**(3/2)
C
C         when abs(z)>1 and from power series when abs(z)<=1.
C
C         In most complex variable computation, one must evaluate ele-
C         mentary functions.  When the magnitude of Z is large, losses
C         of significance by argument reduction occur.  Consequently, if
C         the magnitude of ZETA=(2/3)*Z**(3/2) exceeds U1=SQRT(0.5/UR),
C         then losses exceeding half precision are likely and an error
C         flag IERR=3 is triggered where UR=R1MACH(4)=UNIT ROUNDOFF.
C         Also, if the magnitude of ZETA is larger than U2=0.5/UR, then
C         all significance is lost and IERR=4.  In order to use the INT
C         function, ZETA must be further restricted not to exceed
C         U3=I1MACH(9)=LARGEST INTEGER.  Thus, the magnitude of ZETA
C         must be restricted by MIN(U2,U3).  In IEEE arithmetic, U1,U2,
C         and U3 are approximately 2.0E+3, 4.2E+6, 2.1E+9 in single
C         precision and 4.7E+7, 2.3E+15, 2.1E+9 in double precision.
C         This makes U2 limiting is single precision and U3 limiting
C         in double precision.  This means that the magnitude of Z
C         cannot exceed approximately 3.4E+4 in single precision and
C         2.1E+6 in double precision.  This also means that one can
C         expect to retain, in the worst cases on 32-bit machines,
C         no digits in single precision and only 6 digits in double
C         precision.
C
C         The approximate relative error in the magnitude of a complex
C         Bessel function can be expressed as P*10**S where P=MAX(UNIT
C         ROUNDOFF,1.0E-18) is the nominal precision and 10**S repre-
C         sents the increase in error due to argument reduction in the
C         elementary functions.  Here, S=MAX(1,ABS(LOG10(ABS(Z))),
C         ABS(LOG10(FNU))) approximately (i.e., S=MAX(1,ABS(EXPONENT OF
C         ABS(Z),ABS(EXPONENT OF FNU)) ).  However, the phase angle may
C         have only absolute accuracy.  This is most likely to occur
C         when one component (in magnitude) is larger than the other by
C         several orders of magnitude.  If one component is 10**K larger
C         than the other, then one can expect only MAX(ABS(LOG10(P))-K,
C         0) significant digits; or, stated another way, when K exceeds
C         the exponent of P, no significant digits remain in the smaller
C         component.  However, the phase angle retains absolute accuracy
C         because, in complex arithmetic with precision P, the smaller
C         component will not (as a rule) decrease below P times the
C         magnitude of the larger component. In these extreme cases,
C         the principal phase angle is on the order of +P, -P, PI/2-P,
C         or -PI/2+P.
C
C***REFERENCES  1. M. Abramowitz and I. A. Stegun, Handbook of Mathe-
C                 matical Functions, National Bureau of Standards
C                 Applied Mathematics Series 55, U. S. Department
C                 of Commerce, Tenth Printing (1972) or later.
C               2. D. E. Amos, Computation of Bessel Functions of
C                 Complex Argument and Large Order, Report SAND83-0643,
C                 Sandia National Laboratories, Albuquerque, NM, May
C                 1983.
C               3. D. E. Amos, A Subroutine Package for Bessel Functions
C                 of a Complex Argument and Nonnegative Order, Report
C                 SAND85-1018, Sandia National Laboratory, Albuquerque,
C                 NM, May 1985.
C               4. D. E. Amos, A portable package for Bessel functions
C                 of a complex argument and nonnegative order, ACM
C                 Transactions on Mathematical Software, 12 (September
C                 1986), pp. 265-273.
C
C***ROUTINES CALLED  CACAI, CBKNU, I1MACH, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   890801  REVISION DATE from Version 3.2
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C   920128  Category corrected.  (WRB)
C   920811  Prologue revised.  (DWL)
C***END PROLOGUE  CAIRY
      COMPLEX AI, CONE, CSQ, CY, S1, S2, TRM1, TRM2, Z, ZTA, Z3
      REAL AA, AD, AK, ALIM, ATRM, AZ, AZ3, BK, CK, COEF, C1, C2, DIG,
     * DK, D1, D2, ELIM, FID, FNU, RL, R1M5, SFAC, TOL, TTH, ZI, ZR,
     * Z3I, Z3R, R1MACH, BB, ALAZ
      INTEGER ID, IERR, IFLAG, K, KODE, K1, K2, MR, NN, NZ, I1MACH
      DIMENSION CY(1)
      DATA TTH, C1, C2, COEF /6.66666666666666667E-01,
     * 3.55028053887817240E-01,2.58819403792806799E-01,
     * 1.83776298473930683E-01/
      DATA  CONE / (1.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CAIRY
      IERR = 0
      NZ=0
      IF (ID.LT.0 .OR. ID.GT.1) IERR=1
      IF (KODE.LT.1 .OR. KODE.GT.2) IERR=1
      IF (IERR.NE.0) RETURN
      AZ = ABS(Z)
      TOL = MAX(R1MACH(4),1.0E-18)
      FID = ID
      IF (AZ.GT.1.0E0) GO TO 60
C-----------------------------------------------------------------------
C     POWER SERIES FOR ABS(Z).LE.1.
C-----------------------------------------------------------------------
      S1 = CONE
      S2 = CONE
      IF (AZ.LT.TOL) GO TO 160
      AA = AZ*AZ
      IF (AA.LT.TOL/AZ) GO TO 40
      TRM1 = CONE
      TRM2 = CONE
      ATRM = 1.0E0
      Z3 = Z*Z*Z
      AZ3 = AZ*AA
      AK = 2.0E0 + FID
      BK = 3.0E0 - FID - FID
      CK = 4.0E0 - FID
      DK = 3.0E0 + FID + FID
      D1 = AK*DK
      D2 = BK*CK
      AD = MIN(D1,D2)
      AK = 24.0E0 + 9.0E0*FID
      BK = 30.0E0 - 9.0E0*FID
      Z3R = REAL(Z3)
      Z3I = AIMAG(Z3)
      DO 30 K=1,25
        TRM1 = TRM1*CMPLX(Z3R/D1,Z3I/D1)
        S1 = S1 + TRM1
        TRM2 = TRM2*CMPLX(Z3R/D2,Z3I/D2)
        S2 = S2 + TRM2
        ATRM = ATRM*AZ3/AD
        D1 = D1 + AK
        D2 = D2 + BK
        AD = MIN(D1,D2)
        IF (ATRM.LT.TOL*AD) GO TO 40
        AK = AK + 18.0E0
        BK = BK + 18.0E0
   30 CONTINUE
   40 CONTINUE
      IF (ID.EQ.1) GO TO 50
      AI = S1*CMPLX(C1,0.0E0) - Z*S2*CMPLX(C2,0.0E0)
      IF (KODE.EQ.1) RETURN
      ZTA = Z*CSQRT(Z)*CMPLX(TTH,0.0E0)
      AI = AI*CEXP(ZTA)
      RETURN
   50 CONTINUE
      AI = -S2*CMPLX(C2,0.0E0)
      IF (AZ.GT.TOL) AI = AI + Z*Z*S1*CMPLX(C1/(1.0E0+FID),0.0E0)
      IF (KODE.EQ.1) RETURN
      ZTA = Z*CSQRT(Z)*CMPLX(TTH,0.0E0)
      AI = AI*CEXP(ZTA)
      RETURN
C-----------------------------------------------------------------------
C     CASE FOR ABS(Z).GT.1.0
C-----------------------------------------------------------------------
   60 CONTINUE
      FNU = (1.0E0+FID)/3.0E0
C-----------------------------------------------------------------------
C     SET PARAMETERS RELATED TO MACHINE CONSTANTS.
C     TOL IS THE APPROXIMATE UNIT ROUNDOFF LIMITED TO 1.0E-18.
C     ELIM IS THE APPROXIMATE EXPONENTIAL OVER- AND UNDERFLOW LIMIT.
C     EXP(-ELIM).LT.EXP(-ALIM)=EXP(-ELIM)/TOL    AND
C     EXP(ELIM).GT.EXP(ALIM)=EXP(ELIM)*TOL       ARE INTERVALS NEAR
C     UNDERFLOW AND OVERFLOW LIMITS WHERE SCALED ARITHMETIC IS DONE.
C     RL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC EXPANSION FOR LARGE Z.
C     DIG = NUMBER OF BASE 10 DIGITS IN TOL = 10**(-DIG).
C-----------------------------------------------------------------------
      K1 = I1MACH(12)
      K2 = I1MACH(13)
      R1M5 = R1MACH(5)
      K = MIN(ABS(K1),ABS(K2))
      ELIM = 2.303E0*(K*R1M5-3.0E0)
      K1 = I1MACH(11) - 1
      AA = R1M5*K1
      DIG = MIN(AA,18.0E0)
      AA = AA*2.303E0
      ALIM = ELIM + MAX(-AA,-41.45E0)
      RL = 1.2E0*DIG + 3.0E0
      ALAZ=ALOG(AZ)
C-----------------------------------------------------------------------
C     TEST FOR RANGE
C-----------------------------------------------------------------------
      AA=0.5E0/TOL
      BB=I1MACH(9)*0.5E0
      AA=MIN(AA,BB)
      AA=AA**TTH
      IF (AZ.GT.AA) GO TO 260
      AA=SQRT(AA)
      IF (AZ.GT.AA) IERR=3
      CSQ=CSQRT(Z)
      ZTA=Z*CSQ*CMPLX(TTH,0.0E0)
C-----------------------------------------------------------------------
C     RE(ZTA).LE.0 WHEN RE(Z).LT.0, ESPECIALLY WHEN IM(Z) IS SMALL
C-----------------------------------------------------------------------
      IFLAG = 0
      SFAC = 1.0E0
      ZI = AIMAG(Z)
      ZR = REAL(Z)
      AK = AIMAG(ZTA)
      IF (ZR.GE.0.0E0) GO TO 70
      BK = REAL(ZTA)
      CK = -ABS(BK)
      ZTA = CMPLX(CK,AK)
   70 CONTINUE
      IF (ZI.NE.0.0E0) GO TO 80
      IF (ZR.GT.0.0E0) GO TO 80
      ZTA = CMPLX(0.0E0,AK)
   80 CONTINUE
      AA = REAL(ZTA)
      IF (AA.GE.0.0E0 .AND. ZR.GT.0.0E0) GO TO 100
      IF (KODE.EQ.2) GO TO 90
C-----------------------------------------------------------------------
C     OVERFLOW TEST
C-----------------------------------------------------------------------
      IF (AA.GT.(-ALIM)) GO TO 90
      AA = -AA + 0.25E0*ALAZ
      IFLAG = 1
      SFAC = TOL
      IF (AA.GT.ELIM) GO TO 240
   90 CONTINUE
C-----------------------------------------------------------------------
C     CBKNU AND CACAI RETURN EXP(ZTA)*K(FNU,ZTA) ON KODE=2
C-----------------------------------------------------------------------
      MR = 1
      IF (ZI.LT.0.0E0) MR = -1
      CALL CACAI(ZTA, FNU, KODE, MR, 1, CY, NN, RL, TOL, ELIM, ALIM)
      IF (NN.LT.0) GO TO 250
      NZ = NZ + NN
      GO TO 120
  100 CONTINUE
      IF (KODE.EQ.2) GO TO 110
C-----------------------------------------------------------------------
C     UNDERFLOW TEST
C-----------------------------------------------------------------------
      IF (AA.LT.ALIM) GO TO 110
      AA = -AA - 0.25E0*ALAZ
      IFLAG = 2
      SFAC = 1.0E0/TOL
      IF (AA.LT.(-ELIM)) GO TO 180
  110 CONTINUE
      CALL CBKNU(ZTA, FNU, KODE, 1, CY, NZ, TOL, ELIM, ALIM)
  120 CONTINUE
      S1 = CY(1)*CMPLX(COEF,0.0E0)
      IF (IFLAG.NE.0) GO TO 140
      IF (ID.EQ.1) GO TO 130
      AI = CSQ*S1
      RETURN
  130 AI = -Z*S1
      RETURN
  140 CONTINUE
      S1 = S1*CMPLX(SFAC,0.0E0)
      IF (ID.EQ.1) GO TO 150
      S1 = S1*CSQ
      AI = S1*CMPLX(1.0E0/SFAC,0.0E0)
      RETURN
  150 CONTINUE
      S1 = -S1*Z
      AI = S1*CMPLX(1.0E0/SFAC,0.0E0)
      RETURN
  160 CONTINUE
      AA = 1.0E+3*R1MACH(1)
      S1 = CMPLX(0.0E0,0.0E0)
      IF (ID.EQ.1) GO TO 170
      IF (AZ.GT.AA) S1 = CMPLX(C2,0.0E0)*Z
      AI = CMPLX(C1,0.0E0) - S1
      RETURN
  170 CONTINUE
      AI = -CMPLX(C2,0.0E0)
      AA = SQRT(AA)
      IF (AZ.GT.AA) S1 = Z*Z*CMPLX(0.5E0,0.0E0)
      AI = AI + S1*CMPLX(C1,0.0E0)
      RETURN
  180 CONTINUE
      NZ = 1
      AI = CMPLX(0.0E0,0.0E0)
      RETURN
  240 CONTINUE
      NZ = 0
      IERR=2
      RETURN
  250 CONTINUE
      IF(NN.EQ.(-1)) GO TO 240
      NZ=0
      IERR=5
      RETURN
  260 CONTINUE
      IERR=4
      NZ=0
      RETURN
      END
*DECK CASYI
      SUBROUTINE CASYI (Z, FNU, KODE, N, Y, NZ, RL, TOL, ELIM, ALIM)
C***BEGIN PROLOGUE  CASYI
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CASYI-A, ZASYI-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CASYI COMPUTES THE I BESSEL FUNCTION FOR REAL(Z).GE.0.0 BY
C     MEANS OF THE ASYMPTOTIC EXPANSION FOR LARGE ABS(Z) IN THE
C     REGION ABS(Z).GT.MAX(RL,FNU*FNU/2). NZ=0 IS A NORMAL RETURN.
C     NZ.LT.0 INDICATES AN OVERFLOW ON KODE=1.
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CASYI
      COMPLEX AK1, CK, CONE, CS1, CS2, CZ, CZERO, DK, EZ, P1, RZ, S2,
     * Y, Z
      REAL AA, ACZ, AEZ, AK, ALIM, ARG, ARM, ATOL, AZ, BB, BK, DFNU,
     * DNU2, ELIM, FDN, FNU, PI, RL, RTPI, RTR1, S, SGN, SQK, TOL, X,
     * YY, R1MACH
      INTEGER I, IB, IL, INU, J, JL, K, KODE, KODED, M, N, NN, NZ
      DIMENSION Y(N)
      DATA PI, RTPI  /3.14159265358979324E0 , 0.159154943091895336E0 /
      DATA CZERO, CONE / (0.0E0,0.0E0), (1.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CASYI
      NZ = 0
      AZ = ABS(Z)
      X = REAL(Z)
      ARM = 1.0E+3*R1MACH(1)
      RTR1 = SQRT(ARM)
      IL = MIN(2,N)
      DFNU = FNU + (N-IL)
C-----------------------------------------------------------------------
C     OVERFLOW TEST
C-----------------------------------------------------------------------
      AK1 = CMPLX(RTPI,0.0E0)/Z
      AK1 = CSQRT(AK1)
      CZ = Z
      IF (KODE.EQ.2) CZ = Z - CMPLX(X,0.0E0)
      ACZ = REAL(CZ)
      IF (ABS(ACZ).GT.ELIM) GO TO 80
      DNU2 = DFNU + DFNU
      KODED = 1
      IF ((ABS(ACZ).GT.ALIM) .AND. (N.GT.2)) GO TO 10
      KODED = 0
      AK1 = AK1*CEXP(CZ)
   10 CONTINUE
      FDN = 0.0E0
      IF (DNU2.GT.RTR1) FDN = DNU2*DNU2
      EZ = Z*CMPLX(8.0E0,0.0E0)
C-----------------------------------------------------------------------
C     WHEN Z IS IMAGINARY, THE ERROR TEST MUST BE MADE RELATIVE TO THE
C     FIRST RECIPROCAL POWER SINCE THIS IS THE LEADING TERM OF THE
C     EXPANSION FOR THE IMAGINARY PART.
C-----------------------------------------------------------------------
      AEZ = 8.0E0*AZ
      S = TOL/AEZ
      JL = RL+RL + 2
      YY = AIMAG(Z)
      P1 = CZERO
      IF (YY.EQ.0.0E0) GO TO 20
C-----------------------------------------------------------------------
C     CALCULATE EXP(PI*(0.5+FNU+N-IL)*I) TO MINIMIZE LOSSES OF
C     SIGNIFICANCE WHEN FNU OR N IS LARGE
C-----------------------------------------------------------------------
      INU = FNU
      ARG = (FNU-INU)*PI
      INU = INU + N - IL
      AK = -SIN(ARG)
      BK = COS(ARG)
      IF (YY.LT.0.0E0) BK = -BK
      P1 = CMPLX(AK,BK)
      IF (MOD(INU,2).EQ.1) P1 = -P1
   20 CONTINUE
      DO 50 K=1,IL
        SQK = FDN - 1.0E0
        ATOL = S*ABS(SQK)
        SGN = 1.0E0
        CS1 = CONE
        CS2 = CONE
        CK = CONE
        AK = 0.0E0
        AA = 1.0E0
        BB = AEZ
        DK = EZ
        DO 30 J=1,JL
          CK = CK*CMPLX(SQK,0.0E0)/DK
          CS2 = CS2 + CK
          SGN = -SGN
          CS1 = CS1 + CK*CMPLX(SGN,0.0E0)
          DK = DK + EZ
          AA = AA*ABS(SQK)/BB
          BB = BB + AEZ
          AK = AK + 8.0E0
          SQK = SQK - AK
          IF (AA.LE.ATOL) GO TO 40
   30   CONTINUE
        GO TO 90
   40   CONTINUE
        S2 = CS1
        IF (X+X.LT.ELIM) S2 = S2 + P1*CS2*CEXP(-Z-Z)
        FDN = FDN + 8.0E0*DFNU + 4.0E0
        P1 = -P1
        M = N - IL + K
        Y(M) = S2*AK1
   50 CONTINUE
      IF (N.LE.2) RETURN
      NN = N
      K = NN - 2
      AK = K
      RZ = (CONE+CONE)/Z
      IB = 3
      DO 60 I=IB,NN
        Y(K) = CMPLX(AK+FNU,0.0E0)*RZ*Y(K+1) + Y(K+2)
        AK = AK - 1.0E0
        K = K - 1
   60 CONTINUE
      IF (KODED.EQ.0) RETURN
      CK = CEXP(CZ)
      DO 70 I=1,NN
        Y(I) = Y(I)*CK
   70 CONTINUE
      RETURN
   80 CONTINUE
      NZ = -1
      RETURN
   90 CONTINUE
      NZ=-2
      RETURN
      END
*DECK CBESJ
      SUBROUTINE CBESJ (Z, FNU, KODE, N, CY, NZ, IERR)
C***BEGIN PROLOGUE  CBESJ
C***PURPOSE  Compute a sequence of the Bessel functions J(a,z) for
C            complex argument z and real nonnegative orders a=b,b+1,
C            b+2,... where b>0.  A scaling option is available to
C            help avoid overflow.
C***LIBRARY   SLATEC
C***CATEGORY  C10A4
C***TYPE      COMPLEX (CBESJ-C, ZBESJ-C)
C***KEYWORDS  BESSEL FUNCTIONS OF COMPLEX ARGUMENT,
C             BESSEL FUNCTIONS OF THE FIRST KIND, J BESSEL FUNCTIONS
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C         On KODE=1, CBESJ computes an N member sequence of complex
C         Bessel functions CY(L)=J(FNU+L-1,Z) for real nonnegative
C         orders FNU+L-1, L=1,...,N and complex Z in the cut plane
C         -pi<arg(Z)<=pi.  On KODE=2, CBESJ returns the scaled functions
C
C            CY(L) = exp(-abs(Y))*J(FNU+L-1,Z),  L=1,...,N and Y=Im(Z)
C
C         which remove the exponential growth in both the upper and
C         lower half planes as Z goes to infinity.  Definitions and
C         notation are found in the NBS Handbook of Mathematical
C         Functions (Ref. 1).
C
C         Input
C           Z      - Argument of type COMPLEX
C           FNU    - Initial order of type REAL, FNU>=0
C           KODE   - A parameter to indicate the scaling option
C                    KODE=1  returns
C                            CY(L)=J(FNU+L-1,Z), L=1,...,N
C                        =2  returns
C                            CY(L)=J(FNU+L-1,Z)*exp(-abs(Y)), L=1,...,N
C                            where Y=Im(Z)
C           N      - Number of terms in the sequence, N>=1
C
C         Output
C           CY     - Result vector of type COMPLEX
C           NZ     - Number of underflows set to zero
C                    NZ=0    Normal return
C                    NZ>0    CY(L)=0, L=N-NZ+1,...,N
C           IERR   - Error flag
C                    IERR=0  Normal return     - COMPUTATION COMPLETED
C                    IERR=1  Input error       - NO COMPUTATION
C                    IERR=2  Overflow          - NO COMPUTATION
C                            (Im(Z) too large on KODE=1)
C                    IERR=3  Precision warning - COMPUTATION COMPLETED
C                            (Result has half precision or less
C                            because abs(Z) or FNU+N-1 is large)
C                    IERR=4  Precision error   - NO COMPUTATION
C                            (Result has no precision because
C                            abs(Z) or FNU+N-1 is too large)
C                    IERR=5  Algorithmic error - NO COMPUTATION
C                            (Termination condition not met)
C
C *Long Description:
C
C         The computation is carried out by the formulae
C
C            J(a,z) = exp( a*pi*i/2)*I(a,-i*z),  Im(z)>=0
C
C            J(a,z) = exp(-a*pi*i/2)*I(a, i*z),  Im(z)<0
C
C         where the I Bessel function is computed as described in the
C         prologue to CBESI.
C
C         For negative orders, the formula
C
C            J(-a,z) = J(a,z)*cos(a*pi) - Y(a,z)*sin(a*pi)
C
C         can be used.  However, for large orders close to integers, the
C         the function changes radically.  When a is a large positive
C         integer, the magnitude of J(-a,z)=J(a,z)*cos(a*pi) is a
C         large negative power of ten.  But when a is not an integer,
C         Y(a,z) dominates in magnitude with a large positive power of
C         ten and the most that the second term can be reduced is by
C         unit roundoff from the coefficient.  Thus, wide changes can
C         occur within unit roundoff of a large integer for a.  Here,
C         large means a>abs(z).
C
C         In most complex variable computation, one must evaluate ele-
C         mentary functions.  When the magnitude of Z or FNU+N-1 is
C         large, losses of significance by argument reduction occur.
C         Consequently, if either one exceeds U1=SQRT(0.5/UR), then
C         losses exceeding half precision are likely and an error flag
C         IERR=3 is triggered where UR=R1MACH(4)=UNIT ROUNDOFF.  Also,
C         if either is larger than U2=0.5/UR, then all significance is
C         lost and IERR=4.  In order to use the INT function, arguments
C         must be further restricted not to exceed the largest machine
C         integer, U3=I1MACH(9).  Thus, the magnitude of Z and FNU+N-1
C         is restricted by MIN(U2,U3).  In IEEE arithmetic, U1,U2, and
C         U3 approximate 2.0E+3, 4.2E+6, 2.1E+9 in single precision
C         and 4.7E+7, 2.3E+15 and 2.1E+9 in double precision.  This
C         makes U2 limiting in single precision and U3 limiting in
C         double precision.  This means that one can expect to retain,
C         in the worst cases on IEEE machines, no digits in single pre-
C         cision and only 6 digits in double precision.  Similar con-
C         siderations hold for other machines.
C
C         The approximate relative error in the magnitude of a complex
C         Bessel function can be expressed as P*10**S where P=MAX(UNIT
C         ROUNDOFF,1.0E-18) is the nominal precision and 10**S repre-
C         sents the increase in error due to argument reduction in the
C         elementary functions.  Here, S=MAX(1,ABS(LOG10(ABS(Z))),
C         ABS(LOG10(FNU))) approximately (i.e., S=MAX(1,ABS(EXPONENT OF
C         ABS(Z),ABS(EXPONENT OF FNU)) ).  However, the phase angle may
C         have only absolute accuracy.  This is most likely to occur
C         when one component (in magnitude) is larger than the other by
C         several orders of magnitude.  If one component is 10**K larger
C         than the other, then one can expect only MAX(ABS(LOG10(P))-K,
C         0) significant digits; or, stated another way, when K exceeds
C         the exponent of P, no significant digits remain in the smaller
C         component.  However, the phase angle retains absolute accuracy
C         because, in complex arithmetic with precision P, the smaller
C         component will not (as a rule) decrease below P times the
C         magnitude of the larger component.  In these extreme cases,
C         the principal phase angle is on the order of +P, -P, PI/2-P,
C         or -PI/2+P.
C
C***REFERENCES  1. M. Abramowitz and I. A. Stegun, Handbook of Mathe-
C                 matical Functions, National Bureau of Standards
C                 Applied Mathematics Series 55, U. S. Department
C                 of Commerce, Tenth Printing (1972) or later.
C               2. D. E. Amos, Computation of Bessel Functions of
C                 Complex Argument, Report SAND83-0086, Sandia National
C                 Laboratories, Albuquerque, NM, May 1983.
C               3. D. E. Amos, Computation of Bessel Functions of
C                 Complex Argument and Large Order, Report SAND83-0643,
C                 Sandia National Laboratories, Albuquerque, NM, May
C                 1983.
C               4. D. E. Amos, A Subroutine Package for Bessel Functions
C                 of a Complex Argument and Nonnegative Order, Report
C                 SAND85-1018, Sandia National Laboratory, Albuquerque,
C                 NM, May 1985.
C               5. D. E. Amos, A portable package for Bessel functions
C                 of a complex argument and nonnegative order, ACM
C                 Transactions on Mathematical Software, 12 (September
C                 1986), pp. 265-273.
C
C***ROUTINES CALLED  CBINU, I1MACH, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   890801  REVISION DATE from Version 3.2
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C   920128  Category corrected.  (WRB)
C   920811  Prologue revised.  (DWL)
C***END PROLOGUE  CBESJ
C
      COMPLEX CI, CSGN, CY, Z, ZN
      REAL AA, ALIM, ARG, DIG, ELIM, FNU, FNUL, HPI, RL, R1, R1M5, R2,
     * TOL, YY, R1MACH, AZ, FN, BB, ASCLE, RTOL, ATOL
      INTEGER I, IERR, INU, INUH, IR, KODE, K1, K2, N, NL, NZ, I1MACH, K
      DIMENSION CY(N)
      DATA HPI /1.57079632679489662E0/
C
C***FIRST EXECUTABLE STATEMENT  CBESJ
      IERR = 0
      NZ=0
      IF (FNU.LT.0.0E0) IERR=1
      IF (KODE.LT.1 .OR. KODE.GT.2) IERR=1
      IF (N.LT.1) IERR=1
      IF (IERR.NE.0) RETURN
C-----------------------------------------------------------------------
C     SET PARAMETERS RELATED TO MACHINE CONSTANTS.
C     TOL IS THE APPROXIMATE UNIT ROUNDOFF LIMITED TO 1.0E-18.
C     ELIM IS THE APPROXIMATE EXPONENTIAL OVER- AND UNDERFLOW LIMIT.
C     EXP(-ELIM).LT.EXP(-ALIM)=EXP(-ELIM)/TOL    AND
C     EXP(ELIM).GT.EXP(ALIM)=EXP(ELIM)*TOL       ARE INTERVALS NEAR
C     UNDERFLOW AND OVERFLOW LIMITS WHERE SCALED ARITHMETIC IS DONE.
C     RL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC EXPANSION FOR LARGE Z.
C     DIG = NUMBER OF BASE 10 DIGITS IN TOL = 10**(-DIG).
C     FNUL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC SERIES FOR LARGE FNU.
C-----------------------------------------------------------------------
      TOL = MAX(R1MACH(4),1.0E-18)
      K1 = I1MACH(12)
      K2 = I1MACH(13)
      R1M5 = R1MACH(5)
      K = MIN(ABS(K1),ABS(K2))
      ELIM = 2.303E0*(K*R1M5-3.0E0)
      K1 = I1MACH(11) - 1
      AA = R1M5*K1
      DIG = MIN(AA,18.0E0)
      AA = AA*2.303E0
      ALIM = ELIM + MAX(-AA,-41.45E0)
      RL = 1.2E0*DIG + 3.0E0
      FNUL = 10.0E0 + 6.0E0*(DIG-3.0E0)
      CI = CMPLX(0.0E0,1.0E0)
      YY = AIMAG(Z)
      AZ = ABS(Z)
C-----------------------------------------------------------------------
C     TEST FOR RANGE
C-----------------------------------------------------------------------
      AA = 0.5E0/TOL
      BB=I1MACH(9)*0.5E0
      AA=MIN(AA,BB)
      FN=FNU+(N-1)
      IF(AZ.GT.AA) GO TO 140
      IF(FN.GT.AA) GO TO 140
      AA=SQRT(AA)
      IF(AZ.GT.AA) IERR=3
      IF(FN.GT.AA) IERR=3
C-----------------------------------------------------------------------
C     CALCULATE CSGN=EXP(FNU*HPI*I) TO MINIMIZE LOSSES OF SIGNIFICANCE
C     WHEN FNU IS LARGE
C-----------------------------------------------------------------------
      INU = FNU
      INUH = INU/2
      IR = INU - 2*INUH
      ARG = (FNU-(INU-IR))*HPI
      R1 = COS(ARG)
      R2 = SIN(ARG)
      CSGN = CMPLX(R1,R2)
      IF (MOD(INUH,2).EQ.1) CSGN = -CSGN
C-----------------------------------------------------------------------
C     ZN IS IN THE RIGHT HALF PLANE
C-----------------------------------------------------------------------
      ZN = -Z*CI
      IF (YY.GE.0.0E0) GO TO 40
      ZN = -ZN
      CSGN = CONJG(CSGN)
      CI = CONJG(CI)
   40 CONTINUE
      CALL CBINU(ZN, FNU, KODE, N, CY, NZ, RL, FNUL, TOL, ELIM, ALIM)
      IF (NZ.LT.0) GO TO 120
      NL = N - NZ
      IF (NL.EQ.0) RETURN
      RTOL = 1.0E0/TOL
      ASCLE = R1MACH(1)*RTOL*1.0E+3
      DO 50 I=1,NL
C       CY(I)=CY(I)*CSGN
        ZN=CY(I)
        AA=REAL(ZN)
        BB=AIMAG(ZN)
        ATOL=1.0E0
        IF (MAX(ABS(AA),ABS(BB)).GT.ASCLE) GO TO 55
          ZN = ZN*CMPLX(RTOL,0.0E0)
          ATOL = TOL
   55   CONTINUE
        ZN = ZN*CSGN
        CY(I) = ZN*CMPLX(ATOL,0.0E0)
        CSGN = CSGN*CI
   50 CONTINUE
      RETURN
  120 CONTINUE
      IF(NZ.EQ.(-2)) GO TO 130
      NZ = 0
      IERR = 2
      RETURN
  130 CONTINUE
      NZ=0
      IERR=5
      RETURN
  140 CONTINUE
      NZ=0
      IERR=4
      RETURN
      END
*DECK CBINU
      SUBROUTINE CBINU (Z, FNU, KODE, N, CY, NZ, RL, FNUL, TOL, ELIM,
     +   ALIM)
C***BEGIN PROLOGUE  CBINU
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CAIRY, CBESH, CBESI, CBESJ, CBESK and CBIRY
C***LIBRARY   SLATEC
C***TYPE      ALL (CBINU-A, ZBINU-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CBINU COMPUTES THE I FUNCTION IN THE RIGHT HALF Z PLANE
C
C***SEE ALSO  CAIRY, CBESH, CBESI, CBESJ, CBESK, CBIRY
C***ROUTINES CALLED  CASYI, CBUNI, CMLRI, CSERI, CUOIK, CWRSK
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CBINU
      COMPLEX CW, CY, CZERO, Z
      REAL ALIM, AZ, DFNU, ELIM, FNU, FNUL, RL, TOL
      INTEGER I, INW, KODE, N, NLAST, NN, NUI, NW, NZ
      DIMENSION CY(N), CW(2)
      DATA CZERO / (0.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CBINU
      NZ = 0
      AZ = ABS(Z)
      NN = N
      DFNU = FNU + (N-1)
      IF (AZ.LE.2.0E0) GO TO 10
      IF (AZ*AZ*0.25E0.GT.DFNU+1.0E0) GO TO 20
   10 CONTINUE
C-----------------------------------------------------------------------
C     POWER SERIES
C-----------------------------------------------------------------------
      CALL CSERI(Z, FNU, KODE, NN, CY, NW, TOL, ELIM, ALIM)
      INW = ABS(NW)
      NZ = NZ + INW
      NN = NN - INW
      IF (NN.EQ.0) RETURN
      IF (NW.GE.0) GO TO 120
      DFNU = FNU + (NN-1)
   20 CONTINUE
      IF (AZ.LT.RL) GO TO 40
      IF (DFNU.LE.1.0E0) GO TO 30
      IF (AZ+AZ.LT.DFNU*DFNU) GO TO 50
C-----------------------------------------------------------------------
C     ASYMPTOTIC EXPANSION FOR LARGE Z
C-----------------------------------------------------------------------
   30 CONTINUE
      CALL CASYI(Z, FNU, KODE, NN, CY, NW, RL, TOL, ELIM, ALIM)
      IF (NW.LT.0) GO TO 130
      GO TO 120
   40 CONTINUE
      IF (DFNU.LE.1.0E0) GO TO 70
   50 CONTINUE
C-----------------------------------------------------------------------
C     OVERFLOW AND UNDERFLOW TEST ON I SEQUENCE FOR MILLER ALGORITHM
C-----------------------------------------------------------------------
      CALL CUOIK(Z, FNU, KODE, 1, NN, CY, NW, TOL, ELIM, ALIM)
      IF (NW.LT.0) GO TO 130
      NZ = NZ + NW
      NN = NN - NW
      IF (NN.EQ.0) RETURN
      DFNU = FNU+(NN-1)
      IF (DFNU.GT.FNUL) GO TO 110
      IF (AZ.GT.FNUL) GO TO 110
   60 CONTINUE
      IF (AZ.GT.RL) GO TO 80
   70 CONTINUE
C-----------------------------------------------------------------------
C     MILLER ALGORITHM NORMALIZED BY THE SERIES
C-----------------------------------------------------------------------
      CALL CMLRI(Z, FNU, KODE, NN, CY, NW, TOL)
      IF(NW.LT.0) GO TO 130
      GO TO 120
   80 CONTINUE
C-----------------------------------------------------------------------
C     MILLER ALGORITHM NORMALIZED BY THE WRONSKIAN
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C     OVERFLOW TEST ON K FUNCTIONS USED IN WRONSKIAN
C-----------------------------------------------------------------------
      CALL CUOIK(Z, FNU, KODE, 2, 2, CW, NW, TOL, ELIM, ALIM)
      IF (NW.GE.0) GO TO 100
      NZ = NN
      DO 90 I=1,NN
        CY(I) = CZERO
   90 CONTINUE
      RETURN
  100 CONTINUE
      IF (NW.GT.0) GO TO 130
      CALL CWRSK(Z, FNU, KODE, NN, CY, NW, CW, TOL, ELIM, ALIM)
      IF (NW.LT.0) GO TO 130
      GO TO 120
  110 CONTINUE
C-----------------------------------------------------------------------
C     INCREMENT FNU+NN-1 UP TO FNUL, COMPUTE AND RECUR BACKWARD
C-----------------------------------------------------------------------
      NUI = FNUL-DFNU + 1
      NUI = MAX(NUI,0)
      CALL CBUNI(Z, FNU, KODE, NN, CY, NW, NUI, NLAST, FNUL, TOL, ELIM,
     * ALIM)
      IF (NW.LT.0) GO TO 130
      NZ = NZ + NW
      IF (NLAST.EQ.0) GO TO 120
      NN = NLAST
      GO TO 60
  120 CONTINUE
      RETURN
  130 CONTINUE
      NZ = -1
      IF(NW.EQ.(-2)) NZ=-2
      RETURN
      END
*DECK CBKNU
      SUBROUTINE CBKNU (Z, FNU, KODE, N, Y, NZ, TOL, ELIM, ALIM)
C***BEGIN PROLOGUE  CBKNU
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CAIRY, CBESH, CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CBKNU-A, ZBKNU-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CBKNU COMPUTES THE K BESSEL FUNCTION IN THE RIGHT HALF Z PLANE
C
C***SEE ALSO  CAIRY, CBESH, CBESI, CBESK
C***ROUTINES CALLED  CKSCL, CSHCH, CUCHK, GAMLN, I1MACH, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CBKNU
C
      COMPLEX CCH, CK, COEF, CONE, CRSC, CS, CSCL, CSH, CSR, CSS, CTWO,
     * CZ, CZERO, F, FMU, P, PT, P1, P2, Q, RZ, SMU, ST, S1, S2, Y, Z,
     * ZD, CELM, CY
      REAL AA, AK, ALIM, ASCLE, A1, A2, BB, BK, BRY, CAZ, CC, DNU,
     * DNU2, ELIM, ETEST, FC, FHS, FK, FKS, FNU, FPI, G1, G2, HPI, PI,
     * P2I, P2M, P2R, RK, RTHPI, R1, S, SPI, TM, TOL, TTH, T1, T2, XX,
     * YY, GAMLN, R1MACH, HELIM, ELM, XD, YD, ALAS, AS
      INTEGER I, IDUM, IFLAG, INU, K, KFLAG, KK, KMAX, KODE, KODED, N,
     * NZ, I1MACH, NW, J, IC, INUB
      DIMENSION BRY(3), CC(8), CSS(3), CSR(3), Y(N), CY(2)
C
      DATA KMAX / 30 /
      DATA R1 / 2.0E0 /
      DATA CZERO,CONE,CTWO /(0.0E0,0.0E0),(1.0E0,0.0E0),(2.0E0,0.0E0)/
C
      DATA PI, RTHPI, SPI ,HPI, FPI, TTH /
     1     3.14159265358979324E0,       1.25331413731550025E0,
     2     1.90985931710274403E0,       1.57079632679489662E0,
     3     1.89769999331517738E0,       6.66666666666666666E-01/
C
      DATA CC(1), CC(2), CC(3), CC(4), CC(5), CC(6), CC(7), CC(8)/
     1     5.77215664901532861E-01,    -4.20026350340952355E-02,
     2    -4.21977345555443367E-02,     7.21894324666309954E-03,
     3    -2.15241674114950973E-04,    -2.01348547807882387E-05,
     4     1.13302723198169588E-06,     6.11609510448141582E-09/
C
C***FIRST EXECUTABLE STATEMENT  CBKNU
      XX = REAL(Z)
      YY = AIMAG(Z)
      CAZ = ABS(Z)
      CSCL = CMPLX(1.0E0/TOL,0.0E0)
      CRSC = CMPLX(TOL,0.0E0)
      CSS(1) = CSCL
      CSS(2) = CONE
      CSS(3) = CRSC
      CSR(1) = CRSC
      CSR(2) = CONE
      CSR(3) = CSCL
      BRY(1) = 1.0E+3*R1MACH(1)/TOL
      BRY(2) = 1.0E0/BRY(1)
      BRY(3) = R1MACH(2)
      NZ = 0
      IFLAG = 0
      KODED = KODE
      RZ = CTWO/Z
      INU = FNU+0.5E0
      DNU = FNU - INU
      IF (ABS(DNU).EQ.0.5E0) GO TO 110
      DNU2 = 0.0E0
      IF (ABS(DNU).GT.TOL) DNU2 = DNU*DNU
      IF (CAZ.GT.R1) GO TO 110
C-----------------------------------------------------------------------
C     SERIES FOR ABS(Z).LE.R1
C-----------------------------------------------------------------------
      FC = 1.0E0
      SMU = CLOG(RZ)
      FMU = SMU*CMPLX(DNU,0.0E0)
      CALL CSHCH(FMU, CSH, CCH)
      IF (DNU.EQ.0.0E0) GO TO 10
      FC = DNU*PI
      FC = FC/SIN(FC)
      SMU = CSH*CMPLX(1.0E0/DNU,0.0E0)
   10 CONTINUE
      A2 = 1.0E0 + DNU
C-----------------------------------------------------------------------
C     GAM(1-Z)*GAM(1+Z)=PI*Z/SIN(PI*Z), T1=1/GAM(1-DNU), T2=1/GAM(1+DNU)
C-----------------------------------------------------------------------
      T2 = EXP(-GAMLN(A2,IDUM))
      T1 = 1.0E0/(T2*FC)
      IF (ABS(DNU).GT.0.1E0) GO TO 40
C-----------------------------------------------------------------------
C     SERIES FOR F0 TO RESOLVE INDETERMINACY FOR SMALL ABS(DNU)
C-----------------------------------------------------------------------
      AK = 1.0E0
      S = CC(1)
      DO 20 K=2,8
        AK = AK*DNU2
        TM = CC(K)*AK
        S = S + TM
        IF (ABS(TM).LT.TOL) GO TO 30
   20 CONTINUE
   30 G1 = -S
      GO TO 50
   40 CONTINUE
      G1 = (T1-T2)/(DNU+DNU)
   50 CONTINUE
      G2 = 0.5E0*(T1+T2)*FC
      G1 = G1*FC
      F = CMPLX(G1,0.0E0)*CCH + SMU*CMPLX(G2,0.0E0)
      PT = CEXP(FMU)
      P = CMPLX(0.5E0/T2,0.0E0)*PT
      Q = CMPLX(0.5E0/T1,0.0E0)/PT
      S1 = F
      S2 = P
      AK = 1.0E0
      A1 = 1.0E0
      CK = CONE
      BK = 1.0E0 - DNU2
      IF (INU.GT.0 .OR. N.GT.1) GO TO 80
C-----------------------------------------------------------------------
C     GENERATE K(FNU,Z), 0.0D0 .LE. FNU .LT. 0.5D0 AND N=1
C-----------------------------------------------------------------------
      IF (CAZ.LT.TOL) GO TO 70
      CZ = Z*Z*CMPLX(0.25E0,0.0E0)
      T1 = 0.25E0*CAZ*CAZ
   60 CONTINUE
      F = (F*CMPLX(AK,0.0E0)+P+Q)*CMPLX(1.0E0/BK,0.0E0)
      P = P*CMPLX(1.0E0/(AK-DNU),0.0E0)
      Q = Q*CMPLX(1.0E0/(AK+DNU),0.0E0)
      RK = 1.0E0/AK
      CK = CK*CZ*CMPLX(RK,0.0)
      S1 = S1 + CK*F
      A1 = A1*T1*RK
      BK = BK + AK + AK + 1.0E0
      AK = AK + 1.0E0
      IF (A1.GT.TOL) GO TO 60
   70 CONTINUE
      Y(1) = S1
      IF (KODED.EQ.1) RETURN
      Y(1) = S1*CEXP(Z)
      RETURN
C-----------------------------------------------------------------------
C     GENERATE K(DNU,Z) AND K(DNU+1,Z) FOR FORWARD RECURRENCE
C-----------------------------------------------------------------------
   80 CONTINUE
      IF (CAZ.LT.TOL) GO TO 100
      CZ = Z*Z*CMPLX(0.25E0,0.0E0)
      T1 = 0.25E0*CAZ*CAZ
   90 CONTINUE
      F = (F*CMPLX(AK,0.0E0)+P+Q)*CMPLX(1.0E0/BK,0.0E0)
      P = P*CMPLX(1.0E0/(AK-DNU),0.0E0)
      Q = Q*CMPLX(1.0E0/(AK+DNU),0.0E0)
      RK = 1.0E0/AK
      CK = CK*CZ*CMPLX(RK,0.0E0)
      S1 = S1 + CK*F
      S2 = S2 + CK*(P-F*CMPLX(AK,0.0E0))
      A1 = A1*T1*RK
      BK = BK + AK + AK + 1.0E0
      AK = AK + 1.0E0
      IF (A1.GT.TOL) GO TO 90
  100 CONTINUE
      KFLAG = 2
      BK = REAL(SMU)
      A1 = FNU + 1.0E0
      AK = A1*ABS(BK)
      IF (AK.GT.ALIM) KFLAG = 3
      P2 = S2*CSS(KFLAG)
      S2 = P2*RZ
      S1 = S1*CSS(KFLAG)
      IF (KODED.EQ.1) GO TO 210
      F = CEXP(Z)
      S1 = S1*F
      S2 = S2*F
      GO TO 210
C-----------------------------------------------------------------------
C     IFLAG=0 MEANS NO UNDERFLOW OCCURRED
C     IFLAG=1 MEANS AN UNDERFLOW OCCURRED- COMPUTATION PROCEEDS WITH
C     KODED=2 AND A TEST FOR ON SCALE VALUES IS MADE DURING FORWARD
C     RECURSION
C-----------------------------------------------------------------------
  110 CONTINUE
      COEF = CMPLX(RTHPI,0.0E0)/CSQRT(Z)
      KFLAG = 2
      IF (KODED.EQ.2) GO TO 120
      IF (XX.GT.ALIM) GO TO 290
C     BLANK LINE
      A1 = EXP(-XX)*REAL(CSS(KFLAG))
      PT = CMPLX(A1,0.0E0)*CMPLX(COS(YY),-SIN(YY))
      COEF = COEF*PT
  120 CONTINUE
      IF (ABS(DNU).EQ.0.5E0) GO TO 300
C-----------------------------------------------------------------------
C     MILLER ALGORITHM FOR ABS(Z).GT.R1
C-----------------------------------------------------------------------
      AK = COS(PI*DNU)
      AK = ABS(AK)
      IF (AK.EQ.0.0E0) GO TO 300
      FHS = ABS(0.25E0-DNU2)
      IF (FHS.EQ.0.0E0) GO TO 300
C-----------------------------------------------------------------------
C     COMPUTE R2=F(E). IF ABS(Z).GE.R2, USE FORWARD RECURRENCE TO
C     DETERMINE THE BACKWARD INDEX K. R2=F(E) IS A STRAIGHT LINE ON
C     12.LE.E.LE.60. E IS COMPUTED FROM 2**(-E)=B**(1-I1MACH(11))=
C     TOL WHERE B IS THE BASE OF THE ARITHMETIC.
C-----------------------------------------------------------------------
      T1 = (I1MACH(11)-1)*R1MACH(5)*3.321928094E0
      T1 = MAX(T1,12.0E0)
      T1 = MIN(T1,60.0E0)
      T2 = TTH*T1 - 6.0E0
      IF (XX.NE.0.0E0) GO TO 130
      T1 = HPI
      GO TO 140
  130 CONTINUE
      T1 = ATAN(YY/XX)
      T1 = ABS(T1)
  140 CONTINUE
      IF (T2.GT.CAZ) GO TO 170
C-----------------------------------------------------------------------
C     FORWARD RECURRENCE LOOP WHEN ABS(Z).GE.R2
C-----------------------------------------------------------------------
      ETEST = AK/(PI*CAZ*TOL)
      FK = 1.0E0
      IF (ETEST.LT.1.0E0) GO TO 180
      FKS = 2.0E0
      RK = CAZ + CAZ + 2.0E0
      A1 = 0.0E0
      A2 = 1.0E0
      DO 150 I=1,KMAX
        AK = FHS/FKS
        BK = RK/(FK+1.0E0)
        TM = A2
        A2 = BK*A2 - AK*A1
        A1 = TM
        RK = RK + 2.0E0
        FKS = FKS + FK + FK + 2.0E0
        FHS = FHS + FK + FK
        FK = FK + 1.0E0
        TM = ABS(A2)*FK
        IF (ETEST.LT.TM) GO TO 160
  150 CONTINUE
      GO TO 310
  160 CONTINUE
      FK = FK + SPI*T1*SQRT(T2/CAZ)
      FHS = ABS(0.25E0-DNU2)
      GO TO 180
  170 CONTINUE
C-----------------------------------------------------------------------
C     COMPUTE BACKWARD INDEX K FOR ABS(Z).LT.R2
C-----------------------------------------------------------------------
      A2 = SQRT(CAZ)
      AK = FPI*AK/(TOL*SQRT(A2))
      AA = 3.0E0*T1/(1.0E0+CAZ)
      BB = 14.7E0*T1/(28.0E0+CAZ)
      AK = (ALOG(AK)+CAZ*COS(AA)/(1.0E0+0.008E0*CAZ))/COS(BB)
      FK = 0.12125E0*AK*AK/CAZ + 1.5E0
  180 CONTINUE
      K = FK
C-----------------------------------------------------------------------
C     BACKWARD RECURRENCE LOOP FOR MILLER ALGORITHM
C-----------------------------------------------------------------------
      FK = K
      FKS = FK*FK
      P1 = CZERO
      P2 = CMPLX(TOL,0.0E0)
      CS = P2
      DO 190 I=1,K
        A1 = FKS - FK
        A2 = (FKS+FK)/(A1+FHS)
        RK = 2.0E0/(FK+1.0E0)
        T1 = (FK+XX)*RK
        T2 = YY*RK
        PT = P2
        P2 = (P2*CMPLX(T1,T2)-P1)*CMPLX(A2,0.0E0)
        P1 = PT
        CS = CS + P2
        FKS = A1 - FK + 1.0E0
        FK = FK - 1.0E0
  190 CONTINUE
C-----------------------------------------------------------------------
C     COMPUTE (P2/CS)=(P2/ABS(CS))*(CONJG(CS)/ABS(CS)) FOR BETTER
C     SCALING
C-----------------------------------------------------------------------
      TM = ABS(CS)
      PT = CMPLX(1.0E0/TM,0.0E0)
      S1 = PT*P2
      CS = CONJG(CS)*PT
      S1 = COEF*S1*CS
      IF (INU.GT.0 .OR. N.GT.1) GO TO 200
      ZD = Z
      IF(IFLAG.EQ.1) GO TO 270
      GO TO 240
  200 CONTINUE
C-----------------------------------------------------------------------
C     COMPUTE P1/P2=(P1/ABS(P2)*CONJG(P2)/ABS(P2) FOR SCALING
C-----------------------------------------------------------------------
      TM = ABS(P2)
      PT = CMPLX(1.0E0/TM,0.0E0)
      P1 = PT*P1
      P2 = CONJG(P2)*PT
      PT = P1*P2
      S2 = S1*(CONE+(CMPLX(DNU+0.5E0,0.0E0)-PT)/Z)
C-----------------------------------------------------------------------
C     FORWARD RECURSION ON THE THREE TERM RECURSION RELATION WITH
C     SCALING NEAR EXPONENT EXTREMES ON KFLAG=1 OR KFLAG=3
C-----------------------------------------------------------------------
  210 CONTINUE
      CK = CMPLX(DNU+1.0E0,0.0E0)*RZ
      IF (N.EQ.1) INU = INU - 1
      IF (INU.GT.0) GO TO 220
      IF (N.EQ.1) S1=S2
      ZD = Z
      IF(IFLAG.EQ.1) GO TO 270
      GO TO 240
  220 CONTINUE
      INUB = 1
      IF (IFLAG.EQ.1) GO TO 261
  225 CONTINUE
      P1 = CSR(KFLAG)
      ASCLE = BRY(KFLAG)
      DO 230 I=INUB,INU
        ST = S2
        S2 = CK*S2 + S1
        S1 = ST
        CK = CK + RZ
        IF (KFLAG.GE.3) GO TO 230
        P2 = S2*P1
        P2R = REAL(P2)
        P2I = AIMAG(P2)
        P2R = ABS(P2R)
        P2I = ABS(P2I)
        P2M = MAX(P2R,P2I)
        IF (P2M.LE.ASCLE) GO TO 230
        KFLAG = KFLAG + 1
        ASCLE = BRY(KFLAG)
        S1 = S1*P1
        S2 = P2
        S1 = S1*CSS(KFLAG)
        S2 = S2*CSS(KFLAG)
        P1 = CSR(KFLAG)
  230 CONTINUE
      IF (N.EQ.1) S1 = S2
  240 CONTINUE
      Y(1) = S1*CSR(KFLAG)
      IF (N.EQ.1) RETURN
      Y(2) = S2*CSR(KFLAG)
      IF (N.EQ.2) RETURN
      KK = 2
  250 CONTINUE
      KK = KK + 1
      IF (KK.GT.N) RETURN
      P1 = CSR(KFLAG)
      ASCLE = BRY(KFLAG)
      DO 260 I=KK,N
        P2 = S2
        S2 = CK*S2 + S1
        S1 = P2
        CK = CK + RZ
        P2 = S2*P1
        Y(I) = P2
        IF (KFLAG.GE.3) GO TO 260
        P2R = REAL(P2)
        P2I = AIMAG(P2)
        P2R = ABS(P2R)
        P2I = ABS(P2I)
        P2M = MAX(P2R,P2I)
        IF (P2M.LE.ASCLE) GO TO 260
        KFLAG = KFLAG + 1
        ASCLE = BRY(KFLAG)
        S1 = S1*P1
        S2 = P2
        S1 = S1*CSS(KFLAG)
        S2 = S2*CSS(KFLAG)
        P1 = CSR(KFLAG)
  260 CONTINUE
      RETURN
C-----------------------------------------------------------------------
C     IFLAG=1 CASES, FORWARD RECURRENCE ON SCALED VALUES ON UNDERFLOW
C-----------------------------------------------------------------------
  261 CONTINUE
      HELIM = 0.5E0*ELIM
      ELM = EXP(-ELIM)
      CELM = CMPLX(ELM,0.0)
      ASCLE = BRY(1)
      ZD = Z
      XD = XX
      YD = YY
      IC = -1
      J = 2
      DO 262 I=1,INU
        ST = S2
        S2 = CK*S2+S1
        S1 = ST
        CK = CK+RZ
        AS = ABS(S2)
        ALAS = ALOG(AS)
        P2R = -XD+ALAS
        IF(P2R.LT.(-ELIM)) GO TO 263
        P2 = -ZD+CLOG(S2)
        P2R = REAL(P2)
        P2I = AIMAG(P2)
        P2M = EXP(P2R)/TOL
        P1 = CMPLX(P2M,0.0E0)*CMPLX(COS(P2I),SIN(P2I))
        CALL CUCHK(P1,NW,ASCLE,TOL)
        IF(NW.NE.0) GO TO 263
        J=3-J
        CY(J) = P1
        IF(IC.EQ.(I-1)) GO TO 264
        IC = I
        GO TO 262
  263   CONTINUE
        IF(ALAS.LT.HELIM) GO TO 262
        XD = XD-ELIM
        S1 = S1*CELM
        S2 = S2*CELM
        ZD = CMPLX(XD,YD)
  262 CONTINUE
      IF(N.EQ.1) S1 = S2
      GO TO 270
  264 CONTINUE
      KFLAG = 1
      INUB = I+1
      S2 = CY(J)
      J = 3 - J
      S1 = CY(J)
      IF(INUB.LE.INU) GO TO 225
      IF(N.EQ.1) S1 = S2
      GO TO 240
  270 CONTINUE
      Y(1) = S1
      IF (N.EQ.1) GO TO 280
      Y(2) = S2
  280 CONTINUE
      ASCLE = BRY(1)
      CALL CKSCL(ZD, FNU, N, Y, NZ, RZ, ASCLE, TOL, ELIM)
      INU = N - NZ
      IF (INU.LE.0) RETURN
      KK = NZ + 1
      S1 = Y(KK)
      Y(KK) = S1*CSR(1)
      IF (INU.EQ.1) RETURN
      KK = NZ + 2
      S2 = Y(KK)
      Y(KK) = S2*CSR(1)
      IF (INU.EQ.2) RETURN
      T2 = FNU + (KK-1)
      CK = CMPLX(T2,0.0E0)*RZ
      KFLAG = 1
      GO TO 250
  290 CONTINUE
C-----------------------------------------------------------------------
C     SCALE BY EXP(Z), IFLAG = 1 CASES
C-----------------------------------------------------------------------
      KODED = 2
      IFLAG = 1
      KFLAG = 2
      GO TO 120
C-----------------------------------------------------------------------
C     FNU=HALF ODD INTEGER CASE, DNU=-0.5
C-----------------------------------------------------------------------
  300 CONTINUE
      S1 = COEF
      S2 = COEF
      GO TO 210
  310 CONTINUE
      NZ=-2
      RETURN
      END
*DECK CBUNI
      SUBROUTINE CBUNI (Z, FNU, KODE, N, Y, NZ, NUI, NLAST, FNUL, TOL,
     +   ELIM, ALIM)
C***BEGIN PROLOGUE  CBUNI
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CBUNI-A, ZBUNI-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CBUNI COMPUTES THE I BESSEL FUNCTION FOR LARGE ABS(Z).GT.
C     FNUL AND FNU+N-1.LT.FNUL. THE ORDER IS INCREASED FROM
C     FNU+N-1 GREATER THAN FNUL BY ADDING NUI AND COMPUTING
C     ACCORDING TO THE UNIFORM ASYMPTOTIC EXPANSION FOR I(FNU,Z)
C     ON IFORM=1 AND THE EXPANSION FOR J(FNU,Z) ON IFORM=2
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  CUNI1, CUNI2, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CBUNI
      COMPLEX CSCL, CSCR, CY, RZ, ST, S1, S2, Y, Z
      REAL ALIM, AX, AY, DFNU, ELIM, FNU, FNUI, FNUL, GNU, TOL, XX, YY,
     * ASCLE, BRY, STR, STI, STM, R1MACH
      INTEGER I, IFLAG, IFORM, K, KODE, N, NL, NLAST, NUI, NW, NZ
      DIMENSION Y(N), CY(2), BRY(3)
C***FIRST EXECUTABLE STATEMENT  CBUNI
      NZ = 0
      XX = REAL(Z)
      YY = AIMAG(Z)
      AX = ABS(XX)*1.7321E0
      AY = ABS(YY)
      IFORM = 1
      IF (AY.GT.AX) IFORM = 2
      IF (NUI.EQ.0) GO TO 60
      FNUI = NUI
      DFNU = FNU + (N-1)
      GNU = DFNU + FNUI
      IF (IFORM.EQ.2) GO TO 10
C-----------------------------------------------------------------------
C     ASYMPTOTIC EXPANSION FOR I(FNU,Z) FOR LARGE FNU APPLIED IN
C     -PI/3.LE.ARG(Z).LE.PI/3
C-----------------------------------------------------------------------
      CALL CUNI1(Z, GNU, KODE, 2, CY, NW, NLAST, FNUL, TOL, ELIM, ALIM)
      GO TO 20
   10 CONTINUE
C-----------------------------------------------------------------------
C     ASYMPTOTIC EXPANSION FOR J(FNU,Z*EXP(M*HPI)) FOR LARGE FNU
C     APPLIED IN PI/3.LT.ABS(ARG(Z)).LE.PI/2 WHERE M=+I OR -I
C     AND HPI=PI/2
C-----------------------------------------------------------------------
      CALL CUNI2(Z, GNU, KODE, 2, CY, NW, NLAST, FNUL, TOL, ELIM, ALIM)
   20 CONTINUE
      IF (NW.LT.0) GO TO 50
      IF (NW.NE.0) GO TO 90
      AY = ABS(CY(1))
C----------------------------------------------------------------------
C     SCALE BACKWARD RECURRENCE, BRY(3) IS DEFINED BUT NEVER USED
C----------------------------------------------------------------------
      BRY(1) = 1.0E+3*R1MACH(1)/TOL
      BRY(2) = 1.0E0/BRY(1)
      BRY(3) = BRY(2)
      IFLAG = 2
      ASCLE = BRY(2)
      AX = 1.0E0
      CSCL = CMPLX(AX,0.0E0)
      IF (AY.GT.BRY(1)) GO TO 21
      IFLAG = 1
      ASCLE = BRY(1)
      AX = 1.0E0/TOL
      CSCL = CMPLX(AX,0.0E0)
      GO TO 25
   21 CONTINUE
      IF (AY.LT.BRY(2)) GO TO 25
      IFLAG = 3
      ASCLE = BRY(3)
      AX = TOL
      CSCL = CMPLX(AX,0.0E0)
   25 CONTINUE
      AY = 1.0E0/AX
      CSCR = CMPLX(AY,0.0E0)
      S1 = CY(2)*CSCL
      S2 = CY(1)*CSCL
      RZ = CMPLX(2.0E0,0.0E0)/Z
      DO 30 I=1,NUI
        ST = S2
        S2 = CMPLX(DFNU+FNUI,0.0E0)*RZ*S2 + S1
        S1 = ST
        FNUI = FNUI - 1.0E0
        IF (IFLAG.GE.3) GO TO 30
        ST = S2*CSCR
        STR = REAL(ST)
        STI = AIMAG(ST)
        STR = ABS(STR)
        STI = ABS(STI)
        STM = MAX(STR,STI)
        IF (STM.LE.ASCLE) GO TO 30
        IFLAG = IFLAG+1
        ASCLE = BRY(IFLAG)
        S1 = S1*CSCR
        S2 = ST
        AX = AX*TOL
        AY = 1.0E0/AX
        CSCL = CMPLX(AX,0.0E0)
        CSCR = CMPLX(AY,0.0E0)
        S1 = S1*CSCL
        S2 = S2*CSCL
   30 CONTINUE
      Y(N) = S2*CSCR
      IF (N.EQ.1) RETURN
      NL = N - 1
      FNUI = NL
      K = NL
      DO 40 I=1,NL
        ST = S2
        S2 = CMPLX(FNU+FNUI,0.0E0)*RZ*S2 + S1
        S1 = ST
        ST = S2*CSCR
        Y(K) = ST
        FNUI = FNUI - 1.0E0
        K = K - 1
        IF (IFLAG.GE.3) GO TO 40
        STR = REAL(ST)
        STI = AIMAG(ST)
        STR = ABS(STR)
        STI = ABS(STI)
        STM = MAX(STR,STI)
        IF (STM.LE.ASCLE) GO TO 40
        IFLAG = IFLAG+1
        ASCLE = BRY(IFLAG)
        S1 = S1*CSCR
        S2 = ST
        AX = AX*TOL
        AY = 1.0E0/AX
        CSCL = CMPLX(AX,0.0E0)
        CSCR = CMPLX(AY,0.0E0)
        S1 = S1*CSCL
        S2 = S2*CSCL
   40 CONTINUE
      RETURN
   50 CONTINUE
      NZ = -1
      IF(NW.EQ.(-2)) NZ=-2
      RETURN
   60 CONTINUE
      IF (IFORM.EQ.2) GO TO 70
C-----------------------------------------------------------------------
C     ASYMPTOTIC EXPANSION FOR I(FNU,Z) FOR LARGE FNU APPLIED IN
C     -PI/3.LE.ARG(Z).LE.PI/3
C-----------------------------------------------------------------------
      CALL CUNI1(Z, FNU, KODE, N, Y, NW, NLAST, FNUL, TOL, ELIM, ALIM)
      GO TO 80
   70 CONTINUE
C-----------------------------------------------------------------------
C     ASYMPTOTIC EXPANSION FOR J(FNU,Z*EXP(M*HPI)) FOR LARGE FNU
C     APPLIED IN PI/3.LT.ABS(ARG(Z)).LE.PI/2 WHERE M=+I OR -I
C     AND HPI=PI/2
C-----------------------------------------------------------------------
      CALL CUNI2(Z, FNU, KODE, N, Y, NW, NLAST, FNUL, TOL, ELIM, ALIM)
   80 CONTINUE
      IF (NW.LT.0) GO TO 50
      NZ = NW
      RETURN
   90 CONTINUE
      NLAST = N
      RETURN
      END
*DECK CKSCL
      SUBROUTINE CKSCL (ZR, FNU, N, Y, NZ, RZ, ASCLE, TOL, ELIM)
C***BEGIN PROLOGUE  CKSCL
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBKNU, CUNK1 and CUNK2
C***LIBRARY   SLATEC
C***TYPE      ALL (CKSCL-A, ZKSCL-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     SET K FUNCTIONS TO ZERO ON UNDERFLOW, CONTINUE RECURRENCE
C     ON SCALED FUNCTIONS UNTIL TWO MEMBERS COME ON SCALE, THEN
C     RETURN WITH MIN(NZ+2,N) VALUES SCALED BY 1/TOL.
C
C***SEE ALSO  CBKNU, CUNK1, CUNK2
C***ROUTINES CALLED  CUCHK
C***REVISION HISTORY  (YYMMDD)
C   ??????  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CKSCL
      COMPLEX CK, CS, CY, CZERO, RZ, S1, S2, Y, ZR, ZD, CELM
      REAL AA, ASCLE, ACS, AS, CSI, CSR, ELIM, FN, FNU, TOL, XX, ZRI,
     * ELM, ALAS, HELIM
      INTEGER I, IC, K, KK, N, NN, NW, NZ
      DIMENSION Y(N), CY(2)
      DATA CZERO / (0.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CUCHK
      NZ = 0
      IC = 0
      XX = REAL(ZR)
      NN = MIN(2,N)
      DO 10 I=1,NN
        S1 = Y(I)
        CY(I) = S1
        AS = ABS(S1)
        ACS = -XX + ALOG(AS)
        NZ = NZ + 1
        Y(I) = CZERO
        IF (ACS.LT.(-ELIM)) GO TO 10
        CS = -ZR + CLOG(S1)
        CSR = REAL(CS)
        CSI = AIMAG(CS)
        AA = EXP(CSR)/TOL
        CS = CMPLX(AA,0.0E0)*CMPLX(COS(CSI),SIN(CSI))
        CALL CUCHK(CS, NW, ASCLE, TOL)
        IF (NW.NE.0) GO TO 10
        Y(I) = CS
        NZ = NZ - 1
        IC = I
   10 CONTINUE
      IF (N.EQ.1) RETURN
      IF (IC.GT.1) GO TO 20
      Y(1) = CZERO
      NZ = 2
   20 CONTINUE
      IF (N.EQ.2) RETURN
      IF (NZ.EQ.0) RETURN
      FN = FNU + 1.0E0
      CK = CMPLX(FN,0.0E0)*RZ
      S1 = CY(1)
      S2 = CY(2)
      HELIM = 0.5E0*ELIM
      ELM = EXP(-ELIM)
      CELM = CMPLX(ELM,0.0E0)
      ZRI =AIMAG(ZR)
      ZD = ZR
C
C     FIND TWO CONSECUTIVE Y VALUES ON SCALE. SCALE RECURRENCE IF
C     S2 GETS LARGER THAN EXP(ELIM/2)
C
      DO 30 I=3,N
        KK = I
        CS = S2
        S2 = CK*S2 + S1
        S1 = CS
        CK = CK + RZ
        AS = ABS(S2)
        ALAS = ALOG(AS)
        ACS = -XX + ALAS
        NZ = NZ + 1
        Y(I) = CZERO
        IF (ACS.LT.(-ELIM)) GO TO 25
        CS = -ZD + CLOG(S2)
        CSR = REAL(CS)
        CSI = AIMAG(CS)
        AA = EXP(CSR)/TOL
        CS = CMPLX(AA,0.0E0)*CMPLX(COS(CSI),SIN(CSI))
        CALL CUCHK(CS, NW, ASCLE, TOL)
        IF (NW.NE.0) GO TO 25
        Y(I) = CS
        NZ = NZ - 1
        IF (IC.EQ.(KK-1)) GO TO 40
        IC = KK
        GO TO 30
   25   CONTINUE
        IF(ALAS.LT.HELIM) GO TO 30
        XX = XX-ELIM
        S1 = S1*CELM
        S2 = S2*CELM
        ZD = CMPLX(XX,ZRI)
   30 CONTINUE
      NZ = N
      IF(IC.EQ.N) NZ=N-1
      GO TO 45
   40 CONTINUE
      NZ = KK - 2
   45 CONTINUE
      DO 50 K=1,NZ
        Y(K) = CZERO
   50 CONTINUE
      RETURN
      END
*DECK CMLRI
      SUBROUTINE CMLRI (Z, FNU, KODE, N, Y, NZ, TOL)
C***BEGIN PROLOGUE  CMLRI
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CMLRI-A, ZMLRI-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CMLRI COMPUTES THE I BESSEL FUNCTION FOR RE(Z).GE.0.0 BY THE
C     MILLER ALGORITHM NORMALIZED BY A NEUMANN SERIES.
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  GAMLN, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CMLRI
      COMPLEX CK, CNORM, CONE, CTWO, CZERO, PT, P1, P2, RZ, SUM, Y, Z
      REAL ACK, AK, AP, AT, AZ, BK, FKAP, FKK, FLAM, FNF, FNU, RHO,
     * RHO2, SCLE, TFNF, TOL, TST, X, GAMLN, R1MACH
      INTEGER I, IAZ, IDUM, IFNU, INU, ITIME, K, KK, KM, KODE, M, N, NZ
      DIMENSION Y(N)
      DATA CZERO,CONE,CTWO /(0.0E0,0.0E0),(1.0E0,0.0E0),(2.0E0,0.0E0)/
      SCLE = 1.0E+3*R1MACH(1)/TOL
C***FIRST EXECUTABLE STATEMENT  CMLRI
      NZ=0
      AZ = ABS(Z)
      X = REAL(Z)
      IAZ = AZ
      IFNU = FNU
      INU = IFNU + N - 1
      AT = IAZ + 1.0E0
      CK = CMPLX(AT,0.0E0)/Z
      RZ = CTWO/Z
      P1 = CZERO
      P2 = CONE
      ACK = (AT+1.0E0)/AZ
      RHO = ACK + SQRT(ACK*ACK-1.0E0)
      RHO2 = RHO*RHO
      TST = (RHO2+RHO2)/((RHO2-1.0E0)*(RHO-1.0E0))
      TST = TST/TOL
C-----------------------------------------------------------------------
C     COMPUTE RELATIVE TRUNCATION ERROR INDEX FOR SERIES
C-----------------------------------------------------------------------
      AK = AT
      DO 10 I=1,80
        PT = P2
        P2 = P1 - CK*P2
        P1 = PT
        CK = CK + RZ
        AP = ABS(P2)
        IF (AP.GT.TST*AK*AK) GO TO 20
        AK = AK + 1.0E0
   10 CONTINUE
      GO TO 110
   20 CONTINUE
      I = I + 1
      K = 0
      IF (INU.LT.IAZ) GO TO 40
C-----------------------------------------------------------------------
C     COMPUTE RELATIVE TRUNCATION ERROR FOR RATIOS
C-----------------------------------------------------------------------
      P1 = CZERO
      P2 = CONE
      AT = INU + 1.0E0
      CK = CMPLX(AT,0.0E0)/Z
      ACK = AT/AZ
      TST = SQRT(ACK/TOL)
      ITIME = 1
      DO 30 K=1,80
        PT = P2
        P2 = P1 - CK*P2
        P1 = PT
        CK = CK + RZ
        AP = ABS(P2)
        IF (AP.LT.TST) GO TO 30
        IF (ITIME.EQ.2) GO TO 40
        ACK = ABS(CK)
        FLAM = ACK + SQRT(ACK*ACK-1.0E0)
        FKAP = AP/ABS(P1)
        RHO = MIN(FLAM,FKAP)
        TST = TST*SQRT(RHO/(RHO*RHO-1.0E0))
        ITIME = 2
   30 CONTINUE
      GO TO 110
   40 CONTINUE
C-----------------------------------------------------------------------
C     BACKWARD RECURRENCE AND SUM NORMALIZING RELATION
C-----------------------------------------------------------------------
      K = K + 1
      KK = MAX(I+IAZ,K+INU)
      FKK = KK
      P1 = CZERO
C-----------------------------------------------------------------------
C     SCALE P2 AND SUM BY SCLE
C-----------------------------------------------------------------------
      P2 = CMPLX(SCLE,0.0E0)
      FNF = FNU - IFNU
      TFNF = FNF + FNF
      BK = GAMLN(FKK+TFNF+1.0E0,IDUM) - GAMLN(FKK+1.0E0,IDUM)
     *     -GAMLN(TFNF+1.0E0,IDUM)
      BK = EXP(BK)
      SUM = CZERO
      KM = KK - INU
      DO 50 I=1,KM
        PT = P2
        P2 = P1 + CMPLX(FKK+FNF,0.0E0)*RZ*P2
        P1 = PT
        AK = 1.0E0 - TFNF/(FKK+TFNF)
        ACK = BK*AK
        SUM = SUM + CMPLX(ACK+BK,0.0E0)*P1
        BK = ACK
        FKK = FKK - 1.0E0
   50 CONTINUE
      Y(N) = P2
      IF (N.EQ.1) GO TO 70
      DO 60 I=2,N
        PT = P2
        P2 = P1 + CMPLX(FKK+FNF,0.0E0)*RZ*P2
        P1 = PT
        AK = 1.0E0 - TFNF/(FKK+TFNF)
        ACK = BK*AK
        SUM = SUM + CMPLX(ACK+BK,0.0E0)*P1
        BK = ACK
        FKK = FKK - 1.0E0
        M = N - I + 1
        Y(M) = P2
   60 CONTINUE
   70 CONTINUE
      IF (IFNU.LE.0) GO TO 90
      DO 80 I=1,IFNU
        PT = P2
        P2 = P1 + CMPLX(FKK+FNF,0.0E0)*RZ*P2
        P1 = PT
        AK = 1.0E0 - TFNF/(FKK+TFNF)
        ACK = BK*AK
        SUM = SUM + CMPLX(ACK+BK,0.0E0)*P1
        BK = ACK
        FKK = FKK - 1.0E0
   80 CONTINUE
   90 CONTINUE
      PT = Z
      IF (KODE.EQ.2) PT = PT - CMPLX(X,0.0E0)
      P1 = -CMPLX(FNF,0.0E0)*CLOG(RZ) + PT
      AP = GAMLN(1.0E0+FNF,IDUM)
      PT = P1 - CMPLX(AP,0.0E0)
C-----------------------------------------------------------------------
C     THE DIVISION CEXP(PT)/(SUM+P2) IS ALTERED TO AVOID OVERFLOW
C     IN THE DENOMINATOR BY SQUARING LARGE QUANTITIES
C-----------------------------------------------------------------------
      P2 = P2 + SUM
      AP = ABS(P2)
      P1 = CMPLX(1.0E0/AP,0.0E0)
      CK = CEXP(PT)*P1
      PT = CONJG(P2)*P1
      CNORM = CK*PT
      DO 100 I=1,N
        Y(I) = Y(I)*CNORM
  100 CONTINUE
      RETURN
  110 CONTINUE
      NZ=-2
      RETURN
      END
*DECK CRATI
      SUBROUTINE CRATI (Z, FNU, N, CY, TOL)
C***BEGIN PROLOGUE  CRATI
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESH, CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CRATI-A, ZRATI-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CRATI COMPUTES RATIOS OF I BESSEL FUNCTIONS BY BACKWARD
C     RECURRENCE.  THE STARTING INDEX IS DETERMINED BY FORWARD
C     RECURRENCE AS DESCRIBED IN J. RES. OF NAT. BUR. OF STANDARDS-B,
C     MATHEMATICAL SCIENCES, VOL 77B, P111-114, SEPTEMBER, 1973,
C     BESSEL FUNCTIONS I AND J OF COMPLEX ARGUMENT AND INTEGER ORDER,
C     BY D. J. SOOKNE.
C
C***SEE ALSO  CBESH, CBESI, CBESK
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CRATI
      COMPLEX CDFNU, CONE, CY, CZERO, PT, P1, P2, RZ, T1, Z
      REAL AK, AMAGZ, AP1, AP2, ARG, AZ, DFNU, FDNU, FLAM, FNU, FNUP,
     * RAP1, RHO, TEST, TEST1, TOL
      INTEGER I, ID, IDNU, INU, ITIME, K, KK, MAGZ, N
      DIMENSION CY(N)
      DATA CZERO, CONE / (0.0E0,0.0E0), (1.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CRATI
      AZ = ABS(Z)
      INU = FNU
      IDNU = INU + N - 1
      FDNU = IDNU
      MAGZ = AZ
      AMAGZ = MAGZ+1
      FNUP = MAX(AMAGZ,FDNU)
      ID = IDNU - MAGZ - 1
      ITIME = 1
      K = 1
      RZ = (CONE+CONE)/Z
      T1 = CMPLX(FNUP,0.0E0)*RZ
      P2 = -T1
      P1 = CONE
      T1 = T1 + RZ
      IF (ID.GT.0) ID = 0
      AP2 = ABS(P2)
      AP1 = ABS(P1)
C-----------------------------------------------------------------------
C     THE OVERFLOW TEST ON K(FNU+I-1,Z) BEFORE THE CALL TO CBKNX
C     GUARANTEES THAT P2 IS ON SCALE. SCALE TEST1 AND ALL SUBSEQUENT
C     P2 VALUES BY AP1 TO ENSURE THAT AN OVERFLOW DOES NOT OCCUR
C     PREMATURELY.
C-----------------------------------------------------------------------
      ARG = (AP2+AP2)/(AP1*TOL)
      TEST1 = SQRT(ARG)
      TEST = TEST1
      RAP1 = 1.0E0/AP1
      P1 = P1*CMPLX(RAP1,0.0E0)
      P2 = P2*CMPLX(RAP1,0.0E0)
      AP2 = AP2*RAP1
   10 CONTINUE
      K = K + 1
      AP1 = AP2
      PT = P2
      P2 = P1 - T1*P2
      P1 = PT
      T1 = T1 + RZ
      AP2 = ABS(P2)
      IF (AP1.LE.TEST) GO TO 10
      IF (ITIME.EQ.2) GO TO 20
      AK = ABS(T1)*0.5E0
      FLAM = AK + SQRT(AK*AK-1.0E0)
      RHO = MIN(AP2/AP1,FLAM)
      TEST = TEST1*SQRT(RHO/(RHO*RHO-1.0E0))
      ITIME = 2
      GO TO 10
   20 CONTINUE
      KK = K + 1 - ID
      AK = KK
      DFNU = FNU + (N-1)
      CDFNU = CMPLX(DFNU,0.0E0)
      T1 = CMPLX(AK,0.0E0)
      P1 = CMPLX(1.0E0/AP2,0.0E0)
      P2 = CZERO
      DO 30 I=1,KK
        PT = P1
        P1 = RZ*(CDFNU+T1)*P1 + P2
        P2 = PT
        T1 = T1 - CONE
   30 CONTINUE
      IF (REAL(P1).NE.0.0E0 .OR. AIMAG(P1).NE.0.0E0) GO TO 40
      P1 = CMPLX(TOL,TOL)
   40 CONTINUE
      CY(N) = P2/P1
      IF (N.EQ.1) RETURN
      K = N - 1
      AK = K
      T1 = CMPLX(AK,0.0E0)
      CDFNU = CMPLX(FNU,0.0E0)*RZ
      DO 60 I=2,N
        PT = CDFNU + T1*RZ + CY(K+1)
        IF (REAL(PT).NE.0.0E0 .OR. AIMAG(PT).NE.0.0E0) GO TO 50
        PT = CMPLX(TOL,TOL)
   50   CONTINUE
        CY(K) = CONE/PT
        T1 = T1 - CONE
        K = K - 1
   60 CONTINUE
      RETURN
      END
*DECK CS1S2
      SUBROUTINE CS1S2 (ZR, S1, S2, NZ, ASCLE, ALIM, IUF)
C***BEGIN PROLOGUE  CS1S2
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CAIRY and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CS1S2-A, ZS1S2-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CS1S2 TESTS FOR A POSSIBLE UNDERFLOW RESULTING FROM THE
C     ADDITION OF THE I AND K FUNCTIONS IN THE ANALYTIC CON-
C     TINUATION FORMULA WHERE S1=K FUNCTION AND S2=I FUNCTION.
C     ON KODE=1 THE I AND K FUNCTIONS ARE DIFFERENT ORDERS OF
C     MAGNITUDE, BUT FOR KODE=2 THEY CAN BE OF THE SAME ORDER
C     OF MAGNITUDE AND THE MAXIMUM MUST BE AT LEAST ONE
C     PRECISION ABOVE THE UNDERFLOW LIMIT.
C
C***SEE ALSO  CAIRY, CBESK
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CS1S2
      COMPLEX CZERO, C1, S1, S1D, S2, ZR
      REAL AA, ALIM, ALN, ASCLE, AS1, AS2, XX
      INTEGER IUF, NZ
      DATA CZERO / (0.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CS1S2
      NZ = 0
      AS1 = ABS(S1)
      AS2 = ABS(S2)
      AA = REAL(S1)
      ALN = AIMAG(S1)
      IF (AA.EQ.0.0E0 .AND. ALN.EQ.0.0E0) GO TO 10
      IF (AS1.EQ.0.0E0) GO TO 10
      XX = REAL(ZR)
      ALN = -XX - XX + ALOG(AS1)
      S1D = S1
      S1 = CZERO
      AS1 = 0.0E0
      IF (ALN.LT.(-ALIM)) GO TO 10
      C1 = CLOG(S1D) - ZR - ZR
      S1 = CEXP(C1)
      AS1 = ABS(S1)
      IUF = IUF + 1
   10 CONTINUE
      AA = MAX(AS1,AS2)
      IF (AA.GT.ASCLE) RETURN
      S1 = CZERO
      S2 = CZERO
      NZ = 1
      IUF = 0
      RETURN
      END
*DECK CSERI
      SUBROUTINE CSERI (Z, FNU, KODE, N, Y, NZ, TOL, ELIM, ALIM)
C***BEGIN PROLOGUE  CSERI
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CSERI-A, ZSERI-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CSERI COMPUTES THE I BESSEL FUNCTION FOR REAL(Z).GE.0.0 BY
C     MEANS OF THE POWER SERIES FOR LARGE ABS(Z) IN THE
C     REGION ABS(Z).LE.2*SQRT(FNU+1). NZ=0 IS A NORMAL RETURN.
C     NZ.GT.0 MEANS THAT THE LAST NZ COMPONENTS WERE SET TO ZERO
C     DUE TO UNDERFLOW. NZ.LT.0 MEANS UNDERFLOW OCCURRED, BUT THE
C     CONDITION ABS(Z).LE.2*SQRT(FNU+1) WAS VIOLATED AND THE
C     COMPUTATION MUST BE COMPLETED IN ANOTHER ROUTINE WITH N=N-ABS(NZ).
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  CUCHK, GAMLN, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CSERI
      COMPLEX AK1, CK, COEF, CONE, CRSC, CZ, CZERO, HZ, RZ, S1, S2, W,
     * Y, Z
      REAL AA, ACZ, AK, ALIM, ARM, ASCLE, ATOL, AZ, DFNU, ELIM, FNU,
     * FNUP, RAK1, RS, RTR1, S, SS, TOL, X, GAMLN, R1MACH
      INTEGER I, IB, IDUM, IFLAG, IL, K, KODE, L, M, N, NN, NW, NZ
      DIMENSION Y(N), W(2)
      DATA CZERO, CONE / (0.0E0,0.0E0), (1.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CSERI
      NZ = 0
      AZ = ABS(Z)
      IF (AZ.EQ.0.0E0) GO TO 150
      X = REAL(Z)
      ARM = 1.0E+3*R1MACH(1)
      RTR1 = SQRT(ARM)
      CRSC = CMPLX(1.0E0,0.0E0)
      IFLAG = 0
      IF (AZ.LT.ARM) GO TO 140
      HZ = Z*CMPLX(0.5E0,0.0E0)
      CZ = CZERO
      IF (AZ.GT.RTR1) CZ = HZ*HZ
      ACZ = ABS(CZ)
      NN = N
      CK = CLOG(HZ)
   10 CONTINUE
      DFNU = FNU + (NN-1)
      FNUP = DFNU + 1.0E0
C-----------------------------------------------------------------------
C     UNDERFLOW TEST
C-----------------------------------------------------------------------
      AK1 = CK*CMPLX(DFNU,0.0E0)
      AK = GAMLN(FNUP,IDUM)
      AK1 = AK1 - CMPLX(AK,0.0E0)
      IF (KODE.EQ.2) AK1 = AK1 - CMPLX(X,0.0E0)
      RAK1 = REAL(AK1)
      IF (RAK1.GT.(-ELIM)) GO TO 30
   20 CONTINUE
      NZ = NZ + 1
      Y(NN) = CZERO
      IF (ACZ.GT.DFNU) GO TO 170
      NN = NN - 1
      IF (NN.EQ.0) RETURN
      GO TO 10
   30 CONTINUE
      IF (RAK1.GT.(-ALIM)) GO TO 40
      IFLAG = 1
      SS = 1.0E0/TOL
      CRSC = CMPLX(TOL,0.0E0)
      ASCLE = ARM*SS
   40 CONTINUE
      AK = AIMAG(AK1)
      AA = EXP(RAK1)
      IF (IFLAG.EQ.1) AA = AA*SS
      COEF = CMPLX(AA,0.0E0)*CMPLX(COS(AK),SIN(AK))
      ATOL = TOL*ACZ/FNUP
      IL = MIN(2,NN)
      DO 80 I=1,IL
        DFNU = FNU + (NN-I)
        FNUP = DFNU + 1.0E0
        S1 = CONE
        IF (ACZ.LT.TOL*FNUP) GO TO 60
        AK1 = CONE
        AK = FNUP + 2.0E0
        S = FNUP
        AA = 2.0E0
   50   CONTINUE
        RS = 1.0E0/S
        AK1 = AK1*CZ*CMPLX(RS,0.0E0)
        S1 = S1 + AK1
        S = S + AK
        AK = AK + 2.0E0
        AA = AA*ACZ*RS
        IF (AA.GT.ATOL) GO TO 50
   60   CONTINUE
        M = NN - I + 1
        S2 = S1*COEF
        W(I) = S2
        IF (IFLAG.EQ.0) GO TO 70
        CALL CUCHK(S2, NW, ASCLE, TOL)
        IF (NW.NE.0) GO TO 20
   70   CONTINUE
        Y(M) = S2*CRSC
        IF (I.NE.IL) COEF = COEF*CMPLX(DFNU,0.0E0)/HZ
   80 CONTINUE
      IF (NN.LE.2) RETURN
      K = NN - 2
      AK = K
      RZ = (CONE+CONE)/Z
      IF (IFLAG.EQ.1) GO TO 110
      IB = 3
   90 CONTINUE
      DO 100 I=IB,NN
        Y(K) = CMPLX(AK+FNU,0.0E0)*RZ*Y(K+1) + Y(K+2)
        AK = AK - 1.0E0
        K = K - 1
  100 CONTINUE
      RETURN
C-----------------------------------------------------------------------
C     RECUR BACKWARD WITH SCALED VALUES
C-----------------------------------------------------------------------
  110 CONTINUE
C-----------------------------------------------------------------------
C     EXP(-ALIM)=EXP(-ELIM)/TOL=APPROX. ONE PRECISION ABOVE THE
C     UNDERFLOW LIMIT = ASCLE = R1MACH(1)*CSCL*1.0E+3
C-----------------------------------------------------------------------
      S1 = W(1)
      S2 = W(2)
      DO 120 L=3,NN
        CK = S2
        S2 = S1 + CMPLX(AK+FNU,0.0E0)*RZ*S2
        S1 = CK
        CK = S2*CRSC
        Y(K) = CK
        AK = AK - 1.0E0
        K = K - 1
        IF (ABS(CK).GT.ASCLE) GO TO 130
  120 CONTINUE
      RETURN
  130 CONTINUE
      IB = L + 1
      IF (IB.GT.NN) RETURN
      GO TO 90
  140 CONTINUE
      NZ = N
      IF (FNU.EQ.0.0E0) NZ = NZ - 1
  150 CONTINUE
      Y(1) = CZERO
      IF (FNU.EQ.0.0E0) Y(1) = CONE
      IF (N.EQ.1) RETURN
      DO 160 I=2,N
        Y(I) = CZERO
  160 CONTINUE
      RETURN
C-----------------------------------------------------------------------
C     RETURN WITH NZ.LT.0 IF ABS(Z*Z/4).GT.FNU+N-NZ-1 COMPLETE
C     THE CALCULATION IN CBINU WITH N=N-ABS(NZ)
C-----------------------------------------------------------------------
  170 CONTINUE
      NZ = -NZ
      RETURN
      END
*DECK CSHCH
      SUBROUTINE CSHCH (Z, CSH, CCH)
C***BEGIN PROLOGUE  CSHCH
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESH and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CSHCH-A, ZSHCH-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CSHCH COMPUTES THE COMPLEX HYPERBOLIC FUNCTIONS CSH=SINH(X+I*Y)
C     AND CCH=COSH(X+I*Y), WHERE I**2=-1.
C
C***SEE ALSO  CBESH, CBESK
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CSHCH
      COMPLEX CCH, CSH, Z
      REAL CCHI, CCHR, CH, CN, CSHI, CSHR, SH, SN, X, Y
C***FIRST EXECUTABLE STATEMENT  CSHCH
      X = REAL(Z)
      Y = AIMAG(Z)
      SH = SINH(X)
      CH = COSH(X)
      SN = SIN(Y)
      CN = COS(Y)
      CSHR = SH*CN
      CSHI = CH*SN
      CSH = CMPLX(CSHR,CSHI)
      CCHR = CH*CN
      CCHI = SH*SN
      CCH = CMPLX(CCHR,CCHI)
      RETURN
      END
*DECK CUCHK
      SUBROUTINE CUCHK (Y, NZ, ASCLE, TOL)
C***BEGIN PROLOGUE  CUCHK
C***SUBSIDIARY
C***PURPOSE  Subsidiary to SERI, CUOIK, CUNK1, CUNK2, CUNI1, CUNI2 and
C            CKSCL
C***LIBRARY   SLATEC
C***TYPE      ALL (CUCHK-A, ZUCHK-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C      Y ENTERS AS A SCALED QUANTITY WHOSE MAGNITUDE IS GREATER THAN
C      EXP(-ALIM)=ASCLE=1.0E+3*R1MACH(1)/TOL. THE TEST IS MADE TO SEE
C      IF THE MAGNITUDE OF THE REAL OR IMAGINARY PART WOULD UNDER FLOW
C      WHEN Y IS SCALED (BY TOL) TO ITS PROPER VALUE. Y IS ACCEPTED
C      IF THE UNDERFLOW IS AT LEAST ONE PRECISION BELOW THE MAGNITUDE
C      OF THE LARGEST COMPONENT; OTHERWISE THE PHASE ANGLE DOES NOT HAVE
C      ABSOLUTE ACCURACY AND AN UNDERFLOW IS ASSUMED.
C
C***SEE ALSO  CKSCL, CUNI1, CUNI2, CUNK1, CUNK2, CUOIK, SERI
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   ??????  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CUCHK
C
      COMPLEX Y
      REAL ASCLE, SS, ST, TOL, YR, YI
      INTEGER NZ
C***FIRST EXECUTABLE STATEMENT  CUCHK
      NZ = 0
      YR = REAL(Y)
      YI = AIMAG(Y)
      YR = ABS(YR)
      YI = ABS(YI)
      ST = MIN(YR,YI)
      IF (ST.GT.ASCLE) RETURN
      SS = MAX(YR,YI)
      ST=ST/TOL
      IF (SS.LT.ST) NZ = 1
      RETURN
      END
*DECK CUNHJ
      SUBROUTINE CUNHJ (Z, FNU, IPMTR, TOL, PHI, ARG, ZETA1, ZETA2,
     +   ASUM, BSUM)
C***BEGIN PROLOGUE  CUNHJ
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CUNHJ-A, ZUNHJ-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     REFERENCES
C         HANDBOOK OF MATHEMATICAL FUNCTIONS BY M. ABRAMOWITZ AND I.A.
C         STEGUN, AMS55, NATIONAL BUREAU OF STANDARDS, 1965, CHAPTER 9.
C
C         ASYMPTOTICS AND SPECIAL FUNCTIONS BY F.W.J. OLVER, ACADEMIC
C         PRESS, N.Y., 1974, PAGE 420
C
C     ABSTRACT
C         CUNHJ COMPUTES PARAMETERS FOR BESSEL FUNCTIONS C(FNU,Z) =
C         J(FNU,Z), Y(FNU,Z) OR H(I,FNU,Z) I=1,2 FOR LARGE ORDERS FNU
C         BY MEANS OF THE UNIFORM ASYMPTOTIC EXPANSION
C
C         C(FNU,Z)=C1*PHI*( ASUM*AIRY(ARG) + C2*BSUM*DAIRY(ARG) )
C
C         FOR PROPER CHOICES OF C1, C2, AIRY AND DAIRY WHERE AIRY IS
C         AN AIRY FUNCTION AND DAIRY IS ITS DERIVATIVE.
C
C               (2/3)*FNU*ZETA**1.5 = ZETA1-ZETA2,
C
C         ZETA1=0.5*FNU*CLOG((1+W)/(1-W)), ZETA2=FNU*W FOR SCALING
C         PURPOSES IN AIRY FUNCTIONS FROM CAIRY OR CBIRY.
C
C         MCONJ=SIGN OF AIMAG(Z), BUT IS AMBIGUOUS WHEN Z IS REAL AND
C         MUST BE SPECIFIED. IPMTR=0 RETURNS ALL PARAMETERS. IPMTR=
C         1 COMPUTES ALL EXCEPT ASUM AND BSUM.
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CUNHJ
      COMPLEX ARG, ASUM, BSUM, CFNU, CONE, CR, CZERO, DR, P, PHI,
     * PRZTH, PTFN, RFN13, RTZTA, RZTH, SUMA, SUMB, TFN, T2, UP, W, W2,
     * Z, ZA, ZB, ZC, ZETA, ZETA1, ZETA2, ZTH
      REAL ALFA, ANG, AP, AR, ATOL, AW2, AZTH, BETA, BR, BTOL, C, EX1,
     * EX2, FNU, FN13, FN23, GAMA, HPI, PI, PP, RFNU, RFNU2, THPI, TOL,
     * WI, WR, ZCI, ZCR, ZETAI, ZETAR, ZTHI, ZTHR, ASUMR, ASUMI, BSUMR,
     * BSUMI, TEST, TSTR, TSTI, AC, R1MACH
      INTEGER IAS, IBS, IPMTR, IS, J, JR, JU, K, KMAX, KP1, KS, L, LR,
     * LRP1, L1, L2, M
      DIMENSION AR(14), BR(14), C(105), ALFA(180), BETA(210), GAMA(30),
     * AP(30), P(30), UP(14), CR(14), DR(14)
      DATA AR(1), AR(2), AR(3), AR(4), AR(5), AR(6), AR(7), AR(8),
     1     AR(9), AR(10), AR(11), AR(12), AR(13), AR(14)/
     2     1.00000000000000000E+00,     1.04166666666666667E-01,
     3     8.35503472222222222E-02,     1.28226574556327160E-01,
     4     2.91849026464140464E-01,     8.81627267443757652E-01,
     5     3.32140828186276754E+00,     1.49957629868625547E+01,
     6     7.89230130115865181E+01,     4.74451538868264323E+02,
     7     3.20749009089066193E+03,     2.40865496408740049E+04,
     8     1.98923119169509794E+05,     1.79190200777534383E+06/
      DATA BR(1), BR(2), BR(3), BR(4), BR(5), BR(6), BR(7), BR(8),
     1     BR(9), BR(10), BR(11), BR(12), BR(13), BR(14)/
     2     1.00000000000000000E+00,    -1.45833333333333333E-01,
     3    -9.87413194444444444E-02,    -1.43312053915895062E-01,
     4    -3.17227202678413548E-01,    -9.42429147957120249E-01,
     5    -3.51120304082635426E+00,    -1.57272636203680451E+01,
     6    -8.22814390971859444E+01,    -4.92355370523670524E+02,
     7    -3.31621856854797251E+03,    -2.48276742452085896E+04,
     8    -2.04526587315129788E+05,    -1.83844491706820990E+06/
      DATA C(1), C(2), C(3), C(4), C(5), C(6), C(7), C(8), C(9), C(10),
     1     C(11), C(12), C(13), C(14), C(15), C(16), C(17), C(18),
     2     C(19), C(20), C(21), C(22), C(23), C(24)/
     3     1.00000000000000000E+00,    -2.08333333333333333E-01,
     4     1.25000000000000000E-01,     3.34201388888888889E-01,
     5    -4.01041666666666667E-01,     7.03125000000000000E-02,
     6    -1.02581259645061728E+00,     1.84646267361111111E+00,
     7    -8.91210937500000000E-01,     7.32421875000000000E-02,
     8     4.66958442342624743E+00,    -1.12070026162229938E+01,
     9     8.78912353515625000E+00,    -2.36408691406250000E+00,
     A     1.12152099609375000E-01,    -2.82120725582002449E+01,
     B     8.46362176746007346E+01,    -9.18182415432400174E+01,
     C     4.25349987453884549E+01,    -7.36879435947963170E+00,
     D     2.27108001708984375E-01,     2.12570130039217123E+02,
     E    -7.65252468141181642E+02,     1.05999045252799988E+03/
      DATA C(25), C(26), C(27), C(28), C(29), C(30), C(31), C(32),
     1     C(33), C(34), C(35), C(36), C(37), C(38), C(39), C(40),
     2     C(41), C(42), C(43), C(44), C(45), C(46), C(47), C(48)/
     3    -6.99579627376132541E+02,     2.18190511744211590E+02,
     4    -2.64914304869515555E+01,     5.72501420974731445E-01,
     5    -1.91945766231840700E+03,     8.06172218173730938E+03,
     6    -1.35865500064341374E+04,     1.16553933368645332E+04,
     7    -5.30564697861340311E+03,     1.20090291321635246E+03,
     8    -1.08090919788394656E+02,     1.72772750258445740E+00,
     9     2.02042913309661486E+04,    -9.69805983886375135E+04,
     A     1.92547001232531532E+05,    -2.03400177280415534E+05,
     B     1.22200464983017460E+05,    -4.11926549688975513E+04,
     C     7.10951430248936372E+03,    -4.93915304773088012E+02,
     D     6.07404200127348304E+00,    -2.42919187900551333E+05,
     E     1.31176361466297720E+06,    -2.99801591853810675E+06/
      DATA C(49), C(50), C(51), C(52), C(53), C(54), C(55), C(56),
     1     C(57), C(58), C(59), C(60), C(61), C(62), C(63), C(64),
     2     C(65), C(66), C(67), C(68), C(69), C(70), C(71), C(72)/
     3     3.76327129765640400E+06,    -2.81356322658653411E+06,
     4     1.26836527332162478E+06,    -3.31645172484563578E+05,
     5     4.52187689813627263E+04,    -2.49983048181120962E+03,
     6     2.43805296995560639E+01,     3.28446985307203782E+06,
     7    -1.97068191184322269E+07,     5.09526024926646422E+07,
     8    -7.41051482115326577E+07,     6.63445122747290267E+07,
     9    -3.75671766607633513E+07,     1.32887671664218183E+07,
     A    -2.78561812808645469E+06,     3.08186404612662398E+05,
     B    -1.38860897537170405E+04,     1.10017140269246738E+02,
     C    -4.93292536645099620E+07,     3.25573074185765749E+08,
     D    -9.39462359681578403E+08,     1.55359689957058006E+09,
     E    -1.62108055210833708E+09,     1.10684281682301447E+09/
      DATA C(73), C(74), C(75), C(76), C(77), C(78), C(79), C(80),
     1     C(81), C(82), C(83), C(84), C(85), C(86), C(87), C(88),
     2     C(89), C(90), C(91), C(92), C(93), C(94), C(95), C(96)/
     3    -4.95889784275030309E+08,     1.42062907797533095E+08,
     4    -2.44740627257387285E+07,     2.24376817792244943E+06,
     5    -8.40054336030240853E+04,     5.51335896122020586E+02,
     6     8.14789096118312115E+08,    -5.86648149205184723E+09,
     7     1.86882075092958249E+10,    -3.46320433881587779E+10,
     8     4.12801855797539740E+10,    -3.30265997498007231E+10,
     9     1.79542137311556001E+10,    -6.56329379261928433E+09,
     A     1.55927986487925751E+09,    -2.25105661889415278E+08,
     B     1.73951075539781645E+07,    -5.49842327572288687E+05,
     C     3.03809051092238427E+03,    -1.46792612476956167E+10,
     D     1.14498237732025810E+11,    -3.99096175224466498E+11,
     E     8.19218669548577329E+11,    -1.09837515608122331E+12/
      DATA C(97), C(98), C(99), C(100), C(101), C(102), C(103), C(104),
     1     C(105)/
     2     1.00815810686538209E+12,    -6.45364869245376503E+11,
     3     2.87900649906150589E+11,    -8.78670721780232657E+10,
     4     1.76347306068349694E+10,    -2.16716498322379509E+09,
     5     1.43157876718888981E+08,    -3.87183344257261262E+06,
     6     1.82577554742931747E+04/
      DATA ALFA(1), ALFA(2), ALFA(3), ALFA(4), ALFA(5), ALFA(6),
     1     ALFA(7), ALFA(8), ALFA(9), ALFA(10), ALFA(11), ALFA(12),
     2     ALFA(13), ALFA(14), ALFA(15), ALFA(16), ALFA(17), ALFA(18),
     3     ALFA(19), ALFA(20), ALFA(21), ALFA(22)/
     4    -4.44444444444444444E-03,    -9.22077922077922078E-04,
     5    -8.84892884892884893E-05,     1.65927687832449737E-04,
     6     2.46691372741792910E-04,     2.65995589346254780E-04,
     7     2.61824297061500945E-04,     2.48730437344655609E-04,
     8     2.32721040083232098E-04,     2.16362485712365082E-04,
     9     2.00738858762752355E-04,     1.86267636637545172E-04,
     A     1.73060775917876493E-04,     1.61091705929015752E-04,
     B     1.50274774160908134E-04,     1.40503497391269794E-04,
     C     1.31668816545922806E-04,     1.23667445598253261E-04,
     D     1.16405271474737902E-04,     1.09798298372713369E-04,
     E     1.03772410422992823E-04,     9.82626078369363448E-05/
      DATA ALFA(23), ALFA(24), ALFA(25), ALFA(26), ALFA(27), ALFA(28),
     1     ALFA(29), ALFA(30), ALFA(31), ALFA(32), ALFA(33), ALFA(34),
     2     ALFA(35), ALFA(36), ALFA(37), ALFA(38), ALFA(39), ALFA(40),
     3     ALFA(41), ALFA(42), ALFA(43), ALFA(44)/
     4     9.32120517249503256E-05,     8.85710852478711718E-05,
     5     8.42963105715700223E-05,     8.03497548407791151E-05,
     6     7.66981345359207388E-05,     7.33122157481777809E-05,
     7     7.01662625163141333E-05,     6.72375633790160292E-05,
     8     6.93735541354588974E-04,     2.32241745182921654E-04,
     9    -1.41986273556691197E-05,    -1.16444931672048640E-04,
     A    -1.50803558053048762E-04,    -1.55121924918096223E-04,
     B    -1.46809756646465549E-04,    -1.33815503867491367E-04,
     C    -1.19744975684254051E-04,    -1.06184319207974020E-04,
     D    -9.37699549891194492E-05,    -8.26923045588193274E-05,
     E    -7.29374348155221211E-05,    -6.44042357721016283E-05/
      DATA ALFA(45), ALFA(46), ALFA(47), ALFA(48), ALFA(49), ALFA(50),
     1     ALFA(51), ALFA(52), ALFA(53), ALFA(54), ALFA(55), ALFA(56),
     2     ALFA(57), ALFA(58), ALFA(59), ALFA(60), ALFA(61), ALFA(62),
     3     ALFA(63), ALFA(64), ALFA(65), ALFA(66)/
     4    -5.69611566009369048E-05,    -5.04731044303561628E-05,
     5    -4.48134868008882786E-05,    -3.98688727717598864E-05,
     6    -3.55400532972042498E-05,    -3.17414256609022480E-05,
     7    -2.83996793904174811E-05,    -2.54522720634870566E-05,
     8    -2.28459297164724555E-05,    -2.05352753106480604E-05,
     9    -1.84816217627666085E-05,    -1.66519330021393806E-05,
     A    -1.50179412980119482E-05,    -1.35554031379040526E-05,
     B    -1.22434746473858131E-05,    -1.10641884811308169E-05,
     C    -3.54211971457743841E-04,    -1.56161263945159416E-04,
     D     3.04465503594936410E-05,     1.30198655773242693E-04,
     E     1.67471106699712269E-04,     1.70222587683592569E-04/
      DATA ALFA(67), ALFA(68), ALFA(69), ALFA(70), ALFA(71), ALFA(72),
     1     ALFA(73), ALFA(74), ALFA(75), ALFA(76), ALFA(77), ALFA(78),
     2     ALFA(79), ALFA(80), ALFA(81), ALFA(82), ALFA(83), ALFA(84),
     3     ALFA(85), ALFA(86), ALFA(87), ALFA(88)/
     4     1.56501427608594704E-04,     1.36339170977445120E-04,
     5     1.14886692029825128E-04,     9.45869093034688111E-05,
     6     7.64498419250898258E-05,     6.07570334965197354E-05,
     7     4.74394299290508799E-05,     3.62757512005344297E-05,
     8     2.69939714979224901E-05,     1.93210938247939253E-05,
     9     1.30056674793963203E-05,     7.82620866744496661E-06,
     A     3.59257485819351583E-06,     1.44040049814251817E-07,
     B    -2.65396769697939116E-06,    -4.91346867098485910E-06,
     C    -6.72739296091248287E-06,    -8.17269379678657923E-06,
     D    -9.31304715093561232E-06,    -1.02011418798016441E-05,
     E    -1.08805962510592880E-05,    -1.13875481509603555E-05/
      DATA ALFA(89), ALFA(90), ALFA(91), ALFA(92), ALFA(93), ALFA(94),
     1     ALFA(95), ALFA(96), ALFA(97), ALFA(98), ALFA(99), ALFA(100),
     2     ALFA(101), ALFA(102), ALFA(103), ALFA(104), ALFA(105),
     3     ALFA(106), ALFA(107), ALFA(108), ALFA(109), ALFA(110)/
     4    -1.17519675674556414E-05,    -1.19987364870944141E-05,
     5     3.78194199201772914E-04,     2.02471952761816167E-04,
     6    -6.37938506318862408E-05,    -2.38598230603005903E-04,
     7    -3.10916256027361568E-04,    -3.13680115247576316E-04,
     8    -2.78950273791323387E-04,    -2.28564082619141374E-04,
     9    -1.75245280340846749E-04,    -1.25544063060690348E-04,
     A    -8.22982872820208365E-05,    -4.62860730588116458E-05,
     B    -1.72334302366962267E-05,     5.60690482304602267E-06,
     C     2.31395443148286800E-05,     3.62642745856793957E-05,
     D     4.58006124490188752E-05,     5.24595294959114050E-05,
     E     5.68396208545815266E-05,     5.94349820393104052E-05/
      DATA ALFA(111), ALFA(112), ALFA(113), ALFA(114), ALFA(115),
     1     ALFA(116), ALFA(117), ALFA(118), ALFA(119), ALFA(120),
     2     ALFA(121), ALFA(122), ALFA(123), ALFA(124), ALFA(125),
     3     ALFA(126), ALFA(127), ALFA(128), ALFA(129), ALFA(130)/
     4     6.06478527578421742E-05,     6.08023907788436497E-05,
     5     6.01577894539460388E-05,     5.89199657344698500E-05,
     6     5.72515823777593053E-05,     5.52804375585852577E-05,
     7     5.31063773802880170E-05,     5.08069302012325706E-05,
     8     4.84418647620094842E-05,     4.60568581607475370E-05,
     9    -6.91141397288294174E-04,    -4.29976633058871912E-04,
     A     1.83067735980039018E-04,     6.60088147542014144E-04,
     B     8.75964969951185931E-04,     8.77335235958235514E-04,
     C     7.49369585378990637E-04,     5.63832329756980918E-04,
     D     3.68059319971443156E-04,     1.88464535514455599E-04/
      DATA ALFA(131), ALFA(132), ALFA(133), ALFA(134), ALFA(135),
     1     ALFA(136), ALFA(137), ALFA(138), ALFA(139), ALFA(140),
     2     ALFA(141), ALFA(142), ALFA(143), ALFA(144), ALFA(145),
     3     ALFA(146), ALFA(147), ALFA(148), ALFA(149), ALFA(150)/
     4     3.70663057664904149E-05,    -8.28520220232137023E-05,
     5    -1.72751952869172998E-04,    -2.36314873605872983E-04,
     6    -2.77966150694906658E-04,    -3.02079514155456919E-04,
     7    -3.12594712643820127E-04,    -3.12872558758067163E-04,
     8    -3.05678038466324377E-04,    -2.93226470614557331E-04,
     9    -2.77255655582934777E-04,    -2.59103928467031709E-04,
     A    -2.39784014396480342E-04,    -2.20048260045422848E-04,
     B    -2.00443911094971498E-04,    -1.81358692210970687E-04,
     C    -1.63057674478657464E-04,    -1.45712672175205844E-04,
     D    -1.29425421983924587E-04,    -1.14245691942445952E-04/
      DATA ALFA(151), ALFA(152), ALFA(153), ALFA(154), ALFA(155),
     1     ALFA(156), ALFA(157), ALFA(158), ALFA(159), ALFA(160),
     2     ALFA(161), ALFA(162), ALFA(163), ALFA(164), ALFA(165),
     3     ALFA(166), ALFA(167), ALFA(168), ALFA(169), ALFA(170)/
     4     1.92821964248775885E-03,     1.35592576302022234E-03,
     5    -7.17858090421302995E-04,    -2.58084802575270346E-03,
     6    -3.49271130826168475E-03,    -3.46986299340960628E-03,
     7    -2.82285233351310182E-03,    -1.88103076404891354E-03,
     8    -8.89531718383947600E-04,     3.87912102631035228E-06,
     9     7.28688540119691412E-04,     1.26566373053457758E-03,
     A     1.62518158372674427E-03,     1.83203153216373172E-03,
     B     1.91588388990527909E-03,     1.90588846755546138E-03,
     C     1.82798982421825727E-03,     1.70389506421121530E-03,
     D     1.55097127171097686E-03,     1.38261421852276159E-03/
      DATA ALFA(171), ALFA(172), ALFA(173), ALFA(174), ALFA(175),
     1     ALFA(176), ALFA(177), ALFA(178), ALFA(179), ALFA(180)/
     2     1.20881424230064774E-03,     1.03676532638344962E-03,
     3     8.71437918068619115E-04,     7.16080155297701002E-04,
     4     5.72637002558129372E-04,     4.42089819465802277E-04,
     5     3.24724948503090564E-04,     2.20342042730246599E-04,
     6     1.28412898401353882E-04,     4.82005924552095464E-05/
      DATA BETA(1), BETA(2), BETA(3), BETA(4), BETA(5), BETA(6),
     1     BETA(7), BETA(8), BETA(9), BETA(10), BETA(11), BETA(12),
     2     BETA(13), BETA(14), BETA(15), BETA(16), BETA(17), BETA(18),
     3     BETA(19), BETA(20), BETA(21), BETA(22)/
     4     1.79988721413553309E-02,     5.59964911064388073E-03,
     5     2.88501402231132779E-03,     1.80096606761053941E-03,
     6     1.24753110589199202E-03,     9.22878876572938311E-04,
     7     7.14430421727287357E-04,     5.71787281789704872E-04,
     8     4.69431007606481533E-04,     3.93232835462916638E-04,
     9     3.34818889318297664E-04,     2.88952148495751517E-04,
     A     2.52211615549573284E-04,     2.22280580798883327E-04,
     B     1.97541838033062524E-04,     1.76836855019718004E-04,
     C     1.59316899661821081E-04,     1.44347930197333986E-04,
     D     1.31448068119965379E-04,     1.20245444949302884E-04,
     E     1.10449144504599392E-04,     1.01828770740567258E-04/
      DATA BETA(23), BETA(24), BETA(25), BETA(26), BETA(27), BETA(28),
     1     BETA(29), BETA(30), BETA(31), BETA(32), BETA(33), BETA(34),
     2     BETA(35), BETA(36), BETA(37), BETA(38), BETA(39), BETA(40),
     3     BETA(41), BETA(42), BETA(43), BETA(44)/
     4     9.41998224204237509E-05,     8.74130545753834437E-05,
     5     8.13466262162801467E-05,     7.59002269646219339E-05,
     6     7.09906300634153481E-05,     6.65482874842468183E-05,
     7     6.25146958969275078E-05,     5.88403394426251749E-05,
     8    -1.49282953213429172E-03,    -8.78204709546389328E-04,
     9    -5.02916549572034614E-04,    -2.94822138512746025E-04,
     A    -1.75463996970782828E-04,    -1.04008550460816434E-04,
     B    -5.96141953046457895E-05,    -3.12038929076098340E-05,
     C    -1.26089735980230047E-05,    -2.42892608575730389E-07,
     D     8.05996165414273571E-06,     1.36507009262147391E-05,
     E     1.73964125472926261E-05,     1.98672978842133780E-05/
      DATA BETA(45), BETA(46), BETA(47), BETA(48), BETA(49), BETA(50),
     1     BETA(51), BETA(52), BETA(53), BETA(54), BETA(55), BETA(56),
     2     BETA(57), BETA(58), BETA(59), BETA(60), BETA(61), BETA(62),
     3     BETA(63), BETA(64), BETA(65), BETA(66)/
     4     2.14463263790822639E-05,     2.23954659232456514E-05,
     5     2.28967783814712629E-05,     2.30785389811177817E-05,
     6     2.30321976080909144E-05,     2.28236073720348722E-05,
     7     2.25005881105292418E-05,     2.20981015361991429E-05,
     8     2.16418427448103905E-05,     2.11507649256220843E-05,
     9     2.06388749782170737E-05,     2.01165241997081666E-05,
     A     1.95913450141179244E-05,     1.90689367910436740E-05,
     B     1.85533719641636667E-05,     1.80475722259674218E-05,
     C     5.52213076721292790E-04,     4.47932581552384646E-04,
     D     2.79520653992020589E-04,     1.52468156198446602E-04,
     E     6.93271105657043598E-05,     1.76258683069991397E-05/
      DATA BETA(67), BETA(68), BETA(69), BETA(70), BETA(71), BETA(72),
     1     BETA(73), BETA(74), BETA(75), BETA(76), BETA(77), BETA(78),
     2     BETA(79), BETA(80), BETA(81), BETA(82), BETA(83), BETA(84),
     3     BETA(85), BETA(86), BETA(87), BETA(88)/
     4    -1.35744996343269136E-05,    -3.17972413350427135E-05,
     5    -4.18861861696693365E-05,    -4.69004889379141029E-05,
     6    -4.87665447413787352E-05,    -4.87010031186735069E-05,
     7    -4.74755620890086638E-05,    -4.55813058138628452E-05,
     8    -4.33309644511266036E-05,    -4.09230193157750364E-05,
     9    -3.84822638603221274E-05,    -3.60857167535410501E-05,
     A    -3.37793306123367417E-05,    -3.15888560772109621E-05,
     B    -2.95269561750807315E-05,    -2.75978914828335759E-05,
     C    -2.58006174666883713E-05,    -2.41308356761280200E-05,
     D    -2.25823509518346033E-05,    -2.11479656768912971E-05,
     E    -1.98200638885294927E-05,    -1.85909870801065077E-05/
      DATA BETA(89), BETA(90), BETA(91), BETA(92), BETA(93), BETA(94),
     1     BETA(95), BETA(96), BETA(97), BETA(98), BETA(99), BETA(100),
     2     BETA(101), BETA(102), BETA(103), BETA(104), BETA(105),
     3     BETA(106), BETA(107), BETA(108), BETA(109), BETA(110)/
     4    -1.74532699844210224E-05,    -1.63997823854497997E-05,
     5    -4.74617796559959808E-04,    -4.77864567147321487E-04,
     6    -3.20390228067037603E-04,    -1.61105016119962282E-04,
     7    -4.25778101285435204E-05,     3.44571294294967503E-05,
     8     7.97092684075674924E-05,     1.03138236708272200E-04,
     9     1.12466775262204158E-04,     1.13103642108481389E-04,
     A     1.08651634848774268E-04,     1.01437951597661973E-04,
     B     9.29298396593363896E-05,     8.40293133016089978E-05,
     C     7.52727991349134062E-05,     6.69632521975730872E-05,
     D     5.92564547323194704E-05,     5.22169308826975567E-05,
     E     4.58539485165360646E-05,     4.01445513891486808E-05/
      DATA BETA(111), BETA(112), BETA(113), BETA(114), BETA(115),
     1     BETA(116), BETA(117), BETA(118), BETA(119), BETA(120),
     2     BETA(121), BETA(122), BETA(123), BETA(124), BETA(125),
     3     BETA(126), BETA(127), BETA(128), BETA(129), BETA(130)/
     4     3.50481730031328081E-05,     3.05157995034346659E-05,
     5     2.64956119950516039E-05,     2.29363633690998152E-05,
     6     1.97893056664021636E-05,     1.70091984636412623E-05,
     7     1.45547428261524004E-05,     1.23886640995878413E-05,
     8     1.04775876076583236E-05,     8.79179954978479373E-06,
     9     7.36465810572578444E-04,     8.72790805146193976E-04,
     A     6.22614862573135066E-04,     2.85998154194304147E-04,
     B     3.84737672879366102E-06,    -1.87906003636971558E-04,
     C    -2.97603646594554535E-04,    -3.45998126832656348E-04,
     D    -3.53382470916037712E-04,    -3.35715635775048757E-04/
      DATA BETA(131), BETA(132), BETA(133), BETA(134), BETA(135),
     1     BETA(136), BETA(137), BETA(138), BETA(139), BETA(140),
     2     BETA(141), BETA(142), BETA(143), BETA(144), BETA(145),
     3     BETA(146), BETA(147), BETA(148), BETA(149), BETA(150)/
     4    -3.04321124789039809E-04,    -2.66722723047612821E-04,
     5    -2.27654214122819527E-04,    -1.89922611854562356E-04,
     6    -1.55058918599093870E-04,    -1.23778240761873630E-04,
     7    -9.62926147717644187E-05,    -7.25178327714425337E-05,
     8    -5.22070028895633801E-05,    -3.50347750511900522E-05,
     9    -2.06489761035551757E-05,    -8.70106096849767054E-06,
     A     1.13698686675100290E-06,     9.16426474122778849E-06,
     B     1.56477785428872620E-05,     2.08223629482466847E-05,
     C     2.48923381004595156E-05,     2.80340509574146325E-05,
     D     3.03987774629861915E-05,     3.21156731406700616E-05/
      DATA BETA(151), BETA(152), BETA(153), BETA(154), BETA(155),
     1     BETA(156), BETA(157), BETA(158), BETA(159), BETA(160),
     2     BETA(161), BETA(162), BETA(163), BETA(164), BETA(165),
     3     BETA(166), BETA(167), BETA(168), BETA(169), BETA(170)/
     4    -1.80182191963885708E-03,    -2.43402962938042533E-03,
     5    -1.83422663549856802E-03,    -7.62204596354009765E-04,
     6     2.39079475256927218E-04,     9.49266117176881141E-04,
     7     1.34467449701540359E-03,     1.48457495259449178E-03,
     8     1.44732339830617591E-03,     1.30268261285657186E-03,
     9     1.10351597375642682E-03,     8.86047440419791759E-04,
     A     6.73073208165665473E-04,     4.77603872856582378E-04,
     B     3.05991926358789362E-04,     1.60315694594721630E-04,
     C     4.00749555270613286E-05,    -5.66607461635251611E-05,
     D    -1.32506186772982638E-04,    -1.90296187989614057E-04/
      DATA BETA(171), BETA(172), BETA(173), BETA(174), BETA(175),
     1     BETA(176), BETA(177), BETA(178), BETA(179), BETA(180),
     2     BETA(181), BETA(182), BETA(183), BETA(184), BETA(185),
     3     BETA(186), BETA(187), BETA(188), BETA(189), BETA(190)/
     4    -2.32811450376937408E-04,    -2.62628811464668841E-04,
     5    -2.82050469867598672E-04,    -2.93081563192861167E-04,
     6    -2.97435962176316616E-04,    -2.96557334239348078E-04,
     7    -2.91647363312090861E-04,    -2.83696203837734166E-04,
     8    -2.73512317095673346E-04,    -2.61750155806768580E-04,
     9     6.38585891212050914E-03,     9.62374215806377941E-03,
     A     7.61878061207001043E-03,     2.83219055545628054E-03,
     B    -2.09841352012720090E-03,    -5.73826764216626498E-03,
     C    -7.70804244495414620E-03,    -8.21011692264844401E-03,
     D    -7.65824520346905413E-03,    -6.47209729391045177E-03/
      DATA BETA(191), BETA(192), BETA(193), BETA(194), BETA(195),
     1     BETA(196), BETA(197), BETA(198), BETA(199), BETA(200),
     2     BETA(201), BETA(202), BETA(203), BETA(204), BETA(205),
     3     BETA(206), BETA(207), BETA(208), BETA(209), BETA(210)/
     4    -4.99132412004966473E-03,    -3.45612289713133280E-03,
     5    -2.01785580014170775E-03,    -7.59430686781961401E-04,
     6     2.84173631523859138E-04,     1.10891667586337403E-03,
     7     1.72901493872728771E-03,     2.16812590802684701E-03,
     8     2.45357710494539735E-03,     2.61281821058334862E-03,
     9     2.67141039656276912E-03,     2.65203073395980430E-03,
     A     2.57411652877287315E-03,     2.45389126236094427E-03,
     B     2.30460058071795494E-03,     2.13684837686712662E-03,
     C     1.95896528478870911E-03,     1.77737008679454412E-03,
     D     1.59690280765839059E-03,     1.42111975664438546E-03/
      DATA GAMA(1), GAMA(2), GAMA(3), GAMA(4), GAMA(5), GAMA(6),
     1     GAMA(7), GAMA(8), GAMA(9), GAMA(10), GAMA(11), GAMA(12),
     2     GAMA(13), GAMA(14), GAMA(15), GAMA(16), GAMA(17), GAMA(18),
     3     GAMA(19), GAMA(20), GAMA(21), GAMA(22)/
     4     6.29960524947436582E-01,     2.51984209978974633E-01,
     5     1.54790300415655846E-01,     1.10713062416159013E-01,
     6     8.57309395527394825E-02,     6.97161316958684292E-02,
     7     5.86085671893713576E-02,     5.04698873536310685E-02,
     8     4.42600580689154809E-02,     3.93720661543509966E-02,
     9     3.54283195924455368E-02,     3.21818857502098231E-02,
     A     2.94646240791157679E-02,     2.71581677112934479E-02,
     B     2.51768272973861779E-02,     2.34570755306078891E-02,
     C     2.19508390134907203E-02,     2.06210828235646240E-02,
     D     1.94388240897880846E-02,     1.83810633800683158E-02,
     E     1.74293213231963172E-02,     1.65685837786612353E-02/
      DATA GAMA(23), GAMA(24), GAMA(25), GAMA(26), GAMA(27), GAMA(28),
     1     GAMA(29), GAMA(30)/
     2     1.57865285987918445E-02,     1.50729501494095594E-02,
     3     1.44193250839954639E-02,     1.38184805735341786E-02,
     4     1.32643378994276568E-02,     1.27517121970498651E-02,
     5     1.22761545318762767E-02,     1.18338262398482403E-02/
      DATA EX1, EX2, HPI, PI, THPI /
     1     3.33333333333333333E-01,     6.66666666666666667E-01,
     2     1.57079632679489662E+00,     3.14159265358979324E+00,
     3     4.71238898038468986E+00/
      DATA CZERO, CONE / (0.0E0,0.0E0), (1.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CUNHJ
      RFNU = 1.0E0/FNU
C     ZB = Z*CMPLX(RFNU,0.0E0)
C-----------------------------------------------------------------------
C     OVERFLOW TEST (Z/FNU TOO SMALL)
C-----------------------------------------------------------------------
      TSTR = REAL(Z)
      TSTI = AIMAG(Z)
      TEST = R1MACH(1)*1.0E+3
      AC = FNU*TEST
      IF (ABS(TSTR).GT.AC .OR. ABS(TSTI).GT.AC) GO TO 15
      AC = 2.0E0*ABS(ALOG(TEST))+FNU
      ZETA1 = CMPLX(AC,0.0E0)
      ZETA2 = CMPLX(FNU,0.0E0)
      PHI=CONE
      ARG=CONE
      RETURN
   15 CONTINUE
      ZB = Z*CMPLX(RFNU,0.0E0)
      RFNU2 = RFNU*RFNU
C-----------------------------------------------------------------------
C     COMPUTE IN THE FOURTH QUADRANT
C-----------------------------------------------------------------------
      FN13 = FNU**EX1
      FN23 = FN13*FN13
      RFN13 = CMPLX(1.0E0/FN13,0.0E0)
      W2 = CONE - ZB*ZB
      AW2 = ABS(W2)
      IF (AW2.GT.0.25E0) GO TO 130
C-----------------------------------------------------------------------
C     POWER SERIES FOR ABS(W2).LE.0.25E0
C-----------------------------------------------------------------------
      K = 1
      P(1) = CONE
      SUMA = CMPLX(GAMA(1),0.0E0)
      AP(1) = 1.0E0
      IF (AW2.LT.TOL) GO TO 20
      DO 10 K=2,30
        P(K) = P(K-1)*W2
        SUMA = SUMA + P(K)*CMPLX(GAMA(K),0.0E0)
        AP(K) = AP(K-1)*AW2
        IF (AP(K).LT.TOL) GO TO 20
   10 CONTINUE
      K = 30
   20 CONTINUE
      KMAX = K
      ZETA = W2*SUMA
      ARG = ZETA*CMPLX(FN23,0.0E0)
      ZA = CSQRT(SUMA)
      ZETA2 = CSQRT(W2)*CMPLX(FNU,0.0E0)
      ZETA1 = ZETA2*(CONE+ZETA*ZA*CMPLX(EX2,0.0E0))
      ZA = ZA + ZA
      PHI = CSQRT(ZA)*RFN13
      IF (IPMTR.EQ.1) GO TO 120
C-----------------------------------------------------------------------
C     SUM SERIES FOR ASUM AND BSUM
C-----------------------------------------------------------------------
      SUMB = CZERO
      DO 30 K=1,KMAX
        SUMB = SUMB + P(K)*CMPLX(BETA(K),0.0E0)
   30 CONTINUE
      ASUM = CZERO
      BSUM = SUMB
      L1 = 0
      L2 = 30
      BTOL = TOL*ABS(BSUM)
      ATOL = TOL
      PP = 1.0E0
      IAS = 0
      IBS = 0
      IF (RFNU2.LT.TOL) GO TO 110
      DO 100 IS=2,7
        ATOL = ATOL/RFNU2
        PP = PP*RFNU2
        IF (IAS.EQ.1) GO TO 60
        SUMA = CZERO
        DO 40 K=1,KMAX
          M = L1 + K
          SUMA = SUMA + P(K)*CMPLX(ALFA(M),0.0E0)
          IF (AP(K).LT.ATOL) GO TO 50
   40   CONTINUE
   50   CONTINUE
        ASUM = ASUM + SUMA*CMPLX(PP,0.0E0)
        IF (PP.LT.TOL) IAS = 1
   60   CONTINUE
        IF (IBS.EQ.1) GO TO 90
        SUMB = CZERO
        DO 70 K=1,KMAX
          M = L2 + K
          SUMB = SUMB + P(K)*CMPLX(BETA(M),0.0E0)
          IF (AP(K).LT.ATOL) GO TO 80
   70   CONTINUE
   80   CONTINUE
        BSUM = BSUM + SUMB*CMPLX(PP,0.0E0)
        IF (PP.LT.BTOL) IBS = 1
   90   CONTINUE
        IF (IAS.EQ.1 .AND. IBS.EQ.1) GO TO 110
        L1 = L1 + 30
        L2 = L2 + 30
  100 CONTINUE
  110 CONTINUE
      ASUM = ASUM + CONE
      PP = RFNU*REAL(RFN13)
      BSUM = BSUM*CMPLX(PP,0.0E0)
  120 CONTINUE
      RETURN
C-----------------------------------------------------------------------
C     ABS(W2).GT.0.25E0
C-----------------------------------------------------------------------
  130 CONTINUE
      W = CSQRT(W2)
      WR = REAL(W)
      WI = AIMAG(W)
      IF (WR.LT.0.0E0) WR = 0.0E0
      IF (WI.LT.0.0E0) WI = 0.0E0
      W = CMPLX(WR,WI)
      ZA = (CONE+W)/ZB
      ZC = CLOG(ZA)
      ZCR = REAL(ZC)
      ZCI = AIMAG(ZC)
      IF (ZCI.LT.0.0E0) ZCI = 0.0E0
      IF (ZCI.GT.HPI) ZCI = HPI
      IF (ZCR.LT.0.0E0) ZCR = 0.0E0
      ZC = CMPLX(ZCR,ZCI)
      ZTH = (ZC-W)*CMPLX(1.5E0,0.0E0)
      CFNU = CMPLX(FNU,0.0E0)
      ZETA1 = ZC*CFNU
      ZETA2 = W*CFNU
      AZTH = ABS(ZTH)
      ZTHR = REAL(ZTH)
      ZTHI = AIMAG(ZTH)
      ANG = THPI
      IF (ZTHR.GE.0.0E0 .AND. ZTHI.LT.0.0E0) GO TO 140
      ANG = HPI
      IF (ZTHR.EQ.0.0E0) GO TO 140
      ANG = ATAN(ZTHI/ZTHR)
      IF (ZTHR.LT.0.0E0) ANG = ANG + PI
  140 CONTINUE
      PP = AZTH**EX2
      ANG = ANG*EX2
      ZETAR = PP*COS(ANG)
      ZETAI = PP*SIN(ANG)
      IF (ZETAI.LT.0.0E0) ZETAI = 0.0E0
      ZETA = CMPLX(ZETAR,ZETAI)
      ARG = ZETA*CMPLX(FN23,0.0E0)
      RTZTA = ZTH/ZETA
      ZA = RTZTA/W
      PHI = CSQRT(ZA+ZA)*RFN13
      IF (IPMTR.EQ.1) GO TO 120
      TFN = CMPLX(RFNU,0.0E0)/W
      RZTH = CMPLX(RFNU,0.0E0)/ZTH
      ZC = RZTH*CMPLX(AR(2),0.0E0)
      T2 = CONE/W2
      UP(2) = (T2*CMPLX(C(2),0.0E0)+CMPLX(C(3),0.0E0))*TFN
      BSUM = UP(2) + ZC
      ASUM = CZERO
      IF (RFNU.LT.TOL) GO TO 220
      PRZTH = RZTH
      PTFN = TFN
      UP(1) = CONE
      PP = 1.0E0
      BSUMR = REAL(BSUM)
      BSUMI = AIMAG(BSUM)
      BTOL = TOL*(ABS(BSUMR)+ABS(BSUMI))
      KS = 0
      KP1 = 2
      L = 3
      IAS = 0
      IBS = 0
      DO 210 LR=2,12,2
        LRP1 = LR + 1
C-----------------------------------------------------------------------
C     COMPUTE TWO ADDITIONAL CR, DR, AND UP FOR TWO MORE TERMS IN
C     NEXT SUMA AND SUMB
C-----------------------------------------------------------------------
        DO 160 K=LR,LRP1
          KS = KS + 1
          KP1 = KP1 + 1
          L = L + 1
          ZA = CMPLX(C(L),0.0E0)
          DO 150 J=2,KP1
            L = L + 1
            ZA = ZA*T2 + CMPLX(C(L),0.0E0)
  150     CONTINUE
          PTFN = PTFN*TFN
          UP(KP1) = PTFN*ZA
          CR(KS) = PRZTH*CMPLX(BR(KS+1),0.0E0)
          PRZTH = PRZTH*RZTH
          DR(KS) = PRZTH*CMPLX(AR(KS+2),0.0E0)
  160   CONTINUE
        PP = PP*RFNU2
        IF (IAS.EQ.1) GO TO 180
        SUMA = UP(LRP1)
        JU = LRP1
        DO 170 JR=1,LR
          JU = JU - 1
          SUMA = SUMA + CR(JR)*UP(JU)
  170   CONTINUE
        ASUM = ASUM + SUMA
        ASUMR = REAL(ASUM)
        ASUMI = AIMAG(ASUM)
        TEST = ABS(ASUMR) + ABS(ASUMI)
        IF (PP.LT.TOL .AND. TEST.LT.TOL) IAS = 1
  180   CONTINUE
        IF (IBS.EQ.1) GO TO 200
        SUMB = UP(LR+2) + UP(LRP1)*ZC
        JU = LRP1
        DO 190 JR=1,LR
          JU = JU - 1
          SUMB = SUMB + DR(JR)*UP(JU)
  190   CONTINUE
        BSUM = BSUM + SUMB
        BSUMR = REAL(BSUM)
        BSUMI = AIMAG(BSUM)
        TEST = ABS(BSUMR) + ABS(BSUMI)
        IF (PP.LT.BTOL .AND. TEST.LT.TOL) IBS = 1
  200   CONTINUE
        IF (IAS.EQ.1 .AND. IBS.EQ.1) GO TO 220
  210 CONTINUE
  220 CONTINUE
      ASUM = ASUM + CONE
      BSUM = -BSUM*RFN13/RTZTA
      GO TO 120
      END
*DECK CUNI1
      SUBROUTINE CUNI1 (Z, FNU, KODE, N, Y, NZ, NLAST, FNUL, TOL, ELIM,
     +   ALIM)
C***BEGIN PROLOGUE  CUNI1
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CUNI1-A, ZUNI1-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CUNI1 COMPUTES I(FNU,Z)  BY MEANS OF THE UNIFORM ASYMPTOTIC
C     EXPANSION FOR I(FNU,Z) IN -PI/3.LE.ARG Z.LE.PI/3.
C
C     FNUL IS THE SMALLEST ORDER PERMITTED FOR THE ASYMPTOTIC
C     EXPANSION. NLAST=0 MEANS ALL OF THE Y VALUES WERE SET.
C     NLAST.NE.0 IS THE NUMBER LEFT TO BE COMPUTED BY ANOTHER
C     FORMULA FOR ORDERS FNU TO FNU+NLAST-1 BECAUSE FNU+NLAST-1.LT.FNUL.
C     Y(I)=CZERO FOR I=NLAST+1,N
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  CUCHK, CUNIK, CUOIK, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CUNI1
      COMPLEX CFN, CONE, CRSC, CSCL, CSR, CSS, CWRK, CZERO, C1, C2,
     * PHI, RZ, SUM, S1, S2, Y, Z, ZETA1, ZETA2, CY
      REAL ALIM, APHI, ASCLE, BRY, C2I, C2M, C2R, ELIM, FN, FNU, FNUL,
     * RS1, TOL, YY, R1MACH
      INTEGER I, IFLAG, INIT, K, KODE, M, N, ND, NLAST, NN, NUF, NW, NZ
      DIMENSION BRY(3), Y(N), CWRK(16), CSS(3), CSR(3), CY(2)
      DATA CZERO, CONE / (0.0E0,0.0E0), (1.0E0,0.0E0) /
C***FIRST EXECUTABLE STATEMENT  CUNI1
      NZ = 0
      ND = N
      NLAST = 0
C-----------------------------------------------------------------------
C     COMPUTED VALUES WITH EXPONENTS BETWEEN ALIM AND ELIM IN MAG-
C     NITUDE ARE SCALED TO KEEP INTERMEDIATE ARITHMETIC ON SCALE,
C     EXP(ALIM)=EXP(ELIM)*TOL
C-----------------------------------------------------------------------
      CSCL = CMPLX(1.0E0/TOL,0.0E0)
      CRSC = CMPLX(TOL,0.0E0)
      CSS(1) = CSCL
      CSS(2) = CONE
      CSS(3) = CRSC
      CSR(1) = CRSC
      CSR(2) = CONE
      CSR(3) = CSCL
      BRY(1) = 1.0E+3*R1MACH(1)/TOL
C-----------------------------------------------------------------------
C     CHECK FOR UNDERFLOW AND OVERFLOW ON FIRST MEMBER
C-----------------------------------------------------------------------
      FN = MAX(FNU,1.0E0)
      INIT = 0
      CALL CUNIK(Z, FN, 1, 1, TOL, INIT, PHI, ZETA1, ZETA2, SUM, CWRK)
      IF (KODE.EQ.1) GO TO 10
      CFN = CMPLX(FN,0.0E0)
      S1 = -ZETA1 + CFN*(CFN/(Z+ZETA2))
      GO TO 20
   10 CONTINUE
      S1 = -ZETA1 + ZETA2
   20 CONTINUE
      RS1 = REAL(S1)
      IF (ABS(RS1).GT.ELIM) GO TO 130
   30 CONTINUE
      NN = MIN(2,ND)
      DO 80 I=1,NN
        FN = FNU + (ND-I)
        INIT = 0
        CALL CUNIK(Z, FN, 1, 0, TOL, INIT, PHI, ZETA1, ZETA2, SUM, CWRK)
        IF (KODE.EQ.1) GO TO 40
        CFN = CMPLX(FN,0.0E0)
        YY = AIMAG(Z)
        S1 = -ZETA1 + CFN*(CFN/(Z+ZETA2)) + CMPLX(0.0E0,YY)
        GO TO 50
   40   CONTINUE
        S1 = -ZETA1 + ZETA2
   50   CONTINUE
C-----------------------------------------------------------------------
C     TEST FOR UNDERFLOW AND OVERFLOW
C-----------------------------------------------------------------------
        RS1 = REAL(S1)
        IF (ABS(RS1).GT.ELIM) GO TO 110
        IF (I.EQ.1) IFLAG = 2
        IF (ABS(RS1).LT.ALIM) GO TO 60
C-----------------------------------------------------------------------
C     REFINE  TEST AND SCALE
C-----------------------------------------------------------------------
        APHI = ABS(PHI)
        RS1 = RS1 + ALOG(APHI)
        IF (ABS(RS1).GT.ELIM) GO TO 110
        IF (I.EQ.1) IFLAG = 1
        IF (RS1.LT.0.0E0) GO TO 60
        IF (I.EQ.1) IFLAG = 3
   60   CONTINUE
C-----------------------------------------------------------------------
C     SCALE S1 IF ABS(S1).LT.ASCLE
C-----------------------------------------------------------------------
        S2 = PHI*SUM
        C2R = REAL(S1)
        C2I = AIMAG(S1)
        C2M = EXP(C2R)*REAL(CSS(IFLAG))
        S1 = CMPLX(C2M,0.0E0)*CMPLX(COS(C2I),SIN(C2I))
        S2 = S2*S1
        IF (IFLAG.NE.1) GO TO 70
        CALL CUCHK(S2, NW, BRY(1), TOL)
        IF (NW.NE.0) GO TO 110
   70   CONTINUE
        M = ND - I + 1
        CY(I) = S2
        Y(M) = S2*CSR(IFLAG)
   80 CONTINUE
      IF (ND.LE.2) GO TO 100
      RZ = CMPLX(2.0E0,0.0E0)/Z
      BRY(2) = 1.0E0/BRY(1)
      BRY(3) = R1MACH(2)
      S1 = CY(1)
      S2 = CY(2)
      C1 = CSR(IFLAG)
      ASCLE = BRY(IFLAG)
      K = ND - 2
      FN = K
      DO 90 I=3,ND
        C2 = S2
        S2 = S1 + CMPLX(FNU+FN,0.0E0)*RZ*S2
        S1 = C2
        C2 = S2*C1
        Y(K) = C2
        K = K - 1
        FN = FN - 1.0E0
        IF (IFLAG.GE.3) GO TO 90
        C2R = REAL(C2)
        C2I = AIMAG(C2)
        C2R = ABS(C2R)
        C2I = ABS(C2I)
        C2M = MAX(C2R,C2I)
        IF (C2M.LE.ASCLE) GO TO 90
        IFLAG = IFLAG + 1
        ASCLE = BRY(IFLAG)
        S1 = S1*C1
        S2 = C2
        S1 = S1*CSS(IFLAG)
        S2 = S2*CSS(IFLAG)
        C1 = CSR(IFLAG)
   90 CONTINUE
  100 CONTINUE
      RETURN
C-----------------------------------------------------------------------
C     SET UNDERFLOW AND UPDATE PARAMETERS
C-----------------------------------------------------------------------
  110 CONTINUE
      IF (RS1.GT.0.0E0) GO TO 120
      Y(ND) = CZERO
      NZ = NZ + 1
      ND = ND - 1
      IF (ND.EQ.0) GO TO 100
      CALL CUOIK(Z, FNU, KODE, 1, ND, Y, NUF, TOL, ELIM, ALIM)
      IF (NUF.LT.0) GO TO 120
      ND = ND - NUF
      NZ = NZ + NUF
      IF (ND.EQ.0) GO TO 100
      FN = FNU + (ND-1)
      IF (FN.GE.FNUL) GO TO 30
      NLAST = ND
      RETURN
  120 CONTINUE
      NZ = -1
      RETURN
  130 CONTINUE
      IF (RS1.GT.0.0E0) GO TO 120
      NZ = N
      DO 140 I=1,N
        Y(I) = CZERO
  140 CONTINUE
      RETURN
      END
*DECK CUNI2
      SUBROUTINE CUNI2 (Z, FNU, KODE, N, Y, NZ, NLAST, FNUL, TOL, ELIM,
     +   ALIM)
C***BEGIN PROLOGUE  CUNI2
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CUNI2-A, ZUNI2-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CUNI2 COMPUTES I(FNU,Z) IN THE RIGHT HALF PLANE BY MEANS OF
C     UNIFORM ASYMPTOTIC EXPANSION FOR J(FNU,ZN) WHERE ZN IS Z*I
C     OR -Z*I AND ZN IS IN THE RIGHT HALF PLANE ALSO.
C
C     FNUL IS THE SMALLEST ORDER PERMITTED FOR THE ASYMPTOTIC
C     EXPANSION. NLAST=0 MEANS ALL OF THE Y VALUES WERE SET.
C     NLAST.NE.0 IS THE NUMBER LEFT TO BE COMPUTED BY ANOTHER
C     FORMULA FOR ORDERS FNU TO FNU+NLAST-1 BECAUSE FNU+NLAST-1.LT.FNUL.
C     Y(I)=CZERO FOR I=NLAST+1,N
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  CAIRY, CUCHK, CUNHJ, CUOIK, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CUNI2
      COMPLEX AI, ARG, ASUM, BSUM, CFN, CI, CID, CIP, CONE, CRSC, CSCL,
     * CSR, CSS, CY, CZERO, C1, C2, DAI, PHI, RZ, S1, S2, Y, Z, ZB,
     * ZETA1, ZETA2, ZN, ZAR
      REAL AARG, AIC, ALIM, ANG, APHI, ASCLE, AY, BRY, CAR, C2I, C2M,
     * C2R, ELIM, FN, FNU, FNUL, HPI, RS1, SAR, TOL, YY, R1MACH
      INTEGER I, IFLAG, IN, INU, J, K, KODE, N, NAI, ND, NDAI, NLAST,
     * NN, NUF, NW, NZ, IDUM
      DIMENSION BRY(3), Y(N), CIP(4), CSS(3), CSR(3), CY(2)
      DATA CZERO,CONE,CI/(0.0E0,0.0E0),(1.0E0,0.0E0),(0.0E0,1.0E0)/
      DATA CIP(1),CIP(2),CIP(3),CIP(4)/
     1 (1.0E0,0.0E0), (0.0E0,1.0E0), (-1.0E0,0.0E0), (0.0E0,-1.0E0)/
      DATA HPI, AIC  /
     1      1.57079632679489662E+00,     1.265512123484645396E+00/
C***FIRST EXECUTABLE STATEMENT  CUNI2
      NZ = 0
      ND = N
      NLAST = 0
C-----------------------------------------------------------------------
C     COMPUTED VALUES WITH EXPONENTS BETWEEN ALIM AND ELIM IN MAG-
C     NITUDE ARE SCALED TO KEEP INTERMEDIATE ARITHMETIC ON SCALE,
C     EXP(ALIM)=EXP(ELIM)*TOL
C-----------------------------------------------------------------------
      CSCL = CMPLX(1.0E0/TOL,0.0E0)
      CRSC = CMPLX(TOL,0.0E0)
      CSS(1) = CSCL
      CSS(2) = CONE
      CSS(3) = CRSC
      CSR(1) = CRSC
      CSR(2) = CONE
      CSR(3) = CSCL
      BRY(1) = 1.0E+3*R1MACH(1)/TOL
      YY = AIMAG(Z)
C-----------------------------------------------------------------------
C     ZN IS IN THE RIGHT HALF PLANE AFTER ROTATION BY CI OR -CI
C-----------------------------------------------------------------------
      ZN = -Z*CI
      ZB = Z
      CID = -CI
      INU = FNU
      ANG = HPI*(FNU-INU)
      CAR = COS(ANG)
      SAR = SIN(ANG)
      C2 = CMPLX(CAR,SAR)
      ZAR = C2
      IN = INU + N - 1
      IN = MOD(IN,4)
      C2 = C2*CIP(IN+1)
      IF (YY.GT.0.0E0) GO TO 10
      ZN = CONJG(-ZN)
      ZB = CONJG(ZB)
      CID = -CID
      C2 = CONJG(C2)
   10 CONTINUE
C-----------------------------------------------------------------------
C     CHECK FOR UNDERFLOW AND OVERFLOW ON FIRST MEMBER
C-----------------------------------------------------------------------
      FN = MAX(FNU,1.0E0)
      CALL CUNHJ(ZN, FN, 1, TOL, PHI, ARG, ZETA1, ZETA2, ASUM, BSUM)
      IF (KODE.EQ.1) GO TO 20
      CFN = CMPLX(FNU,0.0E0)
      S1 = -ZETA1 + CFN*(CFN/(ZB+ZETA2))
      GO TO 30
   20 CONTINUE
      S1 = -ZETA1 + ZETA2
   30 CONTINUE
      RS1 = REAL(S1)
      IF (ABS(RS1).GT.ELIM) GO TO 150
   40 CONTINUE
      NN = MIN(2,ND)
      DO 90 I=1,NN
        FN = FNU + (ND-I)
        CALL CUNHJ(ZN, FN, 0, TOL, PHI, ARG, ZETA1, ZETA2, ASUM, BSUM)
        IF (KODE.EQ.1) GO TO 50
        CFN = CMPLX(FN,0.0E0)
        AY = ABS(YY)
        S1 = -ZETA1 + CFN*(CFN/(ZB+ZETA2)) + CMPLX(0.0E0,AY)
        GO TO 60
   50   CONTINUE
        S1 = -ZETA1 + ZETA2
   60   CONTINUE
C-----------------------------------------------------------------------
C     TEST FOR UNDERFLOW AND OVERFLOW
C-----------------------------------------------------------------------
        RS1 = REAL(S1)
        IF (ABS(RS1).GT.ELIM) GO TO 120
        IF (I.EQ.1) IFLAG = 2
        IF (ABS(RS1).LT.ALIM) GO TO 70
C-----------------------------------------------------------------------
C     REFINE  TEST AND SCALE
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
        APHI = ABS(PHI)
        AARG = ABS(ARG)
        RS1 = RS1 + ALOG(APHI) - 0.25E0*ALOG(AARG) - AIC
        IF (ABS(RS1).GT.ELIM) GO TO 120
        IF (I.EQ.1) IFLAG = 1
        IF (RS1.LT.0.0E0) GO TO 70
        IF (I.EQ.1) IFLAG = 3
   70   CONTINUE
C-----------------------------------------------------------------------
C     SCALE S1 TO KEEP INTERMEDIATE ARITHMETIC ON SCALE NEAR
C     EXPONENT EXTREMES
C-----------------------------------------------------------------------
        CALL CAIRY(ARG, 0, 2, AI, NAI, IDUM)
        CALL CAIRY(ARG, 1, 2, DAI, NDAI, IDUM)
        S2 = PHI*(AI*ASUM+DAI*BSUM)
        C2R = REAL(S1)
        C2I = AIMAG(S1)
        C2M = EXP(C2R)*REAL(CSS(IFLAG))
        S1 = CMPLX(C2M,0.0E0)*CMPLX(COS(C2I),SIN(C2I))
        S2 = S2*S1
        IF (IFLAG.NE.1) GO TO 80
        CALL CUCHK(S2, NW, BRY(1), TOL)
        IF (NW.NE.0) GO TO 120
   80   CONTINUE
        IF (YY.LE.0.0E0) S2 = CONJG(S2)
        J = ND - I + 1
        S2 = S2*C2
        CY(I) = S2
        Y(J) = S2*CSR(IFLAG)
        C2 = C2*CID
   90 CONTINUE
      IF (ND.LE.2) GO TO 110
      RZ = CMPLX(2.0E0,0.0E0)/Z
      BRY(2) = 1.0E0/BRY(1)
      BRY(3) = R1MACH(2)
      S1 = CY(1)
      S2 = CY(2)
      C1 = CSR(IFLAG)
      ASCLE = BRY(IFLAG)
      K = ND - 2
      FN = K
      DO 100 I=3,ND
        C2 = S2
        S2 = S1 + CMPLX(FNU+FN,0.0E0)*RZ*S2
        S1 = C2
        C2 = S2*C1
        Y(K) = C2
        K = K - 1
        FN = FN - 1.0E0
        IF (IFLAG.GE.3) GO TO 100
        C2R = REAL(C2)
        C2I = AIMAG(C2)
        C2R = ABS(C2R)
        C2I = ABS(C2I)
        C2M = MAX(C2R,C2I)
        IF (C2M.LE.ASCLE) GO TO 100
        IFLAG = IFLAG + 1
        ASCLE = BRY(IFLAG)
        S1 = S1*C1
        S2 = C2
        S1 = S1*CSS(IFLAG)
        S2 = S2*CSS(IFLAG)
        C1 = CSR(IFLAG)
  100 CONTINUE
  110 CONTINUE
      RETURN
  120 CONTINUE
      IF (RS1.GT.0.0E0) GO TO 140
C-----------------------------------------------------------------------
C     SET UNDERFLOW AND UPDATE PARAMETERS
C-----------------------------------------------------------------------
      Y(ND) = CZERO
      NZ = NZ + 1
      ND = ND - 1
      IF (ND.EQ.0) GO TO 110
      CALL CUOIK(Z, FNU, KODE, 1, ND, Y, NUF, TOL, ELIM, ALIM)
      IF (NUF.LT.0) GO TO 140
      ND = ND - NUF
      NZ = NZ + NUF
      IF (ND.EQ.0) GO TO 110
      FN = FNU + (ND-1)
      IF (FN.LT.FNUL) GO TO 130
C      FN = AIMAG(CID)
C      J = NUF + 1
C      K = MOD(J,4) + 1
C      S1 = CIP(K)
C      IF (FN.LT.0.0E0) S1 = CONJG(S1)
C      C2 = C2*S1
      IN = INU + ND - 1
      IN = MOD(IN,4) + 1
      C2 = ZAR*CIP(IN)
      IF (YY.LE.0.0E0)C2=CONJG(C2)
      GO TO 40
  130 CONTINUE
      NLAST = ND
      RETURN
  140 CONTINUE
      NZ = -1
      RETURN
  150 CONTINUE
      IF (RS1.GT.0.0E0) GO TO 140
      NZ = N
      DO 160 I=1,N
        Y(I) = CZERO
  160 CONTINUE
      RETURN
      END
*DECK CUNIK
      SUBROUTINE CUNIK (ZR, FNU, IKFLG, IPMTR, TOL, INIT, PHI, ZETA1,
     +   ZETA2, SUM, CWRK)
C***BEGIN PROLOGUE  CUNIK
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CUNIK-A, ZUNIK-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C        CUNIK COMPUTES PARAMETERS FOR THE UNIFORM ASYMPTOTIC
C        EXPANSIONS OF THE I AND K FUNCTIONS ON IKFLG= 1 OR 2
C        RESPECTIVELY BY
C
C        W(FNU,ZR) = PHI*EXP(ZETA)*SUM
C
C        WHERE       ZETA=-ZETA1 + ZETA2       OR
C                          ZETA1 - ZETA2
C
C        THE FIRST CALL MUST HAVE INIT=0. SUBSEQUENT CALLS WITH THE
C        SAME ZR AND FNU WILL RETURN THE I OR K FUNCTION ON IKFLG=
C        1 OR 2 WITH NO CHANGE IN INIT. CWRK IS A COMPLEX WORK
C        ARRAY. IPMTR=0 COMPUTES ALL PARAMETERS. IPMTR=1 COMPUTES PHI,
C        ZETA1,ZETA2.
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CUNIK
      COMPLEX CFN, CON, CONE, CRFN, CWRK, CZERO, PHI, S, SR, SUM, T,
     * T2, ZETA1, ZETA2, ZN, ZR
      REAL AC, C, FNU, RFN, TEST, TOL, TSTR, TSTI, R1MACH
      INTEGER I, IKFLG, INIT, IPMTR, J, K, L
      DIMENSION C(120), CWRK(16), CON(2)
      DATA CZERO, CONE / (0.0E0,0.0E0), (1.0E0,0.0E0) /
      DATA CON(1), CON(2)  /
     1(3.98942280401432678E-01,0.0E0),(1.25331413731550025E+00,0.0E0)/
      DATA C(1), C(2), C(3), C(4), C(5), C(6), C(7), C(8), C(9), C(10),
     1     C(11), C(12), C(13), C(14), C(15), C(16), C(17), C(18),
     2     C(19), C(20), C(21), C(22), C(23), C(24)/
     3     1.00000000000000000E+00,    -2.08333333333333333E-01,
     4     1.25000000000000000E-01,     3.34201388888888889E-01,
     5    -4.01041666666666667E-01,     7.03125000000000000E-02,
     6    -1.02581259645061728E+00,     1.84646267361111111E+00,
     7    -8.91210937500000000E-01,     7.32421875000000000E-02,
     8     4.66958442342624743E+00,    -1.12070026162229938E+01,
     9     8.78912353515625000E+00,    -2.36408691406250000E+00,
     A     1.12152099609375000E-01,    -2.82120725582002449E+01,
     B     8.46362176746007346E+01,    -9.18182415432400174E+01,
     C     4.25349987453884549E+01,    -7.36879435947963170E+00,
     D     2.27108001708984375E-01,     2.12570130039217123E+02,
     E    -7.65252468141181642E+02,     1.05999045252799988E+03/
      DATA C(25), C(26), C(27), C(28), C(29), C(30), C(31), C(32),
     1     C(33), C(34), C(35), C(36), C(37), C(38), C(39), C(40),
     2     C(41), C(42), C(43), C(44), C(45), C(46), C(47), C(48)/
     3    -6.99579627376132541E+02,     2.18190511744211590E+02,
     4    -2.64914304869515555E+01,     5.72501420974731445E-01,
     5    -1.91945766231840700E+03,     8.06172218173730938E+03,
     6    -1.35865500064341374E+04,     1.16553933368645332E+04,
     7    -5.30564697861340311E+03,     1.20090291321635246E+03,
     8    -1.08090919788394656E+02,     1.72772750258445740E+00,
     9     2.02042913309661486E+04,    -9.69805983886375135E+04,
     A     1.92547001232531532E+05,    -2.03400177280415534E+05,
     B     1.22200464983017460E+05,    -4.11926549688975513E+04,
     C     7.10951430248936372E+03,    -4.93915304773088012E+02,
     D     6.07404200127348304E+00,    -2.42919187900551333E+05,
     E     1.31176361466297720E+06,    -2.99801591853810675E+06/
      DATA C(49), C(50), C(51), C(52), C(53), C(54), C(55), C(56),
     1     C(57), C(58), C(59), C(60), C(61), C(62), C(63), C(64),
     2     C(65), C(66), C(67), C(68), C(69), C(70), C(71), C(72)/
     3     3.76327129765640400E+06,    -2.81356322658653411E+06,
     4     1.26836527332162478E+06,    -3.31645172484563578E+05,
     5     4.52187689813627263E+04,    -2.49983048181120962E+03,
     6     2.43805296995560639E+01,     3.28446985307203782E+06,
     7    -1.97068191184322269E+07,     5.09526024926646422E+07,
     8    -7.41051482115326577E+07,     6.63445122747290267E+07,
     9    -3.75671766607633513E+07,     1.32887671664218183E+07,
     A    -2.78561812808645469E+06,     3.08186404612662398E+05,
     B    -1.38860897537170405E+04,     1.10017140269246738E+02,
     C    -4.93292536645099620E+07,     3.25573074185765749E+08,
     D    -9.39462359681578403E+08,     1.55359689957058006E+09,
     E    -1.62108055210833708E+09,     1.10684281682301447E+09/
      DATA C(73), C(74), C(75), C(76), C(77), C(78), C(79), C(80),
     1     C(81), C(82), C(83), C(84), C(85), C(86), C(87), C(88),
     2     C(89), C(90), C(91), C(92), C(93), C(94), C(95), C(96)/
     3    -4.95889784275030309E+08,     1.42062907797533095E+08,
     4    -2.44740627257387285E+07,     2.24376817792244943E+06,
     5    -8.40054336030240853E+04,     5.51335896122020586E+02,
     6     8.14789096118312115E+08,    -5.86648149205184723E+09,
     7     1.86882075092958249E+10,    -3.46320433881587779E+10,
     8     4.12801855797539740E+10,    -3.30265997498007231E+10,
     9     1.79542137311556001E+10,    -6.56329379261928433E+09,
     A     1.55927986487925751E+09,    -2.25105661889415278E+08,
     B     1.73951075539781645E+07,    -5.49842327572288687E+05,
     C     3.03809051092238427E+03,    -1.46792612476956167E+10,
     D     1.14498237732025810E+11,    -3.99096175224466498E+11,
     E     8.19218669548577329E+11,    -1.09837515608122331E+12/
      DATA C(97), C(98), C(99), C(100), C(101), C(102), C(103), C(104),
     1     C(105), C(106), C(107), C(108), C(109), C(110), C(111),
     2     C(112), C(113), C(114), C(115), C(116), C(117), C(118)/
     3     1.00815810686538209E+12,    -6.45364869245376503E+11,
     4     2.87900649906150589E+11,    -8.78670721780232657E+10,
     5     1.76347306068349694E+10,    -2.16716498322379509E+09,
     6     1.43157876718888981E+08,    -3.87183344257261262E+06,
     7     1.82577554742931747E+04,     2.86464035717679043E+11,
     8    -2.40629790002850396E+12,     9.10934118523989896E+12,
     9    -2.05168994109344374E+13,     3.05651255199353206E+13,
     A    -3.16670885847851584E+13,     2.33483640445818409E+13,
     B    -1.23204913055982872E+13,     4.61272578084913197E+12,
     C    -1.19655288019618160E+12,     2.05914503232410016E+11,
     D    -2.18229277575292237E+10,     1.24700929351271032E+09/
      DATA C(119), C(120)/
     1    -2.91883881222208134E+07,     1.18838426256783253E+05/
C***FIRST EXECUTABLE STATEMENT  CUNIK
      IF (INIT.NE.0) GO TO 40
C-----------------------------------------------------------------------
C     INITIALIZE ALL VARIABLES
C-----------------------------------------------------------------------
      RFN = 1.0E0/FNU
      CRFN = CMPLX(RFN,0.0E0)
C     T = ZR*CRFN
C-----------------------------------------------------------------------
C     OVERFLOW TEST (ZR/FNU TOO SMALL)
C-----------------------------------------------------------------------
      TSTR = REAL(ZR)
      TSTI = AIMAG(ZR)
      TEST = R1MACH(1)*1.0E+3
      AC = FNU*TEST
      IF (ABS(TSTR).GT.AC .OR. ABS(TSTI).GT.AC) GO TO 15
      AC = 2.0E0*ABS(ALOG(TEST))+FNU
      ZETA1 = CMPLX(AC,0.0E0)
      ZETA2 = CMPLX(FNU,0.0E0)
      PHI=CONE
      RETURN
   15 CONTINUE
      T=ZR*CRFN
      S = CONE + T*T
      SR = CSQRT(S)
      CFN = CMPLX(FNU,0.0E0)
      ZN = (CONE+SR)/T
      ZETA1 = CFN*CLOG(ZN)
      ZETA2 = CFN*SR
      T = CONE/SR
      SR = T*CRFN
      CWRK(16) = CSQRT(SR)
      PHI = CWRK(16)*CON(IKFLG)
      IF (IPMTR.NE.0) RETURN
      T2 = CONE/S
      CWRK(1) = CONE
      CRFN = CONE
      AC = 1.0E0
      L = 1
      DO 20 K=2,15
        S = CZERO
        DO 10 J=1,K
          L = L + 1
          S = S*T2 + CMPLX(C(L),0.0E0)
   10   CONTINUE
        CRFN = CRFN*SR
        CWRK(K) = CRFN*S
        AC = AC*RFN
        TSTR = REAL(CWRK(K))
        TSTI = AIMAG(CWRK(K))
        TEST = ABS(TSTR) + ABS(TSTI)
        IF (AC.LT.TOL .AND. TEST.LT.TOL) GO TO 30
   20 CONTINUE
      K = 15
   30 CONTINUE
      INIT = K
   40 CONTINUE
      IF (IKFLG.EQ.2) GO TO 60
C-----------------------------------------------------------------------
C     COMPUTE SUM FOR THE I FUNCTION
C-----------------------------------------------------------------------
      S = CZERO
      DO 50 I=1,INIT
        S = S + CWRK(I)
   50 CONTINUE
      SUM = S
      PHI = CWRK(16)*CON(1)
      RETURN
   60 CONTINUE
C-----------------------------------------------------------------------
C     COMPUTE SUM FOR THE K FUNCTION
C-----------------------------------------------------------------------
      S = CZERO
      T = CONE
      DO 70 I=1,INIT
        S = S + T*CWRK(I)
        T = -T
   70 CONTINUE
      SUM = S
      PHI = CWRK(16)*CON(2)
      RETURN
      END
*DECK CUOIK
      SUBROUTINE CUOIK (Z, FNU, KODE, IKFLG, N, Y, NUF, TOL, ELIM, ALIM)
C***BEGIN PROLOGUE  CUOIK
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESH, CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CUOIK-A, ZUOIK-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CUOIK COMPUTES THE LEADING TERMS OF THE UNIFORM ASYMPTOTIC
C     EXPANSIONS FOR THE I AND K FUNCTIONS AND COMPARES THEM
C     (IN LOGARITHMIC FORM) TO ALIM AND ELIM FOR OVER AND UNDERFLOW
C     WHERE ALIM.LT.ELIM. IF THE MAGNITUDE, BASED ON THE LEADING
C     EXPONENTIAL, IS LESS THAN ALIM OR GREATER THAN -ALIM, THEN
C     THE RESULT IS ON SCALE. IF NOT, THEN A REFINED TEST USING OTHER
C     MULTIPLIERS (IN LOGARITHMIC FORM) IS MADE BASED ON ELIM. HERE
C     EXP(-ELIM)=SMALLEST MACHINE NUMBER*1.0E+3 AND EXP(-ALIM)=
C     EXP(-ELIM)/TOL
C
C     IKFLG=1 MEANS THE I SEQUENCE IS TESTED
C          =2 MEANS THE K SEQUENCE IS TESTED
C     NUF = 0 MEANS THE LAST MEMBER OF THE SEQUENCE IS ON SCALE
C         =-1 MEANS AN OVERFLOW WOULD OCCUR
C     IKFLG=1 AND NUF.GT.0 MEANS THE LAST NUF Y VALUES WERE SET TO ZERO
C             THE FIRST N-NUF VALUES MUST BE SET BY ANOTHER ROUTINE
C     IKFLG=2 AND NUF.EQ.N MEANS ALL Y VALUES WERE SET TO ZERO
C     IKFLG=2 AND 0.LT.NUF.LT.N NOT CONSIDERED. Y MUST BE SET BY
C             ANOTHER ROUTINE
C
C***SEE ALSO  CBESH, CBESI, CBESK
C***ROUTINES CALLED  CUCHK, CUNHJ, CUNIK, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CUOIK
      COMPLEX ARG, ASUM, BSUM, CWRK, CZ, CZERO, PHI, SUM, Y, Z, ZB,
     * ZETA1, ZETA2, ZN, ZR
      REAL AARG, AIC, ALIM, APHI, ASCLE, AX, AY, ELIM, FNN, FNU, GNN,
     * GNU, RCZ, TOL, X, YY, R1MACH
      INTEGER I, IFORM, IKFLG, INIT, KODE, N, NN, NUF, NW
      DIMENSION Y(N), CWRK(16)
      DATA CZERO / (0.0E0,0.0E0) /
      DATA AIC / 1.265512123484645396E+00 /
C***FIRST EXECUTABLE STATEMENT  CUOIK
      NUF = 0
      NN = N
      X = REAL(Z)
      ZR = Z
      IF (X.LT.0.0E0) ZR = -Z
      ZB = ZR
      YY = AIMAG(ZR)
      AX = ABS(X)*1.7321E0
      AY = ABS(YY)
      IFORM = 1
      IF (AY.GT.AX) IFORM = 2
      GNU = MAX(FNU,1.0E0)
      IF (IKFLG.EQ.1) GO TO 10
      FNN = NN
      GNN = FNU + FNN - 1.0E0
      GNU = MAX(GNN,FNN)
   10 CONTINUE
C-----------------------------------------------------------------------
C     ONLY THE MAGNITUDE OF ARG AND PHI ARE NEEDED ALONG WITH THE
C     REAL PARTS OF ZETA1, ZETA2 AND ZB. NO ATTEMPT IS MADE TO GET
C     THE SIGN OF THE IMAGINARY PART CORRECT.
C-----------------------------------------------------------------------
      IF (IFORM.EQ.2) GO TO 20
      INIT = 0
      CALL CUNIK(ZR, GNU, IKFLG, 1, TOL, INIT, PHI, ZETA1, ZETA2, SUM,
     * CWRK)
      CZ = -ZETA1 + ZETA2
      GO TO 40
   20 CONTINUE
      ZN = -ZR*CMPLX(0.0E0,1.0E0)
      IF (YY.GT.0.0E0) GO TO 30
      ZN = CONJG(-ZN)
   30 CONTINUE
      CALL CUNHJ(ZN, GNU, 1, TOL, PHI, ARG, ZETA1, ZETA2, ASUM, BSUM)
      CZ = -ZETA1 + ZETA2
      AARG = ABS(ARG)
   40 CONTINUE
      IF (KODE.EQ.2) CZ = CZ - ZB
      IF (IKFLG.EQ.2) CZ = -CZ
      APHI = ABS(PHI)
      RCZ = REAL(CZ)
C-----------------------------------------------------------------------
C     OVERFLOW TEST
C-----------------------------------------------------------------------
      IF (RCZ.GT.ELIM) GO TO 170
      IF (RCZ.LT.ALIM) GO TO 50
      RCZ = RCZ + ALOG(APHI)
      IF (IFORM.EQ.2) RCZ = RCZ - 0.25E0*ALOG(AARG) - AIC
      IF (RCZ.GT.ELIM) GO TO 170
      GO TO 100
   50 CONTINUE
C-----------------------------------------------------------------------
C     UNDERFLOW TEST
C-----------------------------------------------------------------------
      IF (RCZ.LT.(-ELIM)) GO TO 60
      IF (RCZ.GT.(-ALIM)) GO TO 100
      RCZ = RCZ + ALOG(APHI)
      IF (IFORM.EQ.2) RCZ = RCZ - 0.25E0*ALOG(AARG) - AIC
      IF (RCZ.GT.(-ELIM)) GO TO 80
   60 CONTINUE
      DO 70 I=1,NN
        Y(I) = CZERO
   70 CONTINUE
      NUF = NN
      RETURN
   80 CONTINUE
      ASCLE = 1.0E+3*R1MACH(1)/TOL
      CZ = CZ + CLOG(PHI)
      IF (IFORM.EQ.1) GO TO 90
      CZ = CZ - CMPLX(0.25E0,0.0E0)*CLOG(ARG) - CMPLX(AIC,0.0E0)
   90 CONTINUE
      AX = EXP(RCZ)/TOL
      AY = AIMAG(CZ)
      CZ = CMPLX(AX,0.0E0)*CMPLX(COS(AY),SIN(AY))
      CALL CUCHK(CZ, NW, ASCLE, TOL)
      IF (NW.EQ.1) GO TO 60
  100 CONTINUE
      IF (IKFLG.EQ.2) RETURN
      IF (N.EQ.1) RETURN
C-----------------------------------------------------------------------
C     SET UNDERFLOWS ON I SEQUENCE
C-----------------------------------------------------------------------
  110 CONTINUE
      GNU = FNU + (NN-1)
      IF (IFORM.EQ.2) GO TO 120
      INIT = 0
      CALL CUNIK(ZR, GNU, IKFLG, 1, TOL, INIT, PHI, ZETA1, ZETA2, SUM,
     * CWRK)
      CZ = -ZETA1 + ZETA2
      GO TO 130
  120 CONTINUE
      CALL CUNHJ(ZN, GNU, 1, TOL, PHI, ARG, ZETA1, ZETA2, ASUM, BSUM)
      CZ = -ZETA1 + ZETA2
      AARG = ABS(ARG)
  130 CONTINUE
      IF (KODE.EQ.2) CZ = CZ - ZB
      APHI = ABS(PHI)
      RCZ = REAL(CZ)
      IF (RCZ.LT.(-ELIM)) GO TO 140
      IF (RCZ.GT.(-ALIM)) RETURN
      RCZ = RCZ + ALOG(APHI)
      IF (IFORM.EQ.2) RCZ = RCZ - 0.25E0*ALOG(AARG) - AIC
      IF (RCZ.GT.(-ELIM)) GO TO 150
  140 CONTINUE
      Y(NN) = CZERO
      NN = NN - 1
      NUF = NUF + 1
      IF (NN.EQ.0) RETURN
      GO TO 110
  150 CONTINUE
      ASCLE = 1.0E+3*R1MACH(1)/TOL
      CZ = CZ + CLOG(PHI)
      IF (IFORM.EQ.1) GO TO 160
      CZ = CZ - CMPLX(0.25E0,0.0E0)*CLOG(ARG) - CMPLX(AIC,0.0E0)
  160 CONTINUE
      AX = EXP(RCZ)/TOL
      AY = AIMAG(CZ)
      CZ = CMPLX(AX,0.0E0)*CMPLX(COS(AY),SIN(AY))
      CALL CUCHK(CZ, NW, ASCLE, TOL)
      IF (NW.EQ.1) GO TO 140
      RETURN
  170 CONTINUE
      NUF = -1
      RETURN
      END
*DECK CWRSK
      SUBROUTINE CWRSK (ZR, FNU, KODE, N, Y, NZ, CW, TOL, ELIM, ALIM)
C***BEGIN PROLOGUE  CWRSK
C***SUBSIDIARY
C***PURPOSE  Subsidiary to CBESI and CBESK
C***LIBRARY   SLATEC
C***TYPE      ALL (CWRSK-A, ZWRSK-A)
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C     CWRSK COMPUTES THE I BESSEL FUNCTION FOR RE(Z).GE.0.0 BY
C     NORMALIZING THE I FUNCTION RATIOS FROM CRATI BY THE WRONSKIAN
C
C***SEE ALSO  CBESI, CBESK
C***ROUTINES CALLED  CBKNU, CRATI, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  CWRSK
      COMPLEX CINU, CSCL, CT, CW, C1, C2, RCT, ST, Y, ZR
      REAL ACT, ACW, ALIM, ASCLE, ELIM, FNU, S1, S2, TOL, YY, R1MACH
      INTEGER I, KODE, N, NW, NZ
      DIMENSION Y(N), CW(2)
C***FIRST EXECUTABLE STATEMENT  CWRSK
C-----------------------------------------------------------------------
C     I(FNU+I-1,Z) BY BACKWARD RECURRENCE FOR RATIOS
C     Y(I)=I(FNU+I,Z)/I(FNU+I-1,Z) FROM CRATI NORMALIZED BY THE
C     WRONSKIAN WITH K(FNU,Z) AND K(FNU+1,Z) FROM CBKNU.
C-----------------------------------------------------------------------
      NZ = 0
      CALL CBKNU(ZR, FNU, KODE, 2, CW, NW, TOL, ELIM, ALIM)
      IF (NW.NE.0) GO TO 50
      CALL CRATI(ZR, FNU, N, Y, TOL)
C-----------------------------------------------------------------------
C     RECUR FORWARD ON I(FNU+1,Z) = R(FNU,Z)*I(FNU,Z),
C     R(FNU+J-1,Z)=Y(J),  J=1,...,N
C-----------------------------------------------------------------------
      CINU = CMPLX(1.0E0,0.0E0)
      IF (KODE.EQ.1) GO TO 10
      YY = AIMAG(ZR)
      S1 = COS(YY)
      S2 = SIN(YY)
      CINU = CMPLX(S1,S2)
   10 CONTINUE
C-----------------------------------------------------------------------
C     ON LOW EXPONENT MACHINES THE K FUNCTIONS CAN BE CLOSE TO BOTH
C     THE UNDER AND OVERFLOW LIMITS AND THE NORMALIZATION MUST BE
C     SCALED TO PREVENT OVER OR UNDERFLOW. CUOIK HAS DETERMINED THAT
C     THE RESULT IS ON SCALE.
C-----------------------------------------------------------------------
      ACW = ABS(CW(2))
      ASCLE = 1.0E+3*R1MACH(1)/TOL
      CSCL = CMPLX(1.0E0,0.0E0)
      IF (ACW.GT.ASCLE) GO TO 20
      CSCL = CMPLX(1.0E0/TOL,0.0E0)
      GO TO 30
   20 CONTINUE
      ASCLE = 1.0E0/ASCLE
      IF (ACW.LT.ASCLE) GO TO 30
      CSCL = CMPLX(TOL,0.0E0)
   30 CONTINUE
      C1 = CW(1)*CSCL
      C2 = CW(2)*CSCL
      ST = Y(1)
C-----------------------------------------------------------------------
C     CINU=CINU*(CONJG(CT)/ABS(CT))*(1.0E0/ABS(CT) PREVENTS
C     UNDER- OR OVERFLOW PREMATURELY BY SQUARING ABS(CT)
C-----------------------------------------------------------------------
      CT = ZR*(C2+ST*C1)
      ACT = ABS(CT)
      RCT = CMPLX(1.0E0/ACT,0.0E0)
      CT = CONJG(CT)*RCT
      CINU = CINU*RCT*CT
      Y(1) = CINU*CSCL
      IF (N.EQ.1) RETURN
      DO 40 I=2,N
        CINU = ST*CINU
        ST = Y(I)
        Y(I) = CINU*CSCL
   40 CONTINUE
      RETURN
   50 CONTINUE
      NZ = -1
      IF(NW.EQ.(-2)) NZ=-2
      RETURN
      END
*DECK FDUMP
      SUBROUTINE FDUMP
C***BEGIN PROLOGUE  FDUMP
C***PURPOSE  Symbolic dump (should be locally written).
C***LIBRARY   SLATEC (XERROR)
C***CATEGORY  R3
C***TYPE      ALL (FDUMP-A)
C***KEYWORDS  ERROR, XERMSG
C***AUTHOR  Jones, R. E., (SNLA)
C***DESCRIPTION
C
C        ***Note*** Machine Dependent Routine
C        FDUMP is intended to be replaced by a locally written
C        version which produces a symbolic dump.  Failing this,
C        it should be replaced by a version which prints the
C        subprogram nesting list.  Note that this dump must be
C        printed on each of up to five files, as indicated by the
C        XGETUA routine.  See XSETUA and XGETUA for details.
C
C     Written by Ron Jones, with SLATEC Common Math Library Subcommittee
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   861211  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  FDUMP
C***FIRST EXECUTABLE STATEMENT  FDUMP
      RETURN
      END
*DECK GAMLN
      REAL FUNCTION GAMLN (Z, IERR)
C***BEGIN PROLOGUE  GAMLN
C***SUBSIDIARY
C***PURPOSE  Compute the logarithm of the Gamma function
C***LIBRARY   SLATEC
C***CATEGORY  C7A
C***TYPE      SINGLE PRECISION (GAMLN-S, DGAMLN-D)
C***KEYWORDS  LOGARITHM OF GAMMA FUNCTION
C***AUTHOR  Amos, D. E., (SNL)
C***DESCRIPTION
C
C         GAMLN COMPUTES THE NATURAL LOG OF THE GAMMA FUNCTION FOR
C         Z.GT.0.  THE ASYMPTOTIC EXPANSION IS USED TO GENERATE VALUES
C         GREATER THAN ZMIN WHICH ARE ADJUSTED BY THE RECURSION
C         G(Z+1)=Z*G(Z) FOR Z.LE.ZMIN.  THE FUNCTION WAS MADE AS
C         PORTABLE AS POSSIBLE BY COMPUTING ZMIN FROM THE NUMBER OF BASE
C         10 DIGITS IN A WORD, RLN=MAX(-ALOG10(R1MACH(4)),0.5E-18)
C         LIMITED TO 18 DIGITS OF (RELATIVE) ACCURACY.
C
C         SINCE INTEGER ARGUMENTS ARE COMMON, A TABLE LOOK UP ON 100
C         VALUES IS USED FOR SPEED OF EXECUTION.
C
C     DESCRIPTION OF ARGUMENTS
C
C         INPUT
C           Z      - REAL ARGUMENT, Z.GT.0.0E0
C
C         OUTPUT
C           GAMLN  - NATURAL LOG OF THE GAMMA FUNCTION AT Z
C           IERR   - ERROR FLAG
C                    IERR=0, NORMAL RETURN, COMPUTATION COMPLETED
C                    IERR=1, Z.LE.0.0E0,    NO COMPUTATION
C
C***REFERENCES  COMPUTATION OF BESSEL FUNCTIONS OF COMPLEX ARGUMENT
C                 BY D. E. AMOS, SAND83-0083, MAY, 1983.
C***ROUTINES CALLED  I1MACH, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   830501  DATE WRITTEN
C   830501  REVISION DATE from Version 3.2
C   910415  Prologue converted to Version 4.0 format.  (BAB)
C   920128  Category corrected.  (WRB)
C   921215  GAMLN defined for Z negative.  (WRB)
C***END PROLOGUE  GAMLN
C
      INTEGER I, I1M, K, MZ, NZ, IERR, I1MACH
      REAL CF, CON, FLN, FZ, GLN, RLN, S, TLG, TRM, TST, T1, WDTOL, Z,
     * ZDMY, ZINC, ZM, ZMIN, ZP, ZSQ
      REAL R1MACH
      DIMENSION CF(22), GLN(100)
C           LNGAMMA(N), N=1,100
      DATA GLN(1), GLN(2), GLN(3), GLN(4), GLN(5), GLN(6), GLN(7),
     1     GLN(8), GLN(9), GLN(10), GLN(11), GLN(12), GLN(13), GLN(14),
     2     GLN(15), GLN(16), GLN(17), GLN(18), GLN(19), GLN(20),
     3     GLN(21), GLN(22)/
     4     0.00000000000000000E+00,     0.00000000000000000E+00,
     5     6.93147180559945309E-01,     1.79175946922805500E+00,
     6     3.17805383034794562E+00,     4.78749174278204599E+00,
     7     6.57925121201010100E+00,     8.52516136106541430E+00,
     8     1.06046029027452502E+01,     1.28018274800814696E+01,
     9     1.51044125730755153E+01,     1.75023078458738858E+01,
     A     1.99872144956618861E+01,     2.25521638531234229E+01,
     B     2.51912211827386815E+01,     2.78992713838408916E+01,
     C     3.06718601060806728E+01,     3.35050734501368889E+01,
     D     3.63954452080330536E+01,     3.93398841871994940E+01,
     E     4.23356164607534850E+01,     4.53801388984769080E+01/
      DATA GLN(23), GLN(24), GLN(25), GLN(26), GLN(27), GLN(28),
     1     GLN(29), GLN(30), GLN(31), GLN(32), GLN(33), GLN(34),
     2     GLN(35), GLN(36), GLN(37), GLN(38), GLN(39), GLN(40),
     3     GLN(41), GLN(42), GLN(43), GLN(44)/
     4     4.84711813518352239E+01,     5.16066755677643736E+01,
     5     5.47847293981123192E+01,     5.80036052229805199E+01,
     6     6.12617017610020020E+01,     6.45575386270063311E+01,
     7     6.78897431371815350E+01,     7.12570389671680090E+01,
     8     7.46582363488301644E+01,     7.80922235533153106E+01,
     9     8.15579594561150372E+01,     8.50544670175815174E+01,
     A     8.85808275421976788E+01,     9.21361756036870925E+01,
     B     9.57196945421432025E+01,     9.93306124547874269E+01,
     C     1.02968198614513813E+02,     1.06631760260643459E+02,
     D     1.10320639714757395E+02,     1.14034211781461703E+02,
     E     1.17771881399745072E+02,     1.21533081515438634E+02/
      DATA GLN(45), GLN(46), GLN(47), GLN(48), GLN(49), GLN(50),
     1     GLN(51), GLN(52), GLN(53), GLN(54), GLN(55), GLN(56),
     2     GLN(57), GLN(58), GLN(59), GLN(60), GLN(61), GLN(62),
     3     GLN(63), GLN(64), GLN(65), GLN(66)/
     4     1.25317271149356895E+02,     1.29123933639127215E+02,
     5     1.32952575035616310E+02,     1.36802722637326368E+02,
     6     1.40673923648234259E+02,     1.44565743946344886E+02,
     7     1.48477766951773032E+02,     1.52409592584497358E+02,
     8     1.56360836303078785E+02,     1.60331128216630907E+02,
     9     1.64320112263195181E+02,     1.68327445448427652E+02,
     A     1.72352797139162802E+02,     1.76395848406997352E+02,
     B     1.80456291417543771E+02,     1.84533828861449491E+02,
     C     1.88628173423671591E+02,     1.92739047287844902E+02,
     D     1.96866181672889994E+02,     2.01009316399281527E+02,
     E     2.05168199482641199E+02,     2.09342586752536836E+02/
      DATA GLN(67), GLN(68), GLN(69), GLN(70), GLN(71), GLN(72),
     1     GLN(73), GLN(74), GLN(75), GLN(76), GLN(77), GLN(78),
     2     GLN(79), GLN(80), GLN(81), GLN(82), GLN(83), GLN(84),
     3     GLN(85), GLN(86), GLN(87), GLN(88)/
     4     2.13532241494563261E+02,     2.17736934113954227E+02,
     5     2.21956441819130334E+02,     2.26190548323727593E+02,
     6     2.30439043565776952E+02,     2.34701723442818268E+02,
     7     2.38978389561834323E+02,     2.43268849002982714E+02,
     8     2.47572914096186884E+02,     2.51890402209723194E+02,
     9     2.56221135550009525E+02,     2.60564940971863209E+02,
     A     2.64921649798552801E+02,     2.69291097651019823E+02,
     B     2.73673124285693704E+02,     2.78067573440366143E+02,
     C     2.82474292687630396E+02,     2.86893133295426994E+02,
     D     2.91323950094270308E+02,     2.95766601350760624E+02,
     E     3.00220948647014132E+02,     3.04686856765668715E+02/
      DATA GLN(89), GLN(90), GLN(91), GLN(92), GLN(93), GLN(94),
     1     GLN(95), GLN(96), GLN(97), GLN(98), GLN(99), GLN(100)/
     2     3.09164193580146922E+02,     3.13652829949879062E+02,
     3     3.18152639620209327E+02,     3.22663499126726177E+02,
     4     3.27185287703775217E+02,     3.31717887196928473E+02,
     5     3.36261181979198477E+02,     3.40815058870799018E+02,
     6     3.45379407062266854E+02,     3.49954118040770237E+02,
     7     3.54539085519440809E+02,     3.59134205369575399E+02/
C             COEFFICIENTS OF ASYMPTOTIC EXPANSION
      DATA CF(1), CF(2), CF(3), CF(4), CF(5), CF(6), CF(7), CF(8),
     1     CF(9), CF(10), CF(11), CF(12), CF(13), CF(14), CF(15),
     2     CF(16), CF(17), CF(18), CF(19), CF(20), CF(21), CF(22)/
     3     8.33333333333333333E-02,    -2.77777777777777778E-03,
     4     7.93650793650793651E-04,    -5.95238095238095238E-04,
     5     8.41750841750841751E-04,    -1.91752691752691753E-03,
     6     6.41025641025641026E-03,    -2.95506535947712418E-02,
     7     1.79644372368830573E-01,    -1.39243221690590112E+00,
     8     1.34028640441683920E+01,    -1.56848284626002017E+02,
     9     2.19310333333333333E+03,    -3.61087712537249894E+04,
     A     6.91472268851313067E+05,    -1.52382215394074162E+07,
     B     3.82900751391414141E+08,    -1.08822660357843911E+10,
     C     3.47320283765002252E+11,    -1.23696021422692745E+13,
     D     4.88788064793079335E+14,    -2.13203339609193739E+16/
C
C             LN(2*PI)
      DATA CON                    /     1.83787706640934548E+00/
C
C***FIRST EXECUTABLE STATEMENT  GAMLN
      IERR=0
      IF (Z.LE.0.0E0) GO TO 70
      IF (Z.GT.101.0E0) GO TO 10
      NZ = Z
      FZ = Z - NZ
      IF (FZ.GT.0.0E0) GO TO 10
      IF (NZ.GT.100) GO TO 10
      GAMLN = GLN(NZ)
      RETURN
   10 CONTINUE
      WDTOL = R1MACH(4)
      WDTOL = MAX(WDTOL,0.5E-18)
      I1M = I1MACH(11)
      RLN = R1MACH(5)*I1M
      FLN = MIN(RLN,20.0E0)
      FLN = MAX(FLN,3.0E0)
      FLN = FLN - 3.0E0
      ZM = 1.8000E0 + 0.3875E0*FLN
      MZ = ZM + 1
      ZMIN = MZ
      ZDMY = Z
      ZINC = 0.0E0
      IF (Z.GE.ZMIN) GO TO 20
      ZINC = ZMIN - NZ
      ZDMY = Z + ZINC
   20 CONTINUE
      ZP = 1.0E0/ZDMY
      T1 = CF(1)*ZP
      S = T1
      IF (ZP.LT.WDTOL) GO TO 40
      ZSQ = ZP*ZP
      TST = T1*WDTOL
      DO 30 K=2,22
        ZP = ZP*ZSQ
        TRM = CF(K)*ZP
        IF (ABS(TRM).LT.TST) GO TO 40
        S = S + TRM
   30 CONTINUE
   40 CONTINUE
      IF (ZINC.NE.0.0E0) GO TO 50
      TLG = ALOG(Z)
      GAMLN = Z*(TLG-1.0E0) + 0.5E0*(CON-TLG) + S
      RETURN
   50 CONTINUE
      ZP = 1.0E0
      NZ = ZINC
      DO 60 I=1,NZ
        ZP = ZP*(Z+(I-1))
   60 CONTINUE
      TLG = ALOG(ZDMY)
      GAMLN = ZDMY*(TLG-1.0E0) - ALOG(ZP) + 0.5E0*(CON-TLG) + S
      RETURN
C
C
   70 CONTINUE
      GAMLN = R1MACH(2)
      IERR=1
      RETURN
      END
*DECK I1MACH
      INTEGER FUNCTION I1MACH (I)
C***BEGIN PROLOGUE  I1MACH
C***PURPOSE  Return integer machine dependent constants.
C***LIBRARY   SLATEC
C***CATEGORY  R1
C***TYPE      INTEGER (I1MACH-I)
C***KEYWORDS  MACHINE CONSTANTS
C***AUTHOR  Fox, P. A., (Bell Labs)
C           Hall, A. D., (Bell Labs)
C           Schryer, N. L., (Bell Labs)
C***DESCRIPTION
C
C   I1MACH can be used to obtain machine-dependent parameters for the
C   local machine environment.  It is a function subprogram with one
C   (input) argument and can be referenced as follows:
C
C        K = I1MACH(I)
C
C   where I=1,...,16.  The (output) value of K above is determined by
C   the (input) value of I.  The results for various values of I are
C   discussed below.
C
C   I/O unit numbers:
C     I1MACH( 1) = the standard input unit.
C     I1MACH( 2) = the standard output unit.
C     I1MACH( 3) = the standard punch unit.
C     I1MACH( 4) = the standard error message unit.
C
C   Words:
C     I1MACH( 5) = the number of bits per integer storage unit.
C     I1MACH( 6) = the number of characters per integer storage unit.
C
C   Integers:
C     assume integers are represented in the S-digit, base-A form
C
C                sign ( X(S-1)*A**(S-1) + ... + X(1)*A + X(0) )
C
C                where 0 .LE. X(I) .LT. A for I=0,...,S-1.
C     I1MACH( 7) = A, the base.
C     I1MACH( 8) = S, the number of base-A digits.
C     I1MACH( 9) = A**S - 1, the largest magnitude.
C
C   Floating-Point Numbers:
C     Assume floating-point numbers are represented in the T-digit,
C     base-B form
C                sign (B**E)*( (X(1)/B) + ... + (X(T)/B**T) )
C
C                where 0 .LE. X(I) .LT. B for I=1,...,T,
C                0 .LT. X(1), and EMIN .LE. E .LE. EMAX.
C     I1MACH(10) = B, the base.
C
C   Single-Precision:
C     I1MACH(11) = T, the number of base-B digits.
C     I1MACH(12) = EMIN, the smallest exponent E.
C     I1MACH(13) = EMAX, the largest exponent E.
C
C   Double-Precision:
C     I1MACH(14) = T, the number of base-B digits.
C     I1MACH(15) = EMIN, the smallest exponent E.
C     I1MACH(16) = EMAX, the largest exponent E.
C
C   To alter this function for a particular environment, the desired
C   set of DATA statements should be activated by removing the C from
C   column 1.  Also, the values of I1MACH(1) - I1MACH(4) should be
C   checked for consistency with the local operating system.
C
C***REFERENCES  P. A. Fox, A. D. Hall and N. L. Schryer, Framework for
C                 a portable library, ACM Transactions on Mathematical
C                 Software 4, 2 (June 1978), pp. 177-188.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   750101  DATE WRITTEN
C   891012  Added VAX G-floating constants.  (WRB)
C   891012  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900618  Added DEC RISC constants.  (WRB)
C   900723  Added IBM RS 6000 constants.  (WRB)
C   901009  Correct I1MACH(7) for IBM Mainframes. Should be 2 not 16.
C           (RWC)
C   910710  Added HP 730 constants.  (SMR)
C   911114  Added Convex IEEE constants.  (WRB)
C   920121  Added SUN -r8 compiler option constants.  (WRB)
C   920229  Added Touchstone Delta i860 constants.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C   920625  Added Convex -p8 and -pd8 compiler option constants.
C           (BKS, WRB)
C   930201  Added DEC Alpha and SGI constants.  (RWC and WRB)
C   930618  Corrected I1MACH(5) for Convex -p8 and -pd8 compiler
C           options.  (DWL, RWC and WRB).
C***END PROLOGUE  I1MACH
C
      INTEGER IMACH(16),OUTPUT
      SAVE IMACH
      EQUIVALENCE (IMACH(4),OUTPUT)
C
C     MACHINE CONSTANTS FOR THE AMIGA
C     ABSOFT COMPILER
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -126 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1022 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE APOLLO
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        129 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1025 /
C
C     MACHINE CONSTANTS FOR THE BURROUGHS 1700 SYSTEM
C
C     DATA IMACH( 1) /          7 /
C     DATA IMACH( 2) /          2 /
C     DATA IMACH( 3) /          2 /
C     DATA IMACH( 4) /          2 /
C     DATA IMACH( 5) /         36 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         33 /
C     DATA IMACH( 9) / Z1FFFFFFFF /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -256 /
C     DATA IMACH(13) /        255 /
C     DATA IMACH(14) /         60 /
C     DATA IMACH(15) /       -256 /
C     DATA IMACH(16) /        255 /
C
C     MACHINE CONSTANTS FOR THE BURROUGHS 5700 SYSTEM
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         48 /
C     DATA IMACH( 6) /          6 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         39 /
C     DATA IMACH( 9) / O0007777777777777 /
C     DATA IMACH(10) /          8 /
C     DATA IMACH(11) /         13 /
C     DATA IMACH(12) /        -50 /
C     DATA IMACH(13) /         76 /
C     DATA IMACH(14) /         26 /
C     DATA IMACH(15) /        -50 /
C     DATA IMACH(16) /         76 /
C
C     MACHINE CONSTANTS FOR THE BURROUGHS 6700/7700 SYSTEMS
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         48 /
C     DATA IMACH( 6) /          6 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         39 /
C     DATA IMACH( 9) / O0007777777777777 /
C     DATA IMACH(10) /          8 /
C     DATA IMACH(11) /         13 /
C     DATA IMACH(12) /        -50 /
C     DATA IMACH(13) /         76 /
C     DATA IMACH(14) /         26 /
C     DATA IMACH(15) /     -32754 /
C     DATA IMACH(16) /      32780 /
C
C     MACHINE CONSTANTS FOR THE CDC 170/180 SERIES USING NOS/VE
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         64 /
C     DATA IMACH( 6) /          8 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         63 /
C     DATA IMACH( 9) / 9223372036854775807 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         47 /
C     DATA IMACH(12) /      -4095 /
C     DATA IMACH(13) /       4094 /
C     DATA IMACH(14) /         94 /
C     DATA IMACH(15) /      -4095 /
C     DATA IMACH(16) /       4094 /
C
C     MACHINE CONSTANTS FOR THE CDC 6000/7000 SERIES
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /    6LOUTPUT/
C     DATA IMACH( 5) /         60 /
C     DATA IMACH( 6) /         10 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         48 /
C     DATA IMACH( 9) / 00007777777777777777B /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         47 /
C     DATA IMACH(12) /       -929 /
C     DATA IMACH(13) /       1070 /
C     DATA IMACH(14) /         94 /
C     DATA IMACH(15) /       -929 /
C     DATA IMACH(16) /       1069 /
C
C     MACHINE CONSTANTS FOR THE CELERITY C1260
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          0 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / Z'7FFFFFFF' /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -126 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1022 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE CONVEX
C     USING THE -fn COMPILER OPTION
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1023 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE CONVEX
C     USING THE -fi COMPILER OPTION
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE CONVEX
C     USING THE -p8 COMPILER OPTION
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         64 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         63 /
C     DATA IMACH( 9) / 9223372036854775807 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         53 /
C     DATA IMACH(12) /      -1023 /
C     DATA IMACH(13) /       1023 /
C     DATA IMACH(14) /        113 /
C     DATA IMACH(15) /     -16383 /
C     DATA IMACH(16) /      16383 /
C
C     MACHINE CONSTANTS FOR THE CONVEX
C     USING THE -pd8 COMPILER OPTION
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         64 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         63 /
C     DATA IMACH( 9) / 9223372036854775807 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         53 /
C     DATA IMACH(12) /      -1023 /
C     DATA IMACH(13) /       1023 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1023 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE CRAY
C     USING THE 46 BIT INTEGER COMPILER OPTION
C
C     DATA IMACH( 1) /        100 /
C     DATA IMACH( 2) /        101 /
C     DATA IMACH( 3) /        102 /
C     DATA IMACH( 4) /        101 /
C     DATA IMACH( 5) /         64 /
C     DATA IMACH( 6) /          8 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         46 /
C     DATA IMACH( 9) / 1777777777777777B /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         47 /
C     DATA IMACH(12) /      -8189 /
C     DATA IMACH(13) /       8190 /
C     DATA IMACH(14) /         94 /
C     DATA IMACH(15) /      -8099 /
C     DATA IMACH(16) /       8190 /
C
C     MACHINE CONSTANTS FOR THE CRAY
C     USING THE 64 BIT INTEGER COMPILER OPTION
C
C     DATA IMACH( 1) /        100 /
C     DATA IMACH( 2) /        101 /
C     DATA IMACH( 3) /        102 /
C     DATA IMACH( 4) /        101 /
C     DATA IMACH( 5) /         64 /
C     DATA IMACH( 6) /          8 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         63 /
C     DATA IMACH( 9) / 777777777777777777777B /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         47 /
C     DATA IMACH(12) /      -8189 /
C     DATA IMACH(13) /       8190 /
C     DATA IMACH(14) /         94 /
C     DATA IMACH(15) /      -8099 /
C     DATA IMACH(16) /       8190 /
C
C     MACHINE CONSTANTS FOR THE DATA GENERAL ECLIPSE S/200
C
C     DATA IMACH( 1) /         11 /
C     DATA IMACH( 2) /         12 /
C     DATA IMACH( 3) /          8 /
C     DATA IMACH( 4) /         10 /
C     DATA IMACH( 5) /         16 /
C     DATA IMACH( 6) /          2 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         15 /
C     DATA IMACH( 9) /      32767 /
C     DATA IMACH(10) /         16 /
C     DATA IMACH(11) /          6 /
C     DATA IMACH(12) /        -64 /
C     DATA IMACH(13) /         63 /
C     DATA IMACH(14) /         14 /
C     DATA IMACH(15) /        -64 /
C     DATA IMACH(16) /         63 /
C
C     MACHINE CONSTANTS FOR THE DEC ALPHA
C     USING G_FLOAT
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1023 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE DEC ALPHA
C     USING IEEE_FLOAT
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE DEC RISC
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE DEC VAX
C     USING D_FLOATING
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         56 /
C     DATA IMACH(15) /       -127 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR THE DEC VAX
C     USING G_FLOATING
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1023 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE ELXSI 6400
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         32 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -126 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1022 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE HARRIS 220
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          0 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         24 /
C     DATA IMACH( 6) /          3 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         23 /
C     DATA IMACH( 9) /    8388607 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         23 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         38 /
C     DATA IMACH(15) /       -127 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR THE HONEYWELL 600/6000 SERIES
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /         43 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         36 /
C     DATA IMACH( 6) /          6 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         35 /
C     DATA IMACH( 9) / O377777777777 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         27 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         63 /
C     DATA IMACH(15) /       -127 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR THE HP 730
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE HP 2100
C     3 WORD DOUBLE PRECISION OPTION WITH FTN4
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          4 /
C     DATA IMACH( 4) /          1 /
C     DATA IMACH( 5) /         16 /
C     DATA IMACH( 6) /          2 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         15 /
C     DATA IMACH( 9) /      32767 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         23 /
C     DATA IMACH(12) /       -128 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         39 /
C     DATA IMACH(15) /       -128 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR THE HP 2100
C     4 WORD DOUBLE PRECISION OPTION WITH FTN4
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          4 /
C     DATA IMACH( 4) /          1 /
C     DATA IMACH( 5) /         16 /
C     DATA IMACH( 6) /          2 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         15 /
C     DATA IMACH( 9) /      32767 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         23 /
C     DATA IMACH(12) /       -128 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         55 /
C     DATA IMACH(15) /       -128 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR THE HP 9000
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          7 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         32 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -126 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1015 /
C     DATA IMACH(16) /       1017 /
C
C     MACHINE CONSTANTS FOR THE IBM 360/370 SERIES,
C     THE XEROX SIGMA 5/7/9, THE SEL SYSTEMS 85/86, AND
C     THE PERKIN ELMER (INTERDATA) 7/32.
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          7 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) /  Z7FFFFFFF /
C     DATA IMACH(10) /         16 /
C     DATA IMACH(11) /          6 /
C     DATA IMACH(12) /        -64 /
C     DATA IMACH(13) /         63 /
C     DATA IMACH(14) /         14 /
C     DATA IMACH(15) /        -64 /
C     DATA IMACH(16) /         63 /
C
C     MACHINE CONSTANTS FOR THE IBM PC
C
      DATA IMACH( 1) /          5 /
      DATA IMACH( 2) /          6 /
      DATA IMACH( 3) /          0 /
      DATA IMACH( 4) /          0 /
      DATA IMACH( 5) /         32 /
      DATA IMACH( 6) /          4 /
      DATA IMACH( 7) /          2 /
      DATA IMACH( 8) /         31 /
      DATA IMACH( 9) / 2147483647 /
      DATA IMACH(10) /          2 /
      DATA IMACH(11) /         24 /
      DATA IMACH(12) /       -125 /
      DATA IMACH(13) /        127 /
      DATA IMACH(14) /         53 /
      DATA IMACH(15) /      -1021 /
      DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE IBM RS 6000
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          0 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE INTEL i860
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE PDP-10 (KA PROCESSOR)
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         36 /
C     DATA IMACH( 6) /          5 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         35 /
C     DATA IMACH( 9) / "377777777777 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         27 /
C     DATA IMACH(12) /       -128 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         54 /
C     DATA IMACH(15) /       -101 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR THE PDP-10 (KI PROCESSOR)
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         36 /
C     DATA IMACH( 6) /          5 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         35 /
C     DATA IMACH( 9) / "377777777777 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         27 /
C     DATA IMACH(12) /       -128 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         62 /
C     DATA IMACH(15) /       -128 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR PDP-11 FORTRAN SUPPORTING
C     32-BIT INTEGER ARITHMETIC.
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         56 /
C     DATA IMACH(15) /       -127 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR PDP-11 FORTRAN SUPPORTING
C     16-BIT INTEGER ARITHMETIC.
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          5 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         16 /
C     DATA IMACH( 6) /          2 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         15 /
C     DATA IMACH( 9) /      32767 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         56 /
C     DATA IMACH(15) /       -127 /
C     DATA IMACH(16) /        127 /
C
C     MACHINE CONSTANTS FOR THE SILICON GRAPHICS
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE SUN
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -125 /
C     DATA IMACH(13) /        128 /
C     DATA IMACH(14) /         53 /
C     DATA IMACH(15) /      -1021 /
C     DATA IMACH(16) /       1024 /
C
C     MACHINE CONSTANTS FOR THE SUN
C     USING THE -r8 COMPILER OPTION
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          6 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         32 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         31 /
C     DATA IMACH( 9) / 2147483647 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         53 /
C     DATA IMACH(12) /      -1021 /
C     DATA IMACH(13) /       1024 /
C     DATA IMACH(14) /        113 /
C     DATA IMACH(15) /     -16381 /
C     DATA IMACH(16) /      16384 /
C
C     MACHINE CONSTANTS FOR THE UNIVAC 1100 SERIES FTN COMPILER
C
C     DATA IMACH( 1) /          5 /
C     DATA IMACH( 2) /          6 /
C     DATA IMACH( 3) /          1 /
C     DATA IMACH( 4) /          6 /
C     DATA IMACH( 5) /         36 /
C     DATA IMACH( 6) /          4 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         35 /
C     DATA IMACH( 9) / O377777777777 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         27 /
C     DATA IMACH(12) /       -128 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         60 /
C     DATA IMACH(15) /      -1024 /
C     DATA IMACH(16) /       1023 /
C
C     MACHINE CONSTANTS FOR THE Z80 MICROPROCESSOR
C
C     DATA IMACH( 1) /          1 /
C     DATA IMACH( 2) /          1 /
C     DATA IMACH( 3) /          0 /
C     DATA IMACH( 4) /          1 /
C     DATA IMACH( 5) /         16 /
C     DATA IMACH( 6) /          2 /
C     DATA IMACH( 7) /          2 /
C     DATA IMACH( 8) /         15 /
C     DATA IMACH( 9) /      32767 /
C     DATA IMACH(10) /          2 /
C     DATA IMACH(11) /         24 /
C     DATA IMACH(12) /       -127 /
C     DATA IMACH(13) /        127 /
C     DATA IMACH(14) /         56 /
C     DATA IMACH(15) /       -127 /
C     DATA IMACH(16) /        127 /
C
C***FIRST EXECUTABLE STATEMENT  I1MACH
      IF (I .LT. 1  .OR.  I .GT. 16) GO TO 10
C
      I1MACH = IMACH(I)
      RETURN
C
   10 CONTINUE
      WRITE (UNIT = OUTPUT, FMT = 9000)
 9000 FORMAT ('1ERROR    1 IN I1MACH - I OUT OF BOUNDS')
C
C     CALL FDUMP
C
      STOP
      END
*DECK J4SAVE
      FUNCTION J4SAVE (IWHICH, IVALUE, ISET)
C***BEGIN PROLOGUE  J4SAVE
C***SUBSIDIARY
C***PURPOSE  Save or recall global variables needed by error
C            handling routines.
C***LIBRARY   SLATEC (XERROR)
C***TYPE      INTEGER (J4SAVE-I)
C***KEYWORDS  ERROR MESSAGES, ERROR NUMBER, RECALL, SAVE, XERROR
C***AUTHOR  Jones, R. E., (SNLA)
C***DESCRIPTION
C
C     Abstract
C        J4SAVE saves and recalls several global variables needed
C        by the library error handling routines.
C
C     Description of Parameters
C      --Input--
C        IWHICH - Index of item desired.
C                = 1 Refers to current error number.
C                = 2 Refers to current error control flag.
C                = 3 Refers to current unit number to which error
C                    messages are to be sent.  (0 means use standard.)
C                = 4 Refers to the maximum number of times any
C                     message is to be printed (as set by XERMAX).
C                = 5 Refers to the total number of units to which
C                     each error message is to be written.
C                = 6 Refers to the 2nd unit for error messages
C                = 7 Refers to the 3rd unit for error messages
C                = 8 Refers to the 4th unit for error messages
C                = 9 Refers to the 5th unit for error messages
C        IVALUE - The value to be set for the IWHICH-th parameter,
C                 if ISET is .TRUE. .
C        ISET   - If ISET=.TRUE., the IWHICH-th parameter will BE
C                 given the value, IVALUE.  If ISET=.FALSE., the
C                 IWHICH-th parameter will be unchanged, and IVALUE
C                 is a dummy parameter.
C      --Output--
C        The (old) value of the IWHICH-th parameter will be returned
C        in the function value, J4SAVE.
C
C***SEE ALSO  XERMSG
C***REFERENCES  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC
C                 Error-handling Package, SAND82-0800, Sandia
C                 Laboratories, 1982.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900205  Minor modifications to prologue.  (WRB)
C   900402  Added TYPE section.  (WRB)
C   910411  Added KEYWORDS section.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  J4SAVE
      LOGICAL ISET
      INTEGER IPARAM(9)
      SAVE IPARAM
      DATA IPARAM(1),IPARAM(2),IPARAM(3),IPARAM(4)/0,2,0,10/
      DATA IPARAM(5)/1/
      DATA IPARAM(6),IPARAM(7),IPARAM(8),IPARAM(9)/0,0,0,0/
C***FIRST EXECUTABLE STATEMENT  J4SAVE
      J4SAVE = IPARAM(IWHICH)
      IF (ISET) IPARAM(IWHICH) = IVALUE
      RETURN
      END
*DECK R1MACH
      REAL FUNCTION R1MACH (I)
C***BEGIN PROLOGUE  R1MACH
C***PURPOSE  Return floating point machine dependent constants.
C***LIBRARY   SLATEC
C***CATEGORY  R1
C***TYPE      SINGLE PRECISION (R1MACH-S, D1MACH-D)
C***KEYWORDS  MACHINE CONSTANTS
C***AUTHOR  Fox, P. A., (Bell Labs)
C           Hall, A. D., (Bell Labs)
C           Schryer, N. L., (Bell Labs)
C***DESCRIPTION
C
C   R1MACH can be used to obtain machine-dependent parameters for the
C   local machine environment.  It is a function subprogram with one
C   (input) argument, and can be referenced as follows:
C
C        A = R1MACH(I)
C
C   where I=1,...,5.  The (output) value of A above is determined by
C   the (input) value of I.  The results for various values of I are
C   discussed below.
C
C   R1MACH(1) = B**(EMIN-1), the smallest positive magnitude.
C   R1MACH(2) = B**EMAX*(1 - B**(-T)), the largest magnitude.
C   R1MACH(3) = B**(-T), the smallest relative spacing.
C   R1MACH(4) = B**(1-T), the largest relative spacing.
C   R1MACH(5) = LOG10(B)
C
C   Assume single precision numbers are represented in the T-digit,
C   base-B form
C
C              sign (B**E)*( (X(1)/B) + ... + (X(T)/B**T) )
C
C   where 0 .LE. X(I) .LT. B for I=1,...,T, 0 .LT. X(1), and
C   EMIN .LE. E .LE. EMAX.
C
C   The values of B, T, EMIN and EMAX are provided in I1MACH as
C   follows:
C   I1MACH(10) = B, the base.
C   I1MACH(11) = T, the number of base-B digits.
C   I1MACH(12) = EMIN, the smallest exponent E.
C   I1MACH(13) = EMAX, the largest exponent E.
C
C   To alter this function for a particular environment, the desired
C   set of DATA statements should be activated by removing the C from
C   column 1.  Also, the values of R1MACH(1) - R1MACH(4) should be
C   checked for consistency with the local operating system.
C
C***REFERENCES  P. A. Fox, A. D. Hall and N. L. Schryer, Framework for
C                 a portable library, ACM Transactions on Mathematical
C                 Software 4, 2 (June 1978), pp. 177-188.
C***ROUTINES CALLED  XERMSG
C***REVISION HISTORY  (YYMMDD)
C   790101  DATE WRITTEN
C   890213  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900618  Added DEC RISC constants.  (WRB)
C   900723  Added IBM RS 6000 constants.  (WRB)
C   910710  Added HP 730 constants.  (SMR)
C   911114  Added Convex IEEE constants.  (WRB)
C   920121  Added SUN -r8 compiler option constants.  (WRB)
C   920229  Added Touchstone Delta i860 constants.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C   920625  Added CONVEX -p8 and -pd8 compiler option constants.
C           (BKS, WRB)
C   930201  Added DEC Alpha and SGI constants.  (RWC and WRB)
C***END PROLOGUE  R1MACH
C
      INTEGER SMALL(2)
      INTEGER LARGE(2)
      INTEGER RIGHT(2)
      INTEGER DIVER(2)
      INTEGER LOG10(2)
C
      REAL RMACH(5)
      SAVE RMACH
C
      EQUIVALENCE (RMACH(1),SMALL(1))
      EQUIVALENCE (RMACH(2),LARGE(1))
      EQUIVALENCE (RMACH(3),RIGHT(1))
      EQUIVALENCE (RMACH(4),DIVER(1))
      EQUIVALENCE (RMACH(5),LOG10(1))
C
C     MACHINE CONSTANTS FOR THE AMIGA
C     ABSOFT FORTRAN COMPILER USING THE 68020/68881 COMPILER OPTION
C
C     DATA SMALL(1) / Z'00800000' /
C     DATA LARGE(1) / Z'7F7FFFFF' /
C     DATA RIGHT(1) / Z'33800000' /
C     DATA DIVER(1) / Z'34000000' /
C     DATA LOG10(1) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE AMIGA
C     ABSOFT FORTRAN COMPILER USING SOFTWARE FLOATING POINT
C
C     DATA SMALL(1) / Z'00800000' /
C     DATA LARGE(1) / Z'7EFFFFFF' /
C     DATA RIGHT(1) / Z'33800000' /
C     DATA DIVER(1) / Z'34000000' /
C     DATA LOG10(1) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE APOLLO
C
C     DATA SMALL(1) / 16#00800000 /
C     DATA LARGE(1) / 16#7FFFFFFF /
C     DATA RIGHT(1) / 16#33800000 /
C     DATA DIVER(1) / 16#34000000 /
C     DATA LOG10(1) / 16#3E9A209B /
C
C     MACHINE CONSTANTS FOR THE BURROUGHS 1700 SYSTEM
C
C     DATA RMACH(1) / Z400800000 /
C     DATA RMACH(2) / Z5FFFFFFFF /
C     DATA RMACH(3) / Z4E9800000 /
C     DATA RMACH(4) / Z4EA800000 /
C     DATA RMACH(5) / Z500E730E8 /
C
C     MACHINE CONSTANTS FOR THE BURROUGHS 5700/6700/7700 SYSTEMS
C
C     DATA RMACH(1) / O1771000000000000 /
C     DATA RMACH(2) / O0777777777777777 /
C     DATA RMACH(3) / O1311000000000000 /
C     DATA RMACH(4) / O1301000000000000 /
C     DATA RMACH(5) / O1157163034761675 /
C
C     MACHINE CONSTANTS FOR THE CDC 170/180 SERIES USING NOS/VE
C
C     DATA RMACH(1) / Z"3001800000000000" /
C     DATA RMACH(2) / Z"4FFEFFFFFFFFFFFE" /
C     DATA RMACH(3) / Z"3FD2800000000000" /
C     DATA RMACH(4) / Z"3FD3800000000000" /
C     DATA RMACH(5) / Z"3FFF9A209A84FBCF" /
C
C     MACHINE CONSTANTS FOR THE CDC 6000/7000 SERIES
C
C     DATA RMACH(1) / 00564000000000000000B /
C     DATA RMACH(2) / 37767777777777777776B /
C     DATA RMACH(3) / 16414000000000000000B /
C     DATA RMACH(4) / 16424000000000000000B /
C     DATA RMACH(5) / 17164642023241175720B /
C
C     MACHINE CONSTANTS FOR THE CELERITY C1260
C
C     DATA SMALL(1) / Z'00800000' /
C     DATA LARGE(1) / Z'7F7FFFFF' /
C     DATA RIGHT(1) / Z'33800000' /
C     DATA DIVER(1) / Z'34000000' /
C     DATA LOG10(1) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE CONVEX
C     USING THE -fn COMPILER OPTION
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7FFFFFFF' /
C     DATA RMACH(3) / Z'34800000' /
C     DATA RMACH(4) / Z'35000000' /
C     DATA RMACH(5) / Z'3F9A209B' /
C
C     MACHINE CONSTANTS FOR THE CONVEX
C     USING THE -fi COMPILER OPTION
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7F7FFFFF' /
C     DATA RMACH(3) / Z'33800000' /
C     DATA RMACH(4) / Z'34000000' /
C     DATA RMACH(5) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE CONVEX
C     USING THE -p8 OR -pd8 COMPILER OPTION
C
C     DATA RMACH(1) / Z'0010000000000000' /
C     DATA RMACH(2) / Z'7FFFFFFFFFFFFFFF' /
C     DATA RMACH(3) / Z'3CC0000000000000' /
C     DATA RMACH(4) / Z'3CD0000000000000' /
C     DATA RMACH(5) / Z'3FF34413509F79FF' /
C
C     MACHINE CONSTANTS FOR THE CRAY
C
C     DATA RMACH(1) / 200034000000000000000B /
C     DATA RMACH(2) / 577767777777777777776B /
C     DATA RMACH(3) / 377224000000000000000B /
C     DATA RMACH(4) / 377234000000000000000B /
C     DATA RMACH(5) / 377774642023241175720B /
C
C     MACHINE CONSTANTS FOR THE DATA GENERAL ECLIPSE S/200
C     NOTE - IT MAY BE APPROPRIATE TO INCLUDE THE FOLLOWING CARD -
C     STATIC RMACH(5)
C
C     DATA SMALL /    20K,       0 /
C     DATA LARGE / 77777K, 177777K /
C     DATA RIGHT / 35420K,       0 /
C     DATA DIVER / 36020K,       0 /
C     DATA LOG10 / 40423K,  42023K /
C
C     MACHINE CONSTANTS FOR THE DEC ALPHA
C     USING G_FLOAT
C
C     DATA RMACH(1) / '00000080'X /
C     DATA RMACH(2) / 'FFFF7FFF'X /
C     DATA RMACH(3) / '00003480'X /
C     DATA RMACH(4) / '00003500'X /
C     DATA RMACH(5) / '209B3F9A'X /
C
C     MACHINE CONSTANTS FOR THE DEC ALPHA
C     USING IEEE_FLOAT
C
C     DATA RMACH(1) / '00800000'X /
C     DATA RMACH(2) / '7F7FFFFF'X /
C     DATA RMACH(3) / '33800000'X /
C     DATA RMACH(4) / '34000000'X /
C     DATA RMACH(5) / '3E9A209B'X /
C
C     MACHINE CONSTANTS FOR THE DEC RISC
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7F7FFFFF' /
C     DATA RMACH(3) / Z'33800000' /
C     DATA RMACH(4) / Z'34000000' /
C     DATA RMACH(5) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE DEC VAX
C     (EXPRESSED IN INTEGER AND HEXADECIMAL)
C     THE HEX FORMAT BELOW MAY NOT BE SUITABLE FOR UNIX SYSTEMS
C     THE INTEGER FORMAT SHOULD BE OK FOR UNIX SYSTEMS
C
C     DATA SMALL(1) /       128 /
C     DATA LARGE(1) /    -32769 /
C     DATA RIGHT(1) /     13440 /
C     DATA DIVER(1) /     13568 /
C     DATA LOG10(1) / 547045274 /
C
C     DATA SMALL(1) / Z00000080 /
C     DATA LARGE(1) / ZFFFF7FFF /
C     DATA RIGHT(1) / Z00003480 /
C     DATA DIVER(1) / Z00003500 /
C     DATA LOG10(1) / Z209B3F9A /
C
C     MACHINE CONSTANTS FOR THE ELXSI 6400
C     (ASSUMING REAL*4 IS THE DEFAULT REAL)
C
C     DATA SMALL(1) / '00800000'X /
C     DATA LARGE(1) / '7F7FFFFF'X /
C     DATA RIGHT(1) / '33800000'X /
C     DATA DIVER(1) / '34000000'X /
C     DATA LOG10(1) / '3E9A209B'X /
C
C     MACHINE CONSTANTS FOR THE HARRIS 220
C
C     DATA SMALL(1), SMALL(2) / '20000000, '00000201 /
C     DATA LARGE(1), LARGE(2) / '37777777, '00000177 /
C     DATA RIGHT(1), RIGHT(2) / '20000000, '00000352 /
C     DATA DIVER(1), DIVER(2) / '20000000, '00000353 /
C     DATA LOG10(1), LOG10(2) / '23210115, '00000377 /
C
C     MACHINE CONSTANTS FOR THE HONEYWELL 600/6000 SERIES
C
C     DATA RMACH(1) / O402400000000 /
C     DATA RMACH(2) / O376777777777 /
C     DATA RMACH(3) / O714400000000 /
C     DATA RMACH(4) / O716400000000 /
C     DATA RMACH(5) / O776464202324 /
C
C     MACHINE CONSTANTS FOR THE HP 730
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7F7FFFFF' /
C     DATA RMACH(3) / Z'33800000' /
C     DATA RMACH(4) / Z'34000000' /
C     DATA RMACH(5) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE HP 2100
C     3 WORD DOUBLE PRECISION WITH FTN4
C
C     DATA SMALL(1), SMALL(2) / 40000B,       1 /
C     DATA LARGE(1), LARGE(2) / 77777B, 177776B /
C     DATA RIGHT(1), RIGHT(2) / 40000B,    325B /
C     DATA DIVER(1), DIVER(2) / 40000B,    327B /
C     DATA LOG10(1), LOG10(2) / 46420B,  46777B /
C
C     MACHINE CONSTANTS FOR THE HP 2100
C     4 WORD DOUBLE PRECISION WITH FTN4
C
C     DATA SMALL(1), SMALL(2) / 40000B,       1 /
C     DATA LARGE(1), LARGE(2) / 77777B, 177776B /
C     DATA RIGHT(1), RIGHT(2) / 40000B,    325B /
C     DATA DIVER(1), DIVER(2) / 40000B,    327B /
C     DATA LOG10(1), LOG10(2) / 46420B,  46777B /
C
C     MACHINE CONSTANTS FOR THE HP 9000
C
C     DATA SMALL(1) / 00004000000B /
C     DATA LARGE(1) / 17677777777B /
C     DATA RIGHT(1) / 06340000000B /
C     DATA DIVER(1) / 06400000000B /
C     DATA LOG10(1) / 07646420233B /
C
C     MACHINE CONSTANTS FOR THE IBM 360/370 SERIES,
C     THE XEROX SIGMA 5/7/9, THE SEL SYSTEMS 85/86  AND
C     THE PERKIN ELMER (INTERDATA) 7/32.
C
C     DATA RMACH(1) / Z00100000 /
C     DATA RMACH(2) / Z7FFFFFFF /
C     DATA RMACH(3) / Z3B100000 /
C     DATA RMACH(4) / Z3C100000 /
C     DATA RMACH(5) / Z41134413 /
C
C     MACHINE CONSTANTS FOR THE IBM PC
C
      DATA SMALL(1) /     8420761 /
      DATA LARGE(1) /  2139081118 /
      DATA RIGHT(1) /   863997169 /
      DATA DIVER(1) /   872385777 /
      DATA LOG10(1) /  1050288283 /
C     DATA SMALL(1) / 1.18E-38      /
C     DATA LARGE(1) / 3.40E+38      /
C     DATA RIGHT(1) / 0.595E-07     /
C     DATA DIVER(1) / 1.19E-07      /
C     DATA LOG10(1) / 0.30102999566 /
C
C     MACHINE CONSTANTS FOR THE IBM RS 6000
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7F7FFFFF' /
C     DATA RMACH(3) / Z'33800000' /
C     DATA RMACH(4) / Z'34000000' /
C     DATA RMACH(5) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE INTEL i860
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7F7FFFFF' /
C     DATA RMACH(3) / Z'33800000' /
C     DATA RMACH(4) / Z'34000000' /
C     DATA RMACH(5) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE PDP-10 (KA OR KI PROCESSOR)
C
C     DATA RMACH(1) / "000400000000 /
C     DATA RMACH(2) / "377777777777 /
C     DATA RMACH(3) / "146400000000 /
C     DATA RMACH(4) / "147400000000 /
C     DATA RMACH(5) / "177464202324 /
C
C     MACHINE CONSTANTS FOR PDP-11 FORTRAN SUPPORTING
C     32-BIT INTEGERS (EXPRESSED IN INTEGER AND OCTAL).
C
C     DATA SMALL(1) /    8388608 /
C     DATA LARGE(1) / 2147483647 /
C     DATA RIGHT(1) /  880803840 /
C     DATA DIVER(1) /  889192448 /
C     DATA LOG10(1) / 1067065499 /
C
C     DATA RMACH(1) / O00040000000 /
C     DATA RMACH(2) / O17777777777 /
C     DATA RMACH(3) / O06440000000 /
C     DATA RMACH(4) / O06500000000 /
C     DATA RMACH(5) / O07746420233 /
C
C     MACHINE CONSTANTS FOR PDP-11 FORTRAN SUPPORTING
C     16-BIT INTEGERS  (EXPRESSED IN INTEGER AND OCTAL).
C
C     DATA SMALL(1), SMALL(2) /   128,     0 /
C     DATA LARGE(1), LARGE(2) / 32767,    -1 /
C     DATA RIGHT(1), RIGHT(2) / 13440,     0 /
C     DATA DIVER(1), DIVER(2) / 13568,     0 /
C     DATA LOG10(1), LOG10(2) / 16282,  8347 /
C
C     DATA SMALL(1), SMALL(2) / O000200, O000000 /
C     DATA LARGE(1), LARGE(2) / O077777, O177777 /
C     DATA RIGHT(1), RIGHT(2) / O032200, O000000 /
C     DATA DIVER(1), DIVER(2) / O032400, O000000 /
C     DATA LOG10(1), LOG10(2) / O037632, O020233 /
C
C     MACHINE CONSTANTS FOR THE SILICON GRAPHICS
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7F7FFFFF' /
C     DATA RMACH(3) / Z'33800000' /
C     DATA RMACH(4) / Z'34000000' /
C     DATA RMACH(5) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE SUN
C
C     DATA RMACH(1) / Z'00800000' /
C     DATA RMACH(2) / Z'7F7FFFFF' /
C     DATA RMACH(3) / Z'33800000' /
C     DATA RMACH(4) / Z'34000000' /
C     DATA RMACH(5) / Z'3E9A209B' /
C
C     MACHINE CONSTANTS FOR THE SUN
C     USING THE -r8 COMPILER OPTION
C
C     DATA RMACH(1) / Z'0010000000000000' /
C     DATA RMACH(2) / Z'7FEFFFFFFFFFFFFF' /
C     DATA RMACH(3) / Z'3CA0000000000000' /
C     DATA RMACH(4) / Z'3CB0000000000000' /
C     DATA RMACH(5) / Z'3FD34413509F79FF' /
C
C     MACHINE CONSTANTS FOR THE UNIVAC 1100 SERIES
C
C     DATA RMACH(1) / O000400000000 /
C     DATA RMACH(2) / O377777777777 /
C     DATA RMACH(3) / O146400000000 /
C     DATA RMACH(4) / O147400000000 /
C     DATA RMACH(5) / O177464202324 /
C
C     MACHINE CONSTANTS FOR THE Z80 MICROPROCESSOR
C
C     DATA SMALL(1), SMALL(2) /     0,    256/
C     DATA LARGE(1), LARGE(2) /    -1,   -129/
C     DATA RIGHT(1), RIGHT(2) /     0,  26880/
C     DATA DIVER(1), DIVER(2) /     0,  27136/
C     DATA LOG10(1), LOG10(2) /  8347,  32538/
C
C***FIRST EXECUTABLE STATEMENT  R1MACH
      IF (I .LT. 1 .OR. I .GT. 5) CALL XERMSG ('SLATEC', 'R1MACH',
     +   'I OUT OF BOUNDS', 1, 2)
C
      R1MACH = RMACH(I)
      RETURN
C
      END
*DECK XERCNT
      SUBROUTINE XERCNT (LIBRAR, SUBROU, MESSG, NERR, LEVEL, KONTRL)
C***BEGIN PROLOGUE  XERCNT
C***SUBSIDIARY
C***PURPOSE  Allow user control over handling of errors.
C***LIBRARY   SLATEC (XERROR)
C***CATEGORY  R3C
C***TYPE      ALL (XERCNT-A)
C***KEYWORDS  ERROR, XERROR
C***AUTHOR  Jones, R. E., (SNLA)
C***DESCRIPTION
C
C     Abstract
C        Allows user control over handling of individual errors.
C        Just after each message is recorded, but before it is
C        processed any further (i.e., before it is printed or
C        a decision to abort is made), a call is made to XERCNT.
C        If the user has provided his own version of XERCNT, he
C        can then override the value of KONTROL used in processing
C        this message by redefining its value.
C        KONTRL may be set to any value from -2 to 2.
C        The meanings for KONTRL are the same as in XSETF, except
C        that the value of KONTRL changes only for this message.
C        If KONTRL is set to a value outside the range from -2 to 2,
C        it will be moved back into that range.
C
C     Description of Parameters
C
C      --Input--
C        LIBRAR - the library that the routine is in.
C        SUBROU - the subroutine that XERMSG is being called from
C        MESSG  - the first 20 characters of the error message.
C        NERR   - same as in the call to XERMSG.
C        LEVEL  - same as in the call to XERMSG.
C        KONTRL - the current value of the control flag as set
C                 by a call to XSETF.
C
C      --Output--
C        KONTRL - the new value of KONTRL.  If KONTRL is not
C                 defined, it will remain at its original value.
C                 This changed value of control affects only
C                 the current occurrence of the current message.
C
C***REFERENCES  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC
C                 Error-handling Package, SAND82-0800, Sandia
C                 Laboratories, 1982.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   861211  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900206  Routine changed from user-callable to subsidiary.  (WRB)
C   900510  Changed calling sequence to include LIBRARY and SUBROUTINE
C           names, changed routine name from XERCTL to XERCNT.  (RWC)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  XERCNT
      CHARACTER*(*) LIBRAR, SUBROU, MESSG
C***FIRST EXECUTABLE STATEMENT  XERCNT
      RETURN
      END
*DECK XERHLT
      SUBROUTINE XERHLT (MESSG)
C***BEGIN PROLOGUE  XERHLT
C***SUBSIDIARY
C***PURPOSE  Abort program execution and print error message.
C***LIBRARY   SLATEC (XERROR)
C***CATEGORY  R3C
C***TYPE      ALL (XERHLT-A)
C***KEYWORDS  ABORT PROGRAM EXECUTION, ERROR, XERROR
C***AUTHOR  Jones, R. E., (SNLA)
C***DESCRIPTION
C
C     Abstract
C        ***Note*** machine dependent routine
C        XERHLT aborts the execution of the program.
C        The error message causing the abort is given in the calling
C        sequence, in case one needs it for printing on a dayfile,
C        for example.
C
C     Description of Parameters
C        MESSG is as in XERMSG.
C
C***REFERENCES  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC
C                 Error-handling Package, SAND82-0800, Sandia
C                 Laboratories, 1982.
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   861211  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900206  Routine changed from user-callable to subsidiary.  (WRB)
C   900510  Changed calling sequence to delete length of character
C           and changed routine name from XERABT to XERHLT.  (RWC)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  XERHLT
      CHARACTER*(*) MESSG
C***FIRST EXECUTABLE STATEMENT  XERHLT
      STOP
      END
*DECK XERMSG
      SUBROUTINE XERMSG (LIBRAR, SUBROU, MESSG, NERR, LEVEL)
C***BEGIN PROLOGUE  XERMSG
C***PURPOSE  Process error messages for SLATEC and other libraries.
C***LIBRARY   SLATEC (XERROR)
C***CATEGORY  R3C
C***TYPE      ALL (XERMSG-A)
C***KEYWORDS  ERROR MESSAGE, XERROR
C***AUTHOR  Fong, Kirby, (NMFECC at LLNL)
C***DESCRIPTION
C
C   XERMSG processes a diagnostic message in a manner determined by the
C   value of LEVEL and the current value of the library error control
C   flag, KONTRL.  See subroutine XSETF for details.
C
C    LIBRAR   A character constant (or character variable) with the name
C             of the library.  This will be 'SLATEC' for the SLATEC
C             Common Math Library.  The error handling package is
C             general enough to be used by many libraries
C             simultaneously, so it is desirable for the routine that
C             detects and reports an error to identify the library name
C             as well as the routine name.
C
C    SUBROU   A character constant (or character variable) with the name
C             of the routine that detected the error.  Usually it is the
C             name of the routine that is calling XERMSG.  There are
C             some instances where a user callable library routine calls
C             lower level subsidiary routines where the error is
C             detected.  In such cases it may be more informative to
C             supply the name of the routine the user called rather than
C             the name of the subsidiary routine that detected the
C             error.
C
C    MESSG    A character constant (or character variable) with the text
C             of the error or warning message.  In the example below,
C             the message is a character constant that contains a
C             generic message.
C
C                   CALL XERMSG ('SLATEC', 'MMPY',
C                  *'THE ORDER OF THE MATRIX EXCEEDS THE ROW DIMENSION',
C                  *3, 1)
C
C             It is possible (and is sometimes desirable) to generate a
C             specific message--e.g., one that contains actual numeric
C             values.  Specific numeric values can be converted into
C             character strings using formatted WRITE statements into
C             character variables.  This is called standard Fortran
C             internal file I/O and is exemplified in the first three
C             lines of the following example.  You can also catenate
C             substrings of characters to construct the error message.
C             Here is an example showing the use of both writing to
C             an internal file and catenating character strings.
C
C                   CHARACTER*5 CHARN, CHARL
C                   WRITE (CHARN,10) N
C                   WRITE (CHARL,10) LDA
C                10 FORMAT(I5)
C                   CALL XERMSG ('SLATEC', 'MMPY', 'THE ORDER'//CHARN//
C                  *   ' OF THE MATRIX EXCEEDS ITS ROW DIMENSION OF'//
C                  *   CHARL, 3, 1)
C
C             There are two subtleties worth mentioning.  One is that
C             the // for character catenation is used to construct the
C             error message so that no single character constant is
C             continued to the next line.  This avoids confusion as to
C             whether there are trailing blanks at the end of the line.
C             The second is that by catenating the parts of the message
C             as an actual argument rather than encoding the entire
C             message into one large character variable, we avoid
C             having to know how long the message will be in order to
C             declare an adequate length for that large character
C             variable.  XERMSG calls XERPRN to print the message using
C             multiple lines if necessary.  If the message is very long,
C             XERPRN will break it into pieces of 72 characters (as
C             requested by XERMSG) for printing on multiple lines.
C             Also, XERMSG asks XERPRN to prefix each line with ' *  '
C             so that the total line length could be 76 characters.
C             Note also that XERPRN scans the error message backwards
C             to ignore trailing blanks.  Another feature is that
C             the substring '$$' is treated as a new line sentinel
C             by XERPRN.  If you want to construct a multiline
C             message without having to count out multiples of 72
C             characters, just use '$$' as a separator.  '$$'
C             obviously must occur within 72 characters of the
C             start of each line to have its intended effect since
C             XERPRN is asked to wrap around at 72 characters in
C             addition to looking for '$$'.
C
C    NERR     An integer value that is chosen by the library routine's
C             author.  It must be in the range -99 to 999 (three
C             printable digits).  Each distinct error should have its
C             own error number.  These error numbers should be described
C             in the machine readable documentation for the routine.
C             The error numbers need be unique only within each routine,
C             so it is reasonable for each routine to start enumerating
C             errors from 1 and proceeding to the next integer.
C
C    LEVEL    An integer value in the range 0 to 2 that indicates the
C             level (severity) of the error.  Their meanings are
C
C            -1  A warning message.  This is used if it is not clear
C                that there really is an error, but the user's attention
C                may be needed.  An attempt is made to only print this
C                message once.
C
C             0  A warning message.  This is used if it is not clear
C                that there really is an error, but the user's attention
C                may be needed.
C
C             1  A recoverable error.  This is used even if the error is
C                so serious that the routine cannot return any useful
C                answer.  If the user has told the error package to
C                return after recoverable errors, then XERMSG will
C                return to the Library routine which can then return to
C                the user's routine.  The user may also permit the error
C                package to terminate the program upon encountering a
C                recoverable error.
C
C             2  A fatal error.  XERMSG will not return to its caller
C                after it receives a fatal error.  This level should
C                hardly ever be used; it is much better to allow the
C                user a chance to recover.  An example of one of the few
C                cases in which it is permissible to declare a level 2
C                error is a reverse communication Library routine that
C                is likely to be called repeatedly until it integrates
C                across some interval.  If there is a serious error in
C                the input such that another step cannot be taken and
C                the Library routine is called again without the input
C                error having been corrected by the caller, the Library
C                routine will probably be called forever with improper
C                input.  In this case, it is reasonable to declare the
C                error to be fatal.
C
C    Each of the arguments to XERMSG is input; none will be modified by
C    XERMSG.  A routine may make multiple calls to XERMSG with warning
C    level messages; however, after a call to XERMSG with a recoverable
C    error, the routine should return to the user.  Do not try to call
C    XERMSG with a second recoverable error after the first recoverable
C    error because the error package saves the error number.  The user
C    can retrieve this error number by calling another entry point in
C    the error handling package and then clear the error number when
C    recovering from the error.  Calling XERMSG in succession causes the
C    old error number to be overwritten by the latest error number.
C    This is considered harmless for error numbers associated with
C    warning messages but must not be done for error numbers of serious
C    errors.  After a call to XERMSG with a recoverable error, the user
C    must be given a chance to call NUMXER or XERCLR to retrieve or
C    clear the error number.
C***REFERENCES  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC
C                 Error-handling Package, SAND82-0800, Sandia
C                 Laboratories, 1982.
C***ROUTINES CALLED  FDUMP, J4SAVE, XERCNT, XERHLT, XERPRN, XERSVE
C***REVISION HISTORY  (YYMMDD)
C   880101  DATE WRITTEN
C   880621  REVISED AS DIRECTED AT SLATEC CML MEETING OF FEBRUARY 1988.
C           THERE ARE TWO BASIC CHANGES.
C           1.  A NEW ROUTINE, XERPRN, IS USED INSTEAD OF XERPRT TO
C               PRINT MESSAGES.  THIS ROUTINE WILL BREAK LONG MESSAGES
C               INTO PIECES FOR PRINTING ON MULTIPLE LINES.  '$$' IS
C               ACCEPTED AS A NEW LINE SENTINEL.  A PREFIX CAN BE
C               ADDED TO EACH LINE TO BE PRINTED.  XERMSG USES EITHER
C               ' ***' OR ' *  ' AND LONG MESSAGES ARE BROKEN EVERY
C               72 CHARACTERS (AT MOST) SO THAT THE MAXIMUM LINE
C               LENGTH OUTPUT CAN NOW BE AS GREAT AS 76.
C           2.  THE TEXT OF ALL MESSAGES IS NOW IN UPPER CASE SINCE THE
C               FORTRAN STANDARD DOCUMENT DOES NOT ADMIT THE EXISTENCE
C               OF LOWER CASE.
C   880708  REVISED AFTER THE SLATEC CML MEETING OF JUNE 29 AND 30.
C           THE PRINCIPAL CHANGES ARE
C           1.  CLARIFY COMMENTS IN THE PROLOGUES
C           2.  RENAME XRPRNT TO XERPRN
C           3.  REWORK HANDLING OF '$$' IN XERPRN TO HANDLE BLANK LINES
C               SIMILAR TO THE WAY FORMAT STATEMENTS HANDLE THE /
C               CHARACTER FOR NEW RECORDS.
C   890706  REVISED WITH THE HELP OF FRED FRITSCH AND REG CLEMENS TO
C           CLEAN UP THE CODING.
C   890721  REVISED TO USE NEW FEATURE IN XERPRN TO COUNT CHARACTERS IN
C           PREFIX.
C   891013  REVISED TO CORRECT COMMENTS.
C   891214  Prologue converted to Version 4.0 format.  (WRB)
C   900510  Changed test on NERR to be -9999999 < NERR < 99999999, but
C           NERR .ne. 0, and on LEVEL to be -2 < LEVEL < 3.  Added
C           LEVEL=-1 logic, changed calls to XERSAV to XERSVE, and
C           XERCTL to XERCNT.  (RWC)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  XERMSG
      CHARACTER*(*) LIBRAR, SUBROU, MESSG
      CHARACTER*8 XLIBR, XSUBR
      CHARACTER*72  TEMP
      CHARACTER*20  LFIRST
C***FIRST EXECUTABLE STATEMENT  XERMSG
      LKNTRL = J4SAVE (2, 0, .FALSE.)
      MAXMES = J4SAVE (4, 0, .FALSE.)
C
C       LKNTRL IS A LOCAL COPY OF THE CONTROL FLAG KONTRL.
C       MAXMES IS THE MAXIMUM NUMBER OF TIMES ANY PARTICULAR MESSAGE
C          SHOULD BE PRINTED.
C
C       WE PRINT A FATAL ERROR MESSAGE AND TERMINATE FOR AN ERROR IN
C          CALLING XERMSG.  THE ERROR NUMBER SHOULD BE POSITIVE,
C          AND THE LEVEL SHOULD BE BETWEEN 0 AND 2.
C
      IF (NERR.LT.-9999999 .OR. NERR.GT.99999999 .OR. NERR.EQ.0 .OR.
     *   LEVEL.LT.-1 .OR. LEVEL.GT.2) THEN
         CALL XERPRN (' ***', -1, 'FATAL ERROR IN...$$ ' //
     *      'XERMSG -- INVALID ERROR NUMBER OR LEVEL$$ '//
     *      'JOB ABORT DUE TO FATAL ERROR.', 72)
         CALL XERSVE (' ', ' ', ' ', 0, 0, 0, KDUMMY)
         CALL XERHLT (' ***XERMSG -- INVALID INPUT')
         RETURN
      ENDIF
C
C       RECORD THE MESSAGE.
C
      I = J4SAVE (1, NERR, .TRUE.)
      CALL XERSVE (LIBRAR, SUBROU, MESSG, 1, NERR, LEVEL, KOUNT)
C
C       HANDLE PRINT-ONCE WARNING MESSAGES.
C
      IF (LEVEL.EQ.-1 .AND. KOUNT.GT.1) RETURN
C
C       ALLOW TEMPORARY USER OVERRIDE OF THE CONTROL FLAG.
C
      XLIBR  = LIBRAR
      XSUBR  = SUBROU
      LFIRST = MESSG
      LERR   = NERR
      LLEVEL = LEVEL
      CALL XERCNT (XLIBR, XSUBR, LFIRST, LERR, LLEVEL, LKNTRL)
C
      LKNTRL = MAX(-2, MIN(2,LKNTRL))
      MKNTRL = ABS(LKNTRL)
C
C       SKIP PRINTING IF THE CONTROL FLAG VALUE AS RESET IN XERCNT IS
C       ZERO AND THE ERROR IS NOT FATAL.
C
      IF (LEVEL.LT.2 .AND. LKNTRL.EQ.0) GO TO 30
      IF (LEVEL.EQ.0 .AND. KOUNT.GT.MAXMES) GO TO 30
      IF (LEVEL.EQ.1 .AND. KOUNT.GT.MAXMES .AND. MKNTRL.EQ.1) GO TO 30
      IF (LEVEL.EQ.2 .AND. KOUNT.GT.MAX(1,MAXMES)) GO TO 30
C
C       ANNOUNCE THE NAMES OF THE LIBRARY AND SUBROUTINE BY BUILDING A
C       MESSAGE IN CHARACTER VARIABLE TEMP (NOT EXCEEDING 66 CHARACTERS)
C       AND SENDING IT OUT VIA XERPRN.  PRINT ONLY IF CONTROL FLAG
C       IS NOT ZERO.
C
      IF (LKNTRL .NE. 0) THEN
         TEMP(1:21) = 'MESSAGE FROM ROUTINE '
         I = MIN(LEN(SUBROU), 16)
         TEMP(22:21+I) = SUBROU(1:I)
         TEMP(22+I:33+I) = ' IN LIBRARY '
         LTEMP = 33 + I
         I = MIN(LEN(LIBRAR), 16)
         TEMP(LTEMP+1:LTEMP+I) = LIBRAR (1:I)
         TEMP(LTEMP+I+1:LTEMP+I+1) = '.'
         LTEMP = LTEMP + I + 1
         CALL XERPRN (' ***', -1, TEMP(1:LTEMP), 72)
      ENDIF
C
C       IF LKNTRL IS POSITIVE, PRINT AN INTRODUCTORY LINE BEFORE
C       PRINTING THE MESSAGE.  THE INTRODUCTORY LINE TELLS THE CHOICE
C       FROM EACH OF THE FOLLOWING THREE OPTIONS.
C       1.  LEVEL OF THE MESSAGE
C              'INFORMATIVE MESSAGE'
C              'POTENTIALLY RECOVERABLE ERROR'
C              'FATAL ERROR'
C       2.  WHETHER CONTROL FLAG WILL ALLOW PROGRAM TO CONTINUE
C              'PROG CONTINUES'
C              'PROG ABORTED'
C       3.  WHETHER OR NOT A TRACEBACK WAS REQUESTED.  (THE TRACEBACK
C           MAY NOT BE IMPLEMENTED AT SOME SITES, SO THIS ONLY TELLS
C           WHAT WAS REQUESTED, NOT WHAT WAS DELIVERED.)
C              'TRACEBACK REQUESTED'
C              'TRACEBACK NOT REQUESTED'
C       NOTICE THAT THE LINE INCLUDING FOUR PREFIX CHARACTERS WILL NOT
C       EXCEED 74 CHARACTERS.
C       WE SKIP THE NEXT BLOCK IF THE INTRODUCTORY LINE IS NOT NEEDED.
C
      IF (LKNTRL .GT. 0) THEN
C
C       THE FIRST PART OF THE MESSAGE TELLS ABOUT THE LEVEL.
C
         IF (LEVEL .LE. 0) THEN
            TEMP(1:20) = 'INFORMATIVE MESSAGE,'
            LTEMP = 20
         ELSEIF (LEVEL .EQ. 1) THEN
            TEMP(1:30) = 'POTENTIALLY RECOVERABLE ERROR,'
            LTEMP = 30
         ELSE
            TEMP(1:12) = 'FATAL ERROR,'
            LTEMP = 12
         ENDIF
C
C       THEN WHETHER THE PROGRAM WILL CONTINUE.
C
         IF ((MKNTRL.EQ.2 .AND. LEVEL.GE.1) .OR.
     *       (MKNTRL.EQ.1 .AND. LEVEL.EQ.2)) THEN
            TEMP(LTEMP+1:LTEMP+14) = ' PROG ABORTED,'
            LTEMP = LTEMP + 14
         ELSE
            TEMP(LTEMP+1:LTEMP+16) = ' PROG CONTINUES,'
            LTEMP = LTEMP + 16
         ENDIF
C
C       FINALLY TELL WHETHER THERE SHOULD BE A TRACEBACK.
C
         IF (LKNTRL .GT. 0) THEN
            TEMP(LTEMP+1:LTEMP+20) = ' TRACEBACK REQUESTED'
            LTEMP = LTEMP + 20
         ELSE
            TEMP(LTEMP+1:LTEMP+24) = ' TRACEBACK NOT REQUESTED'
            LTEMP = LTEMP + 24
         ENDIF
         CALL XERPRN (' ***', -1, TEMP(1:LTEMP), 72)
      ENDIF
C
C       NOW SEND OUT THE MESSAGE.
C
      CALL XERPRN (' *  ', -1, MESSG, 72)
C
C       IF LKNTRL IS POSITIVE, WRITE THE ERROR NUMBER AND REQUEST A
C          TRACEBACK.
C
      IF (LKNTRL .GT. 0) THEN
         WRITE (TEMP, '(''ERROR NUMBER = '', I8)') NERR
         DO 10 I=16,22
            IF (TEMP(I:I) .NE. ' ') GO TO 20
   10    CONTINUE
C
   20    CALL XERPRN (' *  ', -1, TEMP(1:15) // TEMP(I:23), 72)
         CALL FDUMP
      ENDIF
C
C       IF LKNTRL IS NOT ZERO, PRINT A BLANK LINE AND AN END OF MESSAGE.
C
      IF (LKNTRL .NE. 0) THEN
         CALL XERPRN (' *  ', -1, ' ', 72)
         CALL XERPRN (' ***', -1, 'END OF MESSAGE', 72)
         CALL XERPRN ('    ',  0, ' ', 72)
      ENDIF
C
C       IF THE ERROR IS NOT FATAL OR THE ERROR IS RECOVERABLE AND THE
C       CONTROL FLAG IS SET FOR RECOVERY, THEN RETURN.
C
   30 IF (LEVEL.LE.0 .OR. (LEVEL.EQ.1 .AND. MKNTRL.LE.1)) RETURN
C
C       THE PROGRAM WILL BE STOPPED DUE TO AN UNRECOVERED ERROR OR A
C       FATAL ERROR.  PRINT THE REASON FOR THE ABORT AND THE ERROR
C       SUMMARY IF THE CONTROL FLAG AND THE MAXIMUM ERROR COUNT PERMIT.
C
      IF (LKNTRL.GT.0 .AND. KOUNT.LT.MAX(1,MAXMES)) THEN
         IF (LEVEL .EQ. 1) THEN
            CALL XERPRN
     *         (' ***', -1, 'JOB ABORT DUE TO UNRECOVERED ERROR.', 72)
         ELSE
            CALL XERPRN(' ***', -1, 'JOB ABORT DUE TO FATAL ERROR.', 72)
         ENDIF
         CALL XERSVE (' ', ' ', ' ', -1, 0, 0, KDUMMY)
         CALL XERHLT (' ')
      ELSE
         CALL XERHLT (MESSG)
      ENDIF
      RETURN
      END
*DECK XERPRN
      SUBROUTINE XERPRN (PREFIX, NPREF, MESSG, NWRAP)
C***BEGIN PROLOGUE  XERPRN
C***SUBSIDIARY
C***PURPOSE  Print error messages processed by XERMSG.
C***LIBRARY   SLATEC (XERROR)
C***CATEGORY  R3C
C***TYPE      ALL (XERPRN-A)
C***KEYWORDS  ERROR MESSAGES, PRINTING, XERROR
C***AUTHOR  Fong, Kirby, (NMFECC at LLNL)
C***DESCRIPTION
C
C This routine sends one or more lines to each of the (up to five)
C logical units to which error messages are to be sent.  This routine
C is called several times by XERMSG, sometimes with a single line to
C print and sometimes with a (potentially very long) message that may
C wrap around into multiple lines.
C
C PREFIX  Input argument of type CHARACTER.  This argument contains
C         characters to be put at the beginning of each line before
C         the body of the message.  No more than 16 characters of
C         PREFIX will be used.
C
C NPREF   Input argument of type INTEGER.  This argument is the number
C         of characters to use from PREFIX.  If it is negative, the
C         intrinsic function LEN is used to determine its length.  If
C         it is zero, PREFIX is not used.  If it exceeds 16 or if
C         LEN(PREFIX) exceeds 16, only the first 16 characters will be
C         used.  If NPREF is positive and the length of PREFIX is less
C         than NPREF, a copy of PREFIX extended with blanks to length
C         NPREF will be used.
C
C MESSG   Input argument of type CHARACTER.  This is the text of a
C         message to be printed.  If it is a long message, it will be
C         broken into pieces for printing on multiple lines.  Each line
C         will start with the appropriate prefix and be followed by a
C         piece of the message.  NWRAP is the number of characters per
C         piece; that is, after each NWRAP characters, we break and
C         start a new line.  In addition the characters '$$' embedded
C         in MESSG are a sentinel for a new line.  The counting of
C         characters up to NWRAP starts over for each new line.  The
C         value of NWRAP typically used by XERMSG is 72 since many
C         older error messages in the SLATEC Library are laid out to
C         rely on wrap-around every 72 characters.
C
C NWRAP   Input argument of type INTEGER.  This gives the maximum size
C         piece into which to break MESSG for printing on multiple
C         lines.  An embedded '$$' ends a line, and the count restarts
C         at the following character.  If a line break does not occur
C         on a blank (it would split a word) that word is moved to the
C         next line.  Values of NWRAP less than 16 will be treated as
C         16.  Values of NWRAP greater than 132 will be treated as 132.
C         The actual line length will be NPREF + NWRAP after NPREF has
C         been adjusted to fall between 0 and 16 and NWRAP has been
C         adjusted to fall between 16 and 132.
C
C***REFERENCES  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC
C                 Error-handling Package, SAND82-0800, Sandia
C                 Laboratories, 1982.
C***ROUTINES CALLED  I1MACH, XGETUA
C***REVISION HISTORY  (YYMMDD)
C   880621  DATE WRITTEN
C   880708  REVISED AFTER THE SLATEC CML SUBCOMMITTEE MEETING OF
C           JUNE 29 AND 30 TO CHANGE THE NAME TO XERPRN AND TO REWORK
C           THE HANDLING OF THE NEW LINE SENTINEL TO BEHAVE LIKE THE
C           SLASH CHARACTER IN FORMAT STATEMENTS.
C   890706  REVISED WITH THE HELP OF FRED FRITSCH AND REG CLEMENS TO
C           STREAMLINE THE CODING AND FIX A BUG THAT CAUSED EXTRA BLANK
C           LINES TO BE PRINTED.
C   890721  REVISED TO ADD A NEW FEATURE.  A NEGATIVE VALUE OF NPREF
C           CAUSES LEN(PREFIX) TO BE USED AS THE LENGTH.
C   891013  REVISED TO CORRECT ERROR IN CALCULATING PREFIX LENGTH.
C   891214  Prologue converted to Version 4.0 format.  (WRB)
C   900510  Added code to break messages between words.  (RWC)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  XERPRN
      CHARACTER*(*) PREFIX, MESSG
      INTEGER NPREF, NWRAP
      CHARACTER*148 CBUFF
      INTEGER IU(5), NUNIT
      CHARACTER*2 NEWLIN
      PARAMETER (NEWLIN = '$$')
C***FIRST EXECUTABLE STATEMENT  XERPRN
      CALL XGETUA(IU,NUNIT)
C
C       A ZERO VALUE FOR A LOGICAL UNIT NUMBER MEANS TO USE THE STANDARD
C       ERROR MESSAGE UNIT INSTEAD.  I1MACH(4) RETRIEVES THE STANDARD
C       ERROR MESSAGE UNIT.
C
      N = I1MACH(4)
      DO 10 I=1,NUNIT
         IF (IU(I) .EQ. 0) IU(I) = N
   10 CONTINUE
C
C       LPREF IS THE LENGTH OF THE PREFIX.  THE PREFIX IS PLACED AT THE
C       BEGINNING OF CBUFF, THE CHARACTER BUFFER, AND KEPT THERE DURING
C       THE REST OF THIS ROUTINE.
C
      IF ( NPREF .LT. 0 ) THEN
         LPREF = LEN(PREFIX)
      ELSE
         LPREF = NPREF
      ENDIF
      LPREF = MIN(16, LPREF)
      IF (LPREF .NE. 0) CBUFF(1:LPREF) = PREFIX
C
C       LWRAP IS THE MAXIMUM NUMBER OF CHARACTERS WE WANT TO TAKE AT ONE
C       TIME FROM MESSG TO PRINT ON ONE LINE.
C
      LWRAP = MAX(16, MIN(132, NWRAP))
C
C       SET LENMSG TO THE LENGTH OF MESSG, IGNORE ANY TRAILING BLANKS.
C
      LENMSG = LEN(MESSG)
      N = LENMSG
      DO 20 I=1,N
         IF (MESSG(LENMSG:LENMSG) .NE. ' ') GO TO 30
         LENMSG = LENMSG - 1
   20 CONTINUE
   30 CONTINUE
C
C       IF THE MESSAGE IS ALL BLANKS, THEN PRINT ONE BLANK LINE.
C
      IF (LENMSG .EQ. 0) THEN
         CBUFF(LPREF+1:LPREF+1) = ' '
         DO 40 I=1,NUNIT
            WRITE(IU(I), '(A)') CBUFF(1:LPREF+1)
   40    CONTINUE
         RETURN
      ENDIF
C
C       SET NEXTC TO THE POSITION IN MESSG WHERE THE NEXT SUBSTRING
C       STARTS.  FROM THIS POSITION WE SCAN FOR THE NEW LINE SENTINEL.
C       WHEN NEXTC EXCEEDS LENMSG, THERE IS NO MORE TO PRINT.
C       WE LOOP BACK TO LABEL 50 UNTIL ALL PIECES HAVE BEEN PRINTED.
C
C       WE LOOK FOR THE NEXT OCCURRENCE OF THE NEW LINE SENTINEL.  THE
C       INDEX INTRINSIC FUNCTION RETURNS ZERO IF THERE IS NO OCCURRENCE
C       OR IF THE LENGTH OF THE FIRST ARGUMENT IS LESS THAN THE LENGTH
C       OF THE SECOND ARGUMENT.
C
C       THERE ARE SEVERAL CASES WHICH SHOULD BE CHECKED FOR IN THE
C       FOLLOWING ORDER.  WE ARE ATTEMPTING TO SET LPIECE TO THE NUMBER
C       OF CHARACTERS THAT SHOULD BE TAKEN FROM MESSG STARTING AT
C       POSITION NEXTC.
C
C       LPIECE .EQ. 0   THE NEW LINE SENTINEL DOES NOT OCCUR IN THE
C                       REMAINDER OF THE CHARACTER STRING.  LPIECE
C                       SHOULD BE SET TO LWRAP OR LENMSG+1-NEXTC,
C                       WHICHEVER IS LESS.
C
C       LPIECE .EQ. 1   THE NEW LINE SENTINEL STARTS AT MESSG(NEXTC:
C                       NEXTC).  LPIECE IS EFFECTIVELY ZERO, AND WE
C                       PRINT NOTHING TO AVOID PRODUCING UNNECESSARY
C                       BLANK LINES.  THIS TAKES CARE OF THE SITUATION
C                       WHERE THE LIBRARY ROUTINE HAS A MESSAGE OF
C                       EXACTLY 72 CHARACTERS FOLLOWED BY A NEW LINE
C                       SENTINEL FOLLOWED BY MORE CHARACTERS.  NEXTC
C                       SHOULD BE INCREMENTED BY 2.
C
C       LPIECE .GT. LWRAP+1  REDUCE LPIECE TO LWRAP.
C
C       ELSE            THIS LAST CASE MEANS 2 .LE. LPIECE .LE. LWRAP+1
C                       RESET LPIECE = LPIECE-1.  NOTE THAT THIS
C                       PROPERLY HANDLES THE END CASE WHERE LPIECE .EQ.
C                       LWRAP+1.  THAT IS, THE SENTINEL FALLS EXACTLY
C                       AT THE END OF A LINE.
C
      NEXTC = 1
   50 LPIECE = INDEX(MESSG(NEXTC:LENMSG), NEWLIN)
      IF (LPIECE .EQ. 0) THEN
C
C       THERE WAS NO NEW LINE SENTINEL FOUND.
C
         IDELTA = 0
         LPIECE = MIN(LWRAP, LENMSG+1-NEXTC)
         IF (LPIECE .LT. LENMSG+1-NEXTC) THEN
            DO 52 I=LPIECE+1,2,-1
               IF (MESSG(NEXTC+I-1:NEXTC+I-1) .EQ. ' ') THEN
                  LPIECE = I-1
                  IDELTA = 1
                  GOTO 54
               ENDIF
   52       CONTINUE
         ENDIF
   54    CBUFF(LPREF+1:LPREF+LPIECE) = MESSG(NEXTC:NEXTC+LPIECE-1)
         NEXTC = NEXTC + LPIECE + IDELTA
      ELSEIF (LPIECE .EQ. 1) THEN
C
C       WE HAVE A NEW LINE SENTINEL AT MESSG(NEXTC:NEXTC+1).
C       DON'T PRINT A BLANK LINE.
C
         NEXTC = NEXTC + 2
         GO TO 50
      ELSEIF (LPIECE .GT. LWRAP+1) THEN
C
C       LPIECE SHOULD BE SET DOWN TO LWRAP.
C
         IDELTA = 0
         LPIECE = LWRAP
         DO 56 I=LPIECE+1,2,-1
            IF (MESSG(NEXTC+I-1:NEXTC+I-1) .EQ. ' ') THEN
               LPIECE = I-1
               IDELTA = 1
               GOTO 58
            ENDIF
   56    CONTINUE
   58    CBUFF(LPREF+1:LPREF+LPIECE) = MESSG(NEXTC:NEXTC+LPIECE-1)
         NEXTC = NEXTC + LPIECE + IDELTA
      ELSE
C
C       IF WE ARRIVE HERE, IT MEANS 2 .LE. LPIECE .LE. LWRAP+1.
C       WE SHOULD DECREMENT LPIECE BY ONE.
C
         LPIECE = LPIECE - 1
         CBUFF(LPREF+1:LPREF+LPIECE) = MESSG(NEXTC:NEXTC+LPIECE-1)
         NEXTC  = NEXTC + LPIECE + 2
      ENDIF
C
C       PRINT
C
      DO 60 I=1,NUNIT
         WRITE(IU(I), '(A)') CBUFF(1:LPREF+LPIECE)
   60 CONTINUE
C
      IF (NEXTC .LE. LENMSG) GO TO 50
      RETURN
      END
*DECK XERSVE
      SUBROUTINE XERSVE (LIBRAR, SUBROU, MESSG, KFLAG, NERR, LEVEL,
     +   ICOUNT)
C***BEGIN PROLOGUE  XERSVE
C***SUBSIDIARY
C***PURPOSE  Record that an error has occurred.
C***LIBRARY   SLATEC (XERROR)
C***CATEGORY  R3
C***TYPE      ALL (XERSVE-A)
C***KEYWORDS  ERROR, XERROR
C***AUTHOR  Jones, R. E., (SNLA)
C***DESCRIPTION
C
C *Usage:
C
C        INTEGER  KFLAG, NERR, LEVEL, ICOUNT
C        CHARACTER * (len) LIBRAR, SUBROU, MESSG
C
C        CALL XERSVE (LIBRAR, SUBROU, MESSG, KFLAG, NERR, LEVEL, ICOUNT)
C
C *Arguments:
C
C        LIBRAR :IN    is the library that the message is from.
C        SUBROU :IN    is the subroutine that the message is from.
C        MESSG  :IN    is the message to be saved.
C        KFLAG  :IN    indicates the action to be performed.
C                      when KFLAG > 0, the message in MESSG is saved.
C                      when KFLAG=0 the tables will be dumped and
C                      cleared.
C                      when KFLAG < 0, the tables will be dumped and
C                      not cleared.
C        NERR   :IN    is the error number.
C        LEVEL  :IN    is the error severity.
C        ICOUNT :OUT   the number of times this message has been seen,
C                      or zero if the table has overflowed and does not
C                      contain this message specifically.  When KFLAG=0,
C                      ICOUNT will not be altered.
C
C *Description:
C
C   Record that this error occurred and possibly dump and clear the
C   tables.
C
C***REFERENCES  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC
C                 Error-handling Package, SAND82-0800, Sandia
C                 Laboratories, 1982.
C***ROUTINES CALLED  I1MACH, XGETUA
C***REVISION HISTORY  (YYMMDD)
C   800319  DATE WRITTEN
C   861211  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900413  Routine modified to remove reference to KFLAG.  (WRB)
C   900510  Changed to add LIBRARY NAME and SUBROUTINE to calling
C           sequence, use IF-THEN-ELSE, make number of saved entries
C           easily changeable, changed routine name from XERSAV to
C           XERSVE.  (RWC)
C   910626  Added LIBTAB and SUBTAB to SAVE statement.  (BKS)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  XERSVE
      PARAMETER (LENTAB=10)
      INTEGER LUN(5)
      CHARACTER*(*) LIBRAR, SUBROU, MESSG
      CHARACTER*8  LIBTAB(LENTAB), SUBTAB(LENTAB), LIB, SUB
      CHARACTER*20 MESTAB(LENTAB), MES
      DIMENSION NERTAB(LENTAB), LEVTAB(LENTAB), KOUNT(LENTAB)
      SAVE LIBTAB, SUBTAB, MESTAB, NERTAB, LEVTAB, KOUNT, KOUNTX, NMSG
      DATA KOUNTX/0/, NMSG/0/
C***FIRST EXECUTABLE STATEMENT  XERSVE
C
      IF (KFLAG.LE.0) THEN
C
C        Dump the table.
C
         IF (NMSG.EQ.0) RETURN
C
C        Print to each unit.
C
         CALL XGETUA (LUN, NUNIT)
         DO 20 KUNIT = 1,NUNIT
            IUNIT = LUN(KUNIT)
            IF (IUNIT.EQ.0) IUNIT = I1MACH(4)
C
C           Print the table header.
C
            WRITE (IUNIT,9000)
C
C           Print body of table.
C
            DO 10 I = 1,NMSG
               WRITE (IUNIT,9010) LIBTAB(I), SUBTAB(I), MESTAB(I),
     *            NERTAB(I),LEVTAB(I),KOUNT(I)
   10       CONTINUE
C
C           Print number of other errors.
C
            IF (KOUNTX.NE.0) WRITE (IUNIT,9020) KOUNTX
            WRITE (IUNIT,9030)
   20    CONTINUE
C
C        Clear the error tables.
C
         IF (KFLAG.EQ.0) THEN
            NMSG = 0
            KOUNTX = 0
         ENDIF
      ELSE
C
C        PROCESS A MESSAGE...
C        SEARCH FOR THIS MESSG, OR ELSE AN EMPTY SLOT FOR THIS MESSG,
C        OR ELSE DETERMINE THAT THE ERROR TABLE IS FULL.
C
         LIB = LIBRAR
         SUB = SUBROU
         MES = MESSG
         DO 30 I = 1,NMSG
            IF (LIB.EQ.LIBTAB(I) .AND. SUB.EQ.SUBTAB(I) .AND.
     *         MES.EQ.MESTAB(I) .AND. NERR.EQ.NERTAB(I) .AND.
     *         LEVEL.EQ.LEVTAB(I)) THEN
                  KOUNT(I) = KOUNT(I) + 1
                  ICOUNT = KOUNT(I)
                  RETURN
            ENDIF
   30    CONTINUE
C
         IF (NMSG.LT.LENTAB) THEN
C
C           Empty slot found for new message.
C
            NMSG = NMSG + 1
            LIBTAB(I) = LIB
            SUBTAB(I) = SUB
            MESTAB(I) = MES
            NERTAB(I) = NERR
            LEVTAB(I) = LEVEL
            KOUNT (I) = 1
            ICOUNT    = 1
         ELSE
C
C           Table is full.
C
            KOUNTX = KOUNTX+1
            ICOUNT = 0
         ENDIF
      ENDIF
      RETURN
C
C     Formats.
C
 9000 FORMAT ('0          ERROR MESSAGE SUMMARY' /
     +   ' LIBRARY    SUBROUTINE MESSAGE START             NERR',
     +   '     LEVEL     COUNT')
 9010 FORMAT (1X,A,3X,A,3X,A,3I10)
 9020 FORMAT ('0OTHER ERRORS NOT INDIVIDUALLY TABULATED = ', I10)
 9030 FORMAT (1X)
      END
*DECK XGETUA
      SUBROUTINE XGETUA (IUNITA, N)
C***BEGIN PROLOGUE  XGETUA
C***PURPOSE  Return unit number(s) to which error messages are being
C            sent.
C***LIBRARY   SLATEC (XERROR)
C***CATEGORY  R3C
C***TYPE      ALL (XGETUA-A)
C***KEYWORDS  ERROR, XERROR
C***AUTHOR  Jones, R. E., (SNLA)
C***DESCRIPTION
C
C     Abstract
C        XGETUA may be called to determine the unit number or numbers
C        to which error messages are being sent.
C        These unit numbers may have been set by a call to XSETUN,
C        or a call to XSETUA, or may be a default value.
C
C     Description of Parameters
C      --Output--
C        IUNIT - an array of one to five unit numbers, depending
C                on the value of N.  A value of zero refers to the
C                default unit, as defined by the I1MACH machine
C                constant routine.  Only IUNIT(1),...,IUNIT(N) are
C                defined by XGETUA.  The values of IUNIT(N+1),...,
C                IUNIT(5) are not defined (for N .LT. 5) or altered
C                in any way by XGETUA.
C        N     - the number of units to which copies of the
C                error messages are being sent.  N will be in the
C                range from 1 to 5.
C
C***REFERENCES  R. E. Jones and D. K. Kahaner, XERROR, the SLATEC
C                 Error-handling Package, SAND82-0800, Sandia
C                 Laboratories, 1982.
C***ROUTINES CALLED  J4SAVE
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   861211  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  XGETUA
      DIMENSION IUNITA(5)
C***FIRST EXECUTABLE STATEMENT  XGETUA
      N = J4SAVE(5,0,.FALSE.)
      DO 30 I=1,N
         INDEX = I+4
         IF (I.EQ.1) INDEX = 3
         IUNITA(I) = J4SAVE(INDEX,0,.FALSE.)
   30 CONTINUE
      RETURN
      END
