c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include"PARAM.h"
      parameter(ncombimax=NCOMBIMAX_INC,nmax=NMAX_INC)
      common/datblk/freq(nmax),spac(nmax,ncombimax),
     *     spacstd(nmax,ncombimax),ndat
      dimension radius(ncombimax),w(nmax),pv(nmax),
     *     spacerr(ncombimax)
      dimension ave_ansr4hosei(nmax)
      character*200 sprfile,ofile
      character*200 sprfile_anc(ncombimax)
      pi2=PI2
      two_root2=2.*sqrt(2.)
      
c　SPAC係数の長波長近似にはSPAC係数が大きいと言う条件が必要。ここでは0.9程度までの物を見ることにする。      
c      cspaclim=0.9
      cspaclim=0.7

c アレイ半径比１以上は必要条件。ただし，あまりに半径が異なるアレイ同士を組み合わせるとノイズの状況が異なりすぎるので同じNS比という仮定が破綻する可能性がある音で，ある程度同じ（少なくともオーダーが同じ）サイズのアレイを組み合わせる立場をとる。具体的には◯倍までとする。
      afac_llim=1.
      afac_ulim=2.0001
c      afac_ulim=5.
      
c--------------
c input
c--------------
      read(5,*)freq_max
      read(5,*)
      read(5,*)ncombi
      if(ncombi.gt.ncombimax)then
         write(6,*)'ncombi > ncombimax ',ncombi, ncombimax,'STOP.'
         stop
      endif
      do icombi=1,ncombi
         read(5,'(a)')sprfile
         write(6,'(i10,a)')
     *        icombi,' READ:'//sprfile(1:index(sprfile,' ')-1)
         sprfile_anc(icombi)=sprfile(1:index(sprfile,' ')-1)//'.nc'
         open(10,file=sprfile)
         call rdata(10,icombi)
         close(10)
         read(5,*)radius(icombi)
         write(6,*)radius(icombi)
      enddo
      read(5,*)
      read(5,'(a)')ofile

      do i=1,ndat
         if(freq(i).gt.freq_max)goto 10
      enddo
 10   ndat_out=i-1

      do i=1,ndat_out
         w(i)=pi2*freq(i)
         ave_ansr4hosei(i)=0.
      enddo

c      open(19,file='nsr_ncspac.d')
c      open(20,file='vel_ncspac.d')
      open(20,file=ofile)
c      open(21,file='r_nsr.d')
c---------------
c noise correction      
c---------------      
      do i=1,ndat_out
         sum_ansr=0.
         sum2_ansr=0.
         sum_vel=0.
         sum2_vel=0.
         nok=0   
         do icombi1=1,ncombi    ! radius
         do icombi2=1,ncombi       ! radius
c
         afac=radius(icombi2)/radius(icombi1) !afac should be larger than 1
         idok=1
         
c-------------------------------------------------------         
c afacの制限（少なくともafac>1のみ計算対象）         
         if(icombi1.eq.icombi2)idok=0
         if(afac.le.afac_llim)idok=0
         if(afac.gt.afac_ulim)idok=0
c 長波長近似が成り立つ帯域（コヒーレンスが大きい必要）
         if(spac(i,icombi1).lt.cspaclim.
     *        and.spac(i,icombi2).lt.cspaclim)idok=0
c　velの分子の平方根内が正（ρ2 > ρ1）という条件.
         if(spac(i,icombi1).lt.spac(i,icombi2))idok=0
c ansr<0となる条件。この場合idok=0とする. これを入れると対称な分布とならない。
c NS比はデータのばらつきにより０付近にランダムにばらつくと言う立場をとる必要がある。
c よってこの条件は削除         
c     if(afac**2*spac(i,icombi1).le.spac(i,icombi2))idok=0
c     if(afac**2.le.(1.-spac(i,icombi2))/(1.-spac(i,icombi1)))idok=0
c-------------------------------------------------------         
         
         if(idok.eq.1)then
            
c------------------------------------------------------------------------
c         sq_a2_minus_1=(afac**2-1.)
c     *           *sqrt(spac(i,icombi1)*spac(i,icombi2))
         a2rho1_minus_rho2=afac**2*spac(i,icombi1)-spac(i,icombi2)
c         a4rho1_minus_rho2=afac**4*spac(i,icombi1)-spac(i,icombi2)

c 2次までの近似式による解            
         ansr=(-1.+afac**2-afac**2*spac(i,icombi1)+spac(i,icombi2))/
     *        (a2rho1_minus_rho2)
         ark=2.*sqrt(spac(i,icombi1)-spac(i,icombi2))/
     *        sqrt(a2rho1_minus_rho2)
         
c 4次までの近似式による解            
c (解2)
c       ark=two_root2*sqrt((a2rho1_minus_rho2+sq_a2_minus_1)
c     *        /a4rho1_minus_rho2)
c       ansr=-1./a4rho1_minus_rho2**2*(
c     *      2.*afac**6*spac(i,icombi1)     
c     *        +afac**8*(spac(i,icombi1)-1.)*spac(i,icombi1)     
c     *                +(spac(i,icombi2)-1.)*spac(i,icombi2)     
c     *      +2.*afac**2*(spac(i,icombi2)-sq_a2_minus_1)     
c     *      -   afac**4*(spac(i,icombi1)+spac(i,icombi2)
c     *              +2.*spac(i,icombi1)*spac(i,icombi2)
c     *              -2.*sq_a2_minus_1))
c (解1)
c       ark=two_root2*sqrt((a2rho1_minus_rho2-sq_a2_minus_1)
c     *        /a4rho1_minus_rho2)
c       ansr=-1./a4rho1_minus_rho2**2*(
c     *      2.*afac**6*spac(i,icombi1)     
c     *        +afac**8*(spac(i,icombi1)-1.)*spac(i,icombi1)     
c     *                +(spac(i,icombi2)-1.)*spac(i,icombi2)     
c     *      +2.*afac**2*(spac(i,icombi2)+sq_a2_minus_1)     
c     *      -   afac**4*(spac(i,icombi1)+spac(i,icombi2)
c     *              +2.*spac(i,icombi1)*spac(i,icombi2)
c     *              +2.*sq_a2_minus_1))
       
         
c------------------------------------------------------------------------
         
         vel=w(i)*radius(icombi1)/ark
         sum_ansr=sum_ansr+ansr
         sum2_ansr=sum2_ansr+ansr**2
         sum_vel=sum_vel+vel
         sum2_vel=sum2_vel+vel**2
         nok=nok+1
c         write(21,'(100e15.6)')radius(icombi1),ansr,
c     *        freq(i),vel,spac(i,icombi1)
c         write(21,'(100e15.6)')radius(icombi2),ansr,
c     *        freq(i),vel,spac(i,icombi2)
         endif ! if(idok.eq.1)then
c
         enddo
         enddo
         if(nok.ge.2)then
            ave_ansr=sum_ansr/float(nok)
            ave_ansr4hosei(i)=ave_ansr
            var_ansr=(sum2_ansr-nok*ave_ansr**2)/float(nok-1)
            ave_vel=sum_vel/float(nok)
            var_vel=(sum2_vel-nok*ave_vel**2)/float(nok-1)
c            write(19,*)freq(i),ave_ansr,sqrt(var_ansr)
c            write(20,*)freq(i),ave_vel,sqrt(var_vel)
            write(20,*)freq(i),ave_vel,0,1
         endif
      enddo ! do i=1,ndat_out
c---------------
c      close(19)
      close(20)
c      close(21)

c-----------------------------------------        
c      do icombi=1,ncombi        ! radius
c      open(10,file=sprfile_anc(icombi))
c      do i=1,ndat_out        ! frequency
c         hoseispac=(1.+ave_ansr4hosei(i))*spac(i,icombi)
c         write(10,*)freq(i),hoseispac
c      enddo  !   do i=1,ndat_out ! frequency
c      close(10)
c      enddo  !   do icombi=1,ncombi        ! radius
c-----------------------------------------        
      
      stop
      end

      subroutine rdata(ifile,icombi)
      parameter(ncombimax=NCOMBIMAX_INC,nmax=NMAX_INC)
      common/datblk/freq(nmax),spac(nmax,ncombimax),
     *     spacstd(nmax,ncombimax),ndat
      i=1
 10   read(ifile,*,err=99,end=99)freq(i),spac(i,icombi),
     *     spacstd(i,icombi)
      i=i+1
      goto 10
 99   continue
      ndat=i-1
      if(ndat.gt.nmax)then
         write(6,*)'ndat > nmax ',ndat,nmax,'STOP.'
         stop
      endif

      return
      end
      
