c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include"PARAM.h"
      parameter(ncombimax=NCOMBIMAX_INC,nmax=NMAX_INC)
      common/datblk/freq(nmax),spac(nmax,ncombimax),
     *     spacstd(nmax,ncombimax),ndat
      dimension radius(ncombimax),w(nmax),pv(nmax),
     *     spacerr(ncombimax),idok(ncombimax)
c     *     ,radius_vi(nmax)
      common/OBSERVED/obs
      external bslj0
      character*200 sprfile,ofile
      data re,ae/1.e-7,1.e-7/
      pi2=PI2
      fjisu=0.
      npv=501
      pvmargin=0.1 ! set the margin of a grid search for pv to 10%
      spaclowlim=-0.40276       ! 検討に付すためのSPAC係数の最小値(J0の最初の極小値)
      
c      rklim=1000.
c rklim=2πr/λ=6r/λ, λ=6r/rklim, 
c     λ<1rとすると
c     あまりrkが大きくなると相当な長時間取らないとコヒーレンスが取れなくなる？
c λ<1rに対応するrk程度が限界か。    　
c      rklim_u=6.! (the 1st and 2nd zeros included)
c      rklim_u=10.! (the 1st to 3rd zeros included)
      rklim_u=15. ! (the 1st to 5th zeros included)
c      rklim_u=2.! (the 1st zero included)

      
c
c     rk=0.45, spac=0.95に対応     
c     rk=0.64, spac=0.90に対応     
c     rk=0.91, spac=0.80に対応
c      rklim_l=0.45
      rklim_l=0.
      
c--------------
c input
c--------------
      read(5,*)freq_max
c      read(5,*)pv_end
      read(5,*)dum
      read(5,*)ncombi
      if(ncombi.gt.ncombimax)then
         write(6,*)'ncombi > ncombimax ',ncombi, ncombimax,'STOP.'
         stop
      endif
      do icombi=1,ncombi
         read(5,'(a)')sprfile
         write(6,'(i10,a)')
     *        icombi,' READ:'//sprfile(1:index(sprfile,' ')-1)
         open(10,file=sprfile)
         call rdata(10,icombi)
         close(10)
         read(5,*)radius(icombi)
         write(6,*)radius(icombi)
      enddo
      read(5,'(a)')ofile

      do i=1,ndat
         if(freq(i).gt.freq_max)goto 10
      enddo
 10   ndat_out=i-1

c calcuate average radius      
      radius_vi=0.      
      do icombi=1,ncombi        ! radius
         radius_vi=radius_vi+radius(icombi)
      enddo
      radius_vi=radius_vi/float(ncombi)
c-------------------------------------------      

c--------------
c prcessing & output
c--------------
      do i=1,ndat_out
         w(i)=pi2*freq(i)
      enddo
      
      open(10,file=ofile)
      do i=1,ndat_out ! frequency

c-----------------------------
c determine the search range SRART         
c-----------------------------
         spacmax=-1.d8
         spacmin=1.d8
         do icombi=1,ncombi     ! radius
            if(spac(i,icombi).ge.spacmax)then
               spacmax=spac(i,icombi)
               icombimax=icombi
            endif
            if(spac(i,icombi).le.spacmin)then
               spacmin=spac(i,icombi)
               icombimin=icombi
            endif
         enddo
         
         b=0.
         c=3.83
         r=c
         obs=spacmin
         call fzero(bslj0, b, c, r, re, ae, iflag)
         call wn2pv(b,freq(i),radius(icombi),pv1)
         if(iflag.ge.3)then     !  in case of fzero error
            pv1=50.e-3 
         else
            call wn2pv(b,freq(i),radius(icombimin),pv1)
         endif
c         
         b=0.
         c=3.83
         r=c
         obs=spacmax
         call fzero(bslj0, b, c, r, re, ae, iflag)
         if(iflag.ge.3)then     !  in case of fzero error
            pv2=3.5
         else
            call wn2pv(b,freq(i),radius(icombimax),pv2)
         endif
c         
         if(pv1.le.pv2)then
            pv_beg=pv1*(1.-pvmargin)
            pv_end=pv2*(1.+pvmargin)
         else
            pv_beg=pv2*(1.-pvmargin)
            pv_end=pv1*(1.+pvmargin)
         endif
c         
c      pv_end=1.2
c     pv_beg=50.e-3 ! <- 50m/s.(0でない正の小さな数; ある程度大きな数にしておかないとJ0が計算不能となる。)
c   define the narrowest range (to run cal_bsl(fjisu,rk,aj0) correctly)        
         if(pv_end.lt.0.5   )pv_end=0.5
         if(pv_beg.lt.50.e-3)pv_beg=50.e-3
c
         dpv=(pv_end-pv_beg)/float(npv-1)
c         npv=(pv_end-pv_beg)/dpv
         do ipv=1,npv
            pv(ipv)=pv_beg+dpv*(ipv-1)
         enddo
c-----------------------------
c determine the search range END
c-----------------------------
         
         rmsmin=1.e8
         do ipv=1,npv ! phase velocity
            rms=0.
            icount=0
            do icombi=1,ncombi  ! radius
               rk=w(i)*radius(icombi)/pv(ipv)
               if(spac(i,icombi).ge.spaclowlim)then ! J0の最小値を考慮
               if(rk.ge.rklim_l.and.rk.le.rklim_u)then ! rkのレンジを考慮
                  icount=icount+1
                  idok(icombi)=icount
                  call cal_bsl(fjisu,rk,aj0)
                  rms=rms+(spac(i,icombi)-aj0)**2 
               endif
               endif
            enddo !  do icombi=1,ncombi ! radius
            if(icount.gt.0.and.rms.lt.rmsmin)then
               rmsmin=rms
               pvmin=pv(ipv)
            endif
         enddo ! do ipv=1,npv ! phase velocity

c-----------------------------
c determine the virtual radius START
c-----------------------------
c         rmsmin=1.e8
c         do iradius_vi=1,nradius_vi
c            rms=0.
c            icount=0
c            rk=w(i)*radius_vi(iradius_vi)/pvmin
c            call cal_bsl(fjisu,rk,aj0_vi)
c            do icombi=1,ncombi  
c               if(idok(icombi).gt.0)then
c                  icount=icount+1
c                  rk=w(i)*radius(icombi)/pvmin
c                  call cal_bsl(fjisu,rk,aj0)
c                  rms=rms+(aj0_vi-aj0)**2 
c               endif
c            enddo !  do icombi=1,ncombi ! radius
c            if(icount.gt.0.and.rms.lt.rmsmin)then
c               rmsmin=rms
c               radius_vimin=radius_vi(iradius_vi)
c               aj0_vimin=aj0_vi
c            endif
c        enddo ! do iradius_vi=1,nradius_vi
         
c     determining the best radius is not necessary
c     The use of average radius is enough 
         rk=w(i)*radius_vi/pvmin
         call cal_bsl(fjisu,rk,aj0_vi)
c-----------------------------
c determine the virtual radius END
c-----------------------------
         
c         write(10,*)freq(i),pvmin,rk,radius_vi(1)
c         write(10,*)freq(i),pvmin,aj0_vimin,radius_vimin
         write(10,*)freq(i),pvmin,aj0_vi,radius_vi
 99   enddo
      close(10)
      stop
      end

      subroutine wn2pv(wn,freq,radius,pv)
      pv=PI2*freq*radius/wn
      return
      end

      subroutine rdata(ifile,icombi)
      parameter(ncombimax=NCOMBIMAX_INC,nmax=NMAX_INC)
      common/datblk/freq(nmax),spac(nmax,ncombimax),
     *     spacstd(nmax,ncombimax),ndat
      i=1
 10   read(ifile,*,err=99,end=99)freq(i),spac(i,icombi),
     *     spacstd(i,icombi)
      i=i+1
      goto 10
 99   continue
      ndat=i-1
      if(ndat.gt.nmax)then
         write(6,*)'ndat > nmax ',ndat,nmax,'STOP.'
         stop
      endif

      return
      end
      
      subroutine cal_bsl(fjisu,x,y)
      parameter(ny=1)
      complex cy0,cy1,cy, z
      dimension cy0(ny),cy1(ny),cy(2)
      kode=2
      z=cmplx(x,0.)
      call cbesj(z, fjisu,  kode, ny, cy0, nz, ierr)
      if(nz.ne.0 .or. ierr.ne.0)then
         write(6,*)'Error:nz or ierr in cbesj()',nz,ierr
         stop
      endif
      y=cy0(1)*1.0
      return
      end

      function bslj0(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y)
      bslj0=y-obs
      return
      end
      
      
