c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NMAX_INC 500000
#define OUTPUT_CORRELATION_STATUS 1
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)
      dimension id(nmax)
      dimension kstat(nmax),fstat(nmax),
     +     wavepvstat(nmax),wstdpvstat(nmax),
     +     wstdpvstat_nocor(nmax),wstdpvstat_nocor_sort(nmax),
     +     wavepvstat_sort(nmax),wstdpvstat_sort(nmax)
      dimension radius(nmax),f(nmax),pv(nmax),pvlim(nmax),stdpv(nmax),
     +     nb(nmax),anbstat(nmax),anbstat_sort(nmax)
      dimension fl_enfrcd(nmax),fu_enfrcd(nmax)
      character*200 ofile0,ofile,ffile
      common /PARASPEC/smb,df4spec
      data eps/0.1d0/
      data fllim,fulim/0.1d0,50.d0/
      
      read(5,'(a)')ofile0
      read(5,'(a)')ofile
      read(5,'(a)')ffile
      write(6,'(a)')'OUTPUT '//ofile0(1:index(ofile0,' ')-1)
      write(6,'(a)')'OUTPUT '//ofile(1:index(ofile,' ')-1)
      read(5,*)fmin,fmax,n
      read(5,*)idesacflag
      read(5,*)idcategory
      read(5,*)smb
      read(5,*)df4spec
      
      i=1
 10   read(5,*,err=99,end=99)
     +     id(i),kdum,radius(i),nb(i),f(i),pv(i),stdpv(i),
     +     fl_enfrcd(i),fu_enfrcd(i),pvlim(i)
c      write(6,'(a,i3,5f12.5)')'DEBUG: ',
c     +     id(i),radius(i),f(i),pv(i),stdpv(i),pvlim(i)
      i=i+1
      goto 10
 99   continue
      ndata=i-1
      
      open(15,file=ffile)
      i=1
 100  read(15,*,err=199,end=199)fstat(i)
c      write(6,*)i,fstat(i)
      i=i+1
      goto 100
 199  continue
      close(15)
      nfstat=i-1

      write(6,*)'ndata: ',ndata
      write(6,*)'nfstat: ',nfstat
      
c------------------------
c all
c------------------------
      do i=1,nfstat
         k=0
         nbsum=0
         kstat(i)=0
         wgtall=0.d0
         sumpv=0.d0
         sumstdpv=0.d0
         sumvarpv_nocor=0.d0
         do j=1,ndata
            if(abs(f(j)-fstat(i)).le.1.d-8)then
               call detweight(eps,idcategory,idesacflag,wlfac,
     +              id(j),radius(j),f(j),
     +              fl_enfrcd(j),fu_enfrcd(j),
     +              pv(j),pvlim(j),wgt0,wgt)
c     write(20,'(a,2f12.4,2e15.6,i3)')'DEBUG: ',
c     f(j),wlfac,wgt0,wgt,id(j)
               wgtall=wgtall+wgt0
               sumpv=sumpv+wgt0*pv(j)
               if(wgt0.gt.0.d0)then
                  k=k+1
                  nbsum=nbsum+nb(i)
               endif
            endif
         enddo
         
         if(k.gt.0)then
            wavepv=sumpv/wgtall
            do j=1,ndata
               if(abs(f(j)-fstat(i)).le.1.d-8)then
                  call detweight(eps,idcategory,idesacflag,wlfac,
     +                 id(j),radius(j),f(j),
     +                 fl_enfrcd(j),fu_enfrcd(j),
     +                 pv(j),pvlim(j),wgt0,wgt)
                  biaspv=pv(j)-wavepv
c                  biaspv=0.d0
                  sumstdpv=
     +                 sumstdpv+wgt0*dsqrt(stdpv(j)**2+biaspv**2)
                  sumvarpv_nocor=
     +                 sumvarpv_nocor+wgt0**2*(stdpv(j)**2+biaspv**2)
               endif
            enddo
            wavepvstat(i)=wavepv
            wstdpvstat(i)=sumstdpv/wgtall
            wstdpvstat_nocor(i)=dsqrt(sumvarpv_nocor)/wgtall
            anbstat(i)=dble(nbsum)/dble(k)
            kstat(i)=k
         endif
      enddo
      
c------------------------
c output ALL     
c------------------------
      fmin_dash=dsqrt(fmin**3/fmax)
      fmax_dash=dsqrt(fmax**3/fmin)
      if(fmin_dash.lt.fllim)fmin_dash=fllim
      if(fmax_dash.gt.fulim)fmax_dash=fulim
      write(6,*)'fmin_dash,fmax_dash for ALL: ',fmin_dash,fmax_dash
      
      open (10,file=ofile0)
      
      fspm=fmin_dash
 11   continue
c     do i=1,int(2*n)+1
      
c         call calrange(fmin_dash,fmax_dash,int(2*n),fspm,fsp,fspp,i)
         call calrange(fmin_dash,fmax_dash,int(2*n),fspm,fsp,fspp)
         k=0
         do j=1,nfstat
            if(fstat(j).ge.fspm.and.fstat(j).lt.fspp)then
               if(kstat(j).gt.0)then
                  k=k+1
                  wstdpvstat_nocor_sort(k)=wstdpvstat_nocor(j)
                  wavepvstat_sort(k)=wavepvstat(j)
                  wstdpvstat_sort(k)=wstdpvstat(j)
                  anbstat_sort(k)=anbstat(j)
               endif
            endif
         enddo
         if(k.ge.1)then
            call takemed(wavepvstat_sort,k,wavepv_med)
            call takemed(wstdpvstat_sort,k,wstdpvstat_med)
            call takemed(wstdpvstat_nocor_sort,k,wstdpvstat_nocor_med)
            call takemed(anbstat_sort,k,anbstat_med)
            
#if OUTPUT_CORRELATION_STATUS==0
            write(10,'(2f12.4,e15.6,i5)')
     +           fsp,wavepv_med,wstdpvstat_nocor_med,
     +           int(anbstat_med+0.5d0)
#elif OUTPUT_CORRELATION_STATUS==1
            write(10,'(2f12.4,e15.6,i5)')
     +           fsp,wavepv_med,wstdpvstat_med,
     +           int(anbstat_med+0.5d0)
#endif            
         endif
         
c     enddo
      if(fspp.lt.fmax-1.d-8)then
         fspm=fspp
         goto 11
      endif
      
      close(10)
      
c------------------------
c main      
c------------------------

      open (10,file=ofile)
      
      fspm=fmin
 21   continue
c      do i=1,n+1
c     call calrange(fmin,fmax,n,fspm,fsp,fspp,i)
      call calrange(fmin,fmax,n,fspm,fsp,fspp)
      
         k=0
         do j=1,nfstat
            if(fstat(j).ge.fspm.and.fstat(j).lt.fspp)then
               if(kstat(j).gt.0)then
                  k=k+1
                  wstdpvstat_nocor_sort(k)=wstdpvstat_nocor(j)
                  wavepvstat_sort(k)=wavepvstat(j)
                  wstdpvstat_sort(k)=wstdpvstat(j)
               endif
            endif
         enddo
         if(k.ge.1)then
            call takemed(wavepvstat_sort,k,wavepv_med)
            call takemed(wstdpvstat_sort,k,wstdpvstat_med)
            call takemed(wstdpvstat_nocor_sort,k,wstdpvstat_nocor_med)

#if OUTPUT_CORRELATION_STATUS==0
            write(10,'(2f12.4,e15.6,i5)')
     +           fsp,wavepv_med,wstdpvstat_nocor_med,k
#elif OUTPUT_CORRELATION_STATUS==1
            write(10,'(2f12.4,e15.6,i5)')
     +           fsp,wavepv_med,wstdpvstat_med,k
#endif            
         endif
c     enddo

      if(fspp.lt.fmax-1.d-8)then
         fspm=fspp
         goto 21
      endif
         
      close(10)
      stop
      end

      subroutine detweight(eps,idcategory,idesacflag,wlfac,
     +     id,radius,f,fl_enfrcd,fu_enfrcd,
     +     pv,pvlim,wgt,wgt4pv)
c--------------------------------------------------------------------------
c idcategory  contents   rmin   rmax Ͽ̷׿/­
c     5       SPAC/CCA    0     2m   4-6/2SPAC&ʳ
c             nc-CCA                 (˾줤η̤)
c     6       SPAC/CCA    0     inf  4-6/2SPAC&ʳ
c             nc-CCA    (줤η̤)
c--------------------------------------------------------------------------
      implicit real*8 (a-h,o-z)
      wgt=1.d0
      wl=pv/f
      wlfac=wl/radius
      pvlimfac=pvlim/pv

      if(idesacflag.eq.1)then ! constant weight 1 for esac
         return
      endif
      
      if(pvlimfac.lt.0.d0)then  ! without center point
         call detwlfac0(id,radius,wlfac1,wlfac2,wlfac3,wlfac4)
         call wlfac2wgt(eps,wlfac,wlfac1,wlfac2,wlfac3,wlfac4,wgt)
      else                      ! with center point
         call detwlfac1(id,radius,wlfac1,wlfac2,wlfac3,wlfac4)
         call wlfac2wgt(eps,wlfac,wlfac1,wlfac2,wlfac3,wlfac4,wgt)
         
c PV LIMITʲϷ̤ʼˤǧƼưɼ롣
         if(wlfac.ge.8.d0.and.id.ne.3)then ! nc-CCAʳ 20160213
c-----------------------------------
c  pvlimfacmin=Log(wfac)+1Ѥ롣(min,max)=(1,3)
c     wlfac=10λ  pvlimfacmin=2
c     wlfac>=100λpvlimfacmin=3
c-----------------------------------
            pvlimfacmin=log10(wlfac)+1.d0
            if(pvlimfacmin.lt.1.d0)pvlimfacmin=1.d0
            if(pvlimfacmin.gt.3.d0)pvlimfacmin=3.d0
c     write(6,*)'DEBUG:pvlimfacmin,wlfac',pvlimfacmin,wlfac
            if(pvlimfac.lt.pvlimfacmin)wgt=0.d0
         endif
      endif
      
      if(idcategory.eq.5.and.radius.gt.0.002d0)wgt=0.d0

      if(f.lt.fl_enfrcd.or.f.gt.fu_enfrcd)wgt=0.d0
      
      if(wgt.gt.eps)then
         wgt4pv=wgt
      else
         wgt4pv=0.d0
      endif

      return
      end

      subroutine detwlfac0(id,radius,wlfac1,wlfac2,wlfac3,wlfac4)
c----------------------------
c     without center
c----------------------------
      implicit real*8 (a-h,o-z)
      if(id.gt.2.and.id.ne.100)then
         write(6,*)'ERROR in detwlfac0(): id ',id
         stop
      endif
      if(radius.le.0.002d0)then
         if(     id.eq.100)then   ! 2st-spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=40.d0
            wlfac4=60.d0
         else if(id.eq.1)then ! spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=40.d0
            wlfac4=60.d0
         else if(id.eq.2)then   ! cca
            wlfac1=5.d0
            wlfac2=7.d0
            wlfac3=40.d0
            wlfac4=60.d0
         endif
      else if(radius.le.0.010d0)then
         if(     id.eq.100)then   ! 2st-spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=10.d0
            wlfac4=30.d0
         else if(id.eq.1)then   ! spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=10.d0
            wlfac4=30.d0
         else if(id.eq.2)then   ! cca
            wlfac1=5.d0
            wlfac2=8.d0
            wlfac3=10.d0
            wlfac4=30.d0
         endif
      else
         if(     id.eq.100)then   ! 2st-spac
            wlfac1=4.d0
            wlfac2=5.d0
            wlfac3=7.d0
            wlfac4=8.d0
         else if(id.eq.1)then ! spac
            wlfac1=4.d0
            wlfac2=5.d0
            wlfac3=7.d0
            wlfac4=8.d0
         else if(id.eq.2)then   ! cca
            wlfac1=6.d0
            wlfac2=6.5d0
            wlfac3=7.5d0
            wlfac4=8.d0
         endif
      endif
      return
      end

      subroutine detwlfac1(id,radius,wlfac1,wlfac2,wlfac3,wlfac4)
c----------------------------
c     with center
c----------------------------
      implicit real*8 (a-h,o-z)
      
      if(id.gt.3.and.id.ne.100)then
         write(6,*)'ERROR in detwlfac1(): id ',id
         stop
      endif
      
      if(radius.le.0.002d0)then
         if(     id.eq.100)then   ! 2st-spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=60.d0
            wlfac4=90.d0
         else if(id.eq.1)then ! spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=60.d0
            wlfac4=90.d0
         else if(id.eq.2)then   ! cca
            wlfac1=5.d0
            wlfac2=6.d0
            wlfac3=60.d0
            wlfac4=90.d0
         else if(id.eq.3)then   ! nccca
            wlfac1=10.d0
            wlfac2=15.d0
            wlfac3=100.d0
            wlfac4=120.d0
         endif
c------------------------------------------------------------------         
c  2mʲΤ줤ϼˡȤˤȤʤӰ򤫤С 20170718         
c         if(     id.eq.100)then   ! 2st-spac
c            wlfac1=3.d0
c            wlfac4=90.d0
c         else if(id.eq.1)then ! spac
c            wlfac1=3.d0
c            wlfac4=60.d0
c         else if(id.eq.2)then   ! cca
c            wlfac1=60.d0
c            wlfac4=90.d0
c         else if(id.eq.3)then   ! nccca
c            wlfac1=90.d0
c            wlfac4=150.d0
c         endif
c------------------------------------------------------------------         
      else if(radius.le.0.010d0)then
         if(     id.eq.100)then   ! 2st-spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=10.d0
            wlfac4=30.d0
         else if(     id.eq.1)then ! spac
            wlfac1=3.d0
            wlfac2=6.d0
            wlfac3=10.d0
            wlfac4=30.d0
         else if(id.eq.2)then   ! cca
            wlfac1=5.d0
            wlfac2=8.d0
            wlfac3=10.d0
            wlfac4=30.d0
         else if(id.eq.3)then   ! nccca
            wlfac1=8.d0
            wlfac2=12.d0
            wlfac3=20.d0
            wlfac4=40.d0
         endif
      else
         if(     id.eq.100)then   ! 2st-spac
            wlfac1=4.d0
            wlfac2=6.d0
            wlfac3=8.d0
            wlfac4=10.d0
         else if(     id.eq.1)then ! spac
            wlfac1=4.d0
            wlfac2=6.d0
            wlfac3=8.d0
            wlfac4=10.d0
         else if(id.eq.2)then   ! cca
            wlfac1=6.d0
            wlfac2=7.d0
            wlfac3=8.d0
            wlfac4=10.d0
         else if(id.eq.3)then   ! nccca
            wlfac1=8.d0
            wlfac2=10.d0
            wlfac3=15.d0
            wlfac4=20.d0
         endif
      endif

      return
      end

      subroutine wlfac2wgt(eps,
     +     wlfac,wlfac1,wlfac2,wlfac3,wlfac4,wgt)
      implicit real*8 (a-h,o-z)
      if(     wlfac.lt.wlfac1)then
         wgt=eps*exp(wlfac-wlfac1)
      else if(wlfac.lt.wlfac2)then
         a=(1.d0-eps)/(wlfac2-wlfac1)
         b=1.d0-a*wlfac2
         wgt=a*wlfac+b
      else if(wlfac.lt.wlfac3)then
         wgt=1.d0
      else if(wlfac.lt.wlfac4)then
         a=(eps-1.d0)/(wlfac4-wlfac3)
         b=1.d0-a*wlfac3
         wgt=a*wlfac+b
      else
         wgt=eps*exp(-(wlfac-wlfac4))
      endif
      return
      end


      subroutine wlfac2wgt_org(wlfac,wlfac1,wlfac2,wlfac3,wlfac4,wgt)
      implicit real*8 (a-h,o-z)
      if(     wlfac.lt.wlfac1)then
         wgt=0.d0
      else if(wlfac.lt.wlfac2)then
         wgt=(wlfac-wlfac1)/(wlfac2-wlfac1)
      else if(wlfac.lt.wlfac3)then
         wgt=1.d0
      else if(wlfac.lt.wlfac4)then
         wgt=1.d0-(wlfac-wlfac3)/(wlfac4-wlfac3)
      else
         wgt=0.d0
      endif
      return
      end

      subroutine calrange(fmin,fmax,n,fspm,fsp,fspp)
      implicit real*8 (a-h,o-z)
      fmin_log=log10(fmin)
      fmax_log=log10(fmax)
      df=(fmax_log-fmin_log)/dble(n)

      fmin_log=log10(fspm)
      fsp_logm=fmin_log
      fsp_log =fmin_log+df/2.d0
      fsp_logp=fmin_log+df

      fspm=10**fsp_logm
      fsp =10**fsp_log
      fspp=10**fsp_logp

      dfsp=fspp-fspm

      call caldfana(dfana)
      
      if(dfsp.lt.dfana)then
         fsp=fspm+dfana/2.d0
         fspp=fspm+dfana
      endif
      
      return
      end

      subroutine caldfana(dfana)
      implicit real*8 (a-h,o-z)
      common /PARASPEC/smb,df4spec
      if(smb.gt.10000.d0)then
c-----------------------         
c         df4spec=0.0977d0
c-----------------------
         lwfd0=int(smb/10000)
         Nconst=2*(lwfd0-1)+1
         freql=smb-lwfd0*10000.d0
         dfana=(lwfd*2+1)*df4spec
      else
         dfana=smb
      endif
      return
      end
      
      subroutine calrange_org(fmin,fmax,n,fspm,fsp,fspp,i)
      implicit real*8 (a-h,o-z)
      fmin_log=log10(fmin)
      fmax_log=log10(fmax)
      df=(fmax_log-fmin_log)/dble(n)
      fsp_logm=fmin_log+df*(i-1)-df/2.d0
      fsp_log=fmin_log+df*(i-1)
      fsp_logp=fmin_log+df*(i-1)+df/2.d0
      fspm=10**fsp_logm
      fsp=10**fsp_log
      fspp=10**fsp_logp
      return
      end

      subroutine takemed(dat,k,dat_med)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)
      dimension dat(nmax),dat_sort(nmax)
      call sort(dat,k,dat_sort)
      if(mod(k,2).eq.1)then
         kmed=int(dble(k-1)/2.d0)+1
         dat_med=dat_sort(kmed)
      else
         kmed1=int(dble(k/2.d0))
         kmed2=int(dble(k/2.d0))+1
         dat_med=(dat_sort(kmed1)+dat_sort(kmed2))/2.d0
      endif
      return
      end

      
      SUBROUTINE SORT(X,N,Y)
C
C     PURPOSE--THIS SUBROUTINE SORTS (IN ASCENDING ORDER)
C              THE N ELEMENTS OF THE SINGLE PRECISION VECTOR X
C              AND PUTS THE RESULTING N SORTED VALUES INTO THE
C              SINGLE PRECISION VECTOR Y.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                OBSERVATIONS TO BE SORTED. 
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X. 
C     OUTPUT ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR
C                                INTO WHICH THE SORTED DATA VALUES
C                                FROM X WILL BE PLACED.
C     OUTPUT--THE SINGLE PRECISION VECTOR Y
C             CONTAINING THE SORTED
C             (IN ASCENDING ORDER) VALUES
C             OF THE SINGLE PRECISION VECTOR X.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--THE DIMENSIONS OF THE VECTORS IL AND IU 
C                   (DEFINED AND USED INTERNALLY WITHIN
C                   THIS SUBROUTINE) DICTATE THE MAXIMUM
C                   ALLOWABLE VALUE OF N FOR THIS SUBROUTINE.
C                   IF IL AND IU EACH HAVE DIMENSION K,
C                   THEN N MAY NOT EXCEED 2**(K+1) - 1.
C                   FOR THIS SUBROUTINE AS WRITTEN, THE DIMENSIONS
C                   OF IL AND IU HAVE BEEN SET TO 36,
C                   THUS THE MAXIMUM ALLOWABLE VALUE OF N IS
C                   APPROXIMATELY 137 BILLION.
C                   SINCE THIS EXCEEDS THE MAXIMUM ALLOWABLE
C                   VALUE FOR AN INTEGER VARIABLE IN MANY COMPUTERS,
C                   AND SINCE A SORT OF 137 BILLION ELEMENTS
C                   IS PRESENTLY IMPRACTICAL AND UNLIKELY,
C                   THEN THERE IS NO PRACTICAL RESTRICTION
C                   ON THE MAXIMUM VALUE OF N FOR THIS SUBROUTINE.
C                   (IN LIGHT OF THE ABOVE, NO CHECK OF THE 
C                   UPPER LIMIT OF N HAS BEEN INCORPORATED
C                   INTO THIS SUBROUTINE.)
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     COMMENT--THE SMALLEST ELEMENT OF THE VECTOR X
C              WILL BE PLACED IN THE FIRST POSITION
C              OF THE VECTOR Y,
C              THE SECOND SMALLEST ELEMENT IN THE VECTOR X
C              WILL BE PLACED IN THE SECOND POSITION
C              OF THE VECTOR Y, ETC.
C     COMMENT--THE INPUT VECTOR X REMAINS UNALTERED.
C     COMMENT--IF THE ANALYST DESIRES A SORT 'IN PLACE',
C              THIS IS DONE BY HAVING THE SAME
C              OUTPUT VECTOR AS INPUT VECTOR IN THE CALLING SEQUENCE. 
C              THUS, FOR EXAMPLE, THE CALLING SEQUENCE
C              CALL SORT(X,N,X)
C              IS ALLOWABLE AND WILL RESULT IN
C              THE DESIRED 'IN-PLACE' SORT.
C     COMMENT--THE SORTING ALGORTHM USED HEREIN
C              IS THE BINARY SORT.
C              THIS ALGORTHIM IS EXTREMELY FAST AS THE
C              FOLLOWING TIME TRIALS INDICATE.
C              THESE TIME TRIALS WERE CARRIED OUT ON THE
C              UNIVAC 1108 EXEC 8 SYSTEM AT NBS
C              IN AUGUST OF 1974.
C              BY WAY OF COMPARISON, THE TIME TRIAL VALUES
C              FOR THE EASY-TO-PROGRAM BUT EXTREMELY
C              INEFFICIENT BUBBLE SORT ALGORITHM HAVE
C              ALSO BEEN INCLUDED--
C              NUMBER OF RANDOM        BINARY SORT       BUBBLE SORT
C               NUMBERS SORTED
C                N = 10                 .002 SEC          .002 SEC
C                N = 100                .011 SEC          .045 SEC
C                N = 1000               .141 SEC         4.332 SEC
C                N = 3000               .476 SEC        37.683 SEC
C                N = 10000             1.887 SEC      NOT COMPUTED
C     REFERENCES--CACM MARCH 1969, PAGE 186 (BINARY SORT ALGORITHM
C                 BY RICHARD C. SINGLETON).
C               --CACM JANUARY 1970, PAGE 54.
C               --CACM OCTOBER 1970, PAGE 624.
C               --JACM JANUARY 1961, PAGE 41.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-921-2315
C     ORIGINAL VERSION--JUNE      1972. 
C     UPDATED         --NOVEMBER  1975. 
C
C---------------------------------------------------------------------
C
      implicit real*8 (a-h,o-z)                                         
      DIMENSION X(1),Y(1)
      DIMENSION IU(36),IL(36) 
C
      IPR=6
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)GOTO 50
      IF(N.EQ.1)GOTO 55
      HOLD=X(1)
      DO 60 I=2,N
      IF(X(I).NE.HOLD)GOTO 90
   60 CONTINUE
c      WRITE(IPR, 9)HOLD
      DO 61 I=1,N
      Y(I)=X(I)
   61 CONTINUE
      RETURN
   50 WRITE(IPR,15) 
      WRITE(IPR,47)N
      RETURN
c   55 WRITE(IPR,18) 
   55 continue
      Y(1)=X(1)
      RETURN
   90 CONTINUE
    9 FORMAT(1H ,108H***** NON-FATAL DIAGNOSTIC--THE FIRST  INPUT ARGUME
     1NT (A VECTOR) TO THE SORT   SUBROUTINE HAS ALL ELEMENTS = ,E15.8,6
     1H *****)
   15 FORMAT(1H , 91H***** FATAL ERROR--THE SECOND INPUT ARGUMENT TO THE
     1 SORT   SUBROUTINE IS NON-POSITIVE *****)
   18 FORMAT(1H ,100H***** NON-FATAL DIAGNOSTIC--THE SECOND INPUT ARGUME
     1NT TO THE SORT   SUBROUTINE HAS THE VALUE 1 *****)
   47 FORMAT(1H , 35H***** THE VALUE OF THE ARGUMENT IS ,I8   ,6H *****)
C
C-----START POINT-----------------------------------------------------
C
C     COPY THE VECTOR X INTO THE VECTOR Y
      DO 10 0I=1,N
      Y(I)=X(I)
  100 CONTINUE
C
C     CHECK TO SEE IF THE INPUT VECTOR IS ALREADY SORTED
C
      NM1=N-1
      DO 200 I=1,NM1
      IP1=I+1
      IF(Y(I).LE.Y(IP1))GOTO 200
      GOTO 250
  200 CONTINUE
      RETURN
  250 M=1 
      I=1 
      J=N 
  305 IF(I.GE.J)GOTO 370
  310 K=I 
      MID=(I+J)/2
      AMED=Y(MID)
      IF(Y(I).LE.AMED)GOTO 320 
      Y(MID)=Y(I)
      Y(I)=AMED
      AMED=Y(MID)
  320 L=J 
      IF(Y(J).GE.AMED)GOTO 340 
      Y(MID)=Y(J)
      Y(J)=AMED
      AMED=Y(MID)
      IF(Y(I).LE.AMED)GOTO 340 
      Y(MID)=Y(I)
      Y(I)=AMED
      AMED=Y(MID)
      GOTO 340
  330 Y(L)=Y(K)
      Y(K)=TT
  340 L=L-1
      IF(Y(L).GT.AMED)GOTO 340 
      TT=Y(L)
  350 K=K+1
      IF(Y(K).LT.AMED)GOTO 350 
      IF(K.LE.L)GOTO 330
      LMI=L-I
      JMK=J-K
      IF(LMI.LE.JMK)GOTO 360
      IL(M)=I
      IU(M)=L
      I=K 
      M=M+1
      GOTO 380
  360 IL(M)=K
      IU(M)=J
      J=L 
      M=M+1
      GOTO 380
  370 M=M-1
      IF(M.EQ.0)RETURN
      I=IL(M)
      J=IU(M)
  380 JMI=J-I
      IF(JMI.GE.11)GOTO 310
      IF(I.EQ.1)GOTO 305
      I=I-1
  390 I=I+1
      IF(I.EQ.J)GOTO 370
      AMED=Y(I+1)
      IF(Y(I).LE.AMED)GOTO 390 
      K=I 
  395 Y(K+1)=Y(K)
      K=K-1
      IF(AMED.LT.Y(K))GOTO 395 
      Y(K+1)=AMED
      GOTO 390
      END 
      

