c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
      parameter(nmax=500000)
      implicit real*8 (a-h,o-z)
      dimension id(nmax)
      dimension radius(nmax),f(nmax),pv(nmax),pvlim(nmax),pv2(nmax),
     +     knum(nmax)
      read(5,*)fmin,fmax,n
      read(5,*)idcategory
      i=1
 10   read(5,*,err=99,end=99)
     +     id(i),kdum,radius(i),knum(i),f(i),pv(i),pvlim(i)
c      write(6,'(a,i3,5f12.5)')'DEBUG: ',
c     +     id(i),radius(i),f(i),pv(i),pv2(i),pvlim(i)
      i=i+1
      goto 10
 99   continue
      ndata=i-1

      fmin_log=log10(fmin)
      fmax_log=log10(fmax)
      df=(fmax_log-fmin_log)/dble(n)
      do i=1,n+1
         fsp_logm=fmin_log+df*(i-1)-df/2.d0
         fsp_log=fmin_log+df*(i-1)
         fsp_logp=fmin_log+df*(i-1)+df/2.d0
         fspm=10**fsp_logm
         fsp=10**fsp_log
         fspp=10**fsp_logp
         k=0
         sumf=0.d0
         sumpv=0.d0
         sumpv2=0.d0
c         write(6,*)'DEBUG: ',fspm,fspp
         do j=1,ndata
            if(f(j).ge.fspm.and.f(j).lt.fspp)then
               call detectok2(idcategory,
     +              id(j),radius(j),f(j),pv(j),pvlim(j),idok)
               
               if(idok.eq.1)then
                  sumf=sumf+f(j)
                  sumpv=sumpv+pv(j)
                  sumpv2=sumpv2+pv(j)**2
                  k=k+1
               endif
            endif
         enddo
         if(k.gt.0)then
c            avef=sumf/dble(k)
            ave=sumpv/dble(k)
            if(k.gt.1)then
               std=sqrt((sumpv2-dble(k)*ave**2)/dble(k-1))
               write(6,'(2f12.4,e15.6,i5)')fsp,ave,std,k
            else
               write(6,'(2f12.4,e15.6,i5)')fsp,ave,0.d0,k
            endif
         endif
      enddo
      stop
      end

      subroutine detectok2(idcategory,id,radius,f,pv,pvlim,idok)
c--------------------------------------------------------------------------
c idcategory  contents   rmin   rmax Ͽ̷׿/­
c     1       2stSPAC     0     2m   2-3/2SPACΤ
c     2       2stSPAC     0     inf  2-3/2SPACΤ
c     3       SPAC/CCA    0     2m   3-5/2SPAC
c     4       SPAC/CCA    0     inf  3-5/2SPAC
c     5       SPAC/CCA    0     2m   4-6/2SPAC&ʳ
c             nc-CCA                 (˾줤η̤)
c     6       SPAC/CCA    0     inf  4-6/2SPAC&ʳ
c             nc-CCA    (줤η̤)
c--------------------------------------------------------------------------
c     *1,2ID100ʳidok=0Ȥ뤳ȤǼ¸
c     *3,4pvlim-999˶ꤹ뤳ȤǼ¸
c     & ID100idok=0Ȥ
c     *5,6ID100idok=0Ȥ뤳ȤǼ¸
c--------------------------------------------------------------------------
      implicit real*8 (a-h,o-z)
      idok=1
      wl=pv/f
      wlfac=wl/radius
      pvlimfac=pvlim/pv
      
c----------------------      
c idcategoryˤ 
c----------------------      
      if(idcategory.eq.3.or.idcategory.eq.4)then
         pvlimfac=-1.d0
      endif
c----------------------      
c idcategoryˤ ޤ
c----------------------      
c      write(6,*)'DEBUG: ',pvlimfac
      
      if(pvlimfac.lt.0.d0)then
         id_with_center=0
         call detwlfac0(id,radius,wlfacmin,wlfacmax)
         if(wlfac.lt.wlfacmin.or.wlfac.gt.wlfacmax)idok=0
      else
         id_with_center=1
         call detwlfac1(id,radius,wlfacmin,wlfacmax)
         if(wlfac.lt.wlfacmin.or.wlfac.gt.wlfacmax)idok=0

c PV LIMITʲϷ̤ʼˤǧƼưɼ롣
c         if(wlfac.ge.8.d0)then
         if(wlfac.ge.8.d0.and.id.ne.3)then ! nc-CCAʳȤͿ
c                                                20160213ѹ
c-----------------------------------
c  pvlimfacmin=Log(wfac)+1Ѥ롣(min,max)=(1,3)
c     wlfac=10λ  pvlimfacmin=2
c     wlfac>=100λpvlimfacmin=3
c-----------------------------------
            pvlimfacmin=log10(wlfac)+1.d0
            if(pvlimfacmin.lt.1.d0)pvlimfacmin=1.d0
            if(pvlimfacmin.gt.3.d0)pvlimfacmin=3.d0
c     write(6,*)'DEBUG:pvlimfacmin,wlfac',pvlimfacmin,wlfac
            if(pvlimfac.lt.pvlimfacmin)idok=0
         endif
      endif
      
c----------------------
c idcategoryˤ 
c----------------------
      if(     idcategory.eq.1.or.idcategory.eq.2)then
         if(id.ne.100)idok=0
      else if(idcategory.eq.3.or.idcategory.eq.4)then
         if(id.eq.100)idok=0
      else if(idcategory.eq.5.or.idcategory.eq.6)then
         if(id.eq.100)idok=0
      endif
         
      if(     idcategory.eq.1)then
         if(radius.gt.0.002d0)idok=0
      else if(idcategory.eq.3)then
         if(radius.gt.0.002d0)idok=0
      else if(idcategory.eq.5)then
         if(radius.gt.0.002d0)idok=0
      endif
c----------------------      
c idcategoryˤ ޤ
c----------------------      

      return
      end

      subroutine detwlfac0(id,radius,wlfacmin,wlfacmax)
      implicit real*8 (a-h,o-z)
      if(radius.le.0.002d0)then
         if(     id.eq.100)then   ! 2st-spac
            wlfacmin=3.d0
            wlfacmax=60.d0
         else if(id.eq.1)then ! spac
            wlfacmin=3.d0
            wlfacmax=60.d0
         else if(id.eq.2)then   ! cca
            wlfacmin=5.d0
            wlfacmax=60.d0
         endif
      else if(radius.le.0.010d0)then
         if(     id.eq.100)then   ! 2st-spac
            wlfacmin=3.d0
            wlfacmax=30.d0
         else if(id.eq.1)then   ! spac
            wlfacmin=3.d0
            wlfacmax=30.d0
         else if(id.eq.2)then   ! cca
            wlfacmin=5.d0
            wlfacmax=30.d0
         endif
      else
         if(     id.eq.100)then   ! 2st-spac
            wlfacmin=4.d0
            wlfacmax=8.d0
         else if(id.eq.1)then ! spac
            wlfacmin=4.d0
            wlfacmax=8.d0
         else if(id.eq.2)then   ! cca
            wlfacmin=6.d0
            wlfacmax=8.d0
         endif
      endif

      return
      end

      subroutine detwlfac1(id,radius,wlfacmin,wlfacmax)
      implicit real*8 (a-h,o-z)
      if(radius.le.0.002d0)then

c------------------------------------------------------------------         
c  2mʲΤ줤ϼˡȤˤȤʤӰ򤫤С뤳Ȥˡ20170718         
c         if(     id.eq.100)then   ! 2st-spac
c            wlfacmin=3.d0
c            wlfacmax=90.d0
c         else if(id.eq.1)then ! spac
c            wlfacmin=3.d0
c            wlfacmax=90.d0
c         else if(id.eq.2)then   ! cca
c            wlfacmin=5.d0
c            wlfacmax=90.d0
c         else if(id.eq.3)then   ! nccca
c            wlfacmin=10.d0
c            wlfacmax=120.d0
c         endif
         if(     id.eq.100)then   ! 2st-spac
            wlfacmin=3.d0
            wlfacmax=90.d0
         else if(id.eq.1)then ! spac
            wlfacmin=3.d0
            wlfacmax=60.d0
         else if(id.eq.2)then   ! cca
            wlfacmin=60.d0
            wlfacmax=90.d0
         else if(id.eq.3)then   ! nccca
            wlfacmin=90.d0
            wlfacmax=150.d0
         endif
c------------------------------------------------------------------         

      else if(radius.le.0.010d0)then
         if(     id.eq.100)then   ! 2st-spac
            wlfacmin=3.d0
            wlfacmax=20.d0
         else if(     id.eq.1)then ! spac
            wlfacmin=3.d0
            wlfacmax=20.d0
         else if(id.eq.2)then   ! cca
            wlfacmin=5.d0
            wlfacmax=20.d0
         else if(id.eq.3)then   ! nccca
            wlfacmin=8.d0
            wlfacmax=30.d0
         endif
      else
         if(     id.eq.100)then   ! 2st-spac
            wlfacmin=4.d0
            wlfacmax=10.d0
         else if(     id.eq.1)then ! spac
            wlfacmin=4.d0
            wlfacmax=10.d0
         else if(id.eq.2)then   ! cca
            wlfacmin=6.d0
            wlfacmax=10.d0
         else if(id.eq.3)then   ! nccca
            wlfacmin=8.d0
            wlfacmax=20.d0
         endif
      endif

      return
      end
