c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NMAX_INC 5000000
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC)
      dimension dat(nmax),f(nmax)
      character*200 datafile
c      data frange/0.05d0/
      
      read(5,*)frange_half
      read(5,*)fzero_obs,dum,izero
      read(5,'(a)')datafile

      open(10,file=datafile)
      i=1
 10   read(10,*,end=99,err=99)f(i),dat(i)
      i=i+1
      goto 10
 99   continue
      ndata=i-1
      if(ndata.gt.nmax)then
         write(6,*)'Program refinespaczero'
         write(6,*)'ERROR(ndata>nmax) in rmkd: ',ndata,nmax
         stop
      endif

      fl=fzero_obs*(1.d0-frange_half)
      fu=fzero_obs*(1.d0+frange_half)

      amin=1.d18
      do i=1,ndata
         fdiff=abs(f(i)-fl)
         if(fdiff.le.amin)then
            amin=fdiff
            ifl=i
         endif
      enddo

      amin=1.d18
      do i=ifl,ndata
         fdiff=abs(f(i)-fu)
         if(fdiff.le.amin)then
            amin=fdiff
            ifu=i
         endif
      enddo

      amin=1.d18
      imin=-1
      do i=ifl,ifu
         fdiff=abs(f(i)-fzero_obs)

         idok=0
         if(mod(izero,2).eq.1)then
            if(dat(i-1).gt.0.d0.and.dat(i+1).lt.0.d0)idok=1
         else
            if(dat(i-1).lt.0.d0.and.dat(i+1).gt.0.d0)idok=1
         endif
         
         if(idok.eq.1.and.fdiff.le.amin)then
            amin=fdiff
            imin=i
         endif
      enddo

      if(imin.eq.-1)then
c         write(6,*)fzero_obs
         write(6,'(a)')'NaN'
      else
         write(6,*)f(imin)
      endif
      
      stop
      end

