c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NPMAX_INC 500
#define NCMAX_INC 1000
#define NDMAX_INC 50000
      
      parameter(ncmax=NCMAX_INC,ndmax=NDMAX_INC,npmax=NPMAX_INC)
      implicit real*8 (a-h,o-z)
      common /dblock/f_pick(npmax),pv_pick(npmax),
     +     f(ndmax,ncmax),pv(ndmax,ncmax),
     +     pverr(ndmax,ncmax),
     +     kosu(ndmax,ncmax),id_pick_type(npmax),
     +     idtype(ndmax,ncmax),index_ok(ncmax),
     +     idopt(ncmax),np,nc,nd
      character*200 pickfile,pvfile
      
      read(5,'(a)')pickfile
      read(5,'(a)')pvfile
      read(5,*)adiflim
      read(5,*)nc
c      write(6,*)'adiflim',adiflim
c      write(6,*)'nc:',nc
      
      open(15,file=pickfile)
      do ip=1,npmax
         read(15,*,err=9,end=9)f_pick(ip),pv_pick(ip),
     +        id_pick_type(ip)
c         write(16,*)'DEBUG: ',ip,f_pick(ip),pv_pick(ip),
c     +        id_pick_type(ip)
      enddo
 9    continue
      np=ip-1
      close(15)

      open(15,file=pvfile)
      do id=1,ndmax
         read(15,*,err=99,end=99)
     +        (f(id,ic),pv(id,ic),pverr(id,ic),
     +        kosu(id,ic),idtype(id,ic),ic=1,nc)
      enddo
 99   continue
      nd=id-1
      close(15)
      
      do ip=1,np
c         call detf(ip,idopt)
         adifmin=1.d8
         id_status=0
c detect a data point, dopt,  nearest to the reading point        
c Step1 consider pv data other than 2st-SPAC 
         do ic=1,nc
            call detf(ip,ic)
            idok=1
            if(idtype(idopt(ic),ic).le.0)idok=0    
            if(idtype(idopt(ic),ic).ge.990)idok=0
            if(idok.eq.1)then
               adif=abs(pv(idopt(ic),ic)-pv_pick(ip))/pv_pick(ip)
               if(adif.le.adifmin)then
                  icmin=ic
                  adifmin=adif
               endif
            endif
c            write(6,*)'DEBUG ic ',
c     +           ic,f(idopt(ic),ic),pv(idopt(ic),ic),
c     +           idtype(idopt(ic),ic)

         enddo
         if(adifmin.le.adiflim)then
            id_status=1
         endif

c     Step2 consider pv data of 2st-SPAC
         if(id_status.eq.0)then
            adifmin=1.d8
            do ic=1,nc
               idok=1
               if(idtype(idopt(ic),ic).le.0)idok=0    
               if(idok.eq.1)then
                  adif=abs(pv(idopt(ic),ic)-pv_pick(ip))/pv_pick(ip)
                  if(adif.le.adifmin)then
                     icmin=ic
                     adifmin=adif
                  endif
               endif
            enddo
            if(adifmin.le.adiflim)then
               id_status=2
            endif
         endif
c         write(6,*)'DEBUG id_status',id_status,f_pick(ip),pv_pick(ip)

c  id_status=0 no phase velocity data 
c  id_status=1 phase velocity data othan than 2st-spac 
c  id_status=2 phase velocity data of 2st-spac 

c#XXXXXXXXXXXXXX  idtype 
c#VELFILES_AL     -1
c#VELFILES_SPAC   1
c#VELFILES_ESAC   100
c#VELFILES_NCSPAC 110
c#VELFILES_SPAC1P 999
c#VELFILES_CCA    2
c#VELFILES_NCCCA  3
c#XXXXXXXXXXXXXXXX
         
c take average of data points with relative distance < adiflim from pv(idopt)
         
         if(     id_status.eq.0)then
            write(6,'(3f10.6,i10)')
     +           f_pick(ip),pv_pick(ip),0.,0 ! nothing done
         else ! take statistics
            nok=0
            do ic=1,nc
               idok=1
               if(idtype(idopt(ic),ic).le.0)
     +              idok=0
               if(id_status.eq.1.and.idtype(idopt(ic),ic).ge.990)
     +              idok=0
               adif=abs(pv(idopt(ic),ic)-pv(idopt(ic),icmin))
     +              /pv(idopt(ic),icmin)
               if(adif.gt.adiflim)idok=0
               if(idok.eq.1)then
                  nok=nok+1
                  index_ok(nok)=ic
c                  write(6,'(2f10.6)')f(idopt(ic),ic),pv(idopt(ic),ic)
               endif
            enddo
            ksum=0
            sum=0.d0
            do iok=1,nok
               ic=index_ok(iok)
               ksum=ksum+kosu(idopt(ic),ic)
               sum=sum+pv(idopt(ic),ic)*kosu(idopt(ic),ic)
            enddo

c-----------------------------            
c assume perfect correlation            
c-----------------------------            
            sum2=0.d0
            do iok=1,nok
               ic=index_ok(iok)
            do jok=1,nok
               jc=index_ok(jok)
               sum2=sum2+
     +              pverr(idopt(ic),ic)*kosu(idopt(ic),ic)
     +             *pverr(idopt(jc),jc)*kosu(idopt(jc),jc)
            enddo
            enddo
            kosuave=int(dble(ksum)/dble(nok)+0.5)
            pvave=sum/dble(ksum)
            pverrave=dsqrt(sum2/dble(ksum**2))


            if(id_pick_type(ip).eq.1)then
               write(6,'(3f10.6,2i10)')
     +              f(idopt(1),1),pvave,pverrave,kosuave,
     +              id_pick_type(ip)
c            write(6,'(3f10.6)')f_pick(ip),pv_pick(ip),pv_pick(ip)*0.1,kosu(ip) ! nothing done
            else
               write(6,'(3f10.6,2i10)')
     +              f_pick(ip),pv_pick(ip),pverrave,kosuave,
     +              id_pick_type(ip)
            endif
            
         endif
         
      enddo !   do ip=1,np
      stop
      end
      
      subroutine detf(ip,ic)
      parameter(ncmax=NCMAX_INC,ndmax=NDMAX_INC,npmax=NPMAX_INC)
      implicit real*8 (a-h,o-z)
      common /dblock/f_pick(npmax),pv_pick(npmax),
     +     f(ndmax,ncmax),pv(ndmax,ncmax),
     +     pverr(ndmax,ncmax),
     +     kosu(ndmax,ncmax),id_pick_type(npmax),
     +     idtype(ndmax,ncmax),index_ok(ncmax),
     +     idopt(ncmax),np,nc,nd
      amin=1.d8
      do id=1,nd
         adif=abs(f_pick(ip)-f(id,ic))
         if(adif.le.amin)then
            amin=adif
            idopt(ic)=id
         endif
      enddo
      return
      end
      
