c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NMAX_INC 5000000
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC,nzeromax=10)
      dimension dat(nmax),f(nmax),rk(nzeromax)
      character*200 datafile
      cmin=0.050d0 ! set minimum vs as 50m/s
      pi=acos(-1.d0)
      pi2=pi*2.d0
      rk(1)=2.4048d0
      rk(2)=5.5201d0
      rk(3)=8.6537d0
      rk(4)=11.792d0
      rk(5)=14.931d0
      rk(6)=18.071d0
      rk(7)=21.212d0
      rk(8)=24.353d0
      rk(9)=27.494d0
      rk(10)=30.635d0

      read(5,*)r
      read(5,'(a)')datafile
      read(5,*)clim2
      read(5,*)fmin
      read(5,*)fmax
      clim2=abs(clim2)
      
      open(10,file=datafile)
      i=1
 10   read(10,*,end=99,err=99)f_in,dat_in
      if(f_in.ge.fmin.and.f_in.le.fmax)then
         f(i)=f_in
         dat(i)=dat_in
         i=i+1
      endif
      goto 10
 99   close(10)
      ndata=i-1
      if(ndata.gt.nmax)then
         write(6,*)'Program get_spaczero'
         write(6,*)'ERROR(ndata>nmax) ',ndata,nmax
         stop
      endif

c get the frequency wehre the SPAC coeff is the smallest
      datzero=1.d8
      do i=1,ndata
c         write(6,*)'DEBUG ',f(i),dat(i),datzero,fzero
         if(dat(i).le.datzero)then
            c=pi2*f(i)*r/rk(1)
            if(c.ge.cmin)then
               datzero=dat(i)
               fzero=f(i)
            endif
         endif
      enddo
      
      if(datzero.le.clim2)then
         write(6,*)fzero
      else
         write(6,*)-1.d0
      endif
      
      stop
      end

