c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NMAX_INC 5000000
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC,nzeromax=10)
      dimension dat(nmax),f(nmax),rk(nzeromax)
      dimension fzero(nzeromax)
      character*200 datafile
      cmin=0.050d0 ! set minimum vs as 50m/s
      pi=acos(-1.d0)
      pi2=pi*2.d0
      rk(1)=2.4048d0
      rk(2)=5.5201d0
      rk(3)=8.6537d0
      rk(4)=11.792d0
      rk(5)=14.931d0
      rk(6)=18.071d0
      rk(7)=21.212d0
      rk(8)=24.353d0
      rk(9)=27.494d0
      rk(10)=30.635d0

      read(5,*)r
      read(5,'(a)')datafile
      read(5,*)fmin
      read(5,*)fmax
c      write(6,*)r
c      write(6,'(a)')datafile
      
      open(10,file=datafile)
      i=1
 10   read(10,*,end=99,err=99)f_in,dat_in
      if(f_in.ge.fmin.and.f_in.le.fmax)then
         f(i)=f_in
         dat(i)=dat_in
         i=i+1
      endif
      goto 10
 99   close(10)
      ndata=i-1
      if(ndata.gt.nmax)then
         write(6,*)'Program get_spaczero'
         write(6,*)'ERROR(ndata>nmax) ',ndata,nmax
         stop
      endif

      izero=0
      do i=2,ndata
         if(dat(i-1)*dat(i).lt.0.d0)then
            izero=izero+1
            c=pi2*f(i)*r/rk(izero)
            idok=1
            if(c.lt.cmin)idok=0
            if(izero.eq.1.and.dat(i-1).lt.0.d0)idok=0 ! downward is ok
            if(idok.eq.1)then
c               write(6,*)f(i),izero
               fzero(izero)=f(i)
            else
               izero=izero-1
            endif
         endif
      enddo
      nzero=izero

c------------------------------------
c  check the values between the 1st and 2nd zeros      
c   if the maximum amplitide > 0.6 or < 0.2, later zeros readings are ignored
c     (the minumum value < -0.6 or > -0.2)
c  20220626 
c------------------------------------
      if(nzero.ge.2)then
         amin=1.d8
         do i=1,ndata
            if(f(i).ge.fzero(1).and.f(i).le.fzero(2))then
               if(dat(i).le.amin)then
                  amin=dat(i)
               endif
            endif
         enddo
         if(amin.lt.-0.6d0.or.amin.gt.-0.2d0) then
            nzero=1
         endif
      endif
         
      do izero=1,nzero
         write(6,*)fzero(izero),izero
      enddo

      stop
      end

