c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NMAX_INC 5000000
#define NZEROMAX_INC 15
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC,nzeromax=NZEROMAX_INC)
      dimension pv(nmax),f(nmax)
      character*200 datafile
      
      read(5,*)fac
      read(5,'(a)')datafile
c      write(6,*)fac
c      write(6,'(a)')datafile
      
      open(10,file=datafile)
      i=1
 5    read(10,*,err=9,end=9)f(i),pv(i)
      i=i+1
      goto 5
 9    close(10)
      npv=i-1
      if(npv.gt.nmax)then
         write(6,*)'Program check_spaczero_again'
         write(6,*)'ERROR(ndata>nmax) ',npv,nmax
         stop
      endif

      
 10   read(5,*,err=99,end=99)fzero,pvzero

      fdifmin=1.d18
      do i=1,npv
         fdif=abs(f(i)-fzero)
         if(fdif.le.fdifmin)then
            fdifmin=fdif
            imin=i
         endif
      enddo

      pvdif=abs(pvzero-pv(imin))/pv(imin)
      
      idok=1
!     differnce in frequnecy limited up to 5%
      if(fdifmin.gt.f(imin)*0.05d0)then
         idok=0
!     differnce in pv limited up to fac
      else if(pvdif.gt.fac)then
         idok=-1
      endif
      write(6,*)idok
      goto 10
 99   continue
      stop
      end
      
