#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved
#----------------------------------------
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
from pylab import *
from numpy import *
from tkinter import *
import sys
import os

#import matplotlib
#print(matplotlib.rcParams)
#print(matplotlib.__version__)
#print(matplotlib.matplotlib_fname())
#print(matplotlib.get_data_path())

# character
VERSION="SPAC ZERO reader (Ver.1.0)"
WORKDIR=os.getenv('WORKDIR') 
XTERM=os.getenv('XTERM')

# integer
ID_PNGOUT=int(os.getenv('ID_PNGOUT'))
FIGSIZE_X=int(os.getenv('FIGSIZE_X'))
FIGSIZE_Y=int(os.getenv('FIGSIZE_Y'))
DPI=int(os.getenv('DPI'))
# float
FONTSIZE=float(os.getenv('FONTSIZE'))
PLOTLIM_PV=float(os.getenv('PLOTLIM_SPAC'))
MIN_SPAC=float(os.getenv('MIN_SPAC'))
MAX_SPAC=float(os.getenv('MAX_SPAC'))
PLOTLIM_FREQ=float(os.getenv('PLOTLIM_FREQ'))
MIN_FREQ=float(os.getenv('MIN_FREQ'))
MAX_FREQ=float(os.getenv('MAX_FREQ'))

MARKSIZE_SPAC1ZERO=40
MARKSIZE_SPAC1ZERO1P=10
MARKSIZE_SPAC1ZERO_E=30
MARKSIZE_AUTO=150
MARKSIZE_EYES=100
no_of_pickups=0

IconReadColor=os.getenv('IconReadColor')

ax1log=int(os.getenv('ax1log'))
plotlim_freq=1
plotlim_pv=1

pngout=ID_PNGOUT
x_text_lim_length=2
x_text_rotation_angle=30

line_col="r" # temporaly defined
line_st="-"  # temporaly defined
line_w=0.5    # temporaly defined
freqeps=0.001 # temporaly defined (for plotting lines with constant wavelengths in logarithmic scale)

root=Tk()
root.title("Reading SPAC ZERO")

#-----------------------------------
# Read listfile
#-----------------------------------
fname=WORKDIR+"/list_sprspac.d"
f=open(fname)
listdat=f.read()
f.close()
lines=listdat.split('\n')
color=[];linestyle=[];lw=[];label1=[];label2=[];seismid=[];plotid=[];plotidok=[];radius=[];listdum1=[];listdum2=[];zerobango=[];pickedfileid=[];
zerobango.append("$1$")
zerobango.append("$2$")
zerobango.append("$3$")
zerobango.append("$4$")
zerobango.append("$5$")
zerobango.append("$6$")
zerobango.append("$7$")
zerobango.append("$8$")
zerobango.append("$9$")

npv=0
for line in lines:
    if line.split(' ')[0]!="":
        npv=npv+1
        listdum1.append(line.split(' ')[1])
        label1.append(line.split(' ')[2])
        label2.append(line.split(' ')[3])
        color.append(line.split(' ')[4])
        linestyle.append(line.split(' ')[5])
        lw.append(line.split(' ')[6])
        plotid.append(line.split(' ')[7])
        listdum2.append(line.split(' ')[8])
        radius.append(line.split(' ')[9])
        seismid.append(line.split(' ')[10])
        plotidok.append("1")
        
pickedfileid=listdum1
spac1pok=0
spacok=0
for i in range(len(plotid)):
    if   plotid[i]=="0": # 1p-spac
        plotidok[i]="0"  # <=  initially plot off for visibility
        spac1pok=1
    elif plotid[i]=="1": # spac
        plotidok[i]="1"  # <=  initially plot off for visibility
        spacok=1
        
#-----------------------------------
# Read Freqdat Velocity Data
#-----------------------------------
fname=WORKDIR+"/sprspac.d"
dat=genfromtxt(fname,delimiter=' ')

i=0
freq_max=max(dat[:,5*i])
freq_min=min(dat[:,5*i])
pv_max=max(dat[:,5*i+1])
pv_min=min(dat[:,5*i+1])
i=0
while i < npv:
    freq_max0=max(dat[:,5*i])
    freq_min0=min(dat[:,5*i])
    if freq_max0 > freq_max:
        freq_max=freq_max0
    if freq_min0 < freq_min:
        freq_min=freq_min0
    pv_max0  =max(dat[:,5*i+1])
    pv_min0  =min(dat[:,5*i+1])
    if pv_max0 > pv_max:
        pv_max=pv_max0
    if pv_min0 < pv_min:
        pv_min=pv_min0
    i+=1
#-----------------------------------

# Set parameter values
xcur=[]; ycur=[]     # for cursol point accumulation
xview=[];yview=[];markerview=[]

####################################################
def LineColSt(i,j):
    global line_col,line_st
    line_w=0.5

    if   j%4==0:
        line_st="--"
    elif j%4==1:
        line_st="-"
    elif j%4==2:
        line_st="-."
    elif j%4==3:
        line_st=":"
                
    if   i%7==0:
        line_col="r"
    elif i%7==1:
        line_col="b"
    elif i%7==2:
        line_col="g"
    elif i%7==3:
        line_col="c"
    elif i%7==4:
        line_col="m"
    elif i%7==5:
        line_col="y"
    elif i%7==6:
        line_col="k"
        
def ChangePlotIDOK(idproceed,idfullauto):
    global plotid,plotidok,ChangePlotIDFlag
    global ichangeplotidok,npv,npv4plot

    if idproceed==0 and npv4plot==-1:
        return

    PngPlot()
    WriteData()
    ChangePlotIDFlag=1
    idok=0
    while idok == 0: 
        npv4plot=npv4plot+idproceed
        ichangeplotidok=npv4plot%npv
        
        if   plotid[ichangeplotidok]=="1":   # spac
            if plot_spac.get():
                idok=1
        elif plotid[ichangeplotidok]=="0": # 1p-spac
            if plot_2stspac.get():
                idok=1
#        print("DEBUG",label2[ichangeplotidok]) # exclude esac from the plots
#        if label2[ichangeplotidok]=="esac":
#                idok=0
                
    if idproceed==0:
        if idfullauto==1:
            DoFullAutoReadSpac()
        else:
            DoRefineSpac()

    RPicked()
            
    for i in range(len(plotidok)):
        plotidok[i]="0"
    plotidok[ichangeplotidok]="1"
    
    if label2[ichangeplotidok]=="esac": # exclude esac from the plots
        plotidok[ichangeplotidok]="0"
        
    onclick_dummy()

def PLTCNTL():
    global plotid,plotidok,ChangePlotIDFlag
    ChangePlotIDFlag=0

    if plot_spac.get()==0:
        if plot_2stspac.get()==0:
            plot_2stspac.set(1)

    for i in range(len(plotid)):
        if plotid[i]=="0": # 1p-spac
            if plot_2stspac.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="1": # spac
            if plot_spac.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        else:
            plotidok[i]="0"
        if label2[i]=="esac":  # exclude esac from the plots
            plotidok[i]="0"
            
def DoRefineSpac():
    global ichangeplotidok,pickedfileid
    global xcur,ycur,markerview
    xposp=[];yposp=[];zposp=[]
    xcur=[];ycur=[];markerview=[]
    fname0=pickedfileid[ichangeplotidok]
    fname="work/picked_"+fname0.split('/')[5]
    fname_out=WORKDIR+"/DoRefineSpac.d"
    fw=open(fname_out,'w')
    print('%s '%(fname), file=fw)
    print('%d '%(ichangeplotidok), file=fw)
    print('%s'%(radius[ichangeplotidok]), file=fw)
    print('%s'%(label1[ichangeplotidok]), file=fw)
    print('%s'%(label2[ichangeplotidok]), file=fw)
    fw.close()

    command="cd "+WORKDIR+";. ./mkDoRefineSpac.sh "
    print('command %s'%(command))
    os.system(command)
    

def DoFullAutoReadSpac():
    global ichangeplotidok,pickedfileid
    global xcur,ycur,markerview
    xposp=[];yposp=[];zposp=[]
    xcur=[];ycur=[];markerview=[]
    fname0=pickedfileid[ichangeplotidok]
    fname="work/picked_"+fname0.split('/')[5]

    fname_out=WORKDIR+"/DoRefineSpac.d"
    fw=open(fname_out,'w')
    print('%s'%(fname), file=fw)
    print('%d'%(ichangeplotidok), file=fw)
    print('%s'%(radius[ichangeplotidok]), file=fw)
    print('%s'%(label1[ichangeplotidok]), file=fw)
    print('%s'%(label2[ichangeplotidok]), file=fw)
    fw.close()

    command="cd "+WORKDIR+";. ./mkDoFullAutoReadSpac.sh"
    print('command %s'%(command))
    os.system(command)
    

def RPicked():
    global ichangeplotidok,pickedfileid
    global xcur,ycur,markerview
    xposp=[];yposp=[];zposp=[]
    xcur=[];ycur=[];markerview=[]
    fname0=pickedfileid[ichangeplotidok]
    fname=WORKDIR+"/work/picked_"+fname0.split('/')[5]
    print('fname %s'%(fname))
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data: ',fname)
    elif no_of_lines == 1:
        dat=genfromtxt(fname,delimiter=' ')
        xposp.append(dat[0])
        yposp.append(dat[1])
        zposp.append(dat[2])
    else:
        dat=genfromtxt(fname,delimiter=' ')
        xposp=dat[:,0] # 
        yposp=dat[:,1] # 
        zposp=dat[:,2] # 
        
    for i in range(len(xposp)):
        xcur.append(xposp[i]) #add the cursor point into x-list
        ycur.append(0)        #add the cursor point into y-list
        markerview.append(i)
        
    print("Read previous readings (%s). Press Middle Button to Update Figure."%(fname))

def SetPlotLimValue():
    global min_pv_value
    global max_pv_value
    global min_freq_value
    global max_freq_value
    global fixedvalue_plotlim_freq
    global fixedvalue_plotlim_pv

    min_pv_value=MIN_SPAC
    max_pv_value=MAX_SPAC
    min_freq_value=MIN_FREQ
    max_freq_value=MAX_FREQ
    fixedvalue_plotlim_freq=PLOTLIM_FREQ
    fixedvalue_plotlim_pv=PLOTLIM_PV
    
    # initial values for plot
    global ChangePlotIDFlag
    global plot_2stspac
    global plot_spac
    global npv4plot
    global ichangeplotidok
    ichangeplotidok=0
    npv4plot=-1
    plot_2stspac=BooleanVar()
    plot_spac=BooleanVar()
    plot_2stspac.set(os.getenv('plot_2stspac'))
    plot_spac.set(os.getenv('plot_spac'))
    PLTCNTL()

def ReSetPlotLimValue():
    global min_pv_value
    global max_pv_value
    global min_freq_value
    global max_freq_value
    global fixedvalue_plotlim_freq
    global fixedvalue_plotlim_pv

    min_pv_value=float(e_pvmin.get())
    max_pv_value=float(e_pvmax.get())
    min_freq_value=float(e_freqmin.get())
    max_freq_value=float(e_freqmax.get())
    if max_freq_value > min_freq_value:
        fixedvalue_plotlim_freq=1
    else:
        fixedvalue_plotlim_freq=99
    if max_pv_value > min_pv_value:
        fixedvalue_plotlim_pv=1
    else:
        fixedvalue_plotlim_pv=99

def ChangePlotLim():
    global plotlim_freq
    global plotlim_pv
    plotlim_freq=-plotlim_freq
    plotlim_pv=-plotlim_pv
    onclick_dummy()

def ChangeScale():
    global ax1log
    ax1log=-ax1log
    onclick_dummy()

def PngPlot():
    global ChangePlotIDFlag
    global ichangeplotidok,pickedfileid
    if ChangePlotIDFlag == 1:
        fname0=pickedfileid[ichangeplotidok]
        fname=WORKDIR+"/work/picked_"+fname0.split('/')[5]+".png"
    else:
        fname=WORKDIR+"/image_sprspac.png"
        
    print('output  pngfile: %s '%(fname))
    savefig(fname,dpi=72)

def DoZeroPV():
    command="cd "+WORKDIR+";. ./mkzeropv.sh"
    os.system(command)
    print("A script file mkzeropv.sh executed.")
    
#def DoReadPV():
#        command="cd "+WORKDIR+";. ./exe.sh"
#        os.system(command)
#        print "Read Phase Velocities."
        
def WriteData():
    global ChangePlotIDFlag
    global plotidok
    global ichangeplotidok,pickedfileid
    global radius
#    if ChangePlotIDFlag == 1:
    if ChangePlotIDFlag == 1 and plotidok[ichangeplotidok] == "1":
        fname0=pickedfileid[ichangeplotidok]
        fname=WORKDIR+"/work/picked_"+fname0.split('/')[5]
        print('output datafile: %s '%(fname))
        fw=open(fname,'w')
        no_of_pickups=len(xview)
        for i in range(len(xview)):
            print('%f %f %d %s %s %s %s '%(xview[i],yview[i],markerview[i]+1,radius[ichangeplotidok],label1[ichangeplotidok],label2[ichangeplotidok],seismid[ichangeplotidok]), file=fw)
        fw.close()

    fname=WORKDIR+"/readsprspac.py_param_local.sh"
    print('output datafile: %s '%(fname))
    fw=open(fname,'w')
    print('#!/bin/bash', file=fw)
    print('export plot_2stspac=%s'%(plot_2stspac.get()), file=fw)
    print('export plot_spac=%s'%(plot_spac.get()), file=fw)
    print('export IconReadColor=%s'%(IconReadColor), file=fw)
    print('export ax1log=%s'%(ax1log), file=fw)
    print('export PLOTLIM_FREQ=%s'%(plotlim_freq), file=fw)
    print('export PLOTLIM_SPAC=%s'%(plotlim_pv), file=fw)
    print('export MIN_SPAC=%s'%(min_pv_value), file=fw)
    print('export MAX_SPAC=%s'%(max_pv_value), file=fw)
    print('export MIN_FREQ=%s'%(min_freq_value), file=fw)
    print('export MAX_FREQ=%s'%(max_freq_value), file=fw)
    fw.close()
    DoZeroPV()
    
def AutoReadinLimitFrange():
    command="cd "+WORKDIR+";"+XTERM+" -e bash ./mkAutoReadinLimitFrange.sh"
    os.system(command)
    print("AutoReadinLimitFrange")
    print(command)
    RPicked()
    onclick_dummy()

def DetectFRange():
    command="cd "+WORKDIR+";"+XTERM+" -e bash ./mkDetectFRange.sh %s"%(radius[ichangeplotidok])
    os.system(command)
    print(command)
    print('%s'%(radius[ichangeplotidok]))
    print("Detect Frequency Rnage")

def RunShell():
    command="cd "+WORKDIR+";"+XTERM+"&"
#    command="cd "+WORKDIR+";kterm &"
    os.system(command)
    print(command)
    print("Run Shell")

def Save():
    print("Save()")
    PngPlot()
    WriteData()

def Exit():
    print("Exit()")
    PngPlot()
    WriteData()
#
    command="cd "+WORKDIR+";"+XTERM+" -e bash ./mkplot_spac.sh 1"
    print(command)
    os.system(command)
    print("SystematicCheck")
#    
#    root.destroy()
    sys.exit()

SetPlotLimValue()

#---------------------------
# plot contents begin
#---------------------------
def plot_contents():
    fig.text(0.5,0.02,VERSION,style='italic',fontsize=FONTSIZE*0.7)

    ax1 = fig.add_subplot(111)
    fig.subplots_adjust(left=0.1,right=0.7)
    ax1.set_title('SPAC curves (errorbar: STandard Errors)',fontsize=FONTSIZE)
    ax1.set_xlabel('Frequency [Hz]',fontsize=FONTSIZE)
    ax1.set_ylabel('SPAC coefficient',fontsize=FONTSIZE)
    if ax1log==1:
        ax1.set_xscale('log')
#       ax1.loglog()

    freqmin=freq_min*0.8
    freqmax=freq_max*1.2
    if plotlim_freq==fixedvalue_plotlim_freq:
        freqmin=min_freq_value
        freqmax=max_freq_value
    pvmin=pv_min*0.8
    pvmax=pv_max*1.2
    if plotlim_pv==fixedvalue_plotlim_pv:
        pvmin=min_pv_value
        pvmax=max_pv_value

    dfreq=(freqmax*1.2-freqmin-freqeps)/10
    x=arange(freqeps+freqmin,freqmax*1.2,dfreq)

    zorder=1
    i=0
    plot_shitayo=0
    while i < npv:
        if plotidok[i]=="1":
            plot_shitayo=1
            linecolor=color[i]
            if linestyle[i]=="-" or linestyle[i]==":":
#-------------------------------------------------------
# To deal with the specification change (":" cannot be used.)
# python2.7.12->2.7.18 (ubuntu16.04->20.04)  20200604                    #-------------------------------------------------------
                if linestyle[i]==":":
                    linestyle0=(0,(1,5))
                else:
#                           linestyle0=linestyle[i]
                    linestyle0=(0,())
#-------------------------------------------------------
                ax1.plot(dat[:,5*i],dat[:,5*i+1],color=color[i],linestyle=linestyle0,lw=lw[i],label=label1[i]+'\n'+label2[i],zorder=zorder);
                ax1.plot(dat[:,5*i],dat[:,5*i+1]+dat[:,5*i+2]/sqrt(dat[:,5*i+3]),color=color[i],linestyle=linestyle0,lw=1,zorder=zorder);
                ax1.plot(dat[:,5*i],dat[:,5*i+1]-dat[:,5*i+2]/sqrt(dat[:,5*i+3]),color=color[i],linestyle=linestyle0,lw=1,zorder=zorder);
                zorder+=1
            else:
                ax1.scatter(dat[:,5*i],dat[:,5*i+1],color=color[i],marker=linestyle[i],label=label1[i]+'\n'+label2[i],zorder=zorder);
                zorder+=1

        i+=1

    if ChangePlotIDFlag ==1 and plot_shitayo ==1:        
        for i in range(len(xview)):
            ax1.scatter(xview[i],yview[i],edgecolor='black',color=IconReadColor,s=MARKSIZE_EYES,lw=1,marker=zerobango[int(markerview[i])],zorder=zorder);
        zorder+=1

#-------------------------------------------------
# indicate freqneucny ranges for a pickup
    if ChangePlotIDFlag !=0 and plot_shitayo ==1:
        DetectFRange()
        fname=WORKDIR+"/DetectFRange.d"
        f=open(fname)
        psdlowdat=f.read()
        f.close()
        psdlowlines=psdlowdat.split('\n')
        if linecolor=="y":
            frange_color="grey"
        elif linecolor=="gold":
            frange_color="plum"
        elif linecolor=="pink":
            frange_color="grey"
        elif linecolor=="paleturquoise":
            frange_color="grey"
        else:
            frange_color="red"
        for psdlowline in psdlowlines:
            if psdlowline.split(' ')[0]!="":
                ax1.axvspan(float(psdlowline.split(' ')[0]),float(psdlowline.split(' ')[1]),color=frange_color,alpha=0.2)
#-------------------------------------------------
        
    ax1.grid()

    if   zorder<20:
        legendfontsize=10
        xpos_anchor=1.45
        ncol=1
    elif zorder<24:
        legendfontsize=8
        xpos_anchor=1.45
        ncol=1
    elif zorder<40:
        legendfontsize=6
        xpos_anchor=1.45
        ncol=1
    else:
        legendfontsize=6
        xpos_anchor=1.42
        ncol=2
#    ax1.legend(bbox_to_anchor=(xpos_anchor,1.1),prop={'size':legendfontsize},ncol=ncol)
    ax1.legend(bbox_to_anchor=(xpos_anchor-0.20,0.5),loc='center',prop={'size':legendfontsize},ncol=ncol)

#---------------------
# plot range of Figs #1,2
#---------------------
    ax1.set_xlim([freqmin,freqmax])
    ax1.set_ylim([pvmin,pvmax])
   
#----
# replace tick marks if being lengthy 
#----
   
    draw()
    if ax1log ==-1:
        for label in ax1.get_xticklabels():
            if len(label.get_text())>x_text_lim_length:
                ax1.set_xticklabels([label.get_text() for label in ax1.get_xticklabels()],rotation=x_text_rotation_angle,fontsize=10)
                break
#---------------------------
# plot contents end
#---------------------------

#---------------------------
# onclick() begin
#---------------------------
def onclick(event):
    global xcur,ycur
    global xview,yview,markerview

    if event.inaxes is None:
        return

    bind=event.button

    if bind==1: # add a point
        xctmp=event.xdata
        yctmp=0.
        xcur.append(xctmp) # add the cursor point into x-list
        ycur.append(yctmp) # add the cursor point into y-list
        xtrace=array(xcur) # convert the list into numpy array for fast sorting
        ytrace=array(ycur) # convert the list into numpy array for fast sorting
        ind=argsort(xtrace) # perform the sorting with ascending order
        xview=xtrace[ind]  
        yview=ytrace[ind]
        if len(xview)<=7:
            markerview.append(len(xview)-1)
        else:
            markerview.append(7)

    if bind==2: # select plotting mode
        xtrace=array(xcur) 
        ytrace=array(ycur) 
        ind=argsort(xtrace)
        xview=xtrace[ind]  
        yview=ytrace[ind]  
        ReSetPlotLimValue()

    if bind==3: # erase a point 
        xctmp=event.xdata
        yctmp=event.ydata
        if len(xview)>=1:
            xtrace=array(xcur) # convert a python list into numpy array for minimum distance detecting
            ytrace=array(ycur)
            xdel=xtrace-xctmp
            ydel=ytrace-yctmp
            dvec=xdel**2+ydel**2 # calculate the distance from right clicked point
            mind=argmin(dvec) # get the minimum point index 
            del xcur[mind] # delete the point close to right clicked point
            del ycur[mind] # delete the point close to right clicked point
            xtrace=array(xcur)
            ytrace=array(ycur)
            ind=argsort(xtrace)
            xview=xtrace[ind]
            yview=ytrace[ind]

    # plotting 
    event.canvas.figure.clear()
    plot_contents()
    event.canvas.draw()
    WriteData()
#---------------------------
# onclick() end
#---------------------------
        
#---------------------------
# onclick_SDCheck() 
#---------------------------
def onclick_DSCheck():
    command="cd "+WORKDIR+";"+XTERM+" -e bash ./mkplot_spac.sh 0"
    print(command)
    os.system(command)
    print("SystematicCheck")

#---------------------------
# onclick_dummy() 
#---------------------------
def onclick_dummy():
    global xcur,ycur
    global xview,yview,markerview
    xtrace=array(xcur) 
    ytrace=array(ycur) 
    ind=argsort(xtrace)
    xview=xtrace[ind]  
    yview=ytrace[ind]  
    ReSetPlotLimValue()
    # plotting 
    canvas.figure.clear()
    plot_contents()
    canvas.draw()
#---------------------------
# onclick() end
#---------------------------

fig = figure(figsize=(FIGSIZE_X,FIGSIZE_Y),dpi=DPI)
#fig.text(0.5,0.02,VERSION,style='italic',fontsize=FONTSIZE*0.7)

if len(xcur)>=1:
    xtrace=array(xcur) # convert the list into numpy array for fast sorting
    ytrace=array(ycur) # convert the list into numpy array for fast sorting
    ind=argsort(xtrace) # perform the sorting with ascending order
    xview=xtrace[ind]  
    yview=ytrace[ind]
plot_contents()

f1=Frame(root) 
Message(f1,text=VERSION+'\nMouse button:\nLeft    :Add readings\nMiddle :Update figure\nRight  :Delete readings\n\nPlot').pack(anchor='sw')
plot_refline=BooleanVar()
plot_loglinear=BooleanVar()
plot_limfree=BooleanVar()
plot_refline.set(True)
plot_loglinear.set(True)
plot_limfree.set(True)
Checkbutton(f1, text="Scale Linear<->Log",  variable=plot_loglinear,command=ChangeScale).pack(anchor='sw')
Checkbutton(f1, text="Range Limited<->Free",  variable=plot_limfree,command=ChangePlotLim).pack(anchor='sw')

Message(f1,text='Min/Max [Frequency(Hz)]',width=300).pack(anchor="sw")
f1_2=Frame(f1) 
e_freqmin=Entry(f1_2,width="5")
e_freqmax=Entry(f1_2,width="5")
e_freqmin.insert(0,MIN_FREQ)
e_freqmax.insert(0,MAX_FREQ)
e_freqmin.pack(side="left")
e_freqmax.pack(side="right")
f1_2.pack(anchor="sw")

Message(f1,text='Min/Max [SPAC]',width=300).pack(anchor="sw")
f1_3=Frame(f1) 
e_pvmin=Entry(f1_3,width="5")
e_pvmax=Entry(f1_3,width="5")
e_pvmin.insert(0,MIN_SPAC)
e_pvmax.insert(0,MAX_SPAC)
e_pvmin.pack(side="left")
e_pvmax.pack(side="right")
f1_3.pack(anchor="sw")

button=Button(f1,text='Refresh',command=onclick_dummy)
button.pack(fill='both')

button=Button(f1,text='SystemticCheck',command=onclick_DSCheck)
button.pack(fill='both')

if spac1pok==1:
    Checkbutton(f1, text="1p-spac",  variable=plot_2stspac,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')
if spacok==1:
    Checkbutton(f1, text="2p, 3p- (or more) spac",  variable=plot_spac,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')

#Message(f1,text='\nInput',width=300).pack(anchor='sw')
button=Button(f1,text='All Plot',command=lambda:[PLTCNTL(),onclick_dummy()])
button.pack(fill='both')

button=Button(f1,text='Each Plot',command=lambda:ChangePlotIDOK(1,0))
button.pack(fill='both')
button=Button(f1,text='Each Plot (BACK)',command=lambda:ChangePlotIDOK(-1,0))
button.pack(fill='both')

button=Button(f1,text='RefineReading',command=lambda:ChangePlotIDOK(0,0))
button.pack(fill='both')

button=Button(f1,text='FullAutoRead',command=lambda:ChangePlotIDOK(0,1))
button.pack(fill='both')

#button=Button(f1,text='AutoRead in freq. ranges\nwith no readings',command=AutoReadinLimitFrange)
#button.pack(fill='both')

#button=Button(f1,text='Shell (Run Xterm for DEBUG)',command=RunShell)
#button.pack(fill='both')

#button=Button(f1,text='PHASE VELOCITY READER',command=DoReadPV)
#button.pack(fill='both')
#button=Button(f1,text='SAVE',command=Save)
#button.pack(fill='both')
button=Button(f1,text='SAVE & QUIT',command=Exit)
button.pack(fill='both')

f1.pack(side="left")

f2=Frame(root) 
canvas = FigureCanvasTkAgg(fig,master=f2)
#canvas.show()
canvas.draw()
PngPlot()
canvas.mpl_connect('button_press_event', onclick)
canvas.get_tk_widget().pack(side='top', fill='both', expand=1)
f2.pack(side="right")

if pngout==1:
    PngPlot()
else:
    root.mainloop()
