#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved

limit_frange(){
idok_list=1
if [ -f $listfile ]
then
    grep $file $listfile > /dev/null 2>&1
    if test "$?" != "0"
    then
	idok_list=0
    else
	fl=`grep $file $listfile | awk '{print $10}'`
	fu=`grep $file $listfile | awk '{print $11}'`
    fi
else
idok_list=0
fi

if [ $idok_list -eq 0 ]
then
    fl=-9999.
    fu=9999.
fi # if [ $idok_list -eq 0 ]
echo $fl $fu
}

dirpath=$pointresultdirpath/$arrayname/array/$pointresultdir

########################################################################
# Don't touch from here
########################################################################
workdir=$dirpath/$readpvdir

if test "$workdir" != ""
then
    echo workdir: $workdir
else
echo ERROR workdir not defined. STOP
exit
fi

if [ ! -d $workdir ]
then
mkdir -p $workdir
fi

listfile=$workdir/list_pv.d.checked

currentdir=`pwd`
cd $dirpath/..
CODES_ONLY_CIRCLE=""
CODES_WITH_CENTER=""
CODES=`ls | grep -v $pointresultdir`

for code in $CODES
do
dir=../array/$code/$arrayresultdir/ave

if [ -d $dir ]
then
if [ -f $dir/cmax_by_nsr.d ]
then
CODES_WITH_CENTER="$CODES_WITH_CENTER $code"
else # if [ -f $dir/cmax_by_nsr.d ]
CODES_ONLY_CIRCLE="$CODES_ONLY_CIRCLE $code"
fi   # if [ -f $dir/cmax_by_nsr.d ]
fi # if [ -d $dir ]
done # for code in $CODES
cd $currentdir 

ncode_with_center=0
for code in $CODES_WITH_CENTER
do
#let ncode_with_center=ncode_with_center+1
    ncode_with_center=`echo $ncode_with_center | awk '{print $1+1}'`
done
echo CODES_WITH_CENTER $CODES_WITH_CENTER
echo CODES_ONLY_CIRCLE  $CODES_ONLY_CIRCLE

for file in $workdir/$pickpvfile_auto.tmp $workdir/$pickpvfile_auto.tmp2 
do
if [ -f $file ]
then
rm -f $file
fi   # if [ -f $file ]
done # for file in ..
touch -f $workdir/$pickpvfile_auto.tmp

ncode=1
for code in $CODES_WITH_CENTER $CODES_ONLY_CIRCLE
do
    
if [ $ncode -le $ncode_with_center ]
then
id_with_center=1
else
id_with_center=0
fi

#---------------------
# data processing for an array with a center sensor
#---------------------
#dir=$dirpath/../$code/$arrayresultdir/ave
dir=$dirpath/../../array/$code/$arrayresultdir/ave
seismfile=$dirpath/../$code/$arrayresultdir/seism.log
radius=`cat $seismfile | grep RADIUS | awk '{print $2}'`
VELFILES_AL=$dir/cmax_by_nsr.d
VELFILES_NCCCA=$dir/vel_nc-cca.d
VELFILES_CCA=$dir/vel_cca.d

#------------------
# SPAC*pդ 
#------------------
ls $dir/vel_spac*p.d > /dev/null 2>&1
if test "$?" != "0"
then
#echo WARNING: SPAC FILE NOT FOUND: $dir
VELFILES_SPAC=""
else
echo SPAC FILES FOUND: $dir
VELFILES_SPAC=`ls $dir/vel_spac*p.d`
fi

for file in $VELFILES_SPAC
do
radius_spac=`basename $file | sed 's/vel_spac_R//' | awk 'BEGIN{FS="m"}{
        cradius=$1
        if(cradius~/c$/){sub(/.$/, "",cradius);radius=1.*cradius/100000}
        else{radius=1.*cradius/1000}
        print radius}'`
echo $radius_spac $file >> $workdir/$pickpvfile_auto.tmp2 
done
# Ⱦ¤礭¤٤ʤ

if [ -f $workdir/$pickpvfile_auto.tmp2 ]
then
VELFILES_SPAC=`sort -rn $workdir/$pickpvfile_auto.tmp2 | awk '{print $2}'`
rm -f $workdir/$pickpvfile_auto.tmp2 
fi
#------------------
# SPAC*pդ ޤ
#------------------

if [ $id_with_center -eq 1 ]
then

for file in $workdir/$pickpvfile_auto.AL $workdir/$pickpvfile_auto.PV 
do
if [ -f $file ]
then
rm -f $file
fi   # if [ -f $file ]
done # for file in ..

file=$VELFILES_AL
id=0
cat $file | awk '{print $1,$2}' > $workdir/$pickpvfile_auto.AL

file=$VELFILES_NCCCA
id=3
file1=`echo $file | tr '/' '\n' | tail -4 | head -1`
file2=`echo $file | tr '/' '\n' | tail -1`
rm -f $workdir/$pickpvfile_auto.PV
limit_frange

cat $file | awk '{f=$1;pv=$2;stdpv=$3;knum=$4;
if(knum>0){
ste=stdpv/sqrt(knum)
print "'"$id"'",0,"'"$radius"'",0,knum,0,f,pv,stdpv
}}' > $workdir/$pickpvfile_auto.PV

paste $workdir/$pickpvfile_auto.PV $workdir/$pickpvfile_auto.AL | awk '{
printf "%s %s %s %s %s %s %s %s %s %s\n",
$1,$2,$3,$5,$7,$8,$9,"'"$fl"'","'"$fu"'",$11
}' >> $workdir/$pickpvfile_auto.tmp

file=$VELFILES_CCA
id=2
file1=`echo $file | tr '/' '\n' | tail -4 | head -1`
file2=`echo $file | tr '/' '\n' | tail -1`
rm -f $workdir/$pickpvfile_auto.PV
limit_frange

if [ -f $file ]
then   
cat $file | awk '{f=$1;pv=$2;stdpv=$3;knum=$4;
if(knum>0){
ste=stdpv/sqrt(knum)
print "'"$id"'",0,"'"$radius"'",0,knum,0,f,pv,stdpv
}}' > $workdir/$pickpvfile_auto.PV

paste $workdir/$pickpvfile_auto.PV $workdir/$pickpvfile_auto.AL | awk '{
printf "%s %s %s %s %s %s %s %s %s %s\n",
$1,$2,$3,$5,$7,$8,$9,"'"$fl"'","'"$fu"'",$11
}' >> $workdir/$pickpvfile_auto.tmp
fi # if [ -f $file ]

# spac
for file in $VELFILES_SPAC
do
radius_spac=`basename $file | sed 's/vel_spac_R//' | awk 'BEGIN{FS="m"}{
        cradius=$1
        if(cradius~/c$/){sub(/.$/, "",cradius);radius=1.*cradius/100000}
        else{radius=1.*cradius/1000}
        print radius}'`
id=1
file1=`echo $file | tr '/' '\n' | tail -4 | head -1`
file2=`echo $file | tr '/' '\n' | tail -1`
rm -f $workdir/$pickpvfile_auto.PV
limit_frange
cat $file | awk '{f=$1;pv=$2;stdpv=$3;knum=$4;
if(knum>0){
ste=stdpv/sqrt(knum)
print "'"$id"'",0,"'"$radius"'",0,knum,0,f,pv,stdpv
}}' > $workdir/$pickpvfile_auto.PV

paste $workdir/$pickpvfile_auto.PV $workdir/$pickpvfile_auto.AL | awk '{
printf "%s %s %s %s %s %s %s %s %s %s\n",
$1,$2,$3,$5,$7,$8,$9,"'"$fl"'","'"$fu"'",$11
}' >> $workdir/$pickpvfile_auto.tmp
done # for file in $VELFILES_SPAC

rm -f $workdir/$pickpvfile_auto.PV $workdir/$pickpvfile_auto.AL 

else # if [ $id_with_center -eq 1 ]

file=$VELFILES_CCA
id=2
limit_frange
if [ -f $file ]
then   
cat $file | awk '{f=$1;pv=$2;stdpv=$3;knum=$4;
if(knum>0){
ste=stdpv/sqrt(knum)
print "'"$id"'",0,"'"$radius"'",knum,f,pv,stdpv,"'"$fl"'","'"$fu"'","-999"
}}' >> $workdir/$pickpvfile_auto.tmp
fi # if [ -f $file ]

# spac
for file in $VELFILES_SPAC
do
radius_spac=`basename $file | sed 's/vel_spac_R//' | awk 'BEGIN{FS="m"}{
        cradius=$1
        if(cradius~/c$/){sub(/.$/, "",cradius);radius=1.*cradius/100000}
        else{radius=1.*cradius/1000}
        print radius}'`
id=1
limit_frange
cat $file | awk '{f=$1;pv=$2;stdpv=$3;knum=$4;
if(knum>0){
ste=stdpv/sqrt(knum)
print "'"$id"'",0,"'"$radius_spac"'",knum,f,pv,stdpv,"'"$fl"'","'"$fu"'","-999"
}}' >> $workdir/$pickpvfile_auto.tmp

done # for file in $VELFILES_SPAC

fi # if [ $id_with_center -eq 1 ]
#---------------------
# common
#---------------------

#let ncode=ncode+1
ncode=`echo $ncode | awk '{print $1+1}'`
done


no_of_data_for_pickpvfile_auto=`wc -l $workdir/$pickpvfile_auto.tmp | awk '{print $1}'`
echo no_of_data_for_pickpvfile_auto: $no_of_data_for_pickpvfile_auto

######
# added on 20191023
######
idesacflag=0
if [ $no_of_data_for_pickpvfile_auto -eq 0 ]
then
idesacflag=1
echo No autoreading data. Try to read esac data...

for code in $CODES_ONLY_CIRCLE
do

dir=$dirpath/../../array/$code/$arrayresultdir/ave
radius="-1"
file=$dir/vel_esac.d
id=100
limit_frange
if [ -f $file ]
then   
cat $file | awk '{f=$1;pv=$2;stdpv=$3;knum=$4;
if(knum>0){
ste=stdpv/sqrt(knum)
print "'"$id"'",0,"'"$radius"'",knum,f,pv,stdpv,"'"$fl"'","'"$fu"'","-999"
}}' >> $workdir/$pickpvfile_auto.tmp
fi # if [ -f $file ]
    
done # for code in $CODES_ONLY_CIRCLE

no_of_data_for_pickpvfile_auto=`wc -l $workdir/$pickpvfile_auto.tmp | awk '{print $1}'`
echo "no_of_data_for_pickpvfile_auto (esac): $no_of_data_for_pickpvfile_auto"
    
fi # if [ $no_of_data_for_pickpvfile_auto -eq 0 ]
######

if [ $no_of_data_for_pickpvfile_auto -eq 0 ]
then

echo No autoreading data.
touch -f $workdir/$pickpvfile_auto
touch -f $workdir/$pickpvfile_auto.all
    
else # if [ $no_of_data_for_pickpvfile_auto -eq 0 ]

#-----------------
# summarize
#-----------------
#for readno in 1 2 3 4 5 6 
for readno in 5 6
do

for file in $workdir/$pickpvfile_auto.ID$readno $workdir/$pickpvfile_auto.ID$readno.contents
do
if [ -f $file ]
then
rm -f $file
fi   # if [ -f $file ]
done # for file in ..

#-------------------------------------------------
if [ -f $workdir/$pickpvfile_auto.tmp_f ]
then
    rm -f $workdir/$pickpvfile_auto.tmp_f
fi
cat $workdir/$pickpvfile_auto.tmp | awk '{printf "%20.10f\n", $5}' | sort -n | uniq > $workdir/$pickpvfile_auto.tmp_f
#-------------------------------------------------

# step1
# Extract auto-readings from a view point of wavelength and analysis limit
cat $workdir/$pickpvfile_auto.tmp    | awk 'BEGIN{
printf "%s/%s.ID%sALL\n","'"$workdir"'","'"$pickpvfile_auto"'","'"$readno"'"
printf "%s/%s.ID%s\n","'"$workdir"'","'"$pickpvfile_auto"'","'"$readno"'"
printf "%s/%s.tmp_f\n","'"$workdir"'","'"$pickpvfile_auto"'"
printf "%s,%s,%s\n",
"'"$FREQMIN_RPVAUTO"'","'"$FREQMAX_RPVAUTO"'","'"$ND_RPVAUTO"'"
printf "%s\n","'"$idesacflag"'"
printf "%s\n","'"$readno"'"
printf "%s\n","'"$smoothband"'"
printf "%s\n","'"$df4spec"'"
}{
print $0}' | $bindir/$RPVAUTO_EXE

# step2: . ǽɤ߼̤ΥǡϤϤޤľн
if [ $iddelline -eq 1 ]
then
mv -f $workdir/$pickpvfile_auto.ID$readno $workdir/$pickpvfile_auto.tmp2
cat $workdir/$pickpvfile_auto.tmp2    | awk 'BEGIN{
printf "%s,%s\n%s\n",
"'"$crcflim_redpvdelline"'","'"$wfaclim_redpvdelline"'","'"$radius"'"}{
print $0}' | $bindir/rpvauto_delline   | awk '{
printf "%s %s %s %s\n",$1,$2,$3,$4}' > $workdir/$pickpvfile_auto.ID$readno
rm -f $workdir/$pickpvfile_auto.tmp2
fi # if [ $iddelline -eq 1 ]

done # for readno in 1 2 3 4 5 6 
rm -f $workdir/$pickpvfile_auto.tmp

#-----------------------------------------------------------------
# detectok2() of src/rpvauto2.F
# c idcategory  contents   rmin   rmax Ͽ̷׿/­
#    (readno)
# c     5       SPAC/CCA    0     2m   4-6/2SPAC&ʳ
# c             nc-CCA                 (˾줤η̤)
# c     6       SPAC/CCA    0     inf  4-6/2SPAC&ʳ
# c             nc-CCA    (줤η̤)
echo "copy $workdir/$pickpvfile_auto.ID$readno2copy to $workdir/$pickpvfile_auto..."

cat $workdir/$pickpvfile_auto.ID$readno2copy | awk '{
printf "%s %s %s %s\n",$1,$2,$3,$4}' > $workdir/$pickpvfile_auto

dumline=`cat $workdir/$pickpvfile_auto | wc -l | awk '{print $1}'`
if [ $dumline -eq 1 ]
then
rm -f $workdir/$pickpvfile_auto
touch -f $workdir/$pickpvfile_auto
fi

cat $workdir/$pickpvfile_auto.ID"$readno2copy"ALL | awk '{
printf "%s %s %s %s\n",$1,$2,$3,$4}' > $workdir/$pickpvfile_auto.all

dumline=`cat $workdir/$pickpvfile_auto.all | wc -l | awk '{print $1}'`
if [ $dumline -eq 1 ]
then
rm -f $workdir/$pickpvfile_auto.all
touch -f $workdir/$pickpvfile_auto.all
fi
fi # if [ $no_of_data_for_pickpvfile_auto -eq 0 ]
