#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#--------------------------------
# MOUSE CLICK (only for the center panel)
# left  : add a data point
# middle: switch the scale (linear<-->log)
# right : delete a data point 
#-------------------------------- 

dirpath=$pointresultdirpath/$arrayname/array/$pointresultdir

seismid="SEISMID"

#---------------------
# get the parameter 'smoothband'
#---------------------
#paramshfiles=`find $pointresultdirpath/$arrayname/array -name param.sh`
#tmpparamshfile=$pointresultdirpath/$arrayname/array/paramfile.tmp
#if [ -f $tmpparamshfile ]
#then
#rm -f $tmpparamshfile
#fi
#touch -f $tmpparamshfile
#for paramshfile in $paramshfiles
#do
#cat $paramshfile | grep -v '^#' | grep smoothband | awk 'BEGIN{FS="="}{printf "%12.6f\n",$2}' >> $tmpparamshfile
#done		  
#smoothband=`cat $tmpparamshfile|sort -n|uniq|head -1|awk '{printf "%s",$1}'`
#echo smoothband: $smoothband
#rm -f $tmpparamshfile
#---------------------
# 
#---------------------
MIN_FREQ=$FREQMIN
MAX_FREQ=$FREQMAX
MIN_PV=$VRMIN
MAX_PV=$VRMAX

id_do_read_picked=1 

########################################################################
# Don't touch from here
########################################################################
workdir=$dirpath/$readpvdir
pyfile=$workdir/readpv.py
pyfile_sprspac=$workdir/readsprspac.py
PVUNIT=km
fontsize=13
FIGSIZE_X=8
FIGSIZE_Y=6
DPI=80
if test "$XTERM4PYTHON" == ""
then
TERMINAL="xterm"
#TERMINAL="kterm"
else
TERMINAL=$XTERM4PYTHON
fi

#TITLECHAR=`echo $arrayname | awk '{printf "Velocity [%s]", $1}'`
TITLECHAR="BIDO"

if test "$workdir" == ""
then
echo ERROR workdir not defined. STOP
exit
fi

cd $dirpath/..
CODES=`ls | grep -v $pointresultdir`
VELFILES_SPAC1P=""
VELFILES_SPACAPX=""
VELFILES_NCSPAC=""
VELFILES_ESAC=""
VELFILES_SPAC=""
VELFILES_CCA=""
VELFILES_NCCCA=""
VELFILES_AL=""

#-------
vf=../array/results_for_all_arrays/RESULT/ave/vel_esac.d
if [ -f $vf ]
then
    velfile_esac_for_allarray=$vf
else
    velfile_esac_for_allarray=""
fi
vf=../array/results_for_all_arrays/RESULT/ave/vel_ncspac.d
if [ -f $vf ]
then
    velfile_ncspac_for_allarray=$vf
else
    velfile_ncspac_for_allarray=""
fi
#-------

for code in $CODES 
do
dir=../array/$code/$arrayresultdir/ave
if [ -d $dir ]
then
# 1spacϽ

if [ -f $dir/../seism.log ]
then
no_of_seismometers=`cat $dir/../seism.log | grep 'The number of seismographs' | awk '{print $6}'`
# ncspac: only when no_of_seismometers >= 4
if [ $no_of_seismometers -ge 4 ]
then
VELFILES_NCSPAC="$VELFILES_NCSPAC `find $dir -name 'vel_ncspac.d'`"
fi
# ncspac: only when no_of_seismometers >= 5
#if [ $no_of_seismometers -ge 5 ]
# ncspac: only when no_of_seismometers >= 3
if [ $no_of_seismometers -ge 3 ]
then
VELFILES_ESAC="$VELFILES_ESAC `find $dir -name 'vel_esac.d'`"
fi
fi # if [ -f $dir/../seism.log ]

VELFILES_SPACAPX="$VELFILES_SPACAPX `find $dir -name 'vel_spac*pAPX*.d'`"
VELFILES_SPAC1P="$VELFILES_SPAC1P `find $dir -name 'vel_spac*1p_No*.d'`"
VELFILES_SPAC="$VELFILES_SPAC `find $dir -name 'vel_spac*p.d'`"
VELFILES_CCA="$VELFILES_CCA `find $dir -name 'vel_cca.d'`"
VELFILES_NCCCA="$VELFILES_NCCCA `find $dir -name 'vel_nc-cca.d'`"
VELFILES_AL="$VELFILES_AL `find $dir -name 'cmax_by_nsr.d'`"
fi # if [ -d $dir ]
done # for code in $CODES
cd - >& /dev/null

if [ -d $workdir/work ]
then
echo 
else
mkdir -p $workdir/work
fi

#---------------------
# vel data
#---------------------
no=1
no_sprspac=1
listfile=$workdir/list_pv.d
listfile_sprspac=$workdir/list_sprspac.d
pvfile=$workdir/pv.d
sprspacfile=$workdir/sprspac.d

for file in $listfile $listfile_sprspac $sprspacfile $pvfile 
do
if [ -f $file ]
then
rm -f $file
fi
touch -f $file
done

pvfiles=""
sprspacfiles=""
radiuses=""
nlines=""
id_different_nline=0

#---------------------
# making spac zero related files end
#---------------------
pvlist_added="$velfile_esac_for_allarray"
for file in $VELFILES_SPAC $VELFILES_SPACAPX $VELFILES_ESAC $VELFILES_NCSPAC $VELFILES_CCA $VELFILES_NCCCA $VELFILES_AL $VELFILES_SPAC1P $pvlist_added
do
workpvfile=`echo $workdir $no | awk '{printf "%s/pv%04d.d",$1,$2}'`
pvfiles="$pvfiles $workpvfile"
vf=`dirname $dirpath/../$file`
seismfile=`echo $vf | awk '{printf "%s/../seism.log",$1}'`
seismfile_esac=`echo $vf | awk '{printf "%s/../1/seism_esac.log",$1}'`
seisfile_cohcca=`echo $vf | awk '{printf "%s/../1/seism_cohcca.log",$1}'`
seisfile_spacapx=`echo $vf | awk '{printf "%s/../1/seism_spacapx.log",$1}'`
seisfile_spacapx_combi=`echo $vf | awk '{printf "%s/../1/seism_spacapx_combi.log",$1}'`

seism="JU410"
seismid="JU"
#echo "SEISMID Detected: $seismid [$seism]"
#--------------------------------------

#XXXXXXXXXXXXXXXX
#VELFILES_AL     -1
#VELFILES_SPAC   1
#VELFILES_ESAC   100
#VELFILES_NCSPAC 110
#VELFILES_SPAC1P 999
#VELFILES_CCA    2
#VELFILES_NCCCA  3
#XXXXXXXXXXXXXXXX

file0=`basename ../$file`
idtype=-1
if   test "$file0" == "vel_nc-cca.d"
then
idtype=3 
elif test "$file0" == "vel_cca.d"
then
idtype=2 
elif test "$file0" == "vel_esac.d"
then
idtype=100 
elif test "$file0" == "vel_ncspac.d"
then
idtype=110 
fi

if [ $idtype -le 0 ]
then

echo $file0 | grep vel_spac | grep -v 1p_No | grep -v pAPX >& /dev/null # SPAC
if test "$?" == "0" 
then
idtype=1 # spac 
radiusid=`echo $file0 | sed 's/vel_spac_R/ /'| sed 's/[1-9]p.d$//'`
radius=`cat $seisfile_cohcca | grep $radiusid | head -1 | awk '{print $2}'`
fi

echo $file0 |grep vel_spac |grep -v pAPX_ |grep pAPX >& /dev/null # SPACAPX (circle)
if test "$?" == "0" 
then
idtype=1 # spac (temporaliry use the same idtype with spac)
radius=`cat $seisfile_spacapx | grep radius_ave | awk '{print $2}'`
fi

echo $file0 | grep vel_spac |grep 3pAPX_ >& /dev/null # SPACAPX (combi 3p)
if test "$?" == "0" 
then
idtype=1 # spac (temporaliry use the same idtype with spac)
file0_cluster=`echo $file0 | sed 's/vel_spac/ /'| sed 's/\.d//' | sed 's/CL/ /' | awk '{print $2}'`
radius=`cat $seisfile_spacapx_combi | grep 3pAPX_ | awk 'BEGIN{
no_cluster=1.*"'"$file0_cluster"'"
}{if($14==no_cluster){print $16}}' | tail -1`
fi

echo $file0 | grep vel_spac |grep 2pAPX_ >& /dev/null # SPACAPX (combi 2p)
if test "$?" == "0" 
then
idtype=1 # spac (temporaliry use the same idtype with spac)
file0_cluster=`echo $file0 | sed 's/vel_spac/ /'| sed 's/\.d//' | sed 's/CL/ /' | awk '{print $2}'`
radius=`cat $seisfile_spacapx_combi | grep 2pAPX_ | awk 'BEGIN{
no_cluster=1.*"'"$file0_cluster"'"
}{if($14==no_cluster){print $16}}' | tail -1`
fi

echo $file0 | grep vel_spac | grep 1p_No >& /dev/null  # SPAC1P
if test "$?" == "0" 
then
idtype=999 # spac1p
file0_for_grep=`echo $file0 | sed 's/vel_spac//' | sed 's/\.d//'`
radius=`cat $seisfile_cohcca | grep $file0_for_grep |head -1|awk '{print $2}'`
fi

elif [ $idtype -ge 100 ] # ESAC or NCSPAC
then

    if [ -f $seismfile_esac ]
    then
	radius=`cat $seismfile_esac | awk '{print $1}'`
    else
	radius=`cat $seismfile | grep RADIUS | awk '{print $2}'`
    fi
    
else # OTHERS (CCA, NC-CCA)
    
    radius=`cat $seismfile | grep RADIUS | awk '{print $2}'`
    
fi # if [ $idtype -le 0 ]

radiuses="$radiuses $radius"


if [ $idtype -eq 3 -o $idtype -eq 110 ]  # NC-CCA or NCSPAC
then
cat $dirpath/../$file | awk 'BEGIN{radius=1.*"'"$radius"'"}{f=$1;pv=$2
if(f>0&&pv<=998.9){
wlnrml=pv/f/radius
if(wlnrml>=8){
printf "%s %s %s %s %s\n",f,pv,$3,$4,"'"$idtype"'"}}}'  > $workpvfile
else # if [ $idtype -eq 3 -o $idtype -eq 110 ]
cat $dirpath/../$file | awk '{f=$1;pv=$2
if(f>0&&pv<=998.9){
printf "%s %s %s %s %s\n",f,pv,$3,$4,"'"$idtype"'"}}'  > $workpvfile
fi   # if [ $idtype -eq 3 -o $idtype -eq 110 ]

nline=`wc -l $workpvfile | awk '{print $1}'`
nlines="$nlines $nline"
if [ $no -eq 1 ]
then
nline_org=$nline
nline_max=$nline
#echo "no. of data lines [$file]: $nline"
else
if [ $nline -ge $nline_max ]
then
nline_max=$nline
fi
if [ $nline -ne $nline_org ]
then
id_different_nline=1
fi # if [ $nline -ne $nline_org ]
fi # if [ $no -eq 1 ]

label=`echo $file | awk 'BEGIN{FS="/";no=1.*"'"$no"'"}{
icolor=no % 20

if     (icolor==0){color="r"}
else if(icolor==1){color="b"}
else if(icolor==2){color="g"}
else if(icolor==3){color="c"}
else if(icolor==4){color="m"}
else if(icolor==5){color="y"}
else if(icolor==6){color="gold"}
else if(icolor==7){color="pink"}
else if(icolor==8){color="turquoise"}
else if(icolor==9){color="salmon"}
else if(icolor==10){color="gray"}
else if(icolor==11){color="plum"}
else if(icolor==12){color="royalblue"}
else if(icolor==13){color="firebrick"}
else if(icolor==14){color="darkgreen"}
else if(icolor==15){color="darksalmon"}
else if(icolor==16){color="chartreuse"}
else if(icolor==17){color="paleturquoise"}
else if(icolor==18){color="darkturquoise"}
else if(icolor==19){color="darkcyan"}

code=$3
narr=split($6,arr,"vel_")

if(narr==2){
split(arr[2],name,".d")
name0=name[1]

nname=split(name[1],dummy,"spac")
# SPAC
if(nname==2){ 
nname=split(name[1],dummy,"1p_No")
if(nname==2){ 
#------
# 1p-spac
#------
plotid=0
lw=1
linestyle="-"
}else{
nname=split(name[1],dummy,"ncspac")
if(nname==2){ 
#------
# ncspac
#------
plotid=3
lw=1
linestyle="-"
}else{
#------
# spac
#------
plotid=1
lw=2
linestyle="-"
}}

}else{ 
nname=split(name[1],dummy,"nc-cca")
if(nname==2){ 
#------
#nc-cca
#------
plotid=3
lw=6
linestyle="^"
}else{   

nname=split(name[1],dummy,"esac")
if(nname==2){ 
#------
# esac
#------
plotid=1
lw=1
linestyle="1"
}else{
#------
# cca
#------
plotid=2
lw=4
linestyle="x"}}
}
}else{
plotid=4
name0="ulim_for_cca"
lw=2
linestyle=":"
}

print code,name0,color,linestyle,lw,plotid
}'`

echo $no $workpvfile $label $dirpath/../$file | awk '{printf "%s %s %s %s %s %s %s %s %s %s %s %s\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,0,100000,"'"$seismid"'"}' >> $listfile

#---------
# spr spac
#---------
idsprspacok=0
if   [ $idtype -eq 1 ]   # SPAC or SPACAPX
then
idsprspacok=1
elif [ $idtype -eq 100 ] # ESAC <-- ESAC currently not used because the definition of radius is not clear for this method (i.e., wl=2.6r cannot be defined)
then
idsprspacok=1
elif [ $idtype -eq 999 ] # SPAC1P
then
idsprspacok=1
fi

if [ $idsprspacok -eq 1 ]    
then
worksprspacfile=`echo $workdir $no_sprspac | awk '{printf "%s/sprspac%04d.d",$1,$2}'`
sprspacfiles="$sprspacfiles $worksprspacfile"
vf=`echo $file | sed 's/\/vel_/\/spr_/'`

if [ -f $dirpath/../$vf ]
then
cat $dirpath/../$vf | awk '{
printf "%s %s %s %s %s\n",$1,$2,$3,$4,"'"$idtype"'"}'  > $worksprspacfile

else
    echo WARNING: No file found.
    echo "[$dirpath/../$vf]"
    echo PASS.
    touch -f  $worksprspacfile
fi

#if [ $idtype -ne 100 ] # <--esac is excluded from the zero crossing 20220701
#then
echo $no_sprspac $worksprspacfile $label $dirpath/../$vf | awk '{
printf "%s %s %s %s %s %s %s %s %s %s %s\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,"'"$radius"'","'"$seismid"'"}' >> $listfile_sprspac
#fi

let no_sprspac=no_sprspac+1
fi # if [ $idsprspacok -eq 1 ]    
#---------
let no=no+1
done # for file in $VELFILES_SPAC ...

#-------------------------------
listfile_checked=$listfile.checked
if [ -f $listfile_checked.tmp ]
then
    rm -f $listfile_checked.tmp
fi
touch -f $listfile_checked.tmp
no_of_lines_list=`wc -l $listfile | awk '{print $1}'`
ilist=1
while [ $ilist -le $no_of_lines_list ]
do
buf0=`cat $listfile | head -$ilist | tail -1`
label1=`echo $buf0 | awk '{printf "%s", $3}'`
label2=`echo $buf0 | awk '{printf "%s", $4}'`
buf1=""
if [ -f $listfile_checked ]
then
    buf1=`cat $listfile_checked | awk '{if($3=="'"$label1"'"&&$4=="'"$label2"'"){print $0}}'`
fi
if test "`echo $buf1 | awk '{print $1}'`" != ""
then
echo $buf1 >> $listfile_checked.tmp
else
echo $buf0 >> $listfile_checked.tmp
fi
let ilist=ilist+1
done
mv -f $listfile_checked.tmp  $listfile_checked
\cp $listfile_checked $listfile
#-------------------------------

if [ $id_different_nline -eq 1 ]
then
echo "WARNING in $0 (no. of data differs; Zero padding done)"
for file in $pvfiles $sprspacfiles
do
ndummy="`wc -l $file | awk '{print $1}'`"
if [ $nline_max -gt $ndummy ]
then
$bindir/zeropad <<EOF >> $file
$nline_max
$ndummy
EOF
else
cat $file | sed -n '1,'$nline_max''p > $file.temporal
mv -f $file.temporal $file
fi
done # for file in $pvfiles
fi # if [ $id_different_nline -eq 1 ]

if test "`echo $pvfiles | awk '{print $1}'`" == ""
then
    
echo ERROR: No phase velocity data found

else # if test `echo $pvfiles | awk '{print $1}'` == ""

paste -d " " $pvfiles > $pvfile

if test "`echo $sprspacfiles | awk '{print $1}'`" == ""
then
id_no_spac_coef=1
echo WARNING: No spac coefficient data found
echo                       > $sprspacfile
else
id_no_spac_coef=0
paste -d " " $sprspacfiles > $sprspacfile
fi

for file in $pvfiles $sprspacfiles
do
rm -f $file
done # for file in $pvfiles

for file in $sprspacfiles
do
    vf=`basename $file`
    if [ ! -f $dirpath/rpv/work/picked_$vf ]
    then
	touch -f $dirpath/rpv/work/picked_$vf 
    fi
done

#--------------------------
# radfile start
#--------------------------
radfile=$workdir/radius.d
if [ -f $radfile ]
then
rm -f $radfile
fi # if [ -f $radfile ]

if [ -f $radfile.2 ]
then
rm -f $radfile.2
fi # if [ -f $radfile.2 ]

touch -f $radfile

for radius in $radiuses
do
echo $radius | grep '^[0-9]' | awk '{if($1>0){printf "%5.1e\n",$1}}' | awk '{printf "%20.10f\n",$1}'>> $radfile
done # for $radius in $radiuses
cat $radfile | awk '{printf "%f\n",$1}' | sort -n | uniq >$radfile.2
no_of_radii=`wc -l $radfile.2 | awk '{print $1}'`
# Ⱦ¤İʾ夢ϡ褬ѻˤʤΤǡˣĤ˸ꡣ
if [ $no_of_radii -ge 3 ]
then
head -1 $radfile.2  > $radfile
tail -1 $radfile.2 >> $radfile
else    
mv -f $radfile.2 $radfile
fi
#--------------------------
# radfile end
#--------------------------

if test "$id_pngout" == "1" 
then
ID_PNGOUT=1
file=$pointresultdirpath/$arrayname/$pointresultdir/$visualreadflag_rpv
if [ ! -f $file ]
then
echo no > $file
fi # if [ ! -f $file ]
else # if test "$id_pngout" == "1" 
ID_PNGOUT=0
file=$pointresultdirpath/$arrayname/$pointresultdir/$visualreadflag_rpv
if [ -f $file ]
then
rm -f $file
fi # if [ -f $file ]
echo yes > $file
fi # if test "$id_pngout" == "1" 

if test "$id_do_read_picked" == "1" 
then
ID_DO_READ_PICKED=1
else # if test "$id_do_read_picked" == "1" 
ID_DO_READ_PICKED=0
fi  # if test "$id_do_read_picked" == "1" 

# Limts of Plot Ranges
if test "$MIN_FREQ" != "" -a "$MAX_FREQ" != ""
then
PLOTLIM_FREQ=1
else # if test "$MIN_FREQ" != "" -a "$MAX_FREQ" != ""
MIN_FREQ=0
MAX_FREQ=0
PLOTLIM_FREQ=99
fi  # if test "$MIN_FREQ" != "" -a "$MAX_FREQ" != ""

MIN_SPAC=-0.5
MAX_SPAC=1.1
PLOTLIM_SPAC=1

if test "$MIN_PV" != "" -a "$MAX_PV" != ""
then
PLOTLIM_PV=1
else # if test "$MIN_PV" != "" -a "$MAX_PV" != ""
MIN_PV=0
MAX_PV=0
PLOTLIM_PV=99
fi   # if test "$MIN_PV" != "" -a "$MAX_PV" != ""

#----------
# copy fies
#----------
files="
mkzeropv.sh 
mkzeropv_again.sh 
mkCheckPSD.sh 
mksmth.sh 
mkplot_spac.sh
mkDoRefineSpac.sh 
mkDoFullAutoReadSpac.sh 
mkRefModel.sh 
mkDetectFRange.sh
mkAutoReadinLimitFrange.sh
exe_mkRefModel_manu.sh
mkRefModel_by_zero_manu.sh
mkpsdlevel_ju.sh 
mkcheckpsdlevel.sh 
exe_sprspac_auto.sh"

for f in $files
do
    
if [ -f $workdir/$f ]
then
rm -f $workdir/$f
fi

if [ -f $scriptdir/$f ]
then
cp $scriptdir/$f $workdir
echo OUTPUT $workdir/$f
fi

done # for f in $files
#----------

exefile=$workdir/exe.sh
mkcalerrfile=$workdir/mkcalerr.sh
exportfile="$pyfile"_param.sh
exportfile_local="$pyfile"_param_local.sh
exefile_sprspac=$workdir/exe_sprspac.sh
exefile_sprspac_auto=$workdir/exe_sprspac_auto.sh
exportfile_local_sprspac="$pyfile_sprspac"_param_local.sh

if [ -f $exportfile ]
then
rm -f $exportfile
fi # if [ -f $exportfile ]
touch -f $exportfile

cat <<EOF>>$exportfile
#!/bin/bash

export bindir=$bindir
export scriptdir=$scriptdir
export WORKDIR=$workdir 
export PVUNIT=$PVUNIT
export FONTSIZE=$fontsize
export ID_PNGOUT=$ID_PNGOUT
export ID_DO_READ_PICKED=$ID_DO_READ_PICKED
export PLOTLIM_FREQ=$PLOTLIM_FREQ
export MIN_FREQ=$MIN_FREQ
export MAX_FREQ=$MAX_FREQ
export PLOTLIM_PV=$PLOTLIM_PV
export PLOTLIM_SPAC=$PLOTLIM_SPAC
export MIN_PV=$MIN_PV
export MAX_PV=$MAX_PV
export MIN_SPAC=$MIN_SPAC
export MAX_SPAC=$MAX_SPAC
export TITLECHAR="$TITLECHAR"
export FIGSIZE_X=$FIGSIZE_X
export FIGSIZE_Y=$FIGSIZE_Y
export XTERM="$TERMINAL"
export DPI=$DPI
export idtype_rpv_var=$idtype_rpv_var
export smoothband=$smoothband
export df4spec=$df4spec
export FREQMIN_RPVAUTO=$FREQMIN_RPVAUTO
export FREQMAX_RPVAUTO=$FREQMAX_RPVAUTO
export ND_RPVAUTO=$ND_RPVAUTO
export pickpvfile_autoID=$readno2copy 
# added on 20191118 (see the script ANALYSIS_POIT/readpv.sh)
export LINES_HACHOU="$LINES_HACHOU_RPVAUTO"
export LINES_RADIUS="$LINES_RADIUS_RPVAUTO"
export idplotradius=-1
export ax1log=-1
export plot_allautoreadings=False
export plot_autoreadings=False
export plot_2stspac=False
export plot_spac=True
export plot_cca=True
export plot_nccca=True
export plot_ulim4cca=True
export plot_spac1zero=False
export plot_spac1zero1p=False
export plot_spac1zero_e=False
export plot_spaczeromanu=True
export plot_spaczeromanu2p=True
export IconReadColor=blue
export readrate_flag=3
export GNUPLOT=$GNUPLOT

#------------
# sprspeac
#------------
export work_again=work_again
export smthdir=work_smth
export sprspacdata=./sprspac.d
export dorefinespacfile=./DoRefineSpac.d

# mksmth.sh
export smooth4DoRefineSpac=0.1      #
export frange_half4DoRefineSpac=0.2 # 
export fmin_smooth4DoRefineSpac=0.2 # min freq for output
#export fmax_smooth4DoRefineSpac=80. # max freq for output
#export fmin_smooth4DoRefineSpac=-1. # min freq for output <--automatic
export fmax_smooth4DoRefineSpac=-1. # max freq for output <--automatic

#------------
# mkDoFullAutioReadSpac.sh or mkDoFullAutioReadSpac.sh
export clim1_refmodel=0.35
export clim2_refmodel=0.10
export izeromax_refmodel=10

#---------- 
# mkRefModel.sh
export id_do_again=1
export refmodelfile=spaczero_refmodel.d
export id_add_velfile_mini=1
export id_add_velfile_small=0

#----------------------------------
export id_add_velfile_small_high_zeros=1
#export id_add_velfile_small_high_zeros=0  # <-- temporaly set ineffective for test (20201007)
#----------------------------------

export smoothing_refmodel=0.5
export izero_dc_refmodel=10 # 1/wight of a dispersion curve relative to the 1st zero 
export interpolation_linscale_refmodel=0 # 1 linear scale / 0 log scale 
#export ndata_hokan_refmodel=40
export ndata_hokan_refmodel=20

#---------- 
# mkzero_again
export freq_interporate_refmodel_again=0.01
export factor_off_refmodel_again=0.2
#------------

#------------------------
# for delete_psd_low
# -1:  nothing done
#  1:  1xSelfnoise level 
#  2:  5xSelfnoise level 
#  3: 10xSelfnoise level 
#idpsdlevel=-1
idpsdlevel=2
#------------------------

EOF

#---------------------------------
# when there are only 1p-arrays 
if [ "`cat $listfile_sprspac | grep -v 1p_No | grep -v esac | grep -v DUMMY | wc -l | awk '{print $1}'`"  -eq 0 ]
then
cat <<EOF>>$exportfile
export plot_2stspac=True
export plot_spac=False
EOF
fi # if [ "`cat $listfile
#---------------------------------

if [ -f $exefile ]
then
rm -f $exefile
fi # if [ -f $exefile ]
cat <<EOF> $exefile
#!/bin/bash
cd ../../../../..
# the folloowing autopick script is temporalily not used
#. $workdir/readpv_auto.sh
. $workdir/readpv.py_param.sh
if [ -f $workdir/readpv.py_param_local.sh ]
then
. $workdir/readpv.py_param_local.sh
fi

if [ -f $workdir/.readsprspac.py.run ]
then
rm -f $workdir/.readsprspac.py.run 
fi

cd $workdir;. ./mkzeropv.sh ;cd -

$PYTHON_READPV

EOF
chmod u+x $exefile

if [ -f $exefile_sprspac ]
then
rm -f $exefile_sprspac
fi # if [ -f $exefile_sprspac ]
cat <<EOF> $exefile_sprspac
#!/bin/bash
cd ../../../../..
. $workdir/readpv.py_param.sh
if [ -f $workdir/readsprspac.py_param_local.sh ]
then
. $workdir/readsprspac.py_param_local.sh
fi

if [ ! -f $workdir/.readsprspac.py.run ]
then
touch -f $workdir/.readsprspac.py.run 

$PYTHON_READSPRSPAC

rm  -f $workdir/.readsprspac.py.run 
fi

EOF
chmod u+x $exefile_sprspac

#if [ -f $exefile_sprspac_auto ]
#then
#rm -f $exefile_sprspac_auto
#fi # if [ -f $exefile_sprspac_auto ]

for vf in picked_sprspac.d 
do
if [ ! -f $workdir/$vf ]
then
touch -f $workdir/$vf
fi 
done # for vf in picked_sprspac.d 

for vf in picked_refine.d
do
if [ ! -f $workdir/$vf ]
then
touch -f $workdir/$vf
else
cat $workdir/$vf | awk '{
if($2!=""){
if($5==""){pick_type="1"}else{pick_type=$5}
printf "%s %s %s %s %s\n",$1,$2,$3,$4,pick_type
}}' > $workdir/$vf.temporallySaved
mv -f $workdir/$vf.temporallySaved $workdir/$vf
fi 
done # for vf in $workdir/picked_refine.d

for vf in picked.d
do
if [ -f $workdir/$vf ]
then
cat $workdir/$vf | awk '{
if($2!=""){
if($3==""){pick_type="1"}else{pick_type=$3}
printf "%s %s %s \n",$1,$2,pick_type
}}' > $workdir/$vf.temporallySaved
mv -f $workdir/$vf.temporallySaved $workdir/$vf
else
touch -f $workdir/$vf 
fi 
done # for vf in $workdir/picked_refine.d

for vf in $mkcalerrfile 
do
if [ -f $vf ]
then
rm -f $vf
fi
done # for vf in $mkcalerrfile

ncolumn=`cat $listfile | wc -l | awk '{print $1}'`
cat <<EOF2> $mkcalerrfile
#!/bin/bash
aflim=$DIFLIM4CALERR_RPVAUTO
if [ -f $workdir/picked.d.tmp ]
then
rm -f $workdir/picked.d.tmp 
fi
$bindir/read_refine<<EOF >$workdir/picked.d.tmp
$workdir/picked_refine.d
$workdir/pv.d
\$aflim
$ncolumn
EOF
rm -f $workdir/picked_refine.d
cat $workdir/picked.d.tmp | awk '{
idok=1
if(\$2==""){idok=0}
if(\$1==0){idok=0}
if(\$2==0){idok=0}
if(idok==1){
printf "%5.4f %5.4f %5.4f %d %d\n",\$1,\$2,\$3,\$4,\$5}}' | sort -n  > $workdir/picked_refine.d
EOF2

chmod u+x $mkcalerrfile

#----------------------------
# execute $exefile_sprspac_auto
#----------------------------
exefile_sprspac_auto0=`basename $exefile_sprspac_auto`
dir_before_exefile_sprspac_auto=`pwd`
cd $workdir >& /dev/null
. ./mkpsdlevel_ju.sh
if [ ! -f $exefile_sprspac_auto0.processed ]
then
touch -f $exefile_sprspac_auto0.processed
echo Execute $exefile_sprspac_auto0
$exefile_sprspac_auto0
else
echo File found: $exefile_sprspac_auto0.processed
echo PASS.
fi
. ./mkzeropv.sh
cd $dir_before_exefile_sprspac_auto >& /dev/null
#----------------------------

#-----------------------------
echo PYTHON_READPV: $PYTHON_READPV

. $exportfile
if [ -f $exportfile_local ]
then
echo . $exportfile_local
. $exportfile_local
fi # if [ -f $exportfile_local ]
if [ -f $workdir/.readsprspac.py.run ]
then
rm -f $workdir/.readsprspac.py.run 
fi

if [ -f $WORKDIR_ALL/.readpv ]
then
.  $WORKDIR_ALL/.readpv
fi

if [ -f $WORKDIR_ALL/.readpv_local ]
then
.  $WORKDIR_ALL/.readpv_local 
fi

$PYTHON_READPV

if test "$?" != "0" 
then
cat <<EOF>> Analysis_Point.log

ERROR: program stopped anormalously.
Some trouble happend in executing $PYTHON_READPV
STOP

EOF
exit 1
fi # if test "$?" != "0" 

fi # if test `echo $pvfiles | awk '{print $1}'` == ""
