#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
from pylab import *
from numpy import *
from tkinter import *
import sys
import os
import subprocess
import signal
#import psutil

#import matplotlib
##print(matplotlib.rcParams)
#print(matplotlib.__version__)
#print(matplotlib.matplotlib_fname())
#print(matplotlib.get_data_path())

# character
VERSION="Phase velocity reader (Ver.4)"
TITLECHAR=os.getenv('TITLECHAR') 
WORKDIR=os.getenv('WORKDIR') 
PVUNIT=os.getenv('PVUNIT')
idtype_rpv_var=os.getenv('idtype_rpv_var')
smoothband=os.getenv('smoothband')
df4spec=os.getenv('df4spec')
FREQMIN_RPVAUTO=os.getenv('FREQMIN_RPVAUTO')
FREQMAX_RPVAUTO=os.getenv('FREQMAX_RPVAUTO')
ND_RPVAUTO=os.getenv('ND_RPVAUTO')
pickpvfile_autoID=os.getenv('pickpvfile_autoID')
XTERM=os.getenv('XTERM')

# integer
ID_PNGOUT=int(os.getenv('ID_PNGOUT'))
ID_DO_READ_PICKED=int(os.getenv('ID_DO_READ_PICKED'))
FIGSIZE_X=int(os.getenv('FIGSIZE_X'))
FIGSIZE_Y=int(os.getenv('FIGSIZE_Y'))
DPI=int(os.getenv('DPI'))
# float
FONTSIZE=float(os.getenv('FONTSIZE'))
PLOTLIM_PV=float(os.getenv('PLOTLIM_PV'))
MIN_PV=float(os.getenv('MIN_PV'))
MAX_PV=float(os.getenv('MAX_PV'))
PLOTLIM_FREQ=float(os.getenv('PLOTLIM_FREQ'))
MIN_FREQ=float(os.getenv('MIN_FREQ'))
MAX_FREQ=float(os.getenv('MAX_FREQ'))

MARKSIZE_SPAC1ZERO=40
MARKSIZE_SPAC1ZERO1P=10
MARKSIZE_SPAC1ZERO_E=30
MARKSIZE_SPAC1ZEROMANU1ST=100
MARKSIZE_SPAC1ZEROMANU=50
MARKSIZE_SPAC1ZEROMANU1ST2P=90
MARKSIZE_SPAC1ZEROMANU2P=30
MARKSIZE_AUTO=150
MARKSIZE_EYES=100
no_of_pickups=0

idfirst=1

picktype_flag0=1 # 0 nothing done / 1 adjust to an analysis result
#readrate_flag0=int(os.getenv('readrate_flag'))
IconReadColor=os.getenv('IconReadColor')
ax1log=int(os.getenv('ax1log'))
plotlim_freq=1
plotlim_pv=1
pngout=ID_PNGOUT
do_read_picked=ID_DO_READ_PICKED
x_text_lim_length=2
x_text_rotation_angle=30
hachou=[float(tmpdat) for tmpdat in str(os.getenv('LINES_HACHOU')).split(',')]
radiusfac=[float(tmpdat) for tmpdat in str(os.getenv('LINES_RADIUS')).split(',')]
idplotradius=int(os.getenv('idplotradius'))

line_col="r" # temporaly defined
line_st="-"  # temporaly defined
line_w=0.5    # temporaly defined
freqeps=0.001 # temporaly defined (for plotting lines with constant wavelengths in logarithmic scale)
root=Tk()
root.title("Reading phase velocity data")

#-----------------------------------
# Read AutoPickedALL Data
#-----------------------------------
def rspaczeromanu():
    global freq_rspaczeromanu,pv_rspaczeromanu
    freq_rspaczeromanu=[];pv_rspaczeromanu=[]
    fname=WORKDIR+"/spaczero_manual.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data : ',fname)
    elif no_of_lines == 1:
        dat_spaczeromanu=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu.append(dat_spaczeromanu[0])
        pv_rspaczeromanu.append(dat_spaczeromanu[1])
    else:
        dat_spaczeromanu=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu.append(dat_spaczeromanu[:,0])
        pv_rspaczeromanu.append(dat_spaczeromanu[:,1])

def rspaczeromanu1st():
    global freq_rspaczeromanu1st,pv_rspaczeromanu1st
    freq_rspaczeromanu1st=[];pv_rspaczeromanu1st=[]
    fname=WORKDIR+"/spaczero_manual1st.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data : ',fname)
    elif no_of_lines == 1:
        dat_spaczeromanu1st=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu1st.append(dat_spaczeromanu1st[0])
        pv_rspaczeromanu1st.append(dat_spaczeromanu1st[1])
    else:
        dat_spaczeromanu1st=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu1st.append(dat_spaczeromanu1st[:,0])
        pv_rspaczeromanu1st.append(dat_spaczeromanu1st[:,1])

######
def rspaczeromanu2p():
    global freq_rspaczeromanu2p,pv_rspaczeromanu2p
    freq_rspaczeromanu2p=[];pv_rspaczeromanu2p=[]
    fname=WORKDIR+"/spaczero_manual_2p.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data : ',fname)
    elif no_of_lines == 1:
        dat_spaczeromanu2p=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu2p.append(dat_spaczeromanu2p[0])
        pv_rspaczeromanu2p.append(dat_spaczeromanu2p[1])
    else:
        dat_spaczeromanu2p=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu2p.append(dat_spaczeromanu2p[:,0])
        pv_rspaczeromanu2p.append(dat_spaczeromanu2p[:,1])

def rspaczeromanu1st2p():
    global freq_rspaczeromanu1st2p,pv_rspaczeromanu1st2p
    freq_rspaczeromanu1st2p=[];pv_rspaczeromanu1st2p=[]
    fname=WORKDIR+"/spaczero_manual1st_2p.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data : ',fname)
    elif no_of_lines == 1:
        dat_spaczeromanu1st2p=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu1st2p.append(dat_spaczeromanu1st2p[0])
        pv_rspaczeromanu1st2p.append(dat_spaczeromanu1st2p[1])
    else:
        dat_spaczeromanu1st2p=genfromtxt(fname,delimiter=' ')
        freq_rspaczeromanu1st2p.append(dat_spaczeromanu1st2p[:,0])
        pv_rspaczeromanu1st2p.append(dat_spaczeromanu1st2p[:,1])

######

def rspac1zero():
    global freq_rspac1zero,pv_rspac1zero
    freq_rspac1zero=[];pv_rspac1zero=[]
    fname=WORKDIR+"/spaczero_manual1st_1p.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data : ',fname)
    elif no_of_lines == 1:
        dat_spac1zero=genfromtxt(fname,delimiter=' ')
        freq_rspac1zero.append(dat_spac1zero[0])
        pv_rspac1zero.append(dat_spac1zero[1])
    else:
        dat_spac1zero=genfromtxt(fname,delimiter=' ')
        freq_rspac1zero.append(dat_spac1zero[:,0])
        pv_rspac1zero.append(dat_spac1zero[:,1])

def rspac1zero1p():
    global freq_rspac1zero1p,pv_rspac1zero1p
    freq_rspac1zero1p=[];pv_rspac1zero1p=[]
    fname=WORKDIR+"/spaczero_manual_1p.d"
    no_of_lines=len([None for l in open(fname)])

    if   no_of_lines == 0:
        print('No data : ',fname)
    elif no_of_lines == 1:
        dat_spac1zero1p=genfromtxt(fname,delimiter=' ')
        freq_rspac1zero1p.append(dat_spac1zero1p[0])
        pv_rspac1zero1p.append(dat_spac1zero1p[1])
    else:
        dat_spac1zero1p=genfromtxt(fname,delimiter=' ')
        freq_rspac1zero1p.append(dat_spac1zero1p[:,0])
        pv_rspac1zero1p.append(dat_spac1zero1p[:,1])

def rspac1zero_e():
#        fname=WORKDIR+"/spac1zero_esac.d"
    fname=WORKDIR+"/spaczero_manual_esac.d"
    no_of_lines=len([None for l in open(fname)])

    if   no_of_lines == 0:
        print('No data : ',fname)
    elif no_of_lines == 1:
        dat_spac1zero_e=genfromtxt(fname,delimiter=' ')
        freq_rspac1zero_e.append(dat_spac1zero_e[0])
        pv_rspac1zero_e.append(dat_spac1zero_e[1])
    else:
        dat_spac1zero_e=genfromtxt(fname,delimiter=' ')
        freq_rspac1zero_e.append(dat_spac1zero_e[:,0])
        pv_rspac1zero_e.append(dat_spac1zero_e[:,1])

freq_rspac1zero=[]  ;pv_rspac1zero=[];
freq_rspac1zero1p=[];pv_rspac1zero1p=[];
freq_rspac1zero_e=[];pv_rspac1zero_e=[];
freq_rspaczeromanu=[];pv_rspaczeromanu=[];
freq_rspaczeromanu1st=[];pv_rspaczeromanu1st=[];
freq_rspaczeromanu2p=[];pv_rspaczeromanu2p=[];
freq_rspaczeromanu1st2p=[];pv_rspaczeromanu1st2p=[];

rspac1zero()
rspac1zero1p()
rspac1zero_e()
rspaczeromanu()
rspaczeromanu1st()
rspaczeromanu2p()
rspaczeromanu1st2p()

#-----------------------------------
# Read AutoPickedALL Data
#-----------------------------------
def rpicked_auto_all():
    fname=WORKDIR+"/picked_auto.d.all"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data: ',fname)
    elif no_of_lines == 1:
        dat_auto_all=genfromtxt(fname,delimiter=' ')
        freq_auto_all.append(dat_auto_all[0])
        pv_auto_all.append(dat_auto_all[1])
        stdpv_auto_all.append(dat_auto_all[2])
    else:
        dat_auto_all=genfromtxt(fname,delimiter=' ')
        freq_auto_all.append(dat_auto_all[:,0])
        pv_auto_all.append(dat_auto_all[:,1])
        stdpv_auto_all.append(dat_auto_all[:,2])

freq_auto_all=[];pv_auto_all=[];stdpv_auto_all=[];
rpicked_auto_all()        

#-----------------------------------
# Read AutoPicked Data
#-----------------------------------
def rpicked_auto():
    fname=WORKDIR+"/picked_auto.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data: ',fname)
    elif no_of_lines == 1:
        dat_auto=genfromtxt(fname,delimiter=' ')
        freq_auto.append(dat_auto[0])
        pv_auto.append(dat_auto[1])
        stdpv_auto.append(dat_auto[2])
    else:
        dat_auto=genfromtxt(fname,delimiter=' ')
        freq_auto.append(dat_auto[:,0])
        pv_auto.append(dat_auto[:,1])
        stdpv_auto.append(dat_auto[:,2])

freq_auto=[];pv_auto=[];stdpv_auto=[];
rpicked_auto()        
        
#-----------------------------------
# Read listfile
#-----------------------------------
fname=WORKDIR+"/list_pv.d.checked"
f=open(fname)
listdat=f.read()
f.close()
lines=listdat.split('\n')
color=[];linestyle=[];lw=[];label1=[];label2=[];plotid=[];plotidok=[];fl=[];fu=[];listdum1=[];listdum2=[]
npv=0
for line in lines:
    if line.split(' ')[0]!="":
        npv=npv+1
        listdum1.append(line.split(' ')[1])
        label1.append(line.split(' ')[2])
        label2.append(line.split(' ')[3])
        color.append(line.split(' ')[4])
        linestyle.append(line.split(' ')[5])
        lw.append(line.split(' ')[6])
        plotid.append(line.split(' ')[7])
        listdum2.append(line.split(' ')[8])
        fl.append(line.split(' ')[9])
        fu.append(line.split(' ')[10])
        plotidok.append("1")

# for all auto readings                
#npv=npv+1
label1.append("all auto readings")
label2.append("dummy")
color.append("dummy")
linestyle.append("dummy")
lw.append("dummy")
plotid.append("-1")
plotidok.append("0")

# for auto readings                
label1.append("auto readings")
label2.append("dummy")
color.append("dummy")
linestyle.append("dummy")
lw.append("dummy")
plotid.append("-2")
plotidok.append("1")

# for spac 1st zero
label1.append("dummy")
label2.append("dummy")
color.append("dummy")
linestyle.append("dummy")
lw.append("dummy")
plotid.append("5")
plotidok.append("1")

# for spac 1st zero 1p
label1.append("dummy")
label2.append("dummy")
color.append("dummy")
linestyle.append("dummy")
lw.append("dummy")
plotid.append("6")
plotidok.append("1")

# for spac 1st zero esac
label1.append("dummy")
label2.append("dummy")
color.append("dummy")
linestyle.append("dummy")
lw.append("dummy")
plotid.append("7")
plotidok.append("1")

# for spac zero
label1.append("dummy")
label2.append("dummy")
color.append("dummy")
linestyle.append("dummy")
lw.append("dummy")
plotid.append("8")
plotidok.append("1")

# for spac zero 2p
label1.append("dummy")
label2.append("dummy")
color.append("dummy")
linestyle.append("dummy")
lw.append("dummy")
plotid.append("9")
plotidok.append("1")

allautoreadingsok=0
autoreadingsok=0
spac1pok=0
spacok=0
ccaok=0
ncccaok=0
ulim4ccaok=0
spac1zerook=0
spac1zero1pok=0
spac1zero_eok=0
spaczeromanuok=0
spaczeromanu1stok=0
spaczeromanu2pok=0
spaczeromanu1st2pok=0
for i in range(len(plotid)):
    if   plotid[i]=="0": # 1p-spac
        plotidok[i]="0"  # <=  initially plot off for visibility
        spac1pok=1
    elif plotid[i]=="1": # spac
        spacok=1
    elif plotid[i]=="2": # cca
        ccaok=1
    elif plotid[i]=="3": # nc-cca
        ncccaok=1
    elif plotid[i]=="4": # ulim for cca
        ulim4ccaok=1
    elif plotid[i]=="5": # spac1zero
        spac1zerook=1
        iplotid_spac1zero=i
    elif plotid[i]=="6": # spac1zero1p
        spac1zero1pok=1
        iplotid_spac1zero1p=i
    elif plotid[i]=="7": # spac1zero(esac)
        spac1zero_eok=1
        iplotid_spac1zero_e=i
    elif plotid[i]=="8": # spaczeromanu
        spaczeromanuok=1
        iplotid_spaczeromanu=i
    elif plotid[i]=="9": # spaczeromanu2p
        spaczeromanu2pok=1
        iplotid_spaczeromanu2p=i
    elif plotid[i]=="-1": # all auto readings
        allautoreadingsok=1
    elif plotid[i]=="-2": # auto readings
        autoreadingsok=1
        iplotid_autoreadings=i

#print 'ndata: ',npv

#-----------------------------------
# Read Freqdat Velocity Data
#-----------------------------------
fname=WORKDIR+"/radius.d"
radius=[]
no_of_lines=len([None for l in open(fname)])
if   no_of_lines == 0:
    print('No data: ',fname)
elif no_of_lines == 1:
    radius_tmp=genfromtxt(fname)
    radius.append(radius_tmp)
else:
    radius=genfromtxt(fname)
#for i in range(len(radius)):
#       print 'radius',radius[i]

fname=WORKDIR+"/pv.d"
dat=genfromtxt(fname,delimiter=' ')

i=0
freq_max=max(dat[:,5*i])
freq_min=min(dat[:,5*i])
pv_max=max(dat[:,5*i+1])
pv_min=min(dat[:,5*i+1])
i=0
while i < npv:
    freq_max0=max(dat[:,5*i])
    freq_min0=min(dat[:,5*i])
    if freq_max0 > freq_max:
        freq_max=freq_max0
    if freq_min0 < freq_min:
        freq_min=freq_min0
    pv_max0  =max(dat[:,5*i+1])
    pv_min0  =min(dat[:,5*i+1])
    if pv_max0 > pv_max:
        pv_max=pv_max0
    if pv_min0 < pv_min:
        pv_min=pv_min0
    # print 'pv_max,pvmin',i,pv_min,pv_max
    i+=1
#-----------------------------------

# Set parameter values
xcur=[];ycur=[];icur=[]    # for cursol point accumulation
xview=[];yview=[]
kview=[];iview=[]
xview_refine=[];yview_refine=[];zview_refine=[]
kview_refine=[];iview_refine=[]

####################################################
def LineColSt(i,j):
    global line_col,line_st
    line_w=0.5

#-------------------------------------------------------
# To deal with the specification change (":" cannot be used.)
# python2.7.12->2.7.18 (ubuntu16.04->20.04)  20200604                    #-------------------------------------------------------
    if   j%4==0:
        line_st=(0,(5,5))
#               line_st="--"
    elif j%4==1:
        line_st=(0,())
#               line_st="-"
    elif j%4==2:
        line_st=(0,(3,5,1,5))
#               line_st="-."
    elif j%4==3:
        line_st=(0,(1,5))
#               line_st=":"
#-------------------------------------------------------
                        
    if   i%7==0:
        line_col="r"
    elif i%7==1:
        line_col="b"
    elif i%7==2:
        line_col="g"
    elif i%7==3:
        line_col="c"
    elif i%7==4:
        line_col="m"
    elif i%7==5:
        line_col="y"
    elif i%7==6:
        line_col="k"
        

def PLTCNTL():
    global plotid,plotidok
    for i in range(len(plotid)):
        if  plotid[i]=="-1": # all auto readings
            if plot_allautoreadings.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="-2": # auto readings
            if plot_autoreadings.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="0": # 1p-spac
            if plot_2stspac.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="1": # spac
            if plot_spac.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="2": # cca
            if plot_cca.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="3": # nc-cca
            if plot_nccca.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="4": # ulim for cca
            if plot_ulim4cca.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="5": # spac1zero
            if plot_spac1zero.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="6": # spac1zero1p
            if plot_spac1zero1p.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="7": # spac1zer_e
            if plot_spac1zero_e.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="8": # spaczermanu
            if plot_spaczeromanu.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        elif plotid[i]=="9": # spaczermanu2p
            if plot_spaczeromanu2p.get():
                plotidok[i]="1"
            else:
                plotidok[i]="0"
        else:
            plotidok[i]="0"

           
            
def RPicked():
    global idfirst  
    global xcur,ycur,icur
    if idfirst==1:
        idfirst=0       
        xposp=[];yposp=[];iposp=[]
        fname=WORKDIR+"/picked.d"
        no_of_lines=len([None for l in open(fname)])
        if   no_of_lines == 0:
            print('No data: ',fname)
        elif no_of_lines == 1:
            dat=genfromtxt(fname,delimiter=' ')
            xposp.append(dat[0])
            yposp.append(dat[1])
            iposp.append(dat[2])
        else:
            dat=genfromtxt(fname,delimiter=' ')
            xposp=dat[:,0] # 
            yposp=dat[:,1] # 
            iposp=dat[:,2] # 

        for i in range(len(xposp)):
            xcur.append(xposp[i]) #add the cursor point into x-list
            ycur.append(yposp[i]) #add the cursor point into y-list
            icur.append(iposp[i]) #add the cursor point into y-list
        print("Read previous readings (%s). Press Middle Button to Update Figure."%(fname))
        RPicked_refine()
    else:
        print("Button \"Previous readings\" can be used only once. Do \"Clear all readings\" to use this button.")

def RPicked_refmodel():
    global xcur,ycur,icur
    xposp=[];yposp=[];iposp=[]
    fname=WORKDIR+"/spaczero_refmodel_manu.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data: ',fname)
    elif no_of_lines == 1:
        dat=genfromtxt(fname,delimiter=' ')
        xposp.append(dat[0])
        yposp.append(dat[1])
        iposp.append(dat[2])
    else:
        dat=genfromtxt(fname,delimiter=' ')
        xposp=dat[:,0] # 
        yposp=dat[:,1] # 
        iposp=dat[:,2] # 
        
    for i in range(len(xposp)):
        xcur.append(xposp[i]) #add the cursor point into x-list
        ycur.append(yposp[i]) #add the cursor point into y-list
        icur.append(iposp[i]) #add the cursor point into y-list
        print("Read previous readings (%s). Press Middle Button to Update Figure."%(fname))

def RPicked_refine():
    global xview_refine,yview_refine,zview_refine,kview_refine,iview_refine
    xview_refine=[];yview_refine=[];zview_refine=[]
    kview_refine=[];iview_refine=[]
    xposp=[];yposp=[];zposp=[];
    kposp=[];iposp=[]
    fname=WORKDIR+"/picked_refine.d"
    no_of_lines=len([None for l in open(fname)])
    if   no_of_lines == 0:
        print('No data: ',fname)
    elif no_of_lines == 1:
        dat=genfromtxt(fname,delimiter=' ')
        xview_refine.append(dat[0])
        yview_refine.append(dat[1])
        zview_refine.append(dat[2])
        kview_refine.append(dat[3])
        iview_refine.append(dat[4])
    else:
        dat=genfromtxt(fname,delimiter=' ')
        xposp=dat[:,0] # 
        yposp=dat[:,1] #
        zposp=dat[:,2] #
        kposp=dat[:,3] #
        iposp=dat[:,4] #
        for i in range(len(xposp)):
            xview_refine.append(xposp[i]) 
            yview_refine.append(yposp[i]) 
            zview_refine.append(zposp[i]) 
            kview_refine.append(kposp[i]) 
            iview_refine.append(iposp[i]) 
   
def UpdateFlFu():
    i=0
    while i < npv:
        print('%d %s %s %s %s'%(i+1,label1[i],label2[i],fl[i],fu[i]))
        i+=1
    while True:
        try:
            idum=int(eval(input("Please select the number (0 to pass): ")))
            break
        except:
            pass
     
    if idum > npv+1:
        print('Please enter integer less than %d (npv).'%(npv))
        print('nothing done.')
    elif idum > 0:
        print('%d %s %s '%(idum,label1[idum-1],label2[idum-1]))
        while True:
            try:
                fl[idum-1]=float(eval(input("Please Enter fl [Hz]: ")))
                break
            except:
                pass
        while True:
            try:
                fu[idum-1]=float(eval(input("Please Enter fu [Hz]: ")))
                break
            except:
                pass
                
        print('%d %s %s %s %s'%(idum,label1[idum-1],label2[idum-1],fl[idum-1],fu[idum-1]))
        print('done.')
    else:
        print('nothing done')

def ChangeReadColor():
    global IconReadColor
    if IconReadColor == 'red':
        IconReadColor = 'blue'
    elif IconReadColor == 'blue':
        IconReadColor = 'green'
    elif IconReadColor == 'green':
        IconReadColor = 'yellow'
    elif IconReadColor == 'yellow':
        IconReadColor = 'red'
    onclick_dummy()        
    
def DoRefine():
    fname=WORKDIR+"/picked_refine.d"
    print('output datafile: %s '%(fname))
    fw=open(fname,'w')
    no_of_pickups=len(xview)
    for i in range(len(xview)):
        print('%f %f %d '%(xview[i],yview[i],iview[i]), file=fw)
    fw.close()
    command=". "+WORKDIR+"/mkcalerr.sh"
    os.system(command)
    print("Manual readings refined.")
    RPicked_refine()
# automatically activating adjust reading mode       
    if picktype_flag.get()==0:
        picktype_flag.set(1)

def DoAuto():
    fname=WORKDIR+"/list_pv.d.checked"
    print('output datafile: %s '%(fname))
    fw=open(fname,'w')
    i=0
    while i < npv:
        print('%d %s %s %s %s %s %s %s %s %s %s'%(i+1,listdum1[i],label1[i],label2[i],color[i],linestyle[i],lw[i],plotid[i],listdum2[i],fl[i],fu[i]), file=fw)
        i+=1
    fw.close()
    
    command=". "+WORKDIR+"/readpv_auto.sh"
    os.system(command)
    del freq_auto[:]
    del pv_auto[:]
    del stdpv_auto[:]
    rpicked_auto()
    del freq_auto_all[:]
    del pv_auto_all[:]
    del stdpv_auto_all[:]
    rpicked_auto_all()        
    print("Update autoreadings (%s). Press Middle Button to Update Figure."%(fname))

def SetPlotLimValue():
    global min_pv_value
    global max_pv_value
    global min_freq_value
    global max_freq_value
    global fixedvalue_plotlim_freq
    global fixedvalue_plotlim_pv

    min_pv_value=MIN_PV
    max_pv_value=MAX_PV
    min_freq_value=MIN_FREQ
    max_freq_value=MAX_FREQ
    fixedvalue_plotlim_freq=PLOTLIM_FREQ
    fixedvalue_plotlim_pv=PLOTLIM_PV
    
    # initial values for plot
#        global ax1log
    global plot_allautoreadings
    global plot_autoreadings
    global plot_2stspac
    global plot_spac
    global plot_cca
    global plot_nccca
    global plot_ulim4cca
    global plot_spac1zero
    global plot_spac1zero1p
    global plot_spac1zero_e
    global plot_spaczeromanu
    global plot_spaczeromanu2p
    plot_allautoreadings=BooleanVar()
    plot_autoreadings=BooleanVar()
    plot_2stspac=BooleanVar()
    plot_spac=BooleanVar()
    plot_cca=BooleanVar()
    plot_nccca=BooleanVar()
    plot_ulim4cca=BooleanVar()
    plot_spac1zero=BooleanVar()
    plot_spac1zero1p=BooleanVar()
    plot_spac1zero_e=BooleanVar()
    plot_spaczeromanu=BooleanVar()
    plot_spaczeromanu2p=BooleanVar()
    plot_allautoreadings.set(os.getenv('plot_allautoreadings'))
    plot_autoreadings.set(os.getenv('plot_autoreadings'))
    plot_2stspac.set(os.getenv('plot_2stspac'))
    plot_spac.set(os.getenv('plot_spac'))
    plot_cca.set(os.getenv('plot_cca'))
    plot_nccca.set(os.getenv('plot_nccca'))
    plot_ulim4cca.set(os.getenv('plot_ulim4cca'))
    plot_spac1zero.set(os.getenv('plot_spac1zero'))
    plot_spac1zero1p.set(os.getenv('plot_spac1zero1p'))
    plot_spac1zero_e.set(os.getenv('plot_spac1zero_e'))
    plot_spaczeromanu.set(os.getenv('plot_spaczeromanu'))
    plot_spaczeromanu2p.set(os.getenv('plot_spaczeromanu2p'))
    PLTCNTL()


def ReSetPlotLimValue():
    global min_pv_value
    global max_pv_value
    global min_freq_value
    global max_freq_value
    global fixedvalue_plotlim_freq
    global fixedvalue_plotlim_pv

    min_pv_value=float(e_pvmin.get())
    max_pv_value=float(e_pvmax.get())
    min_freq_value=float(e_freqmin.get())
    max_freq_value=float(e_freqmax.get())
    if max_freq_value > min_freq_value:
        fixedvalue_plotlim_freq=1
    else:
        fixedvalue_plotlim_freq=99
    if max_pv_value > min_pv_value:
        fixedvalue_plotlim_pv=1
    else:
        fixedvalue_plotlim_pv=99

def DoReadSPACZERO():
    global procsprspac
#    command="cd "+WORKDIR+";. ./exe_sprspac.sh"
#    command="cd "+WORKDIR+";"+XTERM+" -sb -e exe_sprspac.sh &"
    command="cd "+WORKDIR+";./exe_sprspac.sh"
    procsprspac=subprocess.Popen(command,shell=True)
#    print(procsprspac.pid)
#    print(os.getpgid(procsprspac.pid))

    rspaczeromanu()
    rspaczeromanu1st()
    rspaczeromanu2p()
    rspaczeromanu1st2p()
    rspac1zero()
    rspac1zero1p()
    onclick_dummy()
    print("Read SPAC ZEROs.")

def DoUpdateSPACZERO():
    rspaczeromanu()
    rspaczeromanu1st()
    rspaczeromanu2p()
    rspaczeromanu1st2p()
    rspac1zero()
    rspac1zero1p()
    onclick_dummy()
    print("Update SPAC ZEROs.")

def CheckPSD():
    command="cd "+WORKDIR+";"+XTERM+" -e bash ./mkCheckPSD.sh"
    print(command)
    os.system(command)
    print("CheckPSD")

def RunShell():
    command="cd "+WORKDIR+";"+XTERM+"&"
#    command="cd "+WORKDIR+";kterm &"
    os.system(command)
    print(command)
    print("Run Shell")

def CreateRefModelZero0():
    command="cd "+WORKDIR+";"+XTERM+" -e bash ./exe_mkRefModel_manu.sh 0"
    print(command)
    os.system(command)
    print("CreateRefModelZero 0")
    ClearReading()
    RPicked_refmodel()
    onclick_dummy()

def CreateRefModelZero1():
    command="cd "+WORKDIR+";"+XTERM+" -e bash ./exe_mkRefModel_manu.sh 1"
    print(command)
    os.system(command)
    print("CreateRefModelZero 1")
    ClearReading()
    RPicked_refmodel()
    onclick_dummy()

def DoNothing():
    print("Nothing done.")
    
def ChangePlotLim():
    global plotlim_freq
    global plotlim_pv
    plotlim_freq=-plotlim_freq
    plotlim_pv=-plotlim_pv
    onclick_dummy()

def ClearReading():
    global idfirst  
    global xcur,ycur,icur
    xcur=[]
    ycur=[]
    icur=[]
    idfirst=1
    onclick_dummy()        
    
def ChangeScale():
    global ax1log
    if ax1log==-1:
        ax1log=1
    elif ax1log>=1:
        ax1log=ax1log+1
    if ax1log>=4:
        ax1log=-1
    onclick_dummy()

def ChangeReferenceLine():
    global idplotradius
    idplotradius=-idplotradius
    onclick_dummy()

def PngPlot():
    fname=WORKDIR+"/image.png"
    print('output  pngfile: %s '%(fname))
    savefig(fname,dpi=72)

def WriteData():
    fname=WORKDIR+"/readpv.py_param_local.sh"
    print('output datafile: %s '%(fname))
    fw=open(fname,'w')
    print('#!/bin/bash', file=fw)
    print('export plot_allautoreadings=%s'%(plot_allautoreadings.get()), file=fw)
    print('export plot_autoreadings=%s'%(plot_autoreadings.get()), file=fw)
    print('export plot_2stspac=%s'%(plot_2stspac.get()), file=fw)
    print('export plot_spac=%s'%(plot_spac.get()), file=fw)
    print('export plot_cca=%s'%(plot_cca.get()), file=fw)
    print('export plot_nccca=%s'%(plot_nccca.get()), file=fw)
    print('export plot_ulim4cca=%s'%(plot_ulim4cca.get()), file=fw)
    print('export plot_spac1zero=%s'%(plot_spac1zero.get()), file=fw)
    print('export plot_spac1zero1p=%s'%(plot_spac1zero1p.get()), file=fw)
    print('export plot_spac1zero_e=%s'%(plot_spac1zero_e.get()), file=fw)
    print('export plot_spaczeromanu=%s'%(plot_spaczeromanu.get()), file=fw)
    print('export plot_spaczeromanu2p=%s'%(plot_spaczeromanu2p.get()), file=fw)
    print('export IconReadColor=%s'%(IconReadColor), file=fw)
    print('export ax1log=%s'%(ax1log), file=fw)
    print('export idplotradius=%s'%(idplotradius), file=fw)
    print('export PLOTLIM_FREQ=%s'%(plotlim_freq), file=fw)
    print('export PLOTLIM_PV=%s'%(plotlim_pv), file=fw)
    print('export MIN_PV=%s'%(min_pv_value), file=fw)
    print('export MAX_PV=%s'%(max_pv_value), file=fw)
    print('export MIN_FREQ=%s'%(min_freq_value), file=fw)
    print('export MAX_FREQ=%s'%(max_freq_value), file=fw)
    print('export LINES_HACHOU="', end=' ', file=fw)
    for i in range(len(hachou)-1):
        print('%s,'%(hachou[i]), end=' ', file=fw)
    print('%s"'%(hachou[len(hachou)-1]), file=fw)
    print('export LINES_RADIUS="', end=' ', file=fw)
    for i in range(len(radiusfac)-1):
        print('%s,'%(radiusfac[i]), end=' ', file=fw)
    print('%s"'%(radiusfac[len(radiusfac)-1]), file=fw)
#    print('export readrate_flag=%s'%(readrate_flag.get()), file=fw)
    print('export readrate_flag=999', file=fw)
    fw.close()
    
    fname=WORKDIR+"/picked.d"
    print('output datafile: %s '%(fname))
    fw=open(fname,'w')
    no_of_pickups=len(xview)
    for i in range(len(xview)):
        print('%f %f %d '%(xview[i],yview[i],iview[i]), file=fw)
    fw.close()
    DoRefine()
    
    fname=WORKDIR+"/picked_auto.d.info"
    print('output datafile: %s '%(fname))
    fw=open(fname,'w')
    print('%s idtype_rpv_var     '%(idtype_rpv_var), file=fw)
    print('%s smoothband         '%(smoothband), file=fw)
    print('%s df4spec            '%(df4spec), file=fw)
    print('%s FREQMIN_RPVAUTO    '%(FREQMIN_RPVAUTO), file=fw)
    print('%s FREQMAX_RPVAUTO    '%(FREQMAX_RPVAUTO), file=fw)
    print('%s ND_RPVAUTO         '%(ND_RPVAUTO), file=fw)
    print('%s pickpvfile_autoID  '%(pickpvfile_autoID), file=fw)
    print('%s no_of_pickups_manu '%(no_of_pickups), file=fw)
    fw.close()
    

def Exit_without_Save():
    global procsprspac
    print("Exit without Save()")
#    if 'procsprspac' in globals():
#        for proc in psutil.Process(procsprspac.pid).children(recursive=True):
#            proc.kill()
    ClearReading()
    sys.exit()

def Exit():
    global procsprspac
    print("Exit()")
    PngPlot()
    WriteData()
#    if 'procsprspac' in globals():
#        for proc in psutil.Process(procsprspac.pid).children(recursive=True):
#            proc.kill()
    sys.exit()

SetPlotLimValue()

#---------------------------
# plot contents begin
#---------------------------
def plot_conetents():
    fig.suptitle(TITLECHAR,fontsize=FONTSIZE)
    fig.text(0.5,0.02,VERSION,style='italic',fontsize=FONTSIZE*0.7)

    ax1 = fig.add_subplot(111)
    fig.subplots_adjust(left=0.1,right=0.7)
    ax1.set_title('Plot of a dispersion curve for reading',fontsize=FONTSIZE)
    ax1.set_xlabel('Frequency [Hz]',fontsize=FONTSIZE)
    ax1.set_ylabel('Phase Velocity [%s/s]'%PVUNIT,fontsize=FONTSIZE)
    if ax1log==1:
        ax1.loglog()
    elif ax1log==2:
        ax1.set_xscale('log')
    elif ax1log==3:
        ax1.set_yscale('log')

    freqmin=freq_min*0.8
    freqmax=freq_max*1.2
    if plotlim_freq==fixedvalue_plotlim_freq:
        freqmin=min_freq_value
        freqmax=max_freq_value
    pvmin=pv_min*0.8
    pvmax=pv_max*1.2
    if plotlim_pv==fixedvalue_plotlim_pv:
        pvmin=min_pv_value
        pvmax=max_pv_value

    dfreq=(freqmax*1.2-freqmin-freqeps)/10
    x=arange(freqeps+freqmin,freqmax*1.2,dfreq)

    zorder=1
    if idplotradius == 1:
        for i in range(len(radius)):
            radiusm=radius[i]*1000
            for j in range(len(radiusfac)):
                label_fac = '%dr(r %gm)' % (radiusfac[j],radiusm)
                LineColSt(i,j)
                ax1.plot(x,radiusfac[j]*radius[i]*x,linestyle=line_st,color=line_col,lw=line_w,label=label_fac,zorder=zorder); zorder+=1
    else:
        for i in range(len(hachou)):
            fac=hachou[i]*1000
            label_fac = 'WL%gm' % fac
            LineColSt(i,1)
            ax1.plot(x,hachou[i]*x,linestyle=line_st,color=line_col,lw=line_w,label=label_fac,zorder=zorder); zorder+=1

#---------------------------
# 20210616 for xticks
#    xtmp4tick=arange(0,freqmax,dfreq4tick)
    if ax1log ==-1:
        ax1log_lindum=1
    elif ax1log == 0:
        ax1log_lindum=1
    elif ax1log == 1:
        ax1log_lindum=0
    elif ax1log == 2:
        ax1log_lindum=0
    elif ax1log == 3:
        ax1log_lindum=1
        
    if ax1log_lindum == 1:
        freqw=freqmax-freqmin
        if freqw <= 1:
            dfreq4tick=0.1
        elif freqw <= 10:
            dfreq4tick=2
        elif freqw <= 20:
            dfreq4tick=5
        elif freqw <= 50:
            dfreq4tick=10
        elif freqw <= 100:
            dfreq4tick=20
        elif freqw <= 200:
            dfreq4tick=50
        else:
            dfreq4tick=100
        xtmp4tick=arange(0,freqmax*2,dfreq4tick)
    else:
        freqwo=2
        if freqmin != 0:
            freqwo=log10(freqmax/freqmin)
        if freqwo>=2:
            xtmp4tick=[0.01,0.1,1,10,100,1000]
        else:
            xtmp4tick=[0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500,1000]
            
#    for i in range(len(xtmp4tick)):
#        print "xtmp4tick[]: ",i,xtmp4tick[i]

    ax1.set_xticks(xtmp4tick)
    labels0=[]
    for tick0 in ax1.get_xticks():
        label0="%.1f"%tick0
        labels0.append(label0)
    ax1.set_xticklabels(labels0)
#---------------------------
                    
    i=0
    while i < npv:
        if plotidok[i]=="1":
            if linestyle[i]=="-" or linestyle[i]==":":
                    
#-------------------------------------------------------
# To deal with the specification change (":" cannot be used.)
# python2.7.12->2.7.18 (ubuntu16.04->20.04)  20200604                    #-------------------------------------------------------
                if linestyle[i]==":":
                    linestyle0=(0,(1,5))
                else:
#                                   linestyle0=linestyle[i]
                    linestyle0=(0,())
#-------------------------------------------------------
                                    
                ax1.plot(dat[:,5*i],dat[:,5*i+1],color=color[i],linestyle=linestyle0,lw=lw[i],label=label1[i]+'\n'+label2[i],zorder=zorder); zorder+=1
            else:
                ax1.scatter(dat[:,5*i],dat[:,5*i+1],color=color[i],marker=linestyle[i],label=label1[i]+'\n'+label2[i],zorder=zorder); zorder+=1

        i+=1
        
#------------------------------------------------
# append errorbars (all)
    i=npv
    if plotidok[i]=="1":
        x_all=[];y_all=[];e_all=[];
        for idum in range(len(freq_auto_all[0])):
            x_all.append(freq_auto_all[0][idum])
        for idum in range(len(pv_auto_all[0])):
            y_all.append(pv_auto_all[0][idum])
        for idum in range(len(stdpv_auto_all[0])):
            e_all.append(stdpv_auto_all[0][idum])
        ax1.errorbar(x_all,y_all,yerr=e_all,fmt='o',color='y',label=label1[i],zorder=zorder);zorder+=1
#------------------------------------------------

#--------------------
# append scatters 
    if plotidok[iplotid_spac1zero]=="1":
        if len(freq_rspac1zero)>=1:
            ax1.scatter(freq_rspac1zero,pv_rspac1zero,edgecolor='black',lw=1,color='y',marker='s',s=MARKSIZE_SPAC1ZERO,label='spac 1st zero (2st)',zorder=zorder); zorder+=1
    if plotidok[iplotid_spac1zero1p]=="1":
        if len(freq_rspac1zero1p)>=1:
            ax1.scatter(freq_rspac1zero1p,pv_rspac1zero1p,edgecolor='black',lw=1,color='y',marker='s',s=MARKSIZE_SPAC1ZERO1P,label='spac zero (2st)',zorder=zorder); zorder+=1
    if plotidok[iplotid_spac1zero_e]=="1":
        if len(freq_rspac1zero_e)>=1:
            ax1.scatter(freq_rspac1zero_e,pv_rspac1zero_e,edgecolor='black',lw=1,color='y',marker='s',s=MARKSIZE_SPAC1ZERO_E,label='esac zero',zorder=zorder); zorder+=1
    if plotidok[iplotid_spaczeromanu2p]=="1":
        if len(freq_rspaczeromanu2p)>=1:
            ax1.scatter(freq_rspaczeromanu2p,pv_rspaczeromanu2p,edgecolor='black',lw=1,color='r',marker='^',s=MARKSIZE_SPAC1ZEROMANU2P,label='spaczero (2p)',zorder=zorder); zorder+=1
        if len(freq_rspaczeromanu1st2p)>=1:
            ax1.scatter(freq_rspaczeromanu1st2p,pv_rspaczeromanu1st2p,edgecolor='black',lw=1,color='r',marker='^',s=MARKSIZE_SPAC1ZEROMANU1ST2P,label='spaczero1st (2p)',zorder=zorder); zorder+=1
    if plotidok[iplotid_spaczeromanu]=="1":
        if len(freq_rspaczeromanu)>=1:
            ax1.scatter(freq_rspaczeromanu,pv_rspaczeromanu,edgecolor='black',lw=1,color='r',marker='s',s=MARKSIZE_SPAC1ZEROMANU,label='spaczero (>3p)',zorder=zorder); zorder+=1
        if len(freq_rspaczeromanu1st)>=1:
            ax1.scatter(freq_rspaczeromanu1st,pv_rspaczeromanu1st,edgecolor='black',lw=1,color='r',marker='s',s=MARKSIZE_SPAC1ZEROMANU1ST,label='spaczero1st (>3p)',zorder=zorder); zorder+=1
            


            
#--------------------
            
    if len(freq_auto)>=1:
#--------------------
# append scatters
        if plotidok[iplotid_autoreadings]=="1":
            ax1.scatter(freq_auto,pv_auto,edgecolor='black',lw=1,color='y',marker='s',s=MARKSIZE_AUTO,label='auto readings',zorder=zorder); zorder+=1
#--------------------
# append errorbars
#        if len(xview_refine)<1:
#            x=[];y=[];e=[];
#            for idum in range():
#                x.append(freq_auto[0][idum])
#            for idum in range(len(pv_auto[0])):
#                y.append(pv_auto[0][idum])
#            for idum in range(len(stdpv_auto[0])):
#                e.append(stdpv_auto[0][idum])
#            ax1.errorbar(x,y,yerr=e,fmt='none',color='black',zorder=zorder);zorder+=1

#------------------------------------------------
# refined readings 
    if len(xview_refine)>=1:
        x=[];y=[];e=[];
        for idum in range(len(xview_refine)):
            x.append(xview_refine[idum])
        for idum in range(len(xview_refine)):
            y.append(yview_refine[idum])
        for idum in range(len(xview_refine)):
            e.append(zview_refine[idum])
        ax1.errorbar(x,y,yerr=e,fmt='o',color=IconReadColor,label='refined readings',zorder=zorder);zorder+=1
#------------------------------------------------
        
    if len(xview)>=1:
        ax1.scatter(xview,yview,edgecolor='black',color=IconReadColor,s=MARKSIZE_EYES,lw=3,marker='x',label='visual readings',zorder=zorder); zorder+=1
        no_of_pickups=len(xview)
        print("the number of pickups: ",no_of_pickups)
        
#-------------------------------------------------
# indicate freqneucny ranges with low powers 
    fname=WORKDIR+"/../../../RESULT/PSD/JU/psdlevel1.d" 
    f=open(fname)
    psdlowdat=f.read()
    f.close()
    psdlowlines=psdlowdat.split('\n')
    for psdlowline in psdlowlines:
        if psdlowline.split(' ')[0]!="":
            ax1.axvspan(psdlowline.split(' ')[0],psdlowline.split(' ')[1],color="gray",alpha=0.2)
    fname=WORKDIR+"/../../../RESULT/PSD/JU/psdlevel5.d"
    f=open(fname)
    psdlowdat=f.read()
    f.close()
    psdlowlines=psdlowdat.split('\n')
    for psdlowline in psdlowlines:
        if psdlowline.split(' ')[0]!="":
            ax1.axvspan(psdlowline.split(' ')[0],psdlowline.split(' ')[1],color="gray",alpha=0.2)
    fname=WORKDIR+"/../../../RESULT/PSD/JU/psdlevel10.d"
    f=open(fname)
    psdlowdat=f.read()
    f.close()
    psdlowlines=psdlowdat.split('\n')
    for psdlowline in psdlowlines:
        if psdlowline.split(' ')[0]!="":
            ax1.axvspan(psdlowline.split(' ')[0],psdlowline.split(' ')[1],color="gray",alpha=0.2)
#-------------------------------------------------

    ax1.grid()

    if   zorder<20:
        legendfontsize=10
        xpos_anchor=1.4
        ncol=1
    elif zorder<24:
        legendfontsize=8
        xpos_anchor=1.4
        ncol=1
    elif zorder<40:
        legendfontsize=6
        xpos_anchor=1.4
        ncol=1
    else:
        legendfontsize=6
        xpos_anchor=1.45
        ncol=2
#    ax1.legend(bbox_to_anchor=(xpos_anchor+0.05,1.1),prop={'size':legendfontsize},ncol=ncol)
    ax1.legend(bbox_to_anchor=(xpos_anchor-0.20,0.5),loc='center',prop={'size':legendfontsize},ncol=ncol)

#---------------------
# plot range of Figs #1,2
#---------------------
    ax1.set_xlim([freqmin,freqmax])
    ax1.set_ylim([pvmin,pvmax])

#----
# replace tick marks if being lengthy 
#----
    if ax1log_lindum == 1:
        for label in ax1.get_xticklabels():
            if len(label.get_text())>x_text_lim_length:
                ax1.set_xticklabels([label.get_text() for label in ax1.get_xticklabels()],rotation=x_text_rotation_angle,fontsize=10)
                break
    draw()
#---------------------------
# plot contents end
#---------------------------

#---------------------------
# onclick() begin
#---------------------------
def onclick(event):
    global xcur,ycur,icur
    global xview,yview,iview

    if event.inaxes is None:
        return

    bind=event.button

    if bind==1: # add a point
        xctmp=event.xdata
        yctmp=event.ydata
        ictmp=picktype_flag.get()
        xcur.append(xctmp) # add the cursor point into x-list
        ycur.append(yctmp) # add the cursor point into y-list
        icur.append(ictmp) # add the cursor point into y-list
        xtrace=array(xcur) # convert the list into numpy array for fast sorting
        ytrace=array(ycur) # convert the list into numpy array for fast sorting
        itrace=array(icur) # convert the list into numpy array for fast sorting
        ind=argsort(ytrace) # perform the sorting with ascending order
        xview=xtrace[ind]  
        yview=ytrace[ind]  
        iview=itrace[ind]  
        DoRefine()

    if bind==2: # select plotting mode
        xtrace=array(xcur) 
        ytrace=array(ycur) 
        itrace=array(icur) 
        ind=argsort(ytrace)
        xview=xtrace[ind]  
        yview=ytrace[ind]  
        iview=itrace[ind]  
        DoRefine()
        ReSetPlotLimValue()

    if bind==3: # erase a point 
        xctmp=event.xdata
        yctmp=event.ydata
        if len(xview)>=1:
            xtrace=array(xcur) # convert a python list into numpy array for minimum distance detecting
            ytrace=array(ycur)
            xdel=xtrace-xctmp
            ydel=ytrace-yctmp
            dvec=xdel**2+ydel**2 # calculate the distance from right clicked point
            mind=argmin(dvec) # get the minimum point index 
            del xcur[mind] # delete the point close to right clicked point
            del ycur[mind] # delete the point close to right clicked point
            del icur[mind] # delete the point close to right clicked point
            xtrace=array(xcur)
            ytrace=array(ycur)
            itrace=array(icur)
            ind=argsort(ytrace)
            xview=xtrace[ind]
            yview=ytrace[ind]
            iview=itrace[ind]
        DoRefine()

    # plotting 
    event.canvas.figure.clear()
    plot_conetents()
    event.canvas.draw()
#---------------------------
# onclick() end
#---------------------------

#---------------------------
# onclick_dummy() begin
#---------------------------
def onclick_dummy():
    global xcur,ycur,icur
    global xview,yview,iview
    xtrace=array(xcur) 
    ytrace=array(ycur) 
    itrace=array(icur) 
    ind=argsort(ytrace)
    xview=xtrace[ind]  
    yview=ytrace[ind]  
    iview=itrace[ind]  
    DoRefine()
    ReSetPlotLimValue()
    # plotting 
    canvas.figure.clear()
    plot_conetents()
    canvas.draw()
#---------------------------
# onclick_dummy() end
#---------------------------

if do_read_picked==1:
    RPicked()

if len(xcur)>=1:
    xtrace=array(xcur) # convert the list into numpy array for fast sorting
    ytrace=array(ycur) # convert the list into numpy array for fast sorting
    itrace=array(icur) # convert the list into numpy array for fast sorting
    ind=argsort(ytrace) # perform the sorting with ascending order
    xview=xtrace[ind]  
    yview=ytrace[ind]  
    iview=itrace[ind]  

fig = figure(figsize=(FIGSIZE_X,FIGSIZE_Y),dpi=DPI)
plot_conetents()

#----------------
# widget
#----------------
f1=Frame(root)
f1.grid(row=0,column=0,sticky="n")
f1B=LabelFrame(root,text="Read") 
f1B.grid(row=0,column=2,sticky="n")

Message(f1,text=VERSION+'\nMouse button:\nLeft    :Add readings\nMiddle :Update figure\nRight  :Delete readings').pack()

Message(f1,text='Plot',width=300).pack(anchor="sw")
plot_refline=BooleanVar()
plot_loglinear=BooleanVar()
plot_limfree=BooleanVar()
plot_refline.set(True)
plot_loglinear.set(True)
plot_limfree.set(True)
Checkbutton(f1, text="Ref. Line WL<->Radius",  variable=plot_refline,command=ChangeReferenceLine).pack(anchor='sw')
Checkbutton(f1, text="Lin>xyLog>xLog>ylog>Lin",  variable=plot_loglinear,command=ChangeScale).pack(anchor='sw')
Checkbutton(f1, text="Range Limited<->Free",  variable=plot_limfree,command=ChangePlotLim).pack(anchor='sw')

Message(f1,text='Min/Max [Frequency(Hz)]',width=300).pack(anchor="sw")
f1_2=Frame(f1) 
e_freqmin=Entry(f1_2,width="5")
e_freqmax=Entry(f1_2,width="5")
e_freqmin.insert(0,MIN_FREQ)
e_freqmax.insert(0,MAX_FREQ)
e_freqmin.pack(side="left")
e_freqmax.pack(side="right")
f1_2.pack(anchor="sw")

Message(f1,text='Min/Max [Phase Vel.(km/s)]',width=300).pack(anchor="sw")
f1_3=Frame(f1) 
e_pvmin=Entry(f1_3,width="5")
e_pvmax=Entry(f1_3,width="5")
e_pvmin.insert(0,MIN_PV)
e_pvmax.insert(0,MAX_PV)
e_pvmin.pack(side="left")
e_pvmax.pack(side="right")
f1_3.pack(anchor="sw")

button=Button(f1,text='Refresh',command=onclick_dummy)
button.pack(fill='both')

#if allautoreadingsok==1:
#       Checkbutton(f1, text="all auto readings",  variable=plot_allautoreadings,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')
#if autoreadingsok==1:
#    Checkbutton(f1, text="auto readings",  variable=plot_autoreadings,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')
if spac1pok==1:
    Checkbutton(f1, text="1p-spac",  variable=plot_2stspac,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')
if spacok==1:
    Checkbutton(f1, text="spac/esac",  variable=plot_spac,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')
if ccaok==1:
    Checkbutton(f1, text="cca",  variable=plot_cca,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')
if ncccaok==1:
    Checkbutton(f1, text="nc-cca/ncspac",  variable=plot_nccca,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')

if ulim4ccaok==1:
    Checkbutton(f1, text="ulim for cca",  variable=plot_ulim4cca,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')

if spac1zerook==1:
    Checkbutton(f1, text="spac 1st zero (1p)",  variable=plot_spac1zero,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')

if spac1zero1pok==1:
    Checkbutton(f1, text="spac zero (1p)",  variable=plot_spac1zero1p,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')

#if spac1zero_eok==1:
#    Checkbutton(f1, text="esac zero",  variable=plot_spac1zero_e,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')

if spaczeromanu2pok==1:
    Checkbutton(f1, text="spac zero (2p)",  variable=plot_spaczeromanu2p,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')

if spaczeromanuok==1:
    Checkbutton(f1, text="spac zero (>3p)",  variable=plot_spaczeromanu,command=lambda:[PLTCNTL(),onclick_dummy()]).pack(anchor='sw')
    
#Message(f1B,text='\nInput',width=300).pack(anchor='sw')
Message(f1B,text='Adjust reading: 0=No/1=Yes',width=300).pack(anchor='sw')
picktype_flag=IntVar()
picktype_flag.set(picktype_flag0)
f1_radio=Frame(f1B) 
radio1=Radiobutton(f1_radio,value=0,variable=picktype_flag,text="0")
radio1.pack(side="left")
radio2=Radiobutton(f1_radio,value=1,variable=picktype_flag,text="1")
radio2.pack(side="left")
f1_radio.pack(anchor="sw")

button=Button(f1B,text='Change reading color',command=ChangeReadColor)
button.pack(fill='both')
button=Button(f1B,text='Previous readings',command=lambda:[RPicked(),onclick_dummy()])
button.pack(fill='both')
button=Button(f1B,text='Clear all readings',command=ClearReading)
button.pack(fill='both')

Message(f1B,text='External Software',width=300).pack(anchor='sw')
button=Button(f1B,text='Check PSD',command=CheckPSD)
button.pack(fill='both')
button=Button(f1B,text='Apply Zero-Crossing Method',command=DoReadSPACZERO)
button.pack(fill='both')
button=Button(f1B,text='Update zero-crossing data',command=DoUpdateSPACZERO)
button.pack(fill='both')
button=Button(f1B,text='Autoread based on 1st zero crossings\nReally OK? [All readings overwritten]',command=CreateRefModelZero0)
button.pack(fill='both')
button=Button(f1B,text='Autoread based on all-zero crossings\nReally OK? [All readings overwritten]',command=CreateRefModelZero1)
button.pack(fill='both')

#button=Button(f1B,text='Shell (Run Xterm for DEBUG)',command=RunShell)
#button.pack(fill='both')
#button=Button(f1B,text='(currently not used)',command=DoNothing)
#button.pack(fill='both')
#button=Button(f1B,text='(currently not used)',command=DoNothing)
#button.pack(fill='both')

#Message(f1B,text='[Quality (bad)1<-->5(good)]',width=300).pack(anchor='sw')
#readrate_flag=IntVar()
#readrate_flag.set(readrate_flag0)
#f1_radio=Frame(f1B) 
#radio1=Radiobutton(f1_radio,value=1,variable=readrate_flag,text="1")
#radio1.pack(side="left")
#radio2=Radiobutton(f1_radio,value=2,variable=readrate_flag,text="2")
#radio2.pack(side="left")
#radio3=Radiobutton(f1_radio,value=3,variable=readrate_flag,text="3")
#radio3.pack(side="left")
#radio3=Radiobutton(f1_radio,value=4,variable=readrate_flag,text="4")
#radio3.pack(side="left")
#radio3=Radiobutton(f1_radio,value=5,variable=readrate_flag,text="5")
#radio3.pack(side="left")
#f1_radio.pack(anchor="sw")

Message(f1,text='Quit',width=300).pack(anchor="sw")
button=Button(f1,text='SAVE & QUIT',command=Exit)
button.pack(fill='both')
#button=Button(f1,text='QUIT (WITHOUT SAVE)',command=Exit_without_Save)
#button.pack(fill='both')

f2=Frame(root) 
f2.grid(row=0,column=3)
canvas = FigureCanvasTkAgg(fig,master=f2)
#canvas.show()
canvas.draw()
canvas.mpl_connect('button_press_event', onclick)
canvas.get_tk_widget().pack(side='top', fill='both', expand=1)

if pngout==1:
    PngPlot()   # <-- with saving pngfile only
#       Exit()      # <-- with saving individual files 
else:
    root.mainloop()
