#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
from pylab import *
from numpy import *
from tkinter import *
from tkinter import filedialog
from tkinter import messagebox
import sys
import os
import subprocess
import signal

root=Tk()
root.title("pvreader")

inputdirs=[]

XTERM=os.getenv('XTERM')
idir=os.getenv('INPUT_DATADIR')
odir=os.getenv('OUTPUT_DATADIR')
WORKDIR_ALL=os.getenv('WORKDIR_ALL')

def OpenDataDir():
    global idir
    global outputdir
    dir = filedialog.askdirectory(initialdir = idir,mustexist=True)
    
    if dir:
        dir1 = dir+"/RESULT/1"
        dir2 = dir+"/RESULT/ave"
        if os.path.exists(dir1):
            if os.path.exists(dir2):
                inputdirs.append(dir)
                print('Data Directory ',len(inputdirs),dir)
        else:
            print('Warning: datadir should contain directories ave and 1, but not found.\n',len(inputdirs),dir)
            message="Selected data directory is not appropriate: "+dir+"\n\nSelect again!"
            messagebox.showinfo(title=None, message=message)
    
def Exit():
    command="Data processing finished."
    print(command)
    sys.exit()

def RunShell():
    inputdir=""
    outputdir=""
    inputdir4message=""

    for i in range(len(inputdirs)):
        inputdir=inputdir+" "+inputdirs[i]
        inputdir4message=inputdir4message+"["+str(i+1)+"]"+inputdirs[i]+"\n"
    if inputdir:
        outputdir=inputdirs[0]+"/output"
        message="Note\nDataDir:\n"+inputdir4message+"\nSaveDir:\n"+outputdir+"\n"
        ret=messagebox.askyesno(title=None, message=message)
        if ret == False:
            Exit()
    else:
        command="ERROR: datadir not defined."
        print(command)
        Exit()
    
    command="Data processing started."
    print(command)
    command="cd "+WORKDIR_ALL+"; "+XTERM+" -e bash ./Analysis_Point.sh \""+inputdir+"\" "+outputdir
#    print(command)
    
    os.system(command)
    inputdirs.clear()

#----------------
# widget
#----------------
f1=Frame(root)
f1.grid(row=0,column=0,sticky="n")
button=Button(f1,text='DataDir',command=OpenDataDir)
button.pack(fill='both')
button=Button(f1,text='RunShell',command=RunShell)
button.pack(fill='both')
button=Button(f1,text='QUIT',command=Exit)
button.pack(fill='both')

root.mainloop()
