#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

#spaczero_manual1st_1p.d.again  # 2st-spac 1st zero
#spaczero_manual_1p.d.again     # all 2st-spac
#spaczero_manual1st_2p.d.again  # 2pair-spac 1st zero
#spaczero_manual_2p.d.again     # all 2pair-spac
#spaczero_manual_esac.d.again # esac all zero
#spaczero_manual.d.again    # spac all  (>3p)
#spaczero_manual1st.d.again # spac 1st zero (>3p)
#spaczero_manual_all.d.again # all spac

ls $work_again/picked_sprspac????.d >& /dev/null
if test "$?" == "0"
then
    datafile=`ls $work_again/picked_sprspac????.d`
else
    datafile="NOFILE"
fi

######################################################################
# Don't touch from here
######################################################################
files="
$refmodelfile.lint1
$refmodelfile.lint2

spaczero_manual_1p.d.again   
spaczero_manual1st_1p.d.again   
spaczero_manual_2p.d.again   
spaczero_manual1st_2p.d.again   
spaczero_manual_esac.d.again    
spaczero_manual.d.again   
spaczero_manual1st.d.again   
spaczero_manual_all.d.again"

for vf in $files
do
if [ -f $vf ]
then
rm -f $vf
fi
echo OUTPUT $vf
touch -f $vf
done

if [ -f  `echo $datafile | awk '{print $1}'` ]
then
    
cat $datafile | awk 'BEGIN{pi=3.14159265;pi2=pi*2}{f=$1;zeronum=$3;r=$4
label1=$5;label2=$6;seismid=$7
if(      zeronum==1){
rk=2.4048
}else if(zeronum==2){
rk=5.5201
}else if(zeronum==3){
rk=8.6537
}else if(zeronum==4){
rk=11.792
}else if(zeronum==5){
rk=14.931
}else if(zeronum==6){
rk=18.071
}else if(zeronum==7){
rk=21.212
}else if(zeronum==8){
rk=24.353
}else if(zeronum==9){
rk=27.494
}else if(zeronum==10){
rk=30.635
#rk=33.776
}else{
rk=0
}
if ($5==""){label1="dummy"}
if ($6==""){label2="dummy"}
if ($7==""){seismid="dummy"}
c=pi2*f*r/rk
printf "%f %f %d %s %s %s %s \n", f, c,zeronum,label1,label2,r,seismid
}' | sort -n  >> ./spaczero_manual_all.d.again  

fi # if [ -f  `echo $datafile | awk '{print $1}'` ]

#-----------------------------------------------
# interpolation (extrapolation will not be done)
#-----------------------------------------------
if [ "`wc -l $refmodelfile | awk '{print $1}'`" -gt 0 ]
then
freqmax_lint=`cat $refmodelfile | awk '{printf "%0.5f\n",$1}' | sort -n | tail -1`
$bindir/linearint2 <<EOF >> $refmodelfile.lint1
$refmodelfile
$freqmax_lint
$freq_interporate_refmodel_again
EOF
fi # if [ "`wc -l $refmodelfile | awk '{print $1}'`" -gt 0 ]

#-----------------------------------------------
# process
#-----------------------------------------------
if [ "`wc -l $refmodelfile.lint1 | awk '{print $1}'`" -gt 0 ]
then
cat ./spaczero_manual_all.d.again | awk 'BEGIN{
print "'"$factor_off_refmodel_again"'"
print "'"$refmodelfile.lint1"'"
}{print $1,$2}' | $bindir/check_spaczero_again >> $refmodelfile.lint2   
fi

rm -f $refmodelfile.lint1
paste ./spaczero_manual_all.d.again $refmodelfile.lint2 | awk '{
if($8==1){printf "%s %s %s %s %s %s %s \n",$1,$2,$3,$4,$5,$6,$7}}' > $refmodelfile.lint1
mv -f $refmodelfile.lint1 ./spaczero_manual_all.d.again
rm -f $refmodelfile.lint2

#-----------------------------------------------
# output
#-----------------------------------------------
cat ./spaczero_manual_all.d.again|grep -v 1p_No | grep -v 2p | grep -v esac >> ./spaczero_manual.d.again 
cat ./spaczero_manual_all.d.again|grep -v 1p_No | grep -v 2p | grep -v esac | awk  '{if($3==1){print $0}}' >> ./spaczero_manual1st.d.again 
cat ./spaczero_manual_all.d.again|grep esac  >> ./spaczero_manual_esac.d.again

cat ./spaczero_manual_all.d.again|grep 1p_No >> ./spaczero_manual_1p.d.again
cat ./spaczero_manual_all.d.again|grep 1p_No| awk  '{if($3==1){print $0}}' >> ./spaczero_manual1st_1p.d.again

cat ./spaczero_manual_all.d.again|grep 2p >> ./spaczero_manual_2p.d.again
cat ./spaczero_manual_all.d.again|grep 2p | awk  '{if($3==1){print $0}}' >> ./spaczero_manual1st_2p.d.again
