#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

#spac1zero.d                 # 2st-spac 1st zero
#-> spaczero_manual1st_1p.d  # 2st-spac 1st zero

#spac1zero1p.d               # all 2st-spac
#-> spaczero_manual_1p.d     # all 2st-spac

#spac1zero_esac.d     # esac all zero
#-> spaczero_manual_esac.d # esac all zero

#spaczero_manual.d    # spac all  (except for esac & 2st-spac) 
#spaczero_manual1st.d # spac 1st zero (except for esac & 2st-spac) 
#spaczero_manual_all.d # all spac including esac & 2st-spac

datafile=`ls ./work/picked_sprspac????.d`

######################################################################
# Don't touch from here
######################################################################
files="
spaczero_manual_1p.d   
spaczero_manual1st_1p.d
spaczero_manual_2p.d   
spaczero_manual1st_2p.d
spaczero_manual_esac.d 
spaczero_manual.d
spaczero_manual1st.d
spaczero_manual_all.d"

for vf in $files
do
if [ -f $vf ]
then
rm -f $vf
fi
echo OUTPUT $vf
touch -f $vf
done

cat $datafile | awk 'BEGIN{pi=3.14159265;pi2=pi*2}{f=$1;zeronum=$3;r=$4
label1=$5;label2=$6;seismid=$7
if(      zeronum==1){
rk=2.4048
}else if(zeronum==2){
rk=5.5201
}else if(zeronum==3){
rk=8.6537
}else if(zeronum==4){
rk=11.792
}else if(zeronum==5){
rk=14.931
}else if(zeronum==6){
rk=18.071
}else if(zeronum==7){
rk=21.212
}else if(zeronum==8){
rk=24.353
}else if(zeronum==9){
rk=27.494
}else if(zeronum==10){
rk=30.635
#rk=33.776
}else{
rk=0
}
if ($5==""){label1="dummy"}
if ($6==""){label2="dummy"}
if ($7==""){seismid="dummy"}
c=pi2*f*r/rk
printf "%f %f %d %s %s %s %s \n", f, c,zeronum,label1,label2,r,seismid
}' | sort -n  >> ./spaczero_manual_all.d  # all spac including esac & 2st-spac
cat ./spaczero_manual_all.d|grep -v 1p_No | grep -v 2p | grep -v esac >> ./spaczero_manual.d 
cat ./spaczero_manual_all.d|grep -v 1p_No | grep -v 2p | grep -v esac | awk  '{if($3==1){print $0}}' >> ./spaczero_manual1st.d 
cat ./spaczero_manual_all.d|grep esac  >> ./spaczero_manual_esac.d
cat ./spaczero_manual_all.d|grep 1p_No >> ./spaczero_manual_1p.d
cat ./spaczero_manual_all.d|grep 1p_No| awk  '{if($3==1){print $0}}' >> ./spaczero_manual1st_1p.d
cat ./spaczero_manual_all.d|grep 2p >> ./spaczero_manual_2p.d
cat ./spaczero_manual_all.d|grep 2p| awk  '{if($3==1){print $0}}' >> ./spaczero_manual1st_2p.d

