#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

idcheckplot=0

######################################################################
# Don't touch from here
######################################################################
file_sprread=`cat $dorefinespacfile | head -1 | sed 's/ //g'`
option_cut=`  cat $dorefinespacfile | head -2 | tail -1 | awk '{no=$1+1
l1=5*(no-1)+1;l2=5*(no-1)+2
printf "%d,%d",l1,l2}'`
radius=`cat $dorefinespacfile | head -3 | tail -1 | awk '{printf "%s",$1}'`
label1=`cat $dorefinespacfile | head -4 | tail -1 | awk '{printf "%s",$1}'`
label2=`cat $dorefinespacfile | head -5 | tail -1 | awk '{printf "%s",$1}'`
seismid=`cat $dorefinespacfile | head -6 | tail -1 | awk '{printf "%s",$1}'`

f_smth=$smthdir/`basename $file_sprread`

if [ ! -d $smthdir ]
then
mkdir -p $smthdir 
fi

#-----------------------------------------------
# clean file
#-----------------------------------------------
for f in $file_sprread.tmp $file_sprread.tmp2
do
if [ -f $f ]
then
rm -f $f
fi
touch -f $f
done

#-----------------------------------------------
# extracting data
#-----------------------------------------------
cat $sprspacdata | cut -d " " -f $option_cut >> $file_sprread.tmp

#-----------------------------------------------
# interpolation
#-----------------------------------------------
#freq_interporate=0.005
#freqmax_lint=`cat $file_sprread.tmp | tail -1 | awk '{print $1}'`
#$bindir/linearint2 <<EOF > $file_sprread.lintmp2
#$file_sprread.tmp
#$freqmax_lint
#$freq_interporate
#EOF
#mv -f $file_sprread.lintmp2 $file_sprread.tmp

#-----------------------------------------------
# smoothing
#-----------------------------------------------
if [ -f $f_smth ]
then
    echo Smoothed file found : $f_smth
    echo Nothing done for smoothing
else

    if [ "`wc -l $file_sprread.tmp | awk '{print $1}'`" -gt 0 ]
    then
	echo Smoothing processing ... : $f_smth
	cat $file_sprread.tmp | awk 'BEGIN{
printf "%s,%s\n"	      ,"'"$fmin_smooth4DoRefineSpac"'","'"$fmax_smooth4DoRefineSpac"'"
printf "%s\n","'"$smooth4DoRefineSpac"'"
       }{print $0}'| $bindir/smth > $f_smth
    else
	echo No data found in $sprspacdata
	echo Nothing done
    fi
    echo done 
fi # if [ ! -f $f_smth ]

#----------------------
# check plot
#----------------------
if [ $idcheckplot -eq 1 ]
then
cat <<EOF> test.gnplt
#set term x11
#set logscale x
plot 0 ti "","$file_sprread.tmp" w l,"$f_smth" w l
pause -1
EOF
gnuplot test.gnplt
rm -f test.gnplt
fi
