#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

listfile=list_sprspac.d
readfile=spaczero_manual_all.d
dir0=../../../array
######################################################################
# Don't touch from here
######################################################################
if test "$1" == ""
then
echo "Usage mkplot_spac.sh id [RETURN] (id:0, standard output or 1 png output)" 
exit 1
fi
id_png=$1

gnpltfile=plot_spac.gnplt
#GNUPLOT=gnuplot
plotdatadir=plotdat
tmplistfile=$listfile.temporal

if [ -f ./readpv.py_param.sh ]
then
. ./readpv.py_param.sh
fi
if [ -f ./readpv.py_param_local.sh ]
then
. ./readpv.py_param_local.sh
fi
if [ -f ./readsprspac.py_param_local.sh  ]
then
. ./readsprspac.py_param_local.sh
fi

for f in $tmplistfile $gnpltfile ./dummy.d
do
if [ -f $f ]
then
rm -f $f
fi
touch -f $f
done

if [ -d $plotdatadir ]
then
rm -rf $plotdatadir 
fi
mkdir -p $plotdatadir 

# Basically, we do not use 1p-arrays.
cat $listfile | grep -v 1p_No | grep -v esac | grep -v DUMMY | awk '{printf "%s %s %s %0.5f\n",$3,$4,$9,$10}'| sort -rn -k 4 >> $tmplistfile

# However, if you have 1p-arrays only, we use 1p array.
if [ "`wc -l $tmplistfile | awk '{print $1}'`" -eq 0 ]
then
cat $listfile | grep -v esac | grep -v DUMMY | awk '{printf "%s %s %s %0.5f\n",$3,$4,$9,$10}'| sort -rn -k 4 >> $tmplistfile
fi

cat <<EOF>> $gnpltfile 
#set term x11
#set logscale x 
EOF

if test "$id_png" == "1"
then
cat <<EOF>> $gnpltfile 
set term png 
EOF
fi

nlist=`wc -l $tmplistfile | awk '{print $1}'`
ilist=1
while [ $ilist -le $nlist ]
do
    
buf=`cat $tmplistfile | head -$ilist | tail -1`
    
tmpfile_zero1=$plotdatadir/zero_1st_$ilist.d
tmpfile_zero2=$plotdatadir/zero_later_$ilist.d
if [ -f $tmpfile_zero1 ]
then
rm -f $tmpfile_zero1 
fi
touch -f $tmpfile_zero1 
if [ -f $tmpfile_zero2 ]
then
rm -f $tmpfile_zero2 
fi
touch -f $tmpfile_zero2 

code=`echo $buf | awk '{print $1}'`
fileid=`echo $buf | awk '{print $2}'`
file0=`echo $buf | awk '{print $3}'`
r=`echo $buf | awk '{print $4}'`

#--------
# extract psdfiles constituting the SPAC coefficients
# start
# id_category
#    1  3p
#    2  2p
#    3  APX
#    0  other (1p)
#--------
idok=0
id_category=0

if [ $idok -eq 0 ]
then   
echo $fileid | grep pAPX_n | grep CL >& /dev/null
if test "$?" == "0"
then
id_category=3
idok=1
fi
fi

if [ $idok -eq 0 ]
then   
echo $fileid | grep 2p >& /dev/null
if test "$?" == "0"
then
id_category=2
idok=1
fi
fi

if [ $idok -eq 0 ]
then   
echo $fileid | grep 3p >& /dev/null
if test "$?" == "0"
then
id_category=1
idok=1
fi
fi

cohfiles=""
if   [ $id_category -eq 1 ]  # 3p
then
seislogfile=../../$code/RESULT/1/seism_cohcca.log
igid=`echo $fileid | sed 's/spac_R/ /' | sed 's/3p/ /' | awk '{printf "%s",$1}'`
cohfiles=`cat $seislogfile | awk 'BEGIN{igid="'"$igid"'"}{if($1==igid){print $7}}'`
elif [ $id_category -eq 2 ] # 2p
then
seislogfile=../../$code/RESULT/1/seism_cohcca.log
igid=`echo $fileid | sed 's/spac_R/ /' | sed 's/2p/ /' | awk '{printf "%s",$1}'`
cohfiles=`cat $seislogfile | awk 'BEGIN{igid="'"$igid"'"}{if($1==igid){print $7}}'`
elif [ $id_category -eq 3 ] # pAPX_n
then
seislogfile=../../$code/RESULT/1/seism_spacapx_combi.log
igid=`echo $fileid | sed 's/CL/ /' | awk '{printf "%d",$2}'`
cohfiles1=`cat $seislogfile | awk 'BEGIN{igid=1.*"'"$igid"'"}{
if($14==igid){print $9}}'`
cohfiles2=`cat $seislogfile | awk 'BEGIN{igid=1.*"'"$igid"'"}{
if($14==igid){print $10}}'`
cohfiles="$cohfiles1 $cohfiles2"
elif [ $id_category -eq 0 ] # 1p
then
seislogfile=../../$code/RESULT/1/seism_cohcca.log
igid=`echo $fileid | sed 's/spac/ /' | awk '{printf "%s",$1}'`
cohfiles=`cat $seislogfile | awk 'BEGIN{igid="'"$igid"'"}{if($9==igid){print $7}}'`
fi # if   [ $id_category -eq 1 ]

IDS=""
for cohfile in $cohfiles
do
IDS="$IDS `echo $cohfile | sed 's/CMPLXcoh/ /' | sed 's/u.d/ /'| awk '{print $2}' | tr '_' ' '`"
done
seisnos=`echo $IDS | tr ' ' '\n' | sort -n | uniq`
psdfiles=""
for seisno in $seisnos
do
psdfile=../../$code/RESULT/ave/SD"$seisno"u_SD"$seisno"u.d
psdfiles="$psdfiles $psdfile"
done

if test "`echo $psdfiles | awk '{print $1}'`" == ""
then
psdfiles="NOFILE"
fi
#--------
# extract psdfiles constituting the SPAC coefficients
# end
#--------

cat $readfile | grep $code | grep $fileid | awk 'BEGIN{r=1.*"'"$r"'"}{
if($3==1){print $1,0," # ",$0}}'  > $tmpfile_zero1
cat $readfile | grep $code | grep $fileid | awk 'BEGIN{r=1.*"'"$r"'"}{
if($3!=1){print $1,0," # ",$0}}'  > $tmpfile_zero2

code_c=`echo $code | tr '_' '-'`
fileid_c=`echo $fileid | tr '_' '-'`

#------------
# plot SPAC coeficient start
#------------
if test "$MAX_FREQ" != ""
then
fmax=$MAX_FREQ
else
fmax=100
fi
if test "$MIN_FREQ" != ""
then
fmin=$MIN_FREQ
else
fmin=0.1
fi

if test "$ax1log" == "1"
then
id_ax1log=1
else
id_ax1log=0
fi

if test "$id_png" == "1"
then
echo $plotdatadir $ilist | awk '{
printf "set output \"%s/spac%03d.png\"\n",$1,$2}' >> $gnpltfile 
fi

cat <<EOF>> $gnpltfile 
set multiplot
set key right top
set origin 0.0,0.0
set size 0.9,0.6
set bmargin 3
set tmargin 0
set border 1
set noytics

unset title
unset logscale y
unset format x
set xrange [$fmin:$fmax]
EOF

if [ $id_ax1log -eq 1 ]
then
cat <<EOF>> $gnpltfile 
set logscale x
EOF
fi

cat <<EOF>> $gnpltfile 
set yrange [-0.6:1]
set xlabel "Frequencfy [Hz]"
set ylabel "SPACcoef[-0.6:1.0]"
set title "$code_c[$fileid_c] r $r"
plot 0 ti "", "../../../../../$file0" w l lw 3 ti "","$tmpfile_zero1" w p ps 2 lw 2 ti "1st zero","$tmpfile_zero2" w p ps 2 lw 2 ti "later zero"

EOF
#------------
# plot SPAC coeficient end
#------------

#------------
# plot psdfile start
#------------
cat <<EOF >> $gnpltfile 
set origin 0.0,0.6
set size 0.9,0.30
set bmargin 0
set tmargin 0
set format x ""
set xlabel ""

set title "$code_c[$fileid_c] r=$r[km]"
set ylabel "PSD"
unset yrange
set logscale y

plot END_OF_LINE
EOF
for psdfile in $psdfiles
do
if test "$psdfile" == "NOFILE"
then
cat <<EOF >> $gnpltfile 
1 ti "",END_OF_LINE
EOF
else
cat <<EOF >> $gnpltfile 
"$psdfile" w l ti "",END_OF_LINE
EOF
fi
done # for psdfile in $psdfiles
cat <<EOF >> $gnpltfile 
"./dummy.d" ti ""
set nomultiplot
EOF

if test "$id_png" == "1"
then
cat <<EOF >> $gnpltfile 
#pause -1
EOF
else
cat <<EOF >> $gnpltfile 
pause -1
EOF
fi

#------------
# plot psdfile end
#------------

let ilist=ilist+1
done # while [ $ilist -le $nlist ]

rm -f $tmplistfile

cat $gnpltfile  | sed 's/END_OF_LINE/\\/' > $gnpltfile.temporal
mv -f $gnpltfile.temporal $gnpltfile

$GNUPLOT $gnpltfile 

rm -f ./dummy.d
