#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

htmlfile=index.html

#############################################################################
# Don't touch from here
#############################################################################
if [ -f $htmlfile ]
then
rm -f $htmlfile 
fi
touch -f $htmlfile 

cat <<EOF>> $htmlfile
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=euc-jp">
<META NAME="ROBOTS" CONTENT="NOINDEX, NOFOLLOW">
<title>BIDO</title>
</head>

<body >
EOF

cat info.d | awk '{printf "%s<BR>\n",$0}' >> $htmlfile

cat <<EOF>> $htmlfile
<BR>
Results of phase velocity readings by PVREADER
<BR>
<img src=image.png />
<BR>
<BR>
<a href=vr.d>Download the phase-velocity readings</a>
<BR>
<a href=spaczeros.d>Download the SPAC zero-crossing data</a>
<BR>
<BR>
EOF

ls png/*.png >& /dev/null
if test "$?" == "0"
then
cat <<EOF>> $htmlfile
<BR>
<BR>
Radings of SPAC zero crossings for zero-crossing method
<BR>
<BR>
EOF
for pngfile in `ls png/*.png`
do
cat <<EOF>> $htmlfile
<img src=$pngfile /> 
EOF
done
fi # if test "$?" == "0"

cat <<EOF>> $htmlfile
</body>
</html>
EOF
