#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

########################################################################
# Don't touch from here
########################################################################
echo Program mkesac.sh
echo "<ESAC COH --> VEL>"

dirpath=$pointresultdirpath/$arrayname/array/$pointresultdir
workdir=$dirpath/../results_for_all_arrays/RESULT
outfile=$workdir/ave/vel_esac.d
outfile_spr=$workdir/ave/spr_esac.d
outfile_ncspac=$workdir/ave/vel_ncspac.d
outfile_ncspac_rad=$workdir/seism.log
outfile_rad=$workdir/1/seism_esac.log
inputfile=$workdir/1/infile.esac
freq_max=50.

cd $dirpath/..
CODES=`ls | grep -v $pointresultdir`
SPRSPACFILES=""
for code in $CODES
do
dir=../array/$code/$arrayresultdir/ave
if [ -d $dir ]
then
SPRSPACFILES="$SPRSPACFILES `find $dir -name 'spr_spac_R*1p_No*.d'`"
fi # if [ -d $dir ]
done # for code in $CODES
cd - >& /dev/null

if [ ! -d $workdir/1 ]
then
mkdir -p $workdir/1
mkdir -p $workdir/ave
fi

#echo $SPRSPACFILES
ifile=0
for file in $SPRSPACFILES
do
let ifile=ifile+1
done

if [ -f $inputfile ]
then
    rm -f $inputfile 
fi
touch -f $inputfile 
cat <<EOF >> $inputfile
$freq_max
999.
$ifile
EOF

for file in $SPRSPACFILES
do
dir_dummy=`dirname $dirpath/../$file`
seisfile_cohcca=$dir_dummy/../1/seism_cohcca.log
radiusid=`echo $file | sed 's/spr_spac/ /' | awk '{print $2}'| sed 's/\.d$//'`
radius=`cat $seisfile_cohcca | grep $radiusid | head -1 | awk '{print $2}'`
cat <<EOF >> $inputfile
$dirpath/../$file
$radius
EOF
done
echo $outfile         >> $inputfile
echo $outfile_ncspac  >> $inputfile

echo processing esac...
cat $inputfile | $bindir/sctr2pv_esac
cat $outfile  | awk '{print $1,$3,0,1}'                       > $outfile_spr
cat $outfile  | awk '{printf "%10.7f\n", $4}' | sort | uniq   > $outfile_rad
cat $outfile  | awk '{print $1,$2,0,1}' > $outfile.temporal
mv -f $outfile.temporal $outfile

echo 
echo processing ncspac...
cat $inputfile | $bindir/sctr2pv_ncspac
echo "The number of seismographs (total):         0"    > $outfile_ncspac_rad
cat $outfile_rad | awk '{printf "RADIUS:    %s\n",$1}' >> $outfile_ncspac_rad

echo 
echo "done [esac/ncspac]"

