#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

seismids=`cat list_sprspac.d | awk '{print $11}' | sort | uniq`

files="
spaczero_manual_1p.d   
spaczero_manual1st_1p.d
spaczero_manual_esac.d 
spaczero_manual.d
spaczero_manual1st.d
spaczero_manual_all.d"

for file in $files
do
newfiles=""
for seismid in $seismids
do
newfile=$file.$seismid
newfiles="$newfiles $newfile"
for f in $file.temporal $file.temporal2 $file.2 $newfile
do
if [ -f $f ]
then
rm -f $f
fi 
done # for f 
cat $file | awk 'BEGIN{seismid="'"$seismid"'"}{
if($7==seismid){print $0}}' > $file.temporal

if [ ! -d ../../../RESULT/PSD/$seismid ]
then
echo mkdir -p ../../../RESULT/PSD/$seismid 
mkdir -p ../../../RESULT/PSD/$seismid 
fi
cat <<EOF2 | $bindir/delete_psd_low  > $file.temporal2
$idpsdlevel
../../../RESULT/PSD/$seismid/psdlevel1.d
../../../RESULT/PSD/$seismid/psdlevel5.d
../../../RESULT/PSD/$seismid/psdlevel10.d
$file.temporal
EOF2

paste $file.temporal $file.temporal2 | awk '{
if($8==1){printf "%f %f %d %s %s %s %s \n",$1,$2,$3,$4,$5,$6,$7}}' > $newfile
rm -f $file.temporal $file.temporal2
done # for seismid 

cat $newfiles | sort -n | uniq > $file.2
rm -f $newfiles
mv -f $file.2 $file

done # for file in $files
