#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

if test "$1" == ""
then
    echo "usage mkRefModel_by_zero_manu.sh idlaterzero [RETURN]"
exit
fi
idlaterzero=$1
#idlaterzero=1
#idlaterzero=0

    
outfile=./spaczero_refmodel_manu.d
datafile_refmodel=./spaczero_manual_all.d 
idhokan=0
idsmth=0
fnod_smth=50

for f in $outfile $outfile.temporal
do
if [ -f $f ]
then
rm -f $f
fi
touch -f $f
done
echo OUTPUT: $outfile

#------------------------------------------------
# zeros from 3p arrays (or more) with double weight on the 1st zeros
#------------------------------------------------
cat $datafile_refmodel | grep -v 1p_No | grep -v 2p | grep -v esac | grep -v DUMMY | awk '{f=$1;c=$2;izero=$3;r=$6
if(izero==1){
izero_out=0.5}else{
izero_out=izero}
print f,c,izero_out}' | sort -n  >> $outfile.temporal
#------------------------------------------------

#------------------------------------------------
# zeros from 2p arrays 
#------------------------------------------------
cat $datafile_refmodel | grep -v 1p_No | grep 2p | grep -v esac | grep -v DUMMY | awk '{f=$1;c=$2;izero=$3;r=$6
print f,c,izero}' | sort -n  >> $outfile.temporal
#------------------------------------------------

#------------------------------------------------
# use zeros from two-point arrays if there is no data 
#------------------------------------------------
no_of_data=`wc -l $outfile.temporal | awk '{print $1}'`
if [ $no_of_data -eq 0 ]
then
cat $datafile_refmodel | grep 1p_No | grep -v esac | grep -v DUMMY | awk '{f=$1;c=$2;izero=$3;r=$6
print f,c,izero}' | sort -n  >> $outfile.temporal
fi # if [ $no_of_data -eq 0 ]
#------------------------------------------------

#-------------------
# unique with avraging (if needed) and interpolation 
#-------------------
echo "Averaging (Unique) ..."

if [ $idlaterzero -eq 1 ]
then
cat $outfile.temporal | sort -n | awk '{
print $1,$2,$3           }' |$bindir/vrdata_unique > $outfile
else
cat $outfile.temporal | sort -n | awk '{
if($3<=1){print $1,$2,$3}}' |$bindir/vrdata_unique > $outfile
fi

#-----------------------------------------------
# interpolation
#-----------------------------------------------
if [ $idhokan -eq 1 ]
then
echo Interpolation ...
\cp $outfile $outfile.temporal
rm -f $outfile
cat $outfile.temporal | awk 'BEGIN{
print "'"$interpolation_linscale_refmodel"'"
print "'"$ndata_hokan_refmodel"'"}{print $1,$2
}' |$bindir/vrdata_hokan > $outfile
rm -f $outfile.temporal
fi # if [ $idhokan -eq 1 ]
#--------------------------------------------

#-----------------------------------------------
# smoothing
#-----------------------------------------------
if [ $idsmth -eq 1 ]
then
    mv -f $outfile $outfile.temporal
    echo Smoothing ...
    fmin_smth=`cat $outfile.temporal|sort -nr|tail -1|awk '{print $1}'`
    fmax_smth=`cat $outfile.temporal|sort -n |tail -1|awk '{print $1}'`
    df_smth=`echo $fmin_smth $fmax_smth $fnod_smth | awk '{
             printf "%0.3f",($2-$1)/$3}'`
    cat $outfile.temporal | awk 'BEGIN{
printf "%s,%s\n","'"$fmin_smth"'","'"$fmax_smth"'"
printf "%s\n","'"$df_smth"'"
}{print $0}' | $bindir/smth > $outfile
    echo done 
    rm -f $outfile.temporal
fi # if [ $idsmth -eq 1 ]
