#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

idstep=$1

######################################################################
# Don't touch from here
#
# -----------------------------------
#  flow chart of the data processing (20201007)
# -----------------------------------
# -- From here --
#
# if there is no 3p-arrray data, id_zerocross_only=1
#   id_add_velfile_mini is set to 0
#   id_add_velfile_small is set to 0
#   id_add_velfile_small_high_zeros is set to 0
#
#if [ $id_add_velfile_mini -eq 1  ] <-- 1 by default
#then
#0) set miniarrayfile to ../../*/RESULT/ave/vel_spac_R104cm3p.d if exist.
#1) smoothing the data of miniarrayfile
#2) extract the data from a three-point irreugular array (actually, we select an array with the smallest radius amoung those between 15m and 102m)
#3) evaluate "rerror" the discrepancy between the zero-based phase velocity of the three-point irreugular array and the maximum phase velocity of the miniature array.
#4) Determine the upper limit od DC from miniature array with taking into account the "rerror"
#5) Extract the selected portion
#fi
#
#if [ $id_add_velfile_small -eq 1 ] <-- 0 by default
#then
#1) Determine a DC portion from a three-point irregular array
#*wavelength 3r-5r
#*frequency of 2-8Hz
#2) Extract the selected portion
#fi
#
#if [ $id_add_velfile_small_high_zeros -eq 1 ] <-- 1 by default
#then
#1) extract higher zeros from arrays with radii from 1.5m to 50m
#fi
#
#vrdata_unique
#vrdata_hokan
#
# -- To here --
#
######################################################################

no_of_data_3p="`wc -l spaczero_manual1st.d | awk '{print $1}'`"
id_zerocross_only=0
idhokan=0

if test "$idstep" == "1"
then

echo In mkRefModel.sh 1
if [ $no_of_data_3p -gt 0 ]
then
datafile_refmodel1="spaczero_manual1st.d" 
datafile_refmodel2="spaczero_manual.d" 
else
id_zerocross_only=1
#datafile_refmodel1="spaczero_manual1st_2p.d" 
datafile_refmodel1="spaczero_manual_2p.d" # later zeros included
datafile_refmodel2="spaczero_manual_2p.d" 
fi
outfile=$refmodelfile

elif test "$idstep" == "2"
then
    
echo In mkRefModel.sh 2
if [ $no_of_data_3p -gt 0 ]
then
datafile_refmodel1="spaczero_manual1st.d spaczero_manual1st.d.again"
datafile_refmodel2="spaczero_manual.d spaczero_manual.d.again"
else
id_zerocross_only=1
#datafile_refmodel1="spaczero_manual1st_2p.d spaczero_manual1st_2p.d.again"
datafile_refmodel1="spaczero_manual_2p.d spaczero_manual_2p.d.again" # later zeros included
datafile_refmodel2="spaczero_manual_2p.d spaczero_manual_2p.d.again"
fi

outfile=$refmodelfile.again

else

    echo Usage: mkRefModel.sh istep
    exit 1

fi

if [ $id_zerocross_only -eq 1 ]
then   
id_add_velfile_mini=0
id_add_velfile_small=0
id_add_velfile_small_high_zeros=0
fi

for f in $outfile $outfile.temporal
do
if [ -f $f ]
then
rm -f $f
fi
touch -f $f
done
echo OUTPUT: $outfile

#-------------------
# zero crossing only
#-------------------
if [ $id_zerocross_only -eq 1 ]
then   
#------------------------------------------------
# zeros from 3p arrays (or more) with double weight on the 1st zeros
#------------------------------------------------
cat $datafile_refmodel1 | grep -v 1p_No | grep -v 2p | grep -v esac | grep -v DUMMY | awk '{f=$1;c=$2;izero=$3;r=$6
if(izero==1){
izero_out=0.5}else{
izero_out=izero}
print f,c,izero_out}' | sort -n  >> $outfile.temporal

#------------------------------------------------
# zeros from 2p arrays 
#------------------------------------------------
cat $datafile_refmodel1 | grep -v 1p_No | grep 2p | grep -v esac | grep -v DUMMY | awk '{f=$1;c=$2;izero=$3;r=$6
print f,c,izero}' | sort -n  >> $outfile.temporal

#------------------------------------------------
# use zeros from two-point arrays if there is no data 
#------------------------------------------------
no_of_data=`wc -l $outfile.temporal | awk '{print $1}'`
if [ $no_of_data -eq 0 ]
then
cat $datafile_refmodel1 | grep 1p_No | grep -v esac | grep -v DUMMY | awk '{f=$1;c=$2;izero=$3;r=$6
print f,c,izero}' | sort -n  >> $outfile.temporal
fi # if [ $no_of_data -eq 0 ]
#------------------------------------------------
fi

#-------------------
# miniatrue array (r=104cm)
#-------------------
if [ $id_add_velfile_mini -eq 1  ]
then
ls -d ../../*/RESULT/ave/vel_spac_R104cm3p.d >& /dev/null
if test "$?" == "0"
then
miniarrayfile=`ls -d ../../*/RESULT/ave/vel_spac_R104cm3p.d |tail -1`
cat $miniarrayfile | grep -vi 'Inf'|grep -vi 'NAN'| grep -v 'NO_ROOT' > $miniarrayfile.lintmp
cat $miniarrayfile.lintmp | awk 'BEGIN{
print "-1.,-1."
print "'"$smoothing_refmodel"'"
}{print $0}' | $bindir/smth > $miniarrayfile.smth

# check the 1st zero of 3p-irregular array (to change the upper limit WL)
buf=`cat $datafile_refmodel1 | awk '{r=$6 
if(r>0.0015&&r<=0.1020){printf "%f %f %f\n",$1,$2,$6}
}' | sort -rn -k 3 | tail -1` 
if test "`echo $buf| awk '{print $1}'`" != ""
then
fsmall_spaczero1=`echo $buf | awk '{print $1}'`
csmall_spaczero1=`echo $buf | awk '{print $2}'`
rsmall_spaczero1=`echo $buf | awk '{print $3}'`
rerror=`cat $miniarrayfile.smth | awk 'BEGIN{
fsmall_spaczero1=1.*"'"$fsmall_spaczero1"'"
csmall_spaczero1=1.*"'"$csmall_spaczero1"'"
amin=1.e18
}{f=$1;c=$2
res2=(f-fsmall_spaczero1)^2
if(res2<=amin){amin=res2; fmin=f;cmin=c}
}END{
#print fmin,cmin
rerror=(cmin-csmall_spaczero1)/csmall_spaczero1
print rerror
}'`
else # if test "`echo $buf| awk '{print $1}'`" != ""
rerror="-999"
fi   # if test "`echo $buf| awk '{print $1}'`" != ""

#cat <<EOF
#fsmall_spaczero1: $fsmall_spaczero1
#csmall_spaczero1: $csmall_spaczero1
#rsmall_spaczero1: $rsmall_spaczero1 
#rerror: $rerror
#EOF

# determine the DC of miniature array
cat $miniarrayfile.smth | awk 'BEGIN{r=0.00104
rerror=1.*"'"$rerror"'"; izero="'"$izero_dc_refmodel"'"}{
f=$1;c=$2;wl=c/f;nwl=wl/r; idok=1

if     (              rerror<-0.5){rfaclim=7}
else if(-0.5<=rerror&&rerror<-0.2){rfaclim=10}
else if(-0.2<=rerror&&rerror<0.05){rfaclim=15}
else {rfaclim=30}

if(nwl<=3||nwl>=rfaclim){idok=0}
if(f<10){idok=0}
if(f>=40){idok=0} # <-(cut by 30 Hz when converted to refmodel for the paper)
if(idok==1){printf "%10.6f %10.6f %d\n", f,c,izero}
}' >> $outfile.temporal
rm -f $miniarrayfile.lintmp $miniarrayfile.smth
fi # if test "$?" == "0"
fi # if [ $id_add_velfile_mini -eq 1  ]

#-------------------
# DC from 3-point irregular array  (r=2-20m)
#-------------------
if [ $id_add_velfile_small -eq 1 ]
then
file=`cat $datafile_refmodel1 | awk '{r=$6
if(r>0.0015&&r<=0.020){printf "%f %s/RESULT/ave/vel_%s.d\n",$6,$4,$5}
}' | sort -rn | tail -1 | awk '{if($2!=""){print $2}else{print "NOFILE"}}'`
file_r=`cat $datafile_refmodel1 | awk '{r=$6
if(r>0.0015&&r<=0.020){printf "%f %s/RESULT/ave/vel_%s.d\n",$6,$4,$5}
}' | sort -rn | tail -1 | awk '{print $1}'`
if [ -f ../../$file ]
then
cat ../../$file | grep -vi 'Inf'|grep -vi 'NAN'| grep -v 'NO_ROOT' > ../../$file.lintmp
cat ../../$file.lintmp | awk 'BEGIN{
print "'"$smoothing_refmodel"'"
}{print $0}' | $bindir/smth > ../../$file.smth
cat ../../$file.smth |awk 'BEGIN{
r=1.*"'"$file_r"'";izero="'"$izero_dc"'"}{f=$1;c=$2;wl=c/f;nwl=wl/r
idok=1
if(nwl<=3||nwl>=5){idok=0}
if(f<2){idok=0}
if(f>=8){idok=0}
if(idok==1){printf "%10.6f %10.6f %d\n", f,c,izero}
}' >> $outfile.temporal
rm -f ../../$file.lintmp ../../$file.smth
fi # if [ -f ../../$file ]
fi # if [ $id_add_velfile_small -eq 1 ]

#-------------------
# DC from 3-point irregular array
#-------------------
if [ $id_add_velfile_small_high_zeros -eq 1 ]
then
cat $datafile_refmodel2 | awk '{
f=$1;c=$2;izero=$3;r=$6
if(r>0.0015&&r<=0.050){
if(izero>1){print $0}}
}' | sort -n  >> $outfile.temporal
fi

#-------------------
# unique with avraging (if needed) and interpolation 
#-------------------
cat $datafile_refmodel1 $outfile.temporal | sort -n | awk '{
print $1,$2,$3}' |$bindir/vrdata_unique  > $outfile
#
if [ $idhokan -eq 1 ]
then
\cp $outfile $outfile.temporal
rm -f $outfile
cat $outfile.temporal | awk 'BEGIN{
print "'"$interpolation_linscale_refmodel"'"
print "'"$ndata_hokan_refmodel"'"}{print $1,$2
}' |$bindir/vrdata_hokan  > $outfile
fi # if [ $idhokan -eq 1 ]

rm -f $outfile.temporal
#--------------------------------------------
