#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

echo In mkDoRefineSpac.sh

idfinalcheck=0
######################################################################
# Don't touch from here
######################################################################
if test "$1" != ""
then
clim1=$1
clim2=$2
else
clim1=$clim1_refmodel
clim2=$clim2_refmodel
fi

. ./mksmth.sh

#----------------------
# refine readings
#----------------------
nlines=`wc -l $file_sprread | awk '{print $1}'`
iline=1
while [ $iline -le $nlines ]
do
buf=`cat $file_sprread | head -$iline | tail -1`
cat <<EOF | $bindir/refinespaczero >> $file_sprread.tmp2
$frange_half4DoRefineSpac
$buf
$f_smth
EOF
iline=`echo $iline | awk '{print $1+1}'`
done

if [ $nlines -gt 0 ]
then
    
rm -f $file_sprread.tmp
paste $file_sprread.tmp2 $file_sprread | awk '{
print $1,$3,$4,$5,$6,$7}'| grep -v NaN > $file_sprread.tmp
mv -f $file_sprread.tmp $file_sprread

if [ $idfinalcheck -eq 1 ]
then
# final check of the "zero" condition     
cat $file_sprread | awk 'BEGIN{
print "'"$clim1"'"
print "'"$clim2"'"
print "'"$f_smth"'"}{print $1}'  | $bindir/check_spaczero | awk '{printf "%9.6f %9.6f %d %s %s %s %s\n",$1,0.,$2,"'"$radius"'","'"$label1"'","'"$label2"'","'"$seismid"'"}'  > $file_sprread.tmp
mv -f $file_sprread.tmp $file_sprread
fi # if [ $idfinalcheck -eq 1 ]

else
    echo No readings found: $file_sprread
    echo Nothing done.
fi

#rm -rf $smthdir  # <-- currently, delete the temporal directory 
rm -f $file_sprread.tmp2
