#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

echo In mkDoFullAutoReadSpac.sh

idfinalcheck=1
flim1=0.
flim2=10000.
######################################################################
# This program seraches a zero crossing point in the frequency range between flim1 and flim2
# * The parameters clim1 and clim2 (positive values) represent the minimum amplitude for the 1st zero and later zeroms.
# * The 1st zero crossing point with phase vcelocity less than 50 m/s will be ignored by the program get_spaczero.F 
# * The later zero crossing points searched with setting clim2 less than 0.03 will be ignored by the program checkspaczero.F 
# * If clim2 is negative, the program will search the "1st zero-crossing" point where the curve does not actually cross zero but close to zero (< |clim|). 
#
# Don't touch from here
######################################################################
if test "$1" != ""
then
if test "$3" != ""  # limitation to the frequency range
then
clim1=$1
clim2=$2
flim1=$3
flim2=$4
else  # if test "$3" != ""   # constraint on the SPAC range
clim1=$1
clim2=$2
fi    # if test "$3" != ""
else                         # constraint on the SPAC range
clim1=$clim1_refmodel
clim2=$clim2_refmodel
fi

. ./mksmth.sh

id_really_zerocross=`echo $clim2 | awk '{if($1>0){print 1}else{print 0}}'`

if [ $id_really_zerocross -eq 1 ]
then
    
# step1 extract zeros up to izeromax_refmodel
cat <<EOF | $bindir/get_spaczero | awk 'BEGIN{izeromax_refmodel=1.*"'"$izeromax_refmodel"'"}{if($2<=izeromax_refmodel){printf "%9.6f %9.6f %d %s %s %s %s\n",$1,0.,$2,"'"$radius"'","'"$label1"'","'"$label2"'","'"$seismid"'"}}' > $file_sprread.tmp2
$radius
$f_smth
$flim1
$flim2
EOF

mv -f $file_sprread.tmp2 $file_sprread

# step2 remove zeros not appropriate
if [ $idfinalcheck -eq 1 ]
then
# final check of the "zero" condition     
cat $file_sprread | awk 'BEGIN{
print "'"$clim1"'"
print "'"$clim2"'"
print "'"$f_smth"'"}{print $1}'  | $bindir/check_spaczero | awk '{printf "%9.6f %9.6f %d %s %s %s %s\n",$1,0.,$2,"'"$radius"'","'"$label1"'","'"$label2"'","'"$seismid"'"}'  > $file_sprread.tmp2
mv -f $file_sprread.tmp2 $file_sprread
#echo OUTPUT: $file_sprread
fi # if [ $idfinalcheck -eq 1 ]

#rm -rf $smthdir  # <-- currently, delete the temporal directory 
rm -f  $file_sprread.tmp 

elif [ $id_really_zerocross -eq 0 ]
then

cat <<EOF | $bindir/get_spaczero_positive | awk '{
if($1>0){printf "%9.6f %9.6f %d %s %s %s %s\n",$1,0.,1,"'"$radius"'","'"$label1"'","'"$label2"'","'"$seismid"'"}}' > $file_sprread.tmp2
$radius
$f_smth
$clim2
$flim1
$flim2
EOF

mv -f $file_sprread.tmp2 $file_sprread
#echo OUTPUT: $file_sprread

else

echo ERROR in id_really_zerocross:  $id_really_zerocross  
echo STOP
exit

fi   # if [ $id_really_zerocross -eq 1 ]







    

