#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

radius=$1

radius=`echo $radius | awk '{printf "%0.2f",$1*1000}'`

f1_detectFRange=`cat work/picked_sprspac00*.d |grep -v 1p_No | grep -v DUMMY | grep -v esac | awk 'BEGIN{radius=1.*"'"$radius"'"}{f=$1;r=$4*1000;nzero=$3;if(radius>r&&nzero==1){printf "%0.2f %0.2f %s\n",r,f,$6}}' | sort -n -k 1 | awk 'BEGIN{radius=1.*"'"$radius"'";fsum=0;wsum=0;n=0}{r=$1;f=$2;w=r/radius;fsum=fsum+f*w; wsum=wsum+w;n=n+1}END{if(n>0){fave=fsum/(wsum)}else{fave=1000}; print fave}'`

f2_detectFRange=`cat work/picked_sprspac00*.d |grep -v 1p_No | grep -v DUMMY | grep -v esac | awk 'BEGIN{radius=1.*"'"$radius"'"}{f=$1;r=$4*1000;nzero=$3;if(radius<r&&nzero==1){printf "%0.2f %0.2f %s\n",r,f,$6}}' | sort -rn -k 1 | awk 'BEGIN{radius=1.*"'"$radius"'";fsum=0;wsum=0;n=0}{r=$1;f=$2;w=radius/r;fsum=fsum+f*w;wsum=wsum+w;n=n+1}END{if(n>0){fave=fsum/(wsum)}else{fave=0.001}; print fave}'`

echo OUTPUT: ./DetectFRange.d
if [ -f ./DetectFRange.d ]
then
rm -f  ./DetectFRange.d
fi

echo $f1_detectFRange $f2_detectFRange | awk '{printf "%s\n%s\n",$1,$2}' | sort -n | awk '{printf "%s ",$1}END{printf "\n"}' > ./DetectFRange.d
