#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

NMDIR=$scriptdir
gnpltfile=mkCheckPSD.gnplt

if [ -f $gnpltfile ]
then
rm -f $gnpltfile
fi

if [ ! -f ./dummy.d ]
then
touch -f ./dummy.d
fi

files=`ls ../../../array/*/RESULT/ave/SD1u_SD1u.d`

#----------
# check JU: To here
#----------

cat <<EOF>$gnpltfile
#set term x11
set xlabel "Frequency [Hz]"
set ylabel "PSD[DataUnit**2*s]"
set format y "10^{%T}"
set format x "10^{%T}"
set logscale x
set logscale y
set xrange [0.1:]
set key outside right
set title "Pwer Spectral Density of UD component"
plot END_OF_LINE
EOF

for file in $files
do
ccode=`echo $file | tr '/' '\n' | head -5 | tail -1 | tr '_' '-'`
cat <<EOF>>$gnpltfile
"$file" w l ti "$ccode",END_OF_LINE
EOF
done

cat <<EOF>>$gnpltfile
"dummy.d" ti ""
pause -1
EOF

cat $gnpltfile | sed 's/END_OF_LINE/\\/' > $gnpltfile.temporaly
mv -f $gnpltfile.temporaly $gnpltfile

$GNUPLOT $gnpltfile
