#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

######################################################################
# Don't touch from here
######################################################################
. ./readpv.py_param.sh
if [ -f ./readsprspac.py_param_local.sh ]
then
. ./readsprspac.py_param_local.sh
fi

for itime in 1 2 3
do
    
if   [ $itime -eq 1 ]
then
clim1_itime=0.10
clim2_itime=0.025
elif [ $itime -eq 2 ]
then
clim1_itime=0.05
clim2_itime=0.0125
elif [ $itime -eq 3 ]
then
clim1_itime=0.10
clim2_itime=-0.10
else
echo ERROR in itime: $itime
echo STOP
exit
fi
    
iline=1
nlines=`wc -l ./list_sprspac.d | awk '{print $1}'`
while [ $iline -le $nlines ]
do
buf=`cat ./list_sprspac.d | head -$iline | tail -1`
sprspacfile=`echo $buf | awk '{print $2}'`
sprspacfile0=`basename $sprspacfile`
no=`echo $buf | awk '{print $1-1}'`
r=`echo $buf | awk '{print $10}'`
arrayname=`echo $buf | awk '{print $3}'`
fileid=`echo $buf | awk '{print $4}'`
fileid0=`basename $fileid`
seismid=`echo $buf | awk '{print $11}'`

#---------
# check array type start
#---------
echo $fileid |grep -v esac |grep -v DUMMY| grep spac_ | grep 2p >& /dev/null
id_2p="$?"
echo $fileid |grep -v esac |grep -v DUMMY| grep spac_ | grep 1p_No >& /dev/null
id_1p="$?"

if [ $id_1p -eq 0 -o  $id_2p -eq 0 ]
then
    id_1p_or_2p=1
else
    id_1p_or_2p=0
fi
#---------
# check array type end
#---------

idprocess_ok=0
if [ $id_1p_or_2p -eq 1 ] # apply the following reading process to either 1p or 2p array
then
idprocess_ok=1
fi
if [ $itime -eq 1 -o $itime -eq 2 ] # apply the following reading process when itime is 1 or 2
then
idprocess_ok=1
fi

if [ $idprocess_ok -eq 1 ]
then
if [ -f work/picked_$sprspacfile0 ]
then
no_of_data=`wc -l work/picked_$sprspacfile0 | awk '{print $1}'`
if [ $no_of_data -eq 0 ]
then

echo fileid: $fileid
echo work/picked_$sprspacfile0
. ./mkDetectFRange.sh $r
fmin_search="`cat DetectFRange.d | awk '{print $1}'`"
fmax_search="`cat DetectFRange.d | awk '{print $2}'`"

if [ -f ./DoRefineSpac.d ]
then
rm -f ./DoRefineSpac.d 
fi

cat <<EOF2 > ./DoRefineSpac.d 
work/picked_$sprspacfile0
$no
$r
$arrayname
$fileid0
$seismid
EOF2

echo . ./mkDoFullAutoReadSpac.sh $clim1_itime $clim2_itime $fmin_search $fmax_search 
. ./mkDoFullAutoReadSpac.sh $clim1_itime $clim2_itime $fmin_search $fmax_search 

no_of_data_added=`wc -l work/picked_$sprspacfile0 | awk '{print $1}'`
echo no_of_data_added: $no_of_data_added
if [ $no_of_data_added -gt 0 ]
then
echo . ./mkzeropv.sh 
. ./mkzeropv.sh 
fi # if [ $no_of_data_added -gt 0 ]

fi # if [ $no_of_data -eq 0 ]
fi # if [ -f work/picked_$sprspacfile0 ]
fi # if [ $idprocess_ok -eq 1 ]

iline=`echo $iline |  awk '{print $1+1}'`
done # while [ $iline -le $nlines ]

done # for itime in 1 2 
