#!/bin/bash
#----------------------------------------
# Python script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.
#----------------------------------------

######################################################################
# Don't touch from here
######################################################################
. ./readpv.py_param.sh
if [ -f ./readsprspac.py_param_local.sh ]
then
. ./readsprspac.py_param_local.sh
fi

for wdir in $smthdir $work_again 
do
if [ -d $wdir ]
then
rm -rf $wdir
fi 
echo mkdir -p $wdir
mkdir -p $wdir
done

iline=1
nlines=`wc -l ./list_sprspac.d | awk '{print $1}'`
while [ $iline -le $nlines ]
do
buf=`cat ./list_sprspac.d | head -$iline | tail -1`
sprspacfile=`echo $buf | awk '{print $2}'`
sprspacfile0=`basename $sprspacfile`
no=`echo $buf | awk '{print $1-1}'`
r=`echo $buf | awk '{print $10}'`
arrayname=`echo $buf | awk '{print $3}'`
fileid=`echo $buf | awk '{print $4}'`
fileid0=`basename $fileid`
seismid=`echo $buf | awk '{print $11}'`

if [ -f ./DoRefineSpac.d ]
then
rm -f ./DoRefineSpac.d 
fi

if [ -f work/picked_$sprspacfile0 ]
then
cat <<EOF2 > ./DoRefineSpac.d 
work/picked_$sprspacfile0
$no
$r
$arrayname
$fileid0
$seismid
EOF2
. ./mkDoFullAutoReadSpac.sh 0.35 0.10

if [ $id_do_again -eq 1 ]
then
if [ `wc -l $file_sprread | awk '{print $1}'` -eq 0 ]
then
cp $file_sprread $work_again

rm -f ./DoRefineSpac.d 
cat <<EOF2 > ./DoRefineSpac.d 
$work_again/picked_$sprspacfile0
$no
$r
$arrayname
$fileid0
$seismid
EOF2
. ./mkDoFullAutoReadSpac.sh 0.20 0.05
fi # if [ `wc -l $file_sprread | awk '{print $1}'` -eq 0 ]
fi # if [ $id_do_again -eq 1 ]

fi # [ -f work/picked_$sprspacfile0 ]

iline=`echo $iline |  awk '{print $1+1}'`
done 

. ./mkzeropv.sh

. ./mkcheckpsdlevel.sh

. ./mkRefModel.sh 1

ls $work_again/picked_sprspac????.d >& /dev/null
if test "$?" != "0"
then
    id_do_again=0
    rmdir $work_again
fi

if [ $id_do_again -eq 1 ]
then
. ./mkzeropv_again.sh
. ./mkRefModel.sh 2

# creating joint data
files="
spaczero_manual.d
spaczero_manual1st.d
spaczero_manual1st_1p.d
spaczero_manual_1p.d
spaczero_manual_all.d
spaczero_manual_esac.d"
for file in $files
do
if [ -f $file.temporal ]
then
    rm -f $file.temporal
fi
touch -f $file.temporal
#cat $file | awk '{printf "%s extracted_1st \n",$0}' >> $file.temporal
#cat $file.again | awk '{printf "%s extracted_2nd \n",$0}' >> $file.temporal
cat $file | awk '{printf "%s \n",$0}' >> $file.temporal
cat $file.again | awk '{printf "%s \n",$0}' >> $file.temporal
rm -f $file
sort -n $file.temporal > $file
rm -f $file.temporal $file.again
done
mv -f spaczero_refmodel.d.again spaczero_refmodel.d
ls $work_again/picked_sprspac*.d >& /dev/null
if test "$?" == "0"
then
mv -f $work_again/picked_sprspac*.d work/
fi
rmdir $work_again
fi # if [ $id_do_again -eq 1 ]

#-----------------------------------------
# Do reading with a limittedfrequnecy range
# when more than 2p array is used 
cat spaczero_manual_all.d | grep -v esac | grep -v DUMMY | grep spac_ |  grep -v 1p_No >& /dev/null
if test "$?" == "0"
then
echo Execute ./mkAutoReadinLimitFrange.sh ...
./mkAutoReadinLimitFrange.sh
else
cat <<EOF

NOTE: Program ./mkAutoReadinLimitFrange.sh is not executed because tthere is no 2p nor 3p array data. (This program is not used for 1p arrays.)

EOF
fi
#-----------------------------------------

#-------
# creating an pick files
echo OUTPUT picked_auto.d
echo OUTPUT picked_auto.d.all

if [ -f picked_auto.d ]
then
rm -f picked_auto.d
fi
cat spaczero_refmodel.d | awk '{printf "%s %s %s %s \n",$1,$2,1,1}' > picked_auto.d
\cp picked_auto.d picked_auto.d.all

#----------------------------------
idwrite_pickedfile=0
#idwrite_pickedfile=1  # <-- temporaly set effective for test (20201007)
#----------------------------------

if [ ! -f picked.d ]
then
idwrite_pickedfile=1
elif [ `wc -l picked.d | awk '{print $1}'` -eq 0 ]
then
idwrite_pickedfile=1
rm -f picked.d
fi
if [ $idwrite_pickedfile -eq 1 ]
then
echo OUTPUT picked.d
cat picked_auto.d | awk '{printf "%f %f %d \n",$1,$2,0}' > picked.d

\cp picked.d picked_refine.d 
currentdir=`pwd`
cd ../../../../..
echo . $currentdir/mkcalerr.sh
. $currentdir/mkcalerr.sh
cd $currentdir >& /dev/null
fi
#-------

rm -rf $smthdir 
mkdir  $smthdir 
