#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

#-------------------------------------------------
echo Now analysis reults will be saved to $output_workdir
echo Now analysis reults will be saved to $output_workdir >> $WORKDIR_ALL/Analysis_Point.log

if [ ! -d $output_workdir ]
then
echo SaveDir Created: $output_workdir  
echo SaveDir Created: $output_workdir  >> $WORKDIR_ALL/Analysis_Point.log
mkdir -p $output_workdir 
fi
#-------------------------------------------------

yn="y"
if test "$yn" == "y" -o "$yn" == "Y"
then
    
    fbase=info.d
    if [ -f $output_workdir/$fbase ]
    then
	rm -f $output_workdir/$fbase 
    fi
    touch -f $output_workdir/$fbase 
    idir=1
    for f in $arraydirpath
    do
#	echo DataDir[$idir] $f >> $output_workdir/$fbase 
	echo DataDir[$idir] `basename $f` >> $output_workdir/$fbase 
	let idir=idir+1
    done
    echo SaveDir `basename $output_workdir` >> $output_workdir/$fbase 
    echo Output $fbase 
    
    fbase=vr.d
    cp $WORKDIR_ALL/result_point/dummysite/array/RESULT/vr.d $output_workdir/$fbase
    echo Output $fbase 
    
    fbase=image.png
    cp $WORKDIR_ALL/result_point/dummysite/array/RESULT/rpv/image.png $output_workdir/$fbase
    echo Output $fbase 
    
    fbase=spaczeros.d
    if [ -f $output_workdir/$fbase ]
    then
	rm -f $output_workdir/$fbase 
    fi
    cat $WORKDIR_ALL/result_point/dummysite/array/RESULT/rpv/spaczero_manual_all.d | grep -v results_for_all_arrays | awk 'BEGIN{printf "F[Hz] PV[km/s] ZeroNo Directory FileID Radius[km]\n"}{if($5!="esac"){printf "%s %s %s %s %s %s\n",$1,$2,$3,$4,$5,$6}}' > $output_workdir/$fbase
#    cat $WORKDIR_ALL/result_point/dummysite/array/RESULT/rpv/spaczero_manual_2p.d | grep -v results_for_all_arrays | awk 'BEGIN{printf "F[Hz] PV[km/s] ZeroNo Directory FileID Radius[km]\n"}{if($5!="esac"){printf "%s %s %s %s %s %s\n",$1,$2,$3,$4,$5,$6}}' > $output_workdir/$fbase
    
    echo Output $fbase 
    plotdatdir=$WORKDIR_ALL/result_point/dummysite/array/RESULT/rpv/plotdat 
    if [ -d $plotdatdir ]
    then
	if [ -d $output_workdir/png ]
	then
	    rm -rf $output_workdir/png
	fi
	ls $plotdatdir/*.png >& /dev/null
	if test "$?" == "0"
	then
	    echo Output pngfiles of SPAC coefficients ....
	    mkdir -p $output_workdir/png
	    files="`ls $plotdatdir/*.png`"
	    for file in $files
	    do
		cp $file $output_workdir/png
	    done
	fi
    fi

    cd $output_workdir
    . $scriptdir/mkhtml.sh
    cd -
    
else
    
    echo Note: old files not overwritten.  
    echo Note: old files not overwritten.  >> $WORKDIR_ALL/Analysis_Point.log
    
fi

idir=`echo $arraydirpath | awk '{print $1}'`
if [ -f $WORKDIR_ALL/.pvreader ]
then
    rm -f $WORKDIR_ALL/.pvreader
fi
cat <<EOF> $WORKDIR_ALL/.pvreader
export INPUT_DATADIR=$idir
export OUTPUT_DATADIR=$output_workdir 
EOF

\cp $WORKDIR_ALL/result_point/dummysite/array/RESULT/rpv/readpv.py_param.sh $WORKDIR_ALL/.readpv
\cp $WORKDIR_ALL/result_point/dummysite/array/RESULT/rpv/readpv.py_param_local.sh $WORKDIR_ALL/.readpv_local

#------------------------------------------------
echo deleting temporal files...
echo deleting temporal files...  >> $WORKDIR_ALL/Analysis_Point.log
rm -rf $WORKDIR_ALL/result_point
#------------------------------------------------

cat <<EOF

done.

EOF
