#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

arrayname=$ARRAYNAMES
   
#############################################################################
# Don't touch from here
#############################################################################
if [ -d $pointresultdirpath ]
then
rm -rf $pointresultdirpath 
fi
mkdir -p $pointresultdirpath 

for arraydirpath0 in $arraydirpath
do

code=`echo $arraydirpath0 | tr '/' '\n' | tail -1`

if [ -f $arraydirpath0/RESULT/seism.log ]
then
    
cat <<EOF
    Datadir and File found: $arraydirpath0/RESULT/seism.log 
EOF
    
else

cat <<EOF>> Analysis_Point.log

ERROR: Datadir/File not found in the data diretory you entered: $arraydirpath0. File "RESULT/seism.log" should exist in the "DataDir" as the directory involving analysis results by BIDO?
STOP

EOF
exit 1
fi

#-------------------
# Create directories
#-------------------
DIRS="
$pointresultdirpath/$arrayname/array/$pointresultdir
$pointresultdirpath/$arrayname/array/$code/$othersdir"
for dir in $DIRS
do
if [ ! -d $dir ]
then
mkdir -p $dir
fi
done # for dir in $DIRS

#-------------------
# Copy Analysis Results
#-------------------
dir0=`pwd`
dir1=$arraydirpath0
dir2=`pwd`/$pointresultdirpath/$arrayname/array/$code

if [ -d $dir1/$arrayresultdir ]
then
if [ -f $dir1/$arrayresultdir/1/seism_cohcca.log ]
then
cd $dir1; tar cf - $arrayresultdir/1/seism_cohcca.log | (cd $dir2; tar xf - ); cd $dir0
fi
if [ -f $dir1/$arrayresultdir/1/seism_spacapx.log ]
then
cd $dir1; tar cf - $arrayresultdir/1/seism_spacapx.log | (cd $dir2; tar xf - ); cd $dir0
fi
if [ -f $dir1/$arrayresultdir/1/seism_spacapx_combi.log ]
then
cd $dir1; tar cf - $arrayresultdir/1/seism_spacapx_combi.log | (cd $dir2; tar xf - ); cd $dir0
fi
if [ -f $dir1/$arrayresultdir/1/seism_esac.log ]
then
cd $dir1; tar cf - $arrayresultdir/1/seism_esac.log | (cd $dir2; tar xf - ); cd $dir0
fi

if [ -f $dir1/$arrayresultdir/1/logfile.estspec_psd.d ]
then
cd $dir1; tar cf - $arrayresultdir/1/logfile.estspec_psd.d | (cd $dir2; tar xf - ); cd $dir0
fi

for file in param.sh seism.d RESULT/array.png
do
if [ -f $dir1/$file ]
then
cd $dir1; tar cf - $file | (cd $dir2/$othersdir; tar xf - ); cd $dir0
fi
done

cd $dir1; tar cf - $arrayresultdir/ave       | (cd $dir2; tar xf - ); cd $dir0

if [ ! -f $dir2/$arrayresultdir/ave/spr_esac.d ]
then
if [ -f $dir2/$arrayresultdir/ave/vel_esac.d ]
then
cat $dir2/$arrayresultdir/ave/vel_esac.d | awk '{print $1,$3}' > $dir2/$arrayresultdir/ave/spr_esac.d 
fi
fi

cd $dir1; tar cf - $arrayresultdir/seism.log | (cd $dir2; tar xf - ); cd $dir0

else # if [ -d $dir1 ]

echo WARNING: Analysis reults not found: $dir1/$arrayresultdir  
echo PASS.

fi   # if [ -d $dir1 ]

#----------
# get radius
#----------
file=$dir1/$arrayresultdir/seism.log 

if [ -f $file ]
then
grep ERROR: $file >& /dev/null
if test "$?" == "0"    
then
idradius_ok=0
else
idradius_ok=1
radii=`grep RADIUS $file | awk '{print $2}'`
fi
else  # if [ -f $file ]
idradius_ok=0
fi    # if [ -f $file ]

file=$dir1/$arrayresultdir/1/seism_spacapx.log 
if [ -f $file -a $idradius_ok -eq 0 ]
then
grep radius_ave $file >& /dev/null
if test "$?" == "0"    
then
idradius_ok=1
radii=`cat $file | grep radius_ave | awk '{print $2}'`
fi
fi # if [ -f $file -a $idradius_ok -eq 0 ]

file=$dir1/$arrayresultdir/1/seism_spacapx_combi.log
if [ -f $file ]
then
if [ `wc -l $file | awk '{print $1}'` -gt 0 -a $idradius_ok -eq 0 ]
then
idradius_ok=1

ls $dir1/$arrayresultdir/ave/vel_spac_R*3pAPX*.d >& /dev/null
if [ "$?" -eq 0 ]    
then
radii=`ls $dir1/$arrayresultdir/ave/vel_spac_R*3pAPX*.d | sed 's/vel_spac_R/ /'| sed 's/3p/ /' | awk '{rc=$2
n=match(rc,/cm/); if(n>0){unit="cm";fac=100000}else{unit="m";fac=1000}
match(rc,/[0-9]+/)
r=substr(rc,RSTART,RLENGTH)
print r/fac}'`
else # if [ "$?" -eq 0 ]    
radii=`ls $dir1/$arrayresultdir/ave/vel_spac_R*2pAPX*.d | sed 's/vel_spac_R/ /'| sed 's/2p/ /' | awk '{rc=$2
n=match(rc,/cm/); if(n>0){unit="cm";fac=100000}else{unit="m";fac=1000}
match(rc,/[0-9]+/)
r=substr(rc,RSTART,RLENGTH)
print r/fac}'`
fi # if [ "$?" -eq 0 ]    
fi # if [ `wc -l $file | awk '{print $1}'` -gt 0 -a $idradius_ok -eq 0 ]
fi # if [ -f $file ]

if [ $idradius_ok -eq 0 ]
then
radii=999
fi # if [ $idradius_ok -eq 0 ]

#-------------------
# Create Locationfile
#-------------------
no_radius=1
for radius in $radii
do
#echo OUTPUT $pointresultdirpath/$arrayname/array/$code/$othersdir/$locationfile.$no_radius
echo 999,999,999,$radius | sed 's/ //g' > $pointresultdirpath/$arrayname/array/$code/$othersdir/$locationfile.$no_radius
let no_radius=no_radius+1
done # for radius in $radii

#-------------------
# Create an Average Locationfile 
#-------------------
outfile=$pointresultdirpath/$arrayname/$othersdir/$locationfile
outfile_radius=$pointresultdirpath/$arrayname/$othersdir/$radiusfile

DIRS="
$pointresultdirpath/$arrayname/$othersdir
$pointresultdirpath/$arrayname/$pointresultdir"

for dir in $DIRS
do
if [ ! -d $dir ]
then
echo mkdir -p $dir
mkdir -p $dir
fi
done

for file in $outfile $outfile_radius $outfile_radius.tmp
do
if [ -f $file ]
then
rm -f $file
fi
touch -f $file
done # for file in $outfile

locationfiles=`ls $pointresultdirpath/$arrayname/array/*/$othersdir/location.d*`
for f in $locationfiles
do
lat=999.
lon=999.
radius=`cat $f | awk 'BEGIN{FS=","}{if($4==""){print 0}else{print $4}}'`
echo $lat $lon $radius $f >> $outfile_radius
done # for loc in `cat $locationfiles`

cat $outfile_radius | sort -k 3 -n >> $outfile_radius.tmp

mv -f $outfile_radius.tmp $outfile_radius
echo OUTPUT $outfile_radius

done # for arraydirpath0 in $arraydirpath
