#!/bin/bash

# clear files
id_a_clean=1 # remove temporal ascifiles for parameter setting
id_b_clean=1 # remove binary executables

# compile sources
idfortran=1

######################################################################
# Don' t touch from here
######################################################################
idpython=0 # set to 1 if you want to create pyton binaries by pyinstaller

cdir=`pwd`

if [ $id_a_clean -eq 1  ]
then
cd ./bin/WORK
if [ -d ./result_point ]
then
rm -rf  ./result_point ]
fi
files="
.pvreader
.readpv
.readpv_local
Analysis_Point.log"
for f in $files
do
if [ -f $f ]
then
rm -rf $f
fi
done
cd $cdir
fi #  
			
if [ $id_b_clean -eq 1  ]
then
cd src
make distclean bindir=../bin
cd ../bin
rm -f pvreader readpv readsprspac
cd WORK/ANALYSIS_POINT/src
make distclean bindir=../bin
cd $cdir
fi

if [ $idfortran -eq 1  ]
then
cd src
./Install.sh
if test "$?" != "0"
then
exit 
fi
cd ../bin/WORK/ANALYSIS_POINT/src/
./Install.sh
if test "$?" != "0"
then
cat <<EOF    

ERROR in compiling fortran program in bin/WORK/ANALYSIS_POINT/src/
      Please check the manual again.
STOP

EOF
exit 
else
cat <<EOF

Compiling fortran program successfully finished.

EOF
fi
cd $cdir
fi # if [ $idfortran -eq 1  ]

if [ $idpython -eq 1  ]
then
cd ./bin/WORK/ANALYSIS_POINT/script

pyinstaller pvreader.py     --onefile 
pyinstaller readpv.py       --onefile 
pyinstaller readsprspac.py  --onefile

mv -f  ./dist/pvreader ../../../pvreader 
mv -f  ./dist/readpv ../../../readpv 
mv -f  ./dist/readsprspac ../../../readsprspac

rm -rf ./dist ./build pvreader.spec readpv.spec readsprspac.spec

cd $cdir
fi # if [ $idpython -eq 1  ]

if [ -f ./Install3.2.log ]
then
rm -f ./Install3.2.log
fi

cat <<EOF>./Install3.2.log
date: `LANG=english date`
`uname -a`

id_a_clean $id_a_clean
id_b_clean $id_b_clean
idfortran $idfortran
idpython $idpython
EOF
