# -*- coding: utf-8 -*-
# coding: utf-8
import numpy as np
import scipy as sc
import scipy.signal as ss

from DiET import Params_DiET

def Make_Spec(Waveform):
    """ 
    Make spectrogram images

    Parameter:
    ----------
    Waveform: Waveform data after removing instrumental response

    Returns:
    ----------
    Spec_scale: Spectrogram image
    t_sample, f_sample: intervals in time and frequency domains
    """

    ###### scipy.signal.stft #####
    f_sample, t_sample, Spec_original = ss.stft(Waveform, fs = Params_DiET.sampling_freq, window=('tukey', 0.25), nperseg=Params_DiET.sampling_freq*Params_DiET.Tsub, noverlap=Params_DiET.overlap*Params_DiET.sampling_freq*Params_DiET.Tsub, nfft=None, detrend='constant', return_onesided=True, boundary=None, padded=None)

    freq_arg_min = np.where(f_sample==Params_DiET.fil1)[0][0]
    freq_arg_max = np.where(f_sample==Params_DiET.fil2)[0][0]
    Spec_power = abs(Spec_original)**2

    ##### Min-Max normalization #####
    Spec_scale=np.log10(abs(Spec_power[freq_arg_min:freq_arg_max+1, :]) / np.min(abs(Spec_power[freq_arg_min:freq_arg_max+1, :])))
    Spec_scale=Spec_scale/np.max(Spec_scale)

    f_sample = f_sample[freq_arg_min : freq_arg_max+1]

    return Spec_scale, t_sample, f_sample
