# -*- coding: utf-8 -*-
# coding: utf-8
import numpy as np
import pandas as pd
import pyproj
import time
import sys
sys.path.append("../../Methods")
from GrASP import Params_GrASP, kNN_graph, Make_Stadis_array, Apply_Tremor

##### Station location #####
Station_loc = pd.read_csv('../../Data/Station_info.csv')
Station_loc_data = Station_loc.values
##### Converted to XY coordinates #####
transformer = pyproj.Transformer.from_crs(Params_GrASP.EPSG_base, Params_GrASP.EPSG_proj, always_xy=True)
Station_locx, Station_locy = transformer.transform(Station_loc_data[:, 2], Station_loc_data[:, 1])
Station_loc_data_XY = np.vstack((Station_loc_data[:, 0], Station_locx, Station_locy))
Station_loc_data_XY = Station_loc_data_XY .T

##### Matrix with information on distances of all station pairs #####
Stadis_array_original = Make_Stadis_array(Station_loc_data)
##### Make adjacency matrix (permanent adjacency) #####
Stadis_array = kNN_graph(Stadis_array_original, k_neareast = Params_GrASP.k_neareast)

##### Loading Tremor probability #####
Read_Detection = pd.read_csv('../../Data/Probability/Probability_T.csv')
Data = Read_Detection.values
header_info = Read_Detection.columns

##### GrASP for Tremor #####
start_calc = time.time()
Save_Candidate = Apply_Tremor(Data, Stadis_array, Station_loc_data_XY)
end_calc = time.time() - start_calc
print('End', end_calc, 'sec')
print(Save_Candidate)

##### Save user results #####
save = 'of'
if save == 'on':
    Save_df = pd.DataFrame(data = Save_Candidate)
    Save_df.to_csv('../../Results/User_results/Tremor_candidate.csv', index = False, header = header_info)

