# -*- coding: utf-8 -*-
# coding: utf-8
import numpy as np
import pandas as pd
import pyproj
import time
import sys
sys.path.append("../../Methods")
from GrASP import Params_GrASP, kNN_graph, Apply_Nocut

##### Matrix with information on distances of all station pairs #####
Stadis_read = pd.read_csv('../../Data/Stadis_array_original.csv', header = None)
Stadis_array_original = Stadis_read.values
##### Make adjacency matrix #####
Stadis_array = kNN_graph(Stadis_array_original, k_neareast = Params_GrASP.k_neareast)

##### Loading EQ probability #####
Read_Detection = pd.read_csv('../../Data/Probability/Probability_EQ.csv')
Data = Read_Detection.values
header_info = Read_Detection.columns
YMDHm = Data[:, :5]
Probability = Data[:, 5:np.shape(Data)[1]]
Probability[Probability < Params_GrASP.Threshold] = 0

##### GrASP for EQ #####
start_calc = time.time()
Save_Candidate = Apply_Nocut(Data, Stadis_array)
end_calc = time.time() - start_calc
print('End', end_calc, 'sec')
print(Save_Candidate)

##### Save user results #####
save = 'of'
if save == 'on':
    Save_df = pd.DataFrame(data = Save_Candidate)
    Save_df.to_csv('../../Results/User_results/EQ_candidate.csv', index = False, header = header_info)

