# -*- coding: utf-8 -*-
# coding: utf-8
import numpy as np
import pandas as pd
import pyproj
import time
import datetime
import sys
sys.path.append("../../Methods")
from GrASP import Params_GrASP, kNN_graph, Apply_Categorization

##### Matrix with information on distances of all station pairs #####
Stadis_read = pd.read_csv('../../Data/Stadis_array_original.csv', header = None)
Stadis_array_original = Stadis_read.values
##### Make adjacency matrix (permanent adjacency) #####
Stadis_array = kNN_graph(Stadis_array_original, k_neareast = Params_GrASP.k_neareast)

##### Load Tremor and EQ association results #####
Tremor_Association = pd.read_csv('../../Results/Tremor_candidate.csv')
Data_T = Tremor_Association.values
header_info = Tremor_Association.columns
EQ_Association = pd.read_csv('../../Results/EQ_candidate.csv')
Data_EQ = EQ_Association.values

##### GrASP for Tremor Categorization #####
start_calc = time.time()
Save_result = Apply_Categorization(Stadis_array, Data_T, Data_EQ)
end_calc = time.time() - start_calc
print('End', end_calc, 'sec')
print(Save_result)
header_info = np.append(header_info, 'Category')

##### Save user results #####
save = 'of'
if save == 'on':
    Save_df = pd.DataFrame(data = Save_result)
    Save_df.to_csv('../../Results/User_results/Tremor_Category.csv', index = False, header = header_info)


##########################

'''
##### Plot #####
import matplotlib.pyplot as plt 
import matplotlib.ticker as tick
fig = plt.figure(figsize = (6,10))
fig.patch.set_alpha(0)

Station_loc = pd.read_csv('../../Data/Station_info.csv')
Station_loc_data = Station_loc.values
Station_Lon = Station_loc_data[:,2]
Station_Lat = Station_loc_data[:,1]
Probability = Save_result[:, 5:(np.shape(Save_result)[1]-1)]
Category = Save_result[:,np.shape(Save_result)[1]-1]
print(Probability)
print(Category)

for i in range(np.shape(Save_result)[0]):
    if Category[i] == 1:
        plt.plot(Station_Lon[(Probability[i,:] >= 0.5)], Station_Lat[(Probability[i,:] >= 0.5)], '^')

plt.show()
'''