# -*- coding: utf-8 -*-
# coding: utf-8
import numpy as np
import scipy.signal as ss
import matplotlib.pyplot as plt 
import matplotlib.ticker as tick
import sys
sys.path.append("../../Methods")
from DiET import Make_Spec

##### Example ######
Data_test = np.random.normal(0, 100, 6000)
Spec_scale, t_sample, f_sample = Make_Spec(Data_test)
##### Spectrogram with the power between 2 and 8 Hz #####
Spec_scale2 = Spec_scale.copy()
Spec_scale2[25:73, :] = 0.2

##### Plot #####
fig = plt.figure(figsize = (8,6))
fig.patch.set_alpha(0)

T_mesh, F_mesh = np.meshgrid(t_sample, f_sample)
plt.pcolormesh(T_mesh, F_mesh, Spec_scale)

plt.xlabel('Time [sec]', fontsize=24)
plt.ylabel('Frequency [Hz]', fontsize=24)
plt.title ('Spectrogram of randomly generated data', fontsize=15)
plt.tick_params(labelsize = 24, labelbottom=True, labelleft=True, length=6)
plt.gca().xaxis.set_major_locator(tick.MultipleLocator(10))
plt.gca().xaxis.set_minor_locator(tick.MultipleLocator(1))
plt.gca().yaxis.set_major_locator(tick.MultipleLocator(2))
plt.gca().yaxis.set_minor_locator(tick.MultipleLocator(0.25))

##### Plot 2 #####
fig = plt.figure(figsize = (8,6))
fig.patch.set_alpha(0)

plt.pcolormesh(T_mesh, F_mesh, Spec_scale2)

plt.xlabel('Time [sec]', fontsize=24)
plt.ylabel('Frequency [Hz]', fontsize=24)
plt.title ('Spectrogram with the power between 2 and 8 Hz', fontsize=15)
plt.tick_params(labelsize = 24, labelbottom=True, labelleft=True, length=6)
plt.gca().xaxis.set_major_locator(tick.MultipleLocator(10))
plt.gca().xaxis.set_minor_locator(tick.MultipleLocator(1))
plt.gca().yaxis.set_major_locator(tick.MultipleLocator(2))
plt.gca().yaxis.set_minor_locator(tick.MultipleLocator(0.25))

plt.show()
quit()